/*
 * Copyright (C) 2010 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.android.cts.verifier;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.Window;
import android.widget.TextView;

/** {@link Activity} that displays an introduction to the verifier. */
public class CtsVerifierActivity extends Activity {

    /** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        requestWindowFeature(Window.FEATURE_NO_TITLE);
        setContentView(R.layout.main);

        OnClickListener clickListener = new OnClickListener() {
            @Override
            public void onClick(View v) {
                startActivity(new Intent(CtsVerifierActivity.this, TestListActivity.class));
            }
        };

        TextView versionText = (TextView) findViewById(R.id.version_text);
        versionText.setText(getString(R.string.version_text, Version.getVersionName(this)));

        findViewById(R.id.detective_logo).setOnClickListener(clickListener);
        findViewById(R.id.continue_button).setOnClickListener(clickListener);
    }
}
