<!--
   Copyright 2010 The Android Open Source Project 

   Licensed under the Apache License, Version 2.0 (the "License"); 
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
-->

# Android Discussion Groups Charter #

## Audience ##

These discussion groups are intended for developers working with the
Android platform. Everyone is welcome to join in, provided you follow our
community's policies described below. Our users help each other, and many
experts post to these groups, including members of the Open Handset Alliance.

No topic is off-limits, provided it relates to Android in some way.
However, since these are very busy lists, search the archives before posting
your question; you may find your question has already been answered.

## Mailing list rules ##

We love simplicity and hate restrictions, so we keep our policies minimal.
The rules below describe what's expected of subscribers to the Android mailing
lists.

- *Please be friendly*: 
    Showing courtesy and respect to others is a vital part of the Android culture, and we expect everyone participating in the Android community to join us in accepting nothing less. Being courteous does not mean we can't constructively disagree with each other, but it does mean that we must be polite when we do so. There's never a reason to be antagonistic or dismissive
toward anyone; if you think there is, think again before you post.
    Mobile development is serious business, but it's also a lot of
fun. Let's keep it that way. Let's strive to be one of the friendliest
communities in all of open source.

- *Allowed discussion topics*: 
    Most of our groups are for technical discussions of Android or users helping each other. Generally we don't put hard restrictions on the topics discussed in the group: as long as the topic is relevant to Android in some way, it's welcome on our groups.  We welcome announcements and discussion of products, libraries, publications, and other interesting Android-related news,
but *please do not cross-post*. Post only to the most relevant group for your message. We even welcome (polite!) discussion of articles and ideas critical of Android--after all, we can't improve if we don't listen.

- *Working Lists*: 
    Some of our groups are considered "working lists", by which we mean that the list is intended to be used in support of the completion of specific tasks. On these groups, we don't welcome off-topic conversations, and will generally ask you to take general discussions to a different list. Since these are lists where people are trying to get work done, we will be pretty aggressive about keeping the noise level low. We ask that you respect our contributors' time and keep general discussions to appropriate lists.

- *Spam*: 
    We hate spam almost as passionately as we love courtesy and respect, so we reserve the right to limit discussions that amount to spam. Outright spam will result in the spammer being immediately and permanently banned from the list.

The most important rule is friendliness. Remember: disrespect and rudeness are not welcome in our community under any circumstances. We don't have a formal policy on dealing with troublemakers, and we hope we never need one. That said, we do pledge to do our best to be fair, and we will always try to warn someone before banning him or her.

## Contacting the moderators ##

If you see anyone being rude, call them out on it. This is your group too, and you don't have to accept someone else being disrespectful just because it wasn't directed at you. Just remember to be polite and courteous yourself! Don't add fuel to the fire.

But if you see an outrageous violation, want to report spam, feel very strongly about something, or even if you just want to chat, then contact the mailing list's owners. It's what we're here for!

