<!--
   Copyright 2010 The Android Open Source Project 

   Licensed under the Apache License, Version 2.0 (the "License"); 
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
-->

# Android Community #

Welcome to the Android community!

The key to any community is, obviously, communication. Like most projects,
Android communicates via mailing lists. Because Android is an extremely large
project with many components, we have many discussion forums, each focusing on
a different topic.

Please check out the groups below, and join any that seem interesting to
you. Note that if you're a user looking for help with your Android device,
this page probably isn't for you; you should contact your carrier or retailer
for help with your phone.

Please note that if you're looking for information about building
applications for Android, you can find a separate set of groups for those at
our sister site, developer.android.com: [https://developer.android.com/resources/community-groups.html]

## Getting the Most from Our Lists ##

Please consider the following before you post to our lists.

- *Read the [Charter for our forums.](groups-charter.html)* This explains the (few) rules and guidelines for our community.

- *Search the group archives to see whether your questions have already been discussed.* This avoids time-wasting redundant discussions.

- *Use a clear, relevant message subject.* This helps everyone, both those trying to answer your question as well as those who may be looking for information in the future.

- *Give plenty of details in your post.* Code or log snippets, pointers to screenshots, and similar details will get better results and make for better discussions. For a great guide to phrasing your questions, read [How to Ask Questions the Smart Way](http://www.catb.org/%7Eesr/faqs/smart-questions.html).
<img src="/images/external-link.png">

## Open Source Project discussions ##

- *android-platform*: 
    This list is for general discussion about the Android open-source project or the platform technologies.
    - Subscribe using Google Groups: [android-platform](https://groups.google.com/forum/?fromgroups#!forum/android-platform)
    - Subscribe via email: [android-platform](mailto:android-platform+subscribe@googlegroups.com)

- *android-building*:
    Subscribe to this list for discussion and help on building the Android source code, and on the build system. If you've just checked out the source code and have questions about how to turn it into binaries, start here.
    - Subscribe using Google Groups: [android-building](https://groups.google.com/forum/?fromgroups#!forum/android-building)
    - Subscribe via email: [android-building](mailto:android-building+subscribe@googlegroups.com)

- *android-porting*:
    This list is for developers who want to port Android to a new device. If you're wondering how to combine the Android source code with your hardware, this is the right group for you. Discuss here the specifics of porting Android to individual devices, from obtaining toolchains and merging kernel drivers all the way to configuring or modifying applications for your specific
configuration.
    - Subscribe using Google Groups: [android-porting](https://groups.google.com/forum/?fromgroups#!forum/android-porting)
    - Subscribe via email: [android-porting](mailto:android-porting+subscribe@googlegroups.com)

- *android-contrib*:
    This list is for developers who want to contribute code to Android. This is a working list, and is not appropriate for general discussion. We ask that general discussion go to android-platform.  Note: contributors to the Android kernel should go to the android-kernel list, below.
    - Subscribe using Google Groups: [android-contrib](https://groups.google.com/forum/?fromgroups#!forum/android-contrib)
    - Subscribe via email: [android-contrib](mailto:android-contrib+subscribe@googlegroups.com)

- *android-kernel*:
    This list is for deveopers who want to contribute to the Linux kernel that Android devices use. If you've downloaded the kernel code, if you know how to compile it, if you want to write kernel code to specifically support Android,
this is your place. This group isn't for user-space topics (see android-platform for that), and people will shake their fingers at you and call you naughty if you ask user-space questions here.
    - Subscribe using Google Groups: [android-kernel](https://groups.google.com/forum/?fromgroups#!forum/android-kernel)
    - Subscribe via email: [android-kernel](mailto:android-kernel+subscribe@googlegroups.com)

## Using email with Google Groups ##

Instead of using the [Google groups](https://groups.google.com/) site, you can use your email client of choice to participate in the mailing lists.

To subscribe to a group without using the Google Groups site, use the link under "subscribe via email" in the lists above.

To set up how you receive mailing list postings by email:

1. Sign into the group via the Google Groups site. For example, for the android-platform group you would use [https://groups.google.com/forum/?fromgroups#!forum/android-platform].

1. Click "My membership" on the right side.

1. Under "How do you want to read this group?" select one of the email options.

## Android on IRC ##

We also have a presence on IRC via [freenode](http://freenode.net/).
We maintain two official IRC channels on [irc.freenode.net](irc://irc.freenode.net/) (access via the web
at [freenode webchat](http://webchat.freenode.net/))

- [\#android](irc://irc.freenode.net/android) - dedicated to general Android discussion and porting concerns

- [\#android-dev](irc://irc.freenode.net/android-dev) - dedicated to discussion about writing Android applications

The channels above are official. There are a few other channels the
community is using, but are not official. These aren't official or officially
moderated/managed, so you use the channels below at your own risk. The Open
Handset Alliance doesn't endorse these channels, there's no warranty express
or implied, and so on. There may be more channels than just these listed.

- [\#android-firehose](irc://irc.freenode.net/android-firehose) - displays in real-time the commits to the Android Open Source Project

- [\#android-fr](irc://irc.freenode.net/android-fr) - pour discuter d'Android en français

- [\#android-offtopic](irc://irc.freenode.net/android-offtopic) - for, well, off-topic discussions

- [\#android-root](irc://irc.freenode.net/android-root) - for discussion related to off-label uses of hardware
