<!--
   Copyright 2010 The Android Open Source Project 

   Licensed under the Apache License, Version 2.0 (the "License"); 
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
-->

# Get Involved #

Thanks for your interest in Android! Here are some ways you can get involved
and help us improve Android. For background on the Android project and our
goals, check out the [Project Philosophy page](/about/philosophy.html).

## Report Bugs ##

One of the easiest and most effective ways you can help improve Android is
to file bugs. For more information, visit the [Reporting Bugs](report-bugs.html) page.

Please note that we can't guarantee that any particular bug will be fixed in
any particular release. To see what happens to your bug once you report it,
read [Life of a Bug](life-of-a-bug.html).

## Develop Apps ##

We created Android so that all developers can distribute their applications
to users on an open platform. One of the best ways you can help Android is to
write cool apps that users love!

To get started, visit [developer.android.com](https://developer.android.com). This site
provides the information and tools you need to write applications for
compatible Android devices, using the SDK.

## Contribute to the Code ##

Code is King. We'd love to review any changes you submit, so please check
out the source, pick a bug or feature, and get coding. Note that the smaller
and more targetted your patch submissions, the easier it will be for us to
review them.

You can get started with Android by learning about the [Life of a Patch](life-of-a-patch.html), 
and by learning about `git`, `repo`, and other tools using the links to the left. 
You can also view the activity on all contributions on our
[Gerrit server](https://android-review.googlesource.com/).
If you need help along the way, you can join our [discussion groups](/community/index.html).
