<!--
   Copyright 2010 The Android Open Source Project 

   Licensed under the Apache License, Version 2.0 (the "License"); 
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
-->

# Android Platform Overview #

Our sister site, [developer.android.com](https://developer.android.com/),
includes feature overviews of the various Android platform versions.
The links below will take you to developer.android.com where you can view this
information.

The links below will navigate you away from this site.

## [Android 4.0](https://developer.android.com/sdk/android-4.0-highlights.html) ##

Android 4.0 corresponded to the "IceCreamSandwich" milestone branch, and has an API level of 14.

## [Android 2.3](https://developer.android.com/sdk/android-2.3-highlights.html) ##

Android 2.3 corresponded to the "Gingerbread" milestone branch, and has an API level of 9.
In versions 2.3.3 and higher, the API level is 10.

## [Android 2.2](https://developer.android.com/sdk/android-2.2-highlights.html) ##

Android 2.2 corresponded to the "FroYo" milestone branch, and has an API level of 8.

## [Android 2.1](https://developer.android.com/sdk/android-2.0-highlights.html) ##

Android 2.1 corresponded to the "Eclair" milestone branch, and has an API level of 7.

The Eclair branch was also used for 2.0 and 2.0.1; however, both of those
releases were quickly obsoleted by the version 2.1 Eclair release. As Android
2.1 includes key bug fixes and improvements not present in 2.0/2.0.1, only
Android 2.1 should be used for new devices. As there is no compatibility
program for 2.0 or 2.0.1, the officially compatible Eclair-based release is Android
2.1. (The linked document refers to Android 2.0, because there were
no new platform features added in 2.1.)

## [Android 1.6](https://developer.android.com/sdk/android-1.6-highlights.html) ##

Android 1.6 corresponded to the "Donut" milestone branch, and has an API level of 4.

## [Android 1.5](https://developer.android.com/sdk/android-1.5-highlights.html) ##

Android 1.5 corresponded to the "Cupcake" milestone branch, and has an API
level of 3.

## [Android 1.1](https://developer.android.com/sdk/android-1.1.html) ##

Android 1.1 has an API level of 2. Android 1.1 was known as
"Petit Four" internally, though this name was not used officially.

## Android 1.0 ##

was the first release of Android, and has an API
level of 1. Since it was the first released version of Android, no platform
highlights were prepared for this release.

