<!--
   Copyright 2010 The Android Open Source Project

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
-->

# Android Technical Information #
Welcome to the Android technical documentation section of the site. Here you
can find technical information useful to people and organizations who are
looking to modify, contribute to, or port the Android software. This is "under
the hood" information intended for engineers.

## Dalvik Technical Information ##
The Dalvik Virtual Machine is the heart of Android. It's a fast, just-in-time
compiled, optimized bytecode virtual machine. Android applications are
compiled to Dalvik bytecode and run on the Dalvik VM. This section includes
detailed information such as the Dalvik bytecode format specification,
design information on the VM itself, and so on.

[&raquo; Dalvik Information](/tech/dalvik/index.html)


## Debugging ##
Android is a large and complex system. This section includes tips and tricks
about debugging at the platform level.

[&raquo; Debugging Information](/tech/debugging/index.html)


## Encryption Technical Information ##
The Android Open-Source Project includes the ability to encrypt the user's data.
This document is written for 3rd parties developing Android devices who want to
include support for encryption on their device.  It covers the few things that
must be done so encryption will work.

[&raquo; Encryption Information](/tech/encryption/index.html)

##Security Technical Information ##
Android provides a robust multi-layered security architecture that provides the
flexibility required for an open platform, while providing protection for all
users of the platform. This document focuses on the security features of the
core Android platform.

[&raquo; Android Security Overview](/tech/security/index.html)

## Input Technical Information ##
Android's input subsystem is responsible for supporting touch screens,
keyboard, joysticks, mice and other devices.

[&raquo; Input Information](/tech/input/index.html)

## Data Usage Technical Information ##
Android's data usage features allow users to understand and control how their
device uses network data. This document is designed for systems integrators
and mobile operators, to help explain technical details they should be aware
of when porting Android to specific devices.

[&raquo; Data Usage Information](/tech/datausage/index.html)


