<!--
   Copyright 2010 The Android Open Source Project 

   Licensed under the Apache License, Version 2.0 (the "License"); 
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
-->

# People and Roles #

The Android Open Source Project (AOSP) includes individuals working in a variety
of roles. As noted in [Our Philosophy](philosophy.html), Google is responsible for Android product management
and the engineering process for the core framework and platform; however,
the project considers contributions from any source, not just Google. This
page describes the kinds of roles that interested parties can take on.

Anyone who is interested in exploring and contributing to Android can use the
Android Open Source Project resources. Anyone can join the mailing lists, ask
questions, contribute patches, report bugs, look at submitted patches, and use
the tools. To get started with the Android code, see [Get Involved](/source/index.html).

## Contributor ##

A "Contributor" is anyone making contributions to the AOSP source code,
including both employees of Google or other companies, as well as external
developers who are contributing to Android on their own behalf.  There is no
distinction between Contributors who are employed by Google, and those who are
not: all engineers use the same tools (git, repo, and gerrit), 
follow the same code review process, and are subject
to the same requirements on code style and so on.

## Developer ##

A "Developer" is an engineer writing applications that run on Android
devices. There is, of course, no difference in skillset between a "Developer"
and a "Contributor", but AOSP uses "Developer" to distinguish between
engineers using the platform and those contributing to it. Developers are
(along with end users) the "customers" of the platform that the Contributors
create. As such, we talk about Developers a lot, though this isn't technically
a separate role in the AOSP per se.

## Verifier ##

"Verifiers" are responsible for testing change requests. After individuals
have submitted a significant amount of high-quality code to the project, the
Project Leads might invite them to become Verifiers. *Note: at this
time, generally Verifiers are the same as Approvers.*

## Approver ##

"Approvers" are experienced members of the project who have demonstrated their
design skills and have made significant technical contributions to the
project. In the code-review process, an Approver decides whether to include or
exclude a change. Project Leads (who are typically employed by Google) choose
the Approvers, sometimes promoting to this position Verifiers who have
demonstrated their expertise within a specific project.

## Project Leads ##

Android consists of a number of sub-projects; you can see these in the git
repository, as individual .git files. Tech Leads are senior Contributors who
oversee the engineering for individual Android projects. Typically these tech
leads will be Google employees.  A Project Lead for an individual project is
responsible for the following:

- Lead all technical aspects of the project; for example, the project roadmap, 
  development, release cycles, versioning, and QA.

- Ensure that the project is QA-ed in time for scheduled Android platform
  releases.

- Designate Verifiers and Approvers for submitted patches.

- Be fair and unbiased while reviewing changes. Accept or reject patches
  based on technical merit and alignment with the Android strategy.

- Review changes in a timely manner and make best efforts to communicate
  when changes are not accepted.

- Optionally maintain a web site for the project for information and
  documents specific to the project.

- Act as a facilitator in resolving technical conflicts.

- Be a public face for the project and the go-to person for questions
  related to the project.

