<!--
   Copyright 2012 The Android Open Source Project

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
-->

# Overview #

The per-application/delegated data usage monitoring and tracking
functionality relies on the xt_qtaguid module in the android-3.0 Linux
kernel (`kernel/net/netfilter/xt_qtaguid`). The socket tagging
functionality in the framework (`system/core/libcutils/qtaguid.c`)
relies mainly on the existence of `/proc/net/xt_qtaguid/ctrl`
interface exported by the `xt_qtaguid` kernel module.

The `quota2` netfilter module (originally part of `xtables-addons`)
allows the functionality to set named quota limits and was extended to
support notifying userspace when certain limits are reached. Once the
quota limit is reached, the `quota2` module discards all subsequent
network traffic. The framework can also specify additional rules to
restrict background data traffic for an application (refer to
`com.android.server.NetworkManagementSocketTagger.setKernelCounterSet`
and
`android.net.NetworkPolicyManager.POLICY_REJECT_METERED_BACKGROUND`).

# How does it work? #

The `qtaguid` netfilter module tracks the network traffic on a
per-socket basis for every application using the unique UID of the
owning application.  There are two tag components associated with any
socket in the system. The first is the UID which uniquely identifies
the application which is responsible for the data transfer (Linux
allows the ability to ascribe the ownership of each network socket to
the UID of the calling application). The second tag component is used
to support additional characterization of the traffic into application
developer specified categories. Using these application level tags, an
application can profile the traffic into several sub-categories.

In the case of applications that provide network data transfer as a
service, such as the download manager, media streaming service, etc,
it is possible to attribute the ownership of the network data transfer
to the UID of the requesting application using the
`TrafficStats.setThreadStatsUid()` function call. The caller must hold
the “`android.permission.MODIFY_NETWORK_ACCOUNTING`” permission to
re-assign the ownership of the network traffic.
