/*
 *		Z-star vc0321 library
 *		Copyright (C) 2006 Koninski Artur takeshi87@o2.pl
 *		Copyright (C) 2006 Michel Xhaard
 *
 * V4L2 by Jean-Francois Moine <http://moinejf.free.fr>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#define MODULE_NAME "vc032x"

#include "gspca.h"

#define DRIVER_VERSION_NUMBER	KERNEL_VERSION(2, 1, 7)
static const char version[] = "2.1.7";

MODULE_AUTHOR("Michel Xhaard <mxhaard@users.sourceforge.net>");
MODULE_DESCRIPTION("GSPCA/VC032X USB Camera Driver");
MODULE_LICENSE("GPL");

/* specific webcam descriptor */
struct sd {
	struct gspca_dev gspca_dev;	/* !! must be the first item */

	unsigned char autogain;
	unsigned char lightfreq;

	char qindex;
	char bridge;
#define BRIDGE_VC0321 0
#define BRIDGE_VC0323 1
	char sensor;
#define SENSOR_HV7131R 0
#define SENSOR_MI1320 1
#define SENSOR_MI1310_SOC 2
#define SENSOR_OV7660 3
#define SENSOR_OV7670 4
#define SENSOR_PO3130NC 5
};

/* V4L2 controls supported by the driver */
static int sd_setautogain(struct gspca_dev *gspca_dev, __s32 val);
static int sd_getautogain(struct gspca_dev *gspca_dev, __s32 *val);
static int sd_setfreq(struct gspca_dev *gspca_dev, __s32 val);
static int sd_getfreq(struct gspca_dev *gspca_dev, __s32 *val);

static struct ctrl sd_ctrls[] = {
	{
	    {
		.id      = V4L2_CID_AUTOGAIN,
		.type    = V4L2_CTRL_TYPE_BOOLEAN,
		.name    = "Auto Gain",
		.minimum = 0,
		.maximum = 1,
		.step    = 1,
#define AUTOGAIN_DEF 1
		.default_value = AUTOGAIN_DEF,
	    },
	    .set = sd_setautogain,
	    .get = sd_getautogain,
	},
	{
	    {
		.id	 = V4L2_CID_POWER_LINE_FREQUENCY,
		.type    = V4L2_CTRL_TYPE_MENU,
		.name    = "Light frequency filter",
		.minimum = 0,
		.maximum = 2,	/* 0: No, 1: 50Hz, 2:60Hz */
		.step    = 1,
#define FREQ_DEF 1
		.default_value = FREQ_DEF,
		.default_value = 1,
	    },
	    .set = sd_setfreq,
	    .get = sd_getfreq,
	},
};

static struct v4l2_pix_format vc0321_mode[] = {
	{320, 240, V4L2_PIX_FMT_YUV420, V4L2_FIELD_NONE,
		.bytesperline = 320 * 2,
		.sizeimage = 320 * 240 * 2,
		.colorspace = V4L2_COLORSPACE_SRGB,
		.priv = 1},
	{640, 480, V4L2_PIX_FMT_YUV420, V4L2_FIELD_NONE,
		.bytesperline = 640 * 2,
		.sizeimage = 640 * 480 * 2,
		.colorspace = V4L2_COLORSPACE_SRGB,
		.priv = 0},
};
static struct v4l2_pix_format vc0323_mode[] = {
	{320, 240, V4L2_PIX_FMT_JPEG, V4L2_FIELD_NONE,
		.bytesperline = 320,
		.sizeimage = 320 * 240 * 3 / 8 + 590,
		.colorspace = V4L2_COLORSPACE_JPEG,
		.priv = 1},
	{640, 480, V4L2_PIX_FMT_JPEG, V4L2_FIELD_NONE,
		.bytesperline = 640,
		.sizeimage = 640 * 480 * 3 / 8 + 590,
		.colorspace = V4L2_COLORSPACE_JPEG,
		.priv = 0},
};

static const __u8 mi1310_socinitVGA_JPG[][4] = {
	{0xb0, 0x03, 0x19, 0xcc},
	{0xb0, 0x04, 0x02, 0xcc},
	{0xb3, 0x00, 0x64, 0xcc},
	{0xb3, 0x00, 0x65, 0xcc},
	{0xb3, 0x05, 0x00, 0xcc},
	{0xb3, 0x06, 0x00, 0xcc},
	{0xb3, 0x08, 0x01, 0xcc},
	{0xb3, 0x09, 0x0c, 0xcc},
	{0xb3, 0x34, 0x02, 0xcc},
	{0xb3, 0x35, 0xdd, 0xcc},
	{0xb3, 0x02, 0x00, 0xcc},
	{0xb3, 0x03, 0x0a, 0xcc},
	{0xb3, 0x04, 0x05, 0xcc},
	{0xb3, 0x20, 0x00, 0xcc},
	{0xb3, 0x21, 0x00, 0xcc},
	{0xb3, 0x22, 0x03, 0xcc},
	{0xb3, 0x23, 0xc0, 0xcc},
	{0xb3, 0x14, 0x00, 0xcc},
	{0xb3, 0x15, 0x00, 0xcc},
	{0xb3, 0x16, 0x04, 0xcc},
	{0xb3, 0x17, 0xff, 0xcc},
	{0xb3, 0x00, 0x65, 0xcc},
	{0xb8, 0x00, 0x00, 0xcc},
	{0xbc, 0x00, 0xd0, 0xcc},
	{0xbc, 0x01, 0x01, 0xcc},
	{0xf0, 0x00, 0x02, 0xbb},
	{0xc8, 0x9f, 0x0b, 0xbb},
	{0x5b, 0x00, 0x01, 0xbb},
	{0x2f, 0xde, 0x20, 0xbb},
	{0xf0, 0x00, 0x00, 0xbb},
	{0x20, 0x03, 0x02, 0xbb},
	{0xf0, 0x00, 0x01, 0xbb},
	{0x05, 0x00, 0x07, 0xbb},
	{0x34, 0x00, 0x00, 0xbb},
	{0x35, 0xff, 0x00, 0xbb},
	{0xdc, 0x07, 0x02, 0xbb},
	{0xdd, 0x3c, 0x18, 0xbb},
	{0xde, 0x92, 0x6d, 0xbb},
	{0xdf, 0xcd, 0xb1, 0xbb},
	{0xe0, 0xff, 0xe7, 0xbb},
	{0x06, 0xf0, 0x0d, 0xbb},
	{0x06, 0x70, 0x0e, 0xbb},
	{0x4c, 0x00, 0x01, 0xbb},
	{0x4d, 0x00, 0x01, 0xbb},
	{0xf0, 0x00, 0x02, 0xbb},
	{0x2e, 0x0c, 0x55, 0xbb},
	{0x21, 0xb6, 0x6e, 0xbb},
	{0x36, 0x30, 0x10, 0xbb},
	{0x37, 0x00, 0xc1, 0xbb},
	{0xf0, 0x00, 0x00, 0xbb},
	{0x07, 0x00, 0x84, 0xbb},
	{0x08, 0x02, 0x4a, 0xbb},
	{0x05, 0x01, 0x10, 0xbb},
	{0x06, 0x00, 0x39, 0xbb},
	{0xf0, 0x00, 0x02, 0xbb},
	{0x58, 0x02, 0x67, 0xbb},
	{0x57, 0x02, 0x00, 0xbb},
	{0x5a, 0x02, 0x67, 0xbb},
	{0x59, 0x02, 0x00, 0xbb},
	{0x5c, 0x12, 0x0d, 0xbb},
	{0x5d, 0x16, 0x11, 0xbb},
	{0x39, 0x06, 0x18, 0xbb},
	{0x3a, 0x06, 0x18, 0xbb},
	{0x3b, 0x06, 0x18, 0xbb},
	{0x3c, 0x06, 0x18, 0xbb},
	{0x64, 0x7b, 0x5b, 0xbb},
	{0xf0, 0x00, 0x02, 0xbb},
	{0x36, 0x30, 0x10, 0xbb},
	{0x37, 0x00, 0xc0, 0xbb},
	{0xbc, 0x0e, 0x00, 0xcc},
	{0xbc, 0x0f, 0x05, 0xcc},
	{0xbc, 0x10, 0xc0, 0xcc},
	{0xbc, 0x11, 0x03, 0xcc},
	{0xb6, 0x00, 0x00, 0xcc},
	{0xb6, 0x03, 0x02, 0xcc},
	{0xb6, 0x02, 0x80, 0xcc},
	{0xb6, 0x05, 0x01, 0xcc},
	{0xb6, 0x04, 0xe0, 0xcc},
	{0xb6, 0x12, 0xf8, 0xcc},
	{0xb6, 0x13, 0x25, 0xcc},
	{0xb6, 0x18, 0x02, 0xcc},
	{0xb6, 0x17, 0x58, 0xcc},
	{0xb6, 0x16, 0x00, 0xcc},
	{0xb6, 0x22, 0x12, 0xcc},
	{0xb6, 0x23, 0x0b, 0xcc},
	{0xbf, 0xc0, 0x39, 0xcc},
	{0xbf, 0xc1, 0x04, 0xcc},
	{0xbf, 0xcc, 0x00, 0xcc},
	{0xbc, 0x02, 0x18, 0xcc},
	{0xbc, 0x03, 0x50, 0xcc},
	{0xbc, 0x04, 0x18, 0xcc},
	{0xbc, 0x05, 0x00, 0xcc},
	{0xbc, 0x06, 0x00, 0xcc},
	{0xbc, 0x08, 0x30, 0xcc},
	{0xbc, 0x09, 0x40, 0xcc},
	{0xbc, 0x0a, 0x10, 0xcc},
	{0xbc, 0x0b, 0x00, 0xcc},
	{0xbc, 0x0c, 0x00, 0xcc},
	{0xb3, 0x5c, 0x01, 0xcc},
	{0xf0, 0x00, 0x01, 0xbb},
	{0x80, 0x00, 0x03, 0xbb},
	{0x81, 0xc7, 0x14, 0xbb},
	{0x82, 0xeb, 0xe8, 0xbb},
	{0x83, 0xfe, 0xf4, 0xbb},
	{0x84, 0xcd, 0x10, 0xbb},
	{0x85, 0xf3, 0xee, 0xbb},
	{0x86, 0xff, 0xf1, 0xbb},
	{0x87, 0xcd, 0x10, 0xbb},
	{0x88, 0xf3, 0xee, 0xbb},
	{0x89, 0x01, 0xf1, 0xbb},
	{0x8a, 0xe5, 0x17, 0xbb},
	{0x8b, 0xe8, 0xe2, 0xbb},
	{0x8c, 0xf7, 0xed, 0xbb},
	{0x8d, 0x00, 0xff, 0xbb},
	{0x8e, 0xec, 0x10, 0xbb},
	{0x8f, 0xf0, 0xed, 0xbb},
	{0x90, 0xf9, 0xf2, 0xbb},
	{0x91, 0x00, 0x00, 0xbb},
	{0x92, 0xe9, 0x0d, 0xbb},
	{0x93, 0xf4, 0xf2, 0xbb},
	{0x94, 0xfb, 0xf5, 0xbb},
	{0x95, 0x00, 0xff, 0xbb},
	{0xb6, 0x0f, 0x08, 0xbb},
	{0xb7, 0x3d, 0x16, 0xbb},
	{0xb8, 0x0c, 0x04, 0xbb},
	{0xb9, 0x1c, 0x07, 0xbb},
	{0xba, 0x0a, 0x03, 0xbb},
	{0xbb, 0x1b, 0x09, 0xbb},
	{0xbc, 0x17, 0x0d, 0xbb},
	{0xbd, 0x23, 0x1d, 0xbb},
	{0xbe, 0x00, 0x28, 0xbb},
	{0xbf, 0x11, 0x09, 0xbb},
	{0xc0, 0x16, 0x15, 0xbb},
	{0xc1, 0x00, 0x1b, 0xbb},
	{0xc2, 0x0e, 0x07, 0xbb},
	{0xc3, 0x14, 0x10, 0xbb},
	{0xc4, 0x00, 0x17, 0xbb},
	{0x06, 0x74, 0x8e, 0xbb},
	{0xf0, 0x00, 0x01, 0xbb},
	{0x06, 0xf4, 0x8e, 0xbb},
	{0x00, 0x00, 0x50, 0xdd},
	{0x06, 0x74, 0x8e, 0xbb},
	{0xf0, 0x00, 0x02, 0xbb},
	{0x24, 0x50, 0x20, 0xbb},
	{0xf0, 0x00, 0x02, 0xbb},
	{0x34, 0x0c, 0x50, 0xbb},
	{0xb3, 0x01, 0x41, 0xcc},
	{0xf0, 0x00, 0x00, 0xbb},
	{0x03, 0x03, 0xc0, 0xbb},
	{},
};
static const __u8 mi1310_socinitQVGA_JPG[][4] = {
	{0xb0, 0x03, 0x19, 0xcc},	{0xb0, 0x04, 0x02, 0xcc},
	{0xb3, 0x00, 0x64, 0xcc},	{0xb3, 0x00, 0x65, 0xcc},
	{0xb3, 0x05, 0x00, 0xcc},	{0xb3, 0x06, 0x00, 0xcc},
	{0xb3, 0x08, 0x01, 0xcc},	{0xb3, 0x09, 0x0c, 0xcc},
	{0xb3, 0x34, 0x02, 0xcc},	{0xb3, 0x35, 0xdd, 0xcc},
	{0xb3, 0x02, 0x00, 0xcc},	{0xb3, 0x03, 0x0a, 0xcc},
	{0xb3, 0x04, 0x05, 0xcc},	{0xb3, 0x20, 0x00, 0xcc},
	{0xb3, 0x21, 0x00, 0xcc},	{0xb3, 0x22, 0x03, 0xcc},
	{0xb3, 0x23, 0xc0, 0xcc},	{0xb3, 0x14, 0x00, 0xcc},
	{0xb3, 0x15, 0x00, 0xcc},	{0xb3, 0x16, 0x04, 0xcc},
	{0xb3, 0x17, 0xff, 0xcc},	{0xb3, 0x00, 0x65, 0xcc},
	{0xb8, 0x00, 0x00, 0xcc},	{0xbc, 0x00, 0xf0, 0xcc},
	{0xbc, 0x01, 0x01, 0xcc},	{0xf0, 0x00, 0x02, 0xbb},
	{0xc8, 0x9f, 0x0b, 0xbb},	{0x5b, 0x00, 0x01, 0xbb},
	{0x2f, 0xde, 0x20, 0xbb},	{0xf0, 0x00, 0x00, 0xbb},
	{0x20, 0x03, 0x02, 0xbb},	{0xf0, 0x00, 0x01, 0xbb},
	{0x05, 0x00, 0x07, 0xbb},	{0x34, 0x00, 0x00, 0xbb},
	{0x35, 0xff, 0x00, 0xbb},	{0xdc, 0x07, 0x02, 0xbb},
	{0xdd, 0x3c, 0x18, 0xbb},	{0xde, 0x92, 0x6d, 0xbb},
	{0xdf, 0xcd, 0xb1, 0xbb},	{0xe0, 0xff, 0xe7, 0xbb},
	{0x06, 0xf0, 0x0d, 0xbb},	{0x06, 0x70, 0x0e, 0xbb},
	{0x4c, 0x00, 0x01, 0xbb},	{0x4d, 0x00, 0x01, 0xbb},
	{0xf0, 0x00, 0x02, 0xbb},	{0x2e, 0x0c, 0x55, 0xbb},
	{0x21, 0xb6, 0x6e, 0xbb},	{0x36, 0x30, 0x10, 0xbb},
	{0x37, 0x00, 0xc1, 0xbb},	{0xf0, 0x00, 0x00, 0xbb},
	{0x07, 0x00, 0x84, 0xbb},	{0x08, 0x02, 0x4a, 0xbb},
	{0x05, 0x01, 0x10, 0xbb},	{0x06, 0x00, 0x39, 0xbb},
	{0xf0, 0x00, 0x02, 0xbb},	{0x58, 0x02, 0x67, 0xbb},
	{0x57, 0x02, 0x00, 0xbb},	{0x5a, 0x02, 0x67, 0xbb},
	{0x59, 0x02, 0x00, 0xbb},	{0x5c, 0x12, 0x0d, 0xbb},
	{0x5d, 0x16, 0x11, 0xbb},	{0x39, 0x06, 0x18, 0xbb},
	{0x3a, 0x06, 0x18, 0xbb},	{0x3b, 0x06, 0x18, 0xbb},
	{0x3c, 0x06, 0x18, 0xbb},	{0x64, 0x7b, 0x5b, 0xbb},
	{0xf0, 0x00, 0x02, 0xbb},	{0x36, 0x30, 0x10, 0xbb},
	{0x37, 0x00, 0xc0, 0xbb},	{0xbc, 0x0e, 0x00, 0xcc},
	{0xbc, 0x0f, 0x05, 0xcc},	{0xbc, 0x10, 0xc0, 0xcc},
	{0xbc, 0x11, 0x03, 0xcc},	{0xb6, 0x00, 0x00, 0xcc},
	{0xb6, 0x03, 0x01, 0xcc},	{0xb6, 0x02, 0x40, 0xcc},
	{0xb6, 0x05, 0x00, 0xcc},	{0xb6, 0x04, 0xf0, 0xcc},
	{0xb6, 0x12, 0xf8, 0xcc},	{0xb6, 0x13, 0x25, 0xcc},
	{0xb6, 0x18, 0x00, 0xcc},	{0xb6, 0x17, 0x96, 0xcc},
	{0xb6, 0x16, 0x00, 0xcc},	{0xb6, 0x22, 0x12, 0xcc},
	{0xb6, 0x23, 0x0b, 0xcc},	{0xbf, 0xc0, 0x39, 0xcc},
	{0xbf, 0xc1, 0x04, 0xcc},	{0xbf, 0xcc, 0x00, 0xcc},
	{0xb3, 0x5c, 0x01, 0xcc},	{0xf0, 0x00, 0x01, 0xbb},
	{0x80, 0x00, 0x03, 0xbb},	{0x81, 0xc7, 0x14, 0xbb},
	{0x82, 0xeb, 0xe8, 0xbb},	{0x83, 0xfe, 0xf4, 0xbb},
	{0x84, 0xcd, 0x10, 0xbb},	{0x85, 0xf3, 0xee, 0xbb},
	{0x86, 0xff, 0xf1, 0xbb},	{0x87, 0xcd, 0x10, 0xbb},
	{0x88, 0xf3, 0xee, 0xbb},	{0x89, 0x01, 0xf1, 0xbb},
	{0x8a, 0xe5, 0x17, 0xbb},	{0x8b, 0xe8, 0xe2, 0xbb},
	{0x8c, 0xf7, 0xed, 0xbb},	{0x8d, 0x00, 0xff, 0xbb},
	{0x8e, 0xec, 0x10, 0xbb},	{0x8f, 0xf0, 0xed, 0xbb},
	{0x90, 0xf9, 0xf2, 0xbb},	{0x91, 0x00, 0x00, 0xbb},
	{0x92, 0xe9, 0x0d, 0xbb},	{0x93, 0xf4, 0xf2, 0xbb},
	{0x94, 0xfb, 0xf5, 0xbb},	{0x95, 0x00, 0xff, 0xbb},
	{0xb6, 0x0f, 0x08, 0xbb},	{0xb7, 0x3d, 0x16, 0xbb},
	{0xb8, 0x0c, 0x04, 0xbb},	{0xb9, 0x1c, 0x07, 0xbb},
	{0xba, 0x0a, 0x03, 0xbb},	{0xbb, 0x1b, 0x09, 0xbb},
	{0xbc, 0x17, 0x0d, 0xbb},	{0xbd, 0x23, 0x1d, 0xbb},
	{0xbe, 0x00, 0x28, 0xbb},	{0xbf, 0x11, 0x09, 0xbb},
	{0xc0, 0x16, 0x15, 0xbb},	{0xc1, 0x00, 0x1b, 0xbb},
	{0xc2, 0x0e, 0x07, 0xbb},	{0xc3, 0x14, 0x10, 0xbb},
	{0xc4, 0x00, 0x17, 0xbb},	{0x06, 0x74, 0x8e, 0xbb},
	{0xf0, 0x00, 0x01, 0xbb},	{0x06, 0xf4, 0x8e, 0xbb},
	{0x00, 0x00, 0x50, 0xdd},	{0x06, 0x74, 0x8e, 0xbb},
	{0xf0, 0x00, 0x02, 0xbb},	{0x24, 0x50, 0x20, 0xbb},
	{0xf0, 0x00, 0x02, 0xbb},	{0x34, 0x0c, 0x50, 0xbb},
	{0xb3, 0x01, 0x41, 0xcc},	{0xf0, 0x00, 0x00, 0xbb},
	{0x03, 0x03, 0xc0, 0xbb},
	{},
};

static const __u8 mi1320_gamma[17] = {
	0x00, 0x13, 0x38, 0x59, 0x79, 0x92, 0xa7, 0xb9, 0xc8,
	0xd4, 0xdf, 0xe7, 0xee, 0xf4, 0xf9, 0xfc, 0xff
};
static const __u8 mi1320_matrix[9] = {
	0x54, 0xda, 0x06, 0xf1, 0x50, 0xf4, 0xf7, 0xea, 0x52
};
static const __u8 mi1320_initVGA_data[][4] = {
	{0xb3, 0x01, 0x01, 0xcc},	{0x00, 0x00, 0x33, 0xdd},
	{0xb0, 0x03, 0x19, 0xcc},	{0x00, 0x00, 0x33, 0xdd},
	{0xb0, 0x04, 0x02, 0xcc},	{0x00, 0x00, 0x33, 0xdd},
	{0xb3, 0x00, 0x64, 0xcc},	{0xb3, 0x00, 0x65, 0xcc},
	{0xb0, 0x16, 0x03, 0xcc},	{0xb3, 0x05, 0x00, 0xcc},
	{0xb3, 0x06, 0x00, 0xcc},	{0xb3, 0x08, 0x01, 0xcc},
	{0xb3, 0x09, 0x0c, 0xcc},	{0xb3, 0x34, 0x02, 0xcc},
	{0xb3, 0x35, 0xc8, 0xcc},	{0xb3, 0x02, 0x00, 0xcc},
	{0xb3, 0x03, 0x0a, 0xcc},	{0xb3, 0x04, 0x05, 0xcc},
	{0xb3, 0x20, 0x00, 0xcc},	{0xb3, 0x21, 0x00, 0xcc},
	{0xb3, 0x22, 0x03, 0xcc},	{0xb3, 0x23, 0xc0, 0xcc},
	{0xb3, 0x14, 0x00, 0xcc},	{0xb3, 0x15, 0x00, 0xcc},
	{0xb3, 0x16, 0x04, 0xcc},	{0xb3, 0x17, 0xff, 0xcc},
	{0xb3, 0x00, 0x67, 0xcc},	{0xbc, 0x00, 0xd0, 0xcc},
	{0xbc, 0x01, 0x01, 0xcc},	{0xf0, 0x00, 0x00, 0xbb},
	{0x0d, 0x00, 0x09, 0xbb},	{0x00, 0x01, 0x00, 0xdd},
	{0x0d, 0x00, 0x08, 0xbb},	{0xf0, 0x00, 0x01, 0xbb},
	{0xa1, 0x05, 0x00, 0xbb},	{0xa4, 0x03, 0xc0, 0xbb},
	{0xf0, 0x00, 0x02, 0xbb},	{0x00, 0x00, 0x10, 0xdd},
	{0xc8, 0x9f, 0x0b, 0xbb},	{0x00, 0x00, 0x10, 0xdd},
	{0xf0, 0x00, 0x00, 0xbb},	{0x00, 0x00, 0x10, 0xdd},
	{0x20, 0x01, 0x00, 0xbb},	{0x00, 0x00, 0x10, 0xdd},
	{0xf0, 0x00, 0x01, 0xbb},	{0x9d, 0x3c, 0xa0, 0xbb},
	{0x47, 0x30, 0x30, 0xbb},	{0xf0, 0x00, 0x00, 0xbb},
	{0x0a, 0x80, 0x11, 0xbb},	{0x35, 0x00, 0x22, 0xbb},
	{0xf0, 0x00, 0x02, 0xbb},	{0x9d, 0xc5, 0x05, 0xbb},
	{0xdc, 0x0f, 0xfc, 0xbb},	{0xf0, 0x00, 0x01, 0xbb},
	{0x06, 0x74, 0x0e, 0xbb},	{0x80, 0x00, 0x06, 0xbb},
	{0x81, 0x04, 0x00, 0xbb},	{0x82, 0x01, 0x02, 0xbb},
	{0x83, 0x03, 0x02, 0xbb},	{0x84, 0x05, 0x00, 0xbb},
	{0x85, 0x01, 0x00, 0xbb},	{0x86, 0x03, 0x02, 0xbb},
	{0x87, 0x05, 0x00, 0xbb},	{0x88, 0x01, 0x00, 0xbb},
	{0x89, 0x02, 0x02, 0xbb},	{0x8a, 0xfd, 0x04, 0xbb},
	{0x8b, 0xfc, 0xfd, 0xbb},	{0x8c, 0xff, 0xfd, 0xbb},
	{0x8d, 0x00, 0x00, 0xbb},	{0x8e, 0xfe, 0x05, 0xbb},
	{0x8f, 0xfc, 0xfd, 0xbb},	{0x90, 0xfe, 0xfd, 0xbb},
	{0x91, 0x00, 0x00, 0xbb},	{0x92, 0xfe, 0x03, 0xbb},
	{0x93, 0xfd, 0xfe, 0xbb},	{0x94, 0xff, 0xfd, 0xbb},
	{0x95, 0x00, 0x00, 0xbb},	{0xb6, 0x07, 0x05, 0xbb},
	{0xb7, 0x13, 0x06, 0xbb},	{0xb8, 0x08, 0x06, 0xbb},
	{0xb9, 0x14, 0x08, 0xbb},	{0xba, 0x06, 0x05, 0xbb},
	{0xbb, 0x13, 0x06, 0xbb},	{0xbc, 0x03, 0x01, 0xbb},
	{0xbd, 0x03, 0x04, 0xbb},	{0xbe, 0x00, 0x02, 0xbb},
	{0xbf, 0x03, 0x01, 0xbb},	{0xc0, 0x02, 0x04, 0xbb},
	{0xc1, 0x00, 0x04, 0xbb},	{0xc2, 0x02, 0x01, 0xbb},
	{0xc3, 0x01, 0x03, 0xbb},	{0xc4, 0x00, 0x04, 0xbb},
	{0xf0, 0x00, 0x00, 0xbb},	{0x05, 0x01, 0x13, 0xbb},
	{0x06, 0x00, 0x11, 0xbb},	{0x07, 0x00, 0x85, 0xbb},
	{0x08, 0x00, 0x27, 0xbb},	{0x20, 0x01, 0x03, 0xbb},
	{0x21, 0x80, 0x00, 0xbb},	{0x22, 0x0d, 0x0f, 0xbb},
	{0x24, 0x80, 0x00, 0xbb},	{0x59, 0x00, 0xff, 0xbb},
	{0xf0, 0x00, 0x02, 0xbb},	{0x39, 0x03, 0x0d, 0xbb},
	{0x3a, 0x06, 0x1b, 0xbb},	{0x3b, 0x00, 0x95, 0xbb},
	{0x3c, 0x04, 0xdb, 0xbb},	{0x57, 0x02, 0x00, 0xbb},
	{0x58, 0x02, 0x66, 0xbb},	{0x59, 0x00, 0xff, 0xbb},
	{0x5a, 0x01, 0x33, 0xbb},	{0x5c, 0x12, 0x0d, 0xbb},
	{0x5d, 0x16, 0x11, 0xbb},	{0x64, 0x5e, 0x1c, 0xbb},
	{0xf0, 0x00, 0x02, 0xbb},	{0x2f, 0xd1, 0x00, 0xbb},
	{0x5b, 0x00, 0x01, 0xbb},	{0xf0, 0x00, 0x02, 0xbb},
	{0x36, 0x68, 0x10, 0xbb},	{0x00, 0x00, 0x30, 0xdd},
	{0x37, 0x82, 0x00, 0xbb},	{0xbc, 0x0e, 0x00, 0xcc},
	{0xbc, 0x0f, 0x05, 0xcc},	{0xbc, 0x10, 0xc0, 0xcc},
	{0xbc, 0x11, 0x03, 0xcc},	{0xb6, 0x00, 0x00, 0xcc},
	{0xb6, 0x03, 0x05, 0xcc},	{0xb6, 0x02, 0x00, 0xcc},
	{0xb6, 0x05, 0x04, 0xcc},	{0xb6, 0x04, 0x00, 0xcc},
	{0xb6, 0x12, 0xf8, 0xcc},	{0xb6, 0x13, 0x29, 0xcc},
	{0xb6, 0x18, 0x0a, 0xcc},	{0xb6, 0x17, 0x00, 0xcc},
	{0xb6, 0x16, 0x00, 0xcc},	{0xb6, 0x22, 0x12, 0xcc},
	{0xb6, 0x23, 0x0b, 0xcc},	{0xbf, 0xc0, 0x26, 0xcc},
	{0xbf, 0xc1, 0x02, 0xcc},	{0xbf, 0xcc, 0x04, 0xcc},
	{0xbc, 0x02, 0x18, 0xcc},	{0xbc, 0x03, 0x50, 0xcc},
	{0xbc, 0x04, 0x18, 0xcc},	{0xbc, 0x05, 0x00, 0xcc},
	{0xbc, 0x06, 0x00, 0xcc},	{0xbc, 0x08, 0x30, 0xcc},
	{0xbc, 0x09, 0x40, 0xcc},	{0xbc, 0x0a, 0x10, 0xcc},
	{0xbc, 0x0b, 0x00, 0xcc},	{0xbc, 0x0c, 0x00, 0xcc},
	{0xb3, 0x5c, 0x01, 0xcc},	{0xb3, 0x01, 0x41, 0xcc},
	{}
};
static const __u8 mi1320_initQVGA_data[][4] = {
	{0xb3, 0x01, 0x01, 0xcc},	{0x00, 0x00, 0x33, 0xdd},
	{0xb0, 0x03, 0x19, 0xcc},	{0x00, 0x00, 0x33, 0xdd},
	{0xb0, 0x04, 0x02, 0xcc},	{0x00, 0x00, 0x33, 0xdd},
	{0xb3, 0x00, 0x64, 0xcc},	{0xb3, 0x00, 0x65, 0xcc},
	{0xb0, 0x16, 0x03, 0xcc},	{0xb3, 0x05, 0x01, 0xcc},
	{0xb3, 0x06, 0x01, 0xcc},	{0xb3, 0x08, 0x01, 0xcc},
	{0xb3, 0x09, 0x0c, 0xcc},	{0xb3, 0x34, 0x02, 0xcc},
	{0xb3, 0x35, 0xc8, 0xcc},	{0xb3, 0x02, 0x00, 0xcc},
	{0xb3, 0x03, 0x0a, 0xcc},	{0xb3, 0x04, 0x05, 0xcc},
	{0xb3, 0x20, 0x00, 0xcc},	{0xb3, 0x21, 0x00, 0xcc},
	{0xb3, 0x22, 0x01, 0xcc},	{0xb3, 0x23, 0xe0, 0xcc},
	{0xb3, 0x14, 0x00, 0xcc},	{0xb3, 0x15, 0x00, 0xcc},
	{0xb3, 0x16, 0x02, 0xcc},	{0xb3, 0x17, 0x7f, 0xcc},
	{0xb3, 0x00, 0x65, 0xcc},	{0xb8, 0x00, 0x00, 0xcc},
	{0xbc, 0x00, 0xd0, 0xcc},	{0xbc, 0x01, 0x01, 0xcc},
	{0xf0, 0x00, 0x00, 0xbb},	{0x0d, 0x00, 0x09, 0xbb},
	{0x00, 0x01, 0x00, 0xdd},	{0x0d, 0x00, 0x08, 0xbb},
	{0xf0, 0x00, 0x00, 0xbb},	{0x02, 0x00, 0x64, 0xbb},
	{0x05, 0x01, 0x78, 0xbb},	{0x06, 0x00, 0x11, 0xbb},
	{0x07, 0x01, 0x42, 0xbb},	{0x08, 0x00, 0x11, 0xbb},
	{0x20, 0x01, 0x00, 0xbb},	{0x21, 0x80, 0x00, 0xbb},
	{0x22, 0x0d, 0x0f, 0xbb},	{0x24, 0x80, 0x00, 0xbb},
	{0x59, 0x00, 0xff, 0xbb},	{0xf0, 0x00, 0x01, 0xbb},
	{0x9d, 0x3c, 0xa0, 0xbb},	{0x47, 0x30, 0x30, 0xbb},
	{0xf0, 0x00, 0x00, 0xbb},	{0x0a, 0x80, 0x11, 0xbb},
	{0x35, 0x00, 0x22, 0xbb},	{0xf0, 0x00, 0x02, 0xbb},
	{0x9d, 0xc5, 0x05, 0xbb},	{0xdc, 0x0f, 0xfc, 0xbb},
	{0xf0, 0x00, 0x01, 0xbb},	{0x06, 0x74, 0x0e, 0xbb},
	{0x80, 0x00, 0x06, 0xbb},	{0x81, 0x04, 0x00, 0xbb},
	{0x82, 0x01, 0x02, 0xbb},	{0x83, 0x03, 0x02, 0xbb},
	{0x84, 0x05, 0x00, 0xbb},	{0x85, 0x01, 0x00, 0xbb},
	{0x86, 0x03, 0x02, 0xbb},	{0x87, 0x05, 0x00, 0xbb},
	{0x88, 0x01, 0x00, 0xbb},	{0x89, 0x02, 0x02, 0xbb},
	{0x8a, 0xfd, 0x04, 0xbb},	{0x8b, 0xfc, 0xfd, 0xbb},
	{0x8c, 0xff, 0xfd, 0xbb},	{0x8d, 0x00, 0x00, 0xbb},
	{0x8e, 0xfe, 0x05, 0xbb},	{0x8f, 0xfc, 0xfd, 0xbb},
	{0x90, 0xfe, 0xfd, 0xbb},	{0x91, 0x00, 0x00, 0xbb},
	{0x92, 0xfe, 0x03, 0xbb},	{0x93, 0xfd, 0xfe, 0xbb},
	{0x94, 0xff, 0xfd, 0xbb},	{0x95, 0x00, 0x00, 0xbb},
	{0xb6, 0x07, 0x05, 0xbb},	{0xb7, 0x13, 0x06, 0xbb},
	{0xb8, 0x08, 0x06, 0xbb},	{0xb9, 0x14, 0x08, 0xbb},
	{0xba, 0x06, 0x05, 0xbb},	{0xbb, 0x13, 0x06, 0xbb},
	{0xbc, 0x03, 0x01, 0xbb},	{0xbd, 0x03, 0x04, 0xbb},
	{0xbe, 0x00, 0x02, 0xbb},	{0xbf, 0x03, 0x01, 0xbb},
	{0xc0, 0x02, 0x04, 0xbb},	{0xc1, 0x00, 0x04, 0xbb},
	{0xc2, 0x02, 0x01, 0xbb},	{0xc3, 0x01, 0x03, 0xbb},
	{0xc4, 0x00, 0x04, 0xbb},	{0xf0, 0x00, 0x02, 0xbb},
	{0xc8, 0x00, 0x00, 0xbb},	{0x2e, 0x00, 0x00, 0xbb},
	{0x2e, 0x0c, 0x5b, 0xbb},	{0x2f, 0xd1, 0x00, 0xbb},
	{0x39, 0x03, 0xca, 0xbb},	{0x3a, 0x06, 0x80, 0xbb},
	{0x3b, 0x01, 0x52, 0xbb},	{0x3c, 0x05, 0x40, 0xbb},
	{0x57, 0x01, 0x9c, 0xbb},	{0x58, 0x01, 0xee, 0xbb},
	{0x59, 0x00, 0xf0, 0xbb},	{0x5a, 0x01, 0x20, 0xbb},
	{0x5c, 0x1d, 0x17, 0xbb},	{0x5d, 0x22, 0x1c, 0xbb},
	{0x64, 0x1e, 0x1c, 0xbb},	{0x5b, 0x00, 0x01, 0xbb},
	{0xf0, 0x00, 0x02, 0xbb},	{0x36, 0x68, 0x10, 0xbb},
	{0x00, 0x00, 0x30, 0xdd},	{0x37, 0x81, 0x00, 0xbb},
	{0xbc, 0x02, 0x18, 0xcc},	{0xbc, 0x03, 0x50, 0xcc},
	{0xbc, 0x04, 0x18, 0xcc},	{0xbc, 0x05, 0x00, 0xcc},
	{0xbc, 0x06, 0x00, 0xcc},	{0xbc, 0x08, 0x30, 0xcc},
	{0xbc, 0x09, 0x40, 0xcc},	{0xbc, 0x0a, 0x10, 0xcc},
	{0xbc, 0x0b, 0x00, 0xcc},	{0xbc, 0x0c, 0x00, 0xcc},
	{0xbf, 0xc0, 0x26, 0xcc},	{0xbf, 0xc1, 0x02, 0xcc},
	{0xbf, 0xcc, 0x04, 0xcc},	{0xb3, 0x5c, 0x01, 0xcc},
	{0xb3, 0x01, 0x41, 0xcc},
	{}
};

static const __u8 po3130_gamma[17] = {
	0x00, 0x13, 0x38, 0x59, 0x79, 0x92, 0xa7, 0xb9, 0xc8,
	0xd4, 0xdf, 0xe7, 0xee, 0xf4, 0xf9, 0xfc, 0xff
};
static const __u8 po3130_matrix[9] = {
	0x5f, 0xec, 0xf5, 0xf1, 0x5a, 0xf5, 0xf1, 0xec, 0x63
};

static const __u8 po3130_initVGA_data[][4] = {
	{0xb0, 0x4d, 0x00, 0xcc},	{0xb3, 0x01, 0x01, 0xcc},
	{0x00, 0x00, 0x50, 0xdd},	{0xb0, 0x03, 0x01, 0xcc},
	{0xb3, 0x00, 0x04, 0xcc},	{0xb3, 0x00, 0x24, 0xcc},
	{0xb3, 0x00, 0x25, 0xcc},	{0xb3, 0x08, 0x01, 0xcc},
	{0xb3, 0x09, 0x0c, 0xcc},	{0xb3, 0x05, 0x00, 0xcc},
	{0xb3, 0x06, 0x01, 0xcc},	{0xb3, 0x03, 0x1a, 0xcc},
	{0xb3, 0x04, 0x15, 0xcc},	{0xb3, 0x20, 0x00, 0xcc},
	{0xb3, 0x21, 0x00, 0xcc},	{0xb3, 0x22, 0x01, 0xcc},
	{0xb3, 0x23, 0xe8, 0xcc},	{0xb8, 0x08, 0xe8, 0xcc},
	{0xb3, 0x14, 0x00, 0xcc},	{0xb3, 0x15, 0x00, 0xcc},
	{0xb3, 0x16, 0x02, 0xcc},	{0xb3, 0x17, 0x7f, 0xcc},
	{0xb3, 0x34, 0x01, 0xcc},	{0xb3, 0x35, 0xf6, 0xcc},
	{0xb3, 0x00, 0x27, 0xcc},	{0xbc, 0x00, 0x71, 0xcc},
	{0xb8, 0x00, 0x21, 0xcc},	{0xb8, 0x27, 0x20, 0xcc},
	{0xb8, 0x01, 0x79, 0xcc},	{0xb8, 0x81, 0x09, 0xcc},
	{0xb8, 0x2c, 0x50, 0xcc},	{0xb8, 0x2d, 0xf8, 0xcc},
	{0xb8, 0x2e, 0xf8, 0xcc},	{0xb8, 0x2f, 0xf8, 0xcc},
	{0xb8, 0x30, 0x50, 0xcc},	{0xb8, 0x31, 0xf8, 0xcc},
	{0xb8, 0x32, 0xf8, 0xcc},	{0xb8, 0x33, 0xf8, 0xcc},
	{0xb8, 0x34, 0x50, 0xcc},	{0xb8, 0x35, 0x00, 0xcc},
	{0xb8, 0x36, 0x00, 0xcc},	{0xb8, 0x37, 0x00, 0xcc},
	{0x00, 0x1e, 0xc6, 0xaa},	{0x00, 0x20, 0x44, 0xaa},
	{0x00, 0xad, 0x02, 0xaa},	{0x00, 0xae, 0x2c, 0xaa},
	{0x00, 0x12, 0x08, 0xaa},	{0x00, 0x17, 0x41, 0xaa},
	{0x00, 0x19, 0x41, 0xaa},	{0x00, 0x1e, 0x06, 0xaa},
	{0x00, 0x21, 0x00, 0xaa},	{0x00, 0x36, 0xc0, 0xaa},
	{0x00, 0x37, 0xc8, 0xaa},	{0x00, 0x3b, 0x36, 0xaa},
	{0x00, 0x4b, 0xfe, 0xaa},	{0x00, 0x51, 0x1c, 0xaa},
	{0x00, 0x52, 0x01, 0xaa},	{0x00, 0x55, 0x0a, 0xaa},
	{0x00, 0x59, 0x02, 0xaa},	{0x00, 0x5a, 0x04, 0xaa},
	{0x00, 0x5c, 0x10, 0xaa},	{0x00, 0x5d, 0x10, 0xaa},
	{0x00, 0x5e, 0x10, 0xaa},	{0x00, 0x5f, 0x10, 0xaa},
	{0x00, 0x61, 0x00, 0xaa},	{0x00, 0x62, 0x18, 0xaa},
	{0x00, 0x63, 0x30, 0xaa},	{0x00, 0x70, 0x68, 0xaa},
	{0x00, 0x80, 0x71, 0xaa},	{0x00, 0x81, 0x08, 0xaa},
	{0x00, 0x82, 0x00, 0xaa},	{0x00, 0x83, 0x55, 0xaa},
	{0x00, 0x84, 0x06, 0xaa},	{0x00, 0x85, 0x06, 0xaa},
	{0x00, 0x86, 0x13, 0xaa},	{0x00, 0x87, 0x18, 0xaa},
	{0x00, 0xaa, 0x3f, 0xaa},	{0x00, 0xab, 0x44, 0xaa},
	{0x00, 0xb0, 0x68, 0xaa},	{0x00, 0xb5, 0x10, 0xaa},
	{0x00, 0xb8, 0x20, 0xaa},	{0x00, 0xb9, 0xa0, 0xaa},
	{0x00, 0xbc, 0x04, 0xaa},	{0x00, 0x8b, 0x40, 0xaa},
	{0x00, 0x8c, 0x91, 0xaa},	{0x00, 0x8d, 0x8f, 0xaa},
	{0x00, 0x8e, 0x91, 0xaa},	{0x00, 0x8f, 0x43, 0xaa},
	{0x00, 0x90, 0x92, 0xaa},	{0x00, 0x91, 0x89, 0xaa},
	{0x00, 0x92, 0x9d, 0xaa},	{0x00, 0x93, 0x46, 0xaa},
	{0x00, 0xd6, 0x22, 0xaa},	{0x00, 0x73, 0x00, 0xaa},
	{0x00, 0x74, 0x10, 0xaa},	{0x00, 0x75, 0x20, 0xaa},
	{0x00, 0x76, 0x2b, 0xaa},	{0x00, 0x77, 0x36, 0xaa},
	{0x00, 0x78, 0x49, 0xaa},	{0x00, 0x79, 0x5a, 0xaa},
	{0x00, 0x7a, 0x7f, 0xaa},	{0x00, 0x7b, 0x9b, 0xaa},
	{0x00, 0x7c, 0xba, 0xaa},	{0x00, 0x7d, 0xd4, 0xaa},
	{0x00, 0x7e, 0xea, 0xaa},	{0x00, 0xd6, 0x62, 0xaa},
	{0x00, 0x73, 0x00, 0xaa},	{0x00, 0x74, 0x10, 0xaa},
	{0x00, 0x75, 0x20, 0xaa},	{0x00, 0x76, 0x2b, 0xaa},
	{0x00, 0x77, 0x36, 0xaa},	{0x00, 0x78, 0x49, 0xaa},
	{0x00, 0x79, 0x5a, 0xaa},	{0x00, 0x7a, 0x7f, 0xaa},
	{0x00, 0x7b, 0x9b, 0xaa},	{0x00, 0x7c, 0xba, 0xaa},
	{0x00, 0x7d, 0xd4, 0xaa},	{0x00, 0x7e, 0xea, 0xaa},
	{0x00, 0xd6, 0xa2, 0xaa},	{0x00, 0x73, 0x00, 0xaa},
	{0x00, 0x74, 0x10, 0xaa},	{0x00, 0x75, 0x20, 0xaa},
	{0x00, 0x76, 0x2b, 0xaa},	{0x00, 0x77, 0x36, 0xaa},
	{0x00, 0x78, 0x49, 0xaa},	{0x00, 0x79, 0x5a, 0xaa},
	{0x00, 0x7a, 0x7f, 0xaa},	{0x00, 0x7b, 0x9b, 0xaa},
	{0x00, 0x7c, 0xba, 0xaa},	{0x00, 0x7d, 0xd4, 0xaa},
	{0x00, 0x7e, 0xea, 0xaa},
	{0x00, 0x4c, 0x07, 0xaa},
	{0x00, 0x4b, 0xe0, 0xaa},	{0x00, 0x4e, 0x77, 0xaa},
	{0x00, 0x59, 0x02, 0xaa},	{0x00, 0x4d, 0x0a, 0xaa},
/*	{0x00, 0xd1, 0x00, 0xaa},	{0x00, 0x20, 0xc4, 0xaa},
	{0xb8, 0x8e, 0x00, 0xcc},	{0xb8, 0x8f, 0xff, 0xcc}, */
	{0x00, 0xd1, 0x3c, 0xaa},	{0x00, 0x20, 0xc4, 0xaa},
	{0xb8, 0x8e, 0x00, 0xcc},	{0xb8, 0x8f, 0xff, 0xcc},
	{0xb8, 0xfe, 0x00, 0xcc},	{0xb8, 0xff, 0x28, 0xcc},
	{0xb9, 0x00, 0x28, 0xcc},	{0xb9, 0x01, 0x28, 0xcc},
	{0xb9, 0x02, 0x28, 0xcc},	{0xb9, 0x03, 0x00, 0xcc},
	{0xb9, 0x04, 0x00, 0xcc},	{0xb9, 0x05, 0x3c, 0xcc},
	{0xb9, 0x06, 0x3c, 0xcc},	{0xb9, 0x07, 0x3c, 0xcc},
	{0xb9, 0x08, 0x3c, 0xcc},	{0x00, 0x05, 0x00, 0xaa},
	{0xb3, 0x5c, 0x00, 0xcc},	{0xb3, 0x01, 0x41, 0xcc},
	{}
};
static const __u8 po3130_rundata[][4] = {
	{0x00, 0x47, 0x45, 0xaa},	{0x00, 0x48, 0x9b, 0xaa},
	{0x00, 0x49, 0x3a, 0xaa},	{0x00, 0x4a, 0x01, 0xaa},
	{0x00, 0x44, 0x40, 0xaa},
/*	{0x00, 0xd5, 0x7c, 0xaa}, */
	{0x00, 0xad, 0x04, 0xaa},	{0x00, 0xae, 0x00, 0xaa},
	{0x00, 0xb0, 0x78, 0xaa},	{0x00, 0x98, 0x02, 0xaa},
	{0x00, 0x94, 0x25, 0xaa},	{0x00, 0x95, 0x25, 0xaa},
	{0x00, 0x59, 0x68, 0xaa},	{0x00, 0x44, 0x20, 0xaa},
	{0x00, 0x17, 0x50, 0xaa},	{0x00, 0x19, 0x50, 0xaa},
	{0x00, 0xd1, 0x3c, 0xaa},	{0x00, 0xd1, 0x3c, 0xaa},
	{0x00, 0x1e, 0x06, 0xaa},	{0x00, 0x1e, 0x06, 0xaa},
	{}
};

static const __u8 po3130_initQVGA_data[][4] = {
	{0xb0, 0x4d, 0x00, 0xcc},	{0xb3, 0x01, 0x01, 0xcc},
	{0x00, 0x00, 0x50, 0xdd},	{0xb0, 0x03, 0x09, 0xcc},
	{0xb3, 0x00, 0x04, 0xcc},	{0xb3, 0x00, 0x24, 0xcc},
	{0xb3, 0x00, 0x25, 0xcc},	{0xb3, 0x08, 0x01, 0xcc},
	{0xb3, 0x09, 0x0c, 0xcc},	{0xb3, 0x05, 0x00, 0xcc},
	{0xb3, 0x06, 0x01, 0xcc},	{0xb3, 0x03, 0x1a, 0xcc},
	{0xb3, 0x04, 0x15, 0xcc},	{0xb3, 0x20, 0x00, 0xcc},
	{0xb3, 0x21, 0x00, 0xcc},	{0xb3, 0x22, 0x01, 0xcc},
	{0xb3, 0x23, 0xe0, 0xcc},	{0xb8, 0x08, 0xe0, 0xcc},
	{0xb3, 0x14, 0x00, 0xcc},	{0xb3, 0x15, 0x00, 0xcc},
	{0xb3, 0x16, 0x02, 0xcc},	{0xb3, 0x17, 0x7f, 0xcc},
	{0xb3, 0x34, 0x01, 0xcc},	{0xb3, 0x35, 0xf6, 0xcc},
	{0xb3, 0x00, 0x27, 0xcc},	{0xbc, 0x00, 0xd1, 0xcc},
	{0xb8, 0x00, 0x21, 0xcc},	{0xb8, 0x27, 0x20, 0xcc},
	{0xb8, 0x01, 0x79, 0xcc},	{0xb8, 0x81, 0x09, 0xcc},
	{0xb8, 0x2c, 0x50, 0xcc},	{0xb8, 0x2d, 0xf8, 0xcc},
	{0xb8, 0x2e, 0xf8, 0xcc},	{0xb8, 0x2f, 0xf8, 0xcc},
	{0xb8, 0x30, 0x50, 0xcc},	{0xb8, 0x31, 0xf8, 0xcc},
	{0xb8, 0x32, 0xf8, 0xcc},	{0xb8, 0x33, 0xf8, 0xcc},
	{0xb8, 0x34, 0x50, 0xcc},	{0xb8, 0x35, 0x00, 0xcc},
	{0xb8, 0x36, 0x00, 0xcc},	{0xb8, 0x37, 0x00, 0xcc},
	{0x00, 0x1e, 0xc6, 0xaa},	{0x00, 0x20, 0x44, 0xaa},
	{0x00, 0xad, 0x02, 0xaa},	{0x00, 0xae, 0x2c, 0xaa},
	{0x00, 0x12, 0x08, 0xaa},	{0x00, 0x17, 0x41, 0xaa},
	{0x00, 0x19, 0x41, 0xaa},	{0x00, 0x1e, 0x06, 0xaa},
	{0x00, 0x21, 0x00, 0xaa},	{0x00, 0x36, 0xc0, 0xaa},
	{0x00, 0x37, 0xc8, 0xaa},	{0x00, 0x3b, 0x36, 0xaa},
	{0x00, 0x4b, 0xfe, 0xaa},	{0x00, 0x51, 0x1c, 0xaa},
	{0x00, 0x52, 0x01, 0xaa},	{0x00, 0x55, 0x0a, 0xaa},
	{0x00, 0x59, 0x6f, 0xaa},	{0x00, 0x5a, 0x04, 0xaa},
	{0x00, 0x5c, 0x10, 0xaa},	{0x00, 0x5d, 0x10, 0xaa},
	{0x00, 0x5e, 0x10, 0xaa},	{0x00, 0x5f, 0x10, 0xaa},
	{0x00, 0x61, 0x00, 0xaa},	{0x00, 0x62, 0x18, 0xaa},
	{0x00, 0x63, 0x30, 0xaa},	{0x00, 0x70, 0x68, 0xaa},
	{0x00, 0x80, 0x71, 0xaa},	{0x00, 0x81, 0x08, 0xaa},
	{0x00, 0x82, 0x00, 0xaa},	{0x00, 0x83, 0x55, 0xaa},
	{0x00, 0x84, 0x06, 0xaa},	{0x00, 0x85, 0x06, 0xaa},
	{0x00, 0x86, 0x13, 0xaa},	{0x00, 0x87, 0x18, 0xaa},
	{0x00, 0xaa, 0x3f, 0xaa},	{0x00, 0xab, 0x44, 0xaa},
	{0x00, 0xb0, 0x68, 0xaa},	{0x00, 0xb5, 0x10, 0xaa},
	{0x00, 0xb8, 0x20, 0xaa},	{0x00, 0xb9, 0xa0, 0xaa},
	{0x00, 0xbc, 0x04, 0xaa},	{0x00, 0x8b, 0x40, 0xaa},
	{0x00, 0x8c, 0x91, 0xaa},	{0x00, 0x8d, 0x8f, 0xaa},
	{0x00, 0x8e, 0x91, 0xaa},	{0x00, 0x8f, 0x43, 0xaa},
	{0x00, 0x90, 0x92, 0xaa},	{0x00, 0x91, 0x89, 0xaa},
	{0x00, 0x92, 0x9d, 0xaa},	{0x00, 0x93, 0x46, 0xaa},
	{0x00, 0xd6, 0x22, 0xaa},	{0x00, 0x73, 0x00, 0xaa},
	{0x00, 0x74, 0x10, 0xaa},	{0x00, 0x75, 0x20, 0xaa},
	{0x00, 0x76, 0x2b, 0xaa},	{0x00, 0x77, 0x36, 0xaa},
	{0x00, 0x78, 0x49, 0xaa},	{0x00, 0x79, 0x5a, 0xaa},
	{0x00, 0x7a, 0x7f, 0xaa},	{0x00, 0x7b, 0x9b, 0xaa},
	{0x00, 0x7c, 0xba, 0xaa},	{0x00, 0x7d, 0xd4, 0xaa},
	{0x00, 0x7e, 0xea, 0xaa},	{0x00, 0xd6, 0x62, 0xaa},
	{0x00, 0x73, 0x00, 0xaa},	{0x00, 0x74, 0x10, 0xaa},
	{0x00, 0x75, 0x20, 0xaa},	{0x00, 0x76, 0x2b, 0xaa},
	{0x00, 0x77, 0x36, 0xaa},	{0x00, 0x78, 0x49, 0xaa},
	{0x00, 0x79, 0x5a, 0xaa},	{0x00, 0x7a, 0x7f, 0xaa},
	{0x00, 0x7b, 0x9b, 0xaa},	{0x00, 0x7c, 0xba, 0xaa},
	{0x00, 0x7d, 0xd4, 0xaa},	{0x00, 0x7e, 0xea, 0xaa},
	{0x00, 0xd6, 0xa2, 0xaa},	{0x00, 0x73, 0x00, 0xaa},
	{0x00, 0x74, 0x10, 0xaa},	{0x00, 0x75, 0x20, 0xaa},
	{0x00, 0x76, 0x2b, 0xaa},	{0x00, 0x77, 0x36, 0xaa},
	{0x00, 0x78, 0x49, 0xaa},	{0x00, 0x79, 0x5a, 0xaa},
	{0x00, 0x7a, 0x7f, 0xaa},	{0x00, 0x7b, 0x9b, 0xaa},
	{0x00, 0x7c, 0xba, 0xaa},	{0x00, 0x7d, 0xd4, 0xaa},
	{0x00, 0x7e, 0xea, 0xaa},	{0x00, 0x4c, 0x07, 0xaa},
	{0x00, 0x4b, 0xe0, 0xaa},	{0x00, 0x4e, 0x77, 0xaa},
	{0x00, 0x59, 0x66, 0xaa},	{0x00, 0x4d, 0x0a, 0xaa},
	{0x00, 0xd1, 0x00, 0xaa},	{0x00, 0x20, 0xc4, 0xaa},
	{0xb8, 0x8e, 0x00, 0xcc},	{0xb8, 0x8f, 0xff, 0xcc},
	{0xb8, 0xfe, 0x00, 0xcc},	{0xb8, 0xff, 0x28, 0xcc},
	{0xb9, 0x00, 0x28, 0xcc},	{0xb9, 0x01, 0x28, 0xcc},
	{0xb9, 0x02, 0x28, 0xcc},	{0xb9, 0x03, 0x00, 0xcc},
	{0xb9, 0x04, 0x00, 0xcc},	{0xb9, 0x05, 0x3c, 0xcc},
	{0xb9, 0x06, 0x3c, 0xcc},	{0xb9, 0x07, 0x3c, 0xcc},
	{0xb9, 0x08, 0x3c, 0xcc},	{0xbc, 0x02, 0x18, 0xcc},
	{0xbc, 0x03, 0x50, 0xcc},	{0xbc, 0x04, 0x18, 0xcc},
	{0xbc, 0x05, 0x00, 0xcc},	{0xbc, 0x06, 0x00, 0xcc},
	{0xbc, 0x08, 0x30, 0xcc},	{0xbc, 0x09, 0x40, 0xcc},
	{0xbc, 0x0a, 0x10, 0xcc},	{0xbc, 0x0b, 0x00, 0xcc},
	{0xbc, 0x0c, 0x00, 0xcc},	{0x00, 0x05, 0x00, 0xaa},
	{0xb3, 0x5c, 0x00, 0xcc},	{0xb3, 0x01, 0x41, 0xcc},
	{}
};

static const __u8 hv7131r_gamma[17] = {
/*	0x00, 0x13, 0x38, 0x59, 0x79, 0x92, 0xa7, 0xb9, 0xc8,
 *	0xd4, 0xdf, 0xe7, 0xee, 0xf4, 0xf9, 0xfc, 0xff */
	0x04, 0x1a, 0x36, 0x55, 0x6f, 0x87, 0x9d, 0xb0, 0xc1,
	0xcf, 0xda, 0xe4, 0xec, 0xf3, 0xf8, 0xfd, 0xff
};
static const __u8 hv7131r_matrix[9] = {
	0x5f, 0xec, 0xf5, 0xf1, 0x5a, 0xf5, 0xf1, 0xec, 0x63
};
static const __u8 hv7131r_initVGA_data[][4] = {
	{0xb0, 0x4d, 0x00, 0xcc},	{0xb3, 0x01, 0x01, 0xcc},
	{0x00, 0x00, 0x50, 0xdd},	{0xb0, 0x03, 0x01, 0xcc},
	{0xb3, 0x00, 0x24, 0xcc},
	{0xb3, 0x00, 0x25, 0xcc},	{0xb3, 0x08, 0x01, 0xcc},
	{0xb3, 0x09, 0x0c, 0xcc},	{0xb3, 0x05, 0x00, 0xcc},
	{0xb3, 0x06, 0x01, 0xcc},
	{0xb3, 0x01, 0x45, 0xcc},	{0xb3, 0x03, 0x0b, 0xcc},
	{0xb3, 0x04, 0x05, 0xcc},	{0xb3, 0x20, 0x00, 0xcc},
	{0xb3, 0x21, 0x00, 0xcc},
	{0xb3, 0x22, 0x01, 0xcc},	{0xb3, 0x23, 0xe0, 0xcc},
	{0xb3, 0x14, 0x00, 0xcc},	{0xb3, 0x15, 0x00, 0xcc},
	{0xb3, 0x16, 0x02, 0xcc},
	{0xb3, 0x17, 0x7f, 0xcc},	{0xb3, 0x34, 0x01, 0xcc},
	{0xb3, 0x35, 0x91, 0xcc},	{0xb3, 0x00, 0x27, 0xcc},
	{0xbc, 0x00, 0x73, 0xcc},
	{0xb8, 0x00, 0x23, 0xcc},	{0x00, 0x01, 0x0c, 0xaa},
	{0x00, 0x14, 0x01, 0xaa},	{0x00, 0x15, 0xe6, 0xaa},
	{0x00, 0x16, 0x02, 0xaa},
	{0x00, 0x17, 0x86, 0xaa},	{0x00, 0x23, 0x00, 0xaa},
	{0x00, 0x25, 0x09, 0xaa},	{0x00, 0x26, 0x27, 0xaa},
	{0x00, 0x27, 0xc0, 0xaa},
	{0xb8, 0x2c, 0x60, 0xcc},	{0xb8, 0x2d, 0xf8, 0xcc},
	{0xb8, 0x2e, 0xf8, 0xcc},	{0xb8, 0x2f, 0xf8, 0xcc},
	{0xb8, 0x30, 0x50, 0xcc},
	{0xb8, 0x31, 0xf8, 0xcc},	{0xb8, 0x32, 0xf8, 0xcc},
	{0xb8, 0x33, 0xf8, 0xcc},	{0xb8, 0x34, 0x65, 0xcc},
	{0xb8, 0x35, 0x00, 0xcc},
	{0xb8, 0x36, 0x00, 0xcc},	{0xb8, 0x37, 0x00, 0xcc},
	{0xb8, 0x27, 0x20, 0xcc},	{0xb8, 0x01, 0x7d, 0xcc},
	{0xb8, 0x81, 0x09, 0xcc},
	{0xb3, 0x01, 0x41, 0xcc},	{0xb8, 0xfe, 0x00, 0xcc},
	{0xb8, 0xff, 0x28, 0xcc},	{0xb9, 0x00, 0x28, 0xcc},
	{0xb9, 0x01, 0x28, 0xcc},
	{0xb9, 0x02, 0x28, 0xcc},	{0xb9, 0x03, 0x00, 0xcc},
	{0xb9, 0x04, 0x00, 0xcc},	{0xb9, 0x05, 0x3c, 0xcc},
	{0xb9, 0x06, 0x3c, 0xcc},
	{0xb9, 0x07, 0x3c, 0xcc},	{0xb9, 0x08, 0x3c, 0xcc},
	{0xb8, 0x8e, 0x00, 0xcc},	{0xb8, 0x8f, 0xff, 0xcc},
	{0x00, 0x30, 0x18, 0xaa},
	{}
};

static const __u8 hv7131r_initQVGA_data[][4] = {
	{0xb0, 0x4d, 0x00, 0xcc},	{0xb3, 0x01, 0x01, 0xcc},
	{0x00, 0x00, 0x50, 0xdd},	{0xb0, 0x03, 0x01, 0xcc},
	{0xb3, 0x00, 0x24, 0xcc},
	{0xb3, 0x00, 0x25, 0xcc},	{0xb3, 0x08, 0x01, 0xcc},
	{0xb3, 0x09, 0x0c, 0xcc},	{0xb3, 0x05, 0x00, 0xcc},
	{0xb3, 0x06, 0x01, 0xcc},
	{0xb3, 0x03, 0x0b, 0xcc},	{0xb3, 0x04, 0x05, 0xcc},
	{0xb3, 0x20, 0x00, 0xcc},	{0xb3, 0x21, 0x00, 0xcc},
	{0xb3, 0x22, 0x01, 0xcc},
	{0xb3, 0x23, 0xe0, 0xcc},	{0xb3, 0x14, 0x00, 0xcc},
	{0xb3, 0x15, 0x00, 0xcc},	{0xb3, 0x16, 0x02, 0xcc},
	{0xb3, 0x17, 0x7f, 0xcc},
	{0xb3, 0x34, 0x01, 0xcc},	{0xb3, 0x35, 0x91, 0xcc},
	{0xb3, 0x00, 0x27, 0xcc},	{0xbc, 0x00, 0xd1, 0xcc},
	{0xb8, 0x00, 0x21, 0xcc},
	{0x00, 0x01, 0x0c, 0xaa},	{0x00, 0x14, 0x01, 0xaa},
	{0x00, 0x15, 0xe6, 0xaa},	{0x00, 0x16, 0x02, 0xaa},
	{0x00, 0x17, 0x86, 0xaa},
	{0x00, 0x23, 0x00, 0xaa},	{0x00, 0x25, 0x01, 0xaa},
	{0x00, 0x26, 0xd4, 0xaa},	{0x00, 0x27, 0xc0, 0xaa},
	{0xbc, 0x02, 0x08, 0xcc},
	{0xbc, 0x03, 0x70, 0xcc},	{0xbc, 0x04, 0x08, 0xcc},
	{0xbc, 0x05, 0x00, 0xcc},	{0xbc, 0x06, 0x00, 0xcc},
	{0xbc, 0x08, 0x3c, 0xcc},
	{0xbc, 0x09, 0x40, 0xcc},	{0xbc, 0x0a, 0x04, 0xcc},
	{0xbc, 0x0b, 0x00, 0xcc},	{0xbc, 0x0c, 0x00, 0xcc},
	{0xb8, 0xfe, 0x02, 0xcc},
	{0xb8, 0xff, 0x07, 0xcc},	{0xb9, 0x00, 0x14, 0xcc},
	{0xb9, 0x01, 0x14, 0xcc},	{0xb9, 0x02, 0x14, 0xcc},
	{0xb9, 0x03, 0x00, 0xcc},
	{0xb9, 0x04, 0x02, 0xcc},	{0xb9, 0x05, 0x05, 0xcc},
	{0xb9, 0x06, 0x0f, 0xcc},	{0xb9, 0x07, 0x0f, 0xcc},
	{0xb9, 0x08, 0x0f, 0xcc},
	{0xb8, 0x2c, 0x60, 0xcc},	{0xb8, 0x2d, 0xf8, 0xcc},
	{0xb8, 0x2e, 0xf8, 0xcc},	{0xb8, 0x2f, 0xf8, 0xcc},
	{0xb8, 0x30, 0x50, 0xcc},
	{0xb8, 0x31, 0xf8, 0xcc},	{0xb8, 0x32, 0xf8, 0xcc},
	{0xb8, 0x33, 0xf8, 0xcc},
	{0xb8, 0x34, 0x65, 0xcc},	{0xb8, 0x35, 0x00, 0xcc},
	{0xb8, 0x36, 0x00, 0xcc},	{0xb8, 0x37, 0x00, 0xcc},
	{0xb8, 0x27, 0x20, 0xcc},
	{0xb8, 0x01, 0x7d, 0xcc},	{0xb8, 0x81, 0x09, 0xcc},
	{0xb3, 0x01, 0x41, 0xcc},	{0xb8, 0xfe, 0x00, 0xcc},
	{0xb8, 0xff, 0x28, 0xcc},
	{0xb9, 0x00, 0x28, 0xcc},	{0xb9, 0x01, 0x28, 0xcc},
	{0xb9, 0x02, 0x28, 0xcc},	{0xb9, 0x03, 0x00, 0xcc},
	{0xb9, 0x04, 0x00, 0xcc},
	{0xb9, 0x05, 0x3c, 0xcc},	{0xb9, 0x06, 0x3c, 0xcc},
	{0xb9, 0x07, 0x3c, 0xcc},	{0xb9, 0x08, 0x3c, 0xcc},
	{0xb8, 0x8e, 0x00, 0xcc},
	{0xb8, 0x8f, 0xff, 0xcc},	{0x00, 0x30, 0x18, 0xaa},
	{}
};

static const __u8 ov7660_gamma[17] = {
	0x00, 0x13, 0x38, 0x59, 0x79, 0x92, 0xa7, 0xb9, 0xc8,
	0xd4, 0xdf, 0xe7, 0xee, 0xf4, 0xf9, 0xfc, 0xff
};
static const __u8 ov7660_matrix[9] = {
	0x5a, 0xf0, 0xf6, 0xf3, 0x57, 0xf6, 0xf3, 0xef, 0x62
};
static const __u8 ov7660_initVGA_data[][4] = {
	{0xb0, 0x4d, 0x00, 0xcc},	{0xb3, 0x01, 0x01, 0xcc},
	{0x00, 0x00, 0x50, 0xdd},
	{0xb0, 0x03, 0x01, 0xcc},
	{0xb3, 0x00, 0x21, 0xcc},	{0xb3, 0x00, 0x26, 0xcc},
	{0xb3, 0x05, 0x01, 0xcc},
	{0xb3, 0x06, 0x03, 0xcc},
	{0xb3, 0x03, 0x1f, 0xcc},	{0xb3, 0x04, 0x05, 0xcc},
	{0xb3, 0x05, 0x00, 0xcc},
	{0xb3, 0x06, 0x01, 0xcc},
	{0xb3, 0x15, 0x00, 0xcc},/* 0xb315  <-0 href startl */
	{0xb3, 0x16, 0x02, 0xcc},	{0xb3, 0x17, 0x7f, 0xcc},
	{0xb3, 0x21, 0x00, 0xcc},
	{0xb3, 0x23, 0xe0, 0xcc},	{0xb3, 0x1d, 0x01, 0xcc},
	{0xb3, 0x1f, 0x02, 0xcc},
	{0xb3, 0x34, 0x01, 0xcc},
	{0xb3, 0x35, 0xa1, 0xcc},	{0xb3, 0x00, 0x26, 0xcc},
	{0xb8, 0x00, 0x33, 0xcc}, /* 13 */
	{0xb8, 0x01, 0x7d, 0xcc},
	{0xbc, 0x00, 0x73, 0xcc},	{0xb8, 0x81, 0x09, 0xcc},
	{0xb8, 0x27, 0x20, 0xcc},
	{0xb8, 0x8f, 0x50, 0xcc},
	{0x00, 0x01, 0x80, 0xaa},	{0x00, 0x02, 0x80, 0xaa},
	{0x00, 0x12, 0x80, 0xaa},
	{0x00, 0x12, 0x05, 0xaa},
	{0x00, 0x1e, 0x01, 0xaa},
	{0x00, 0x3d, 0x40, 0xaa}, /* 0x3d <-40 gamma 01 */
	{0x00, 0x41, 0x00, 0xaa}, /* edge 00 */
	{0x00, 0x0d, 0x48, 0xaa},	{0x00, 0x0e, 0x04, 0xaa},
	{0x00, 0x13, 0xa7, 0xaa},
	{0x00, 0x40, 0xc1, 0xaa},	{0x00, 0x35, 0x00, 0xaa},
	{0x00, 0x36, 0x00, 0xaa},
	{0x00, 0x3c, 0x68, 0xaa},	{0x00, 0x1b, 0x05, 0xaa},
	{0x00, 0x39, 0x43, 0xaa},
	{0x00, 0x8d, 0xcf, 0xaa},
	{0x00, 0x8b, 0xcc, 0xaa},	{0x00, 0x8c, 0xcc, 0xaa},
	{0x00, 0x0f, 0x62, 0xaa},
	{0x00, 0x35, 0x84, 0xaa},
	{0x00, 0x3b, 0x08, 0xaa}, /* 0 * Nightframe 1/4 + 50Hz -> 0xC8 */
	{0x00, 0x3a, 0x00, 0xaa}, /* mx change yuyv format 00, 04, 01; 08, 0c*/
	{0x00, 0x14, 0x2a, 0xaa}, /* agc ampli */
	{0x00, 0x9e, 0x40, 0xaa},	{0xb8, 0x8f, 0x50, 0xcc},
	{0x00, 0x01, 0x80, 0xaa},
	{0x00, 0x02, 0x80, 0xaa},
	{0xb8, 0xfe, 0x00, 0xcc},	{0xb8, 0xff, 0x28, 0xcc},
	{0xb9, 0x00, 0x28, 0xcc},
	{0xb9, 0x01, 0x28, 0xcc},	{0xb9, 0x02, 0x28, 0xcc},
	{0xb9, 0x03, 0x00, 0xcc},
	{0xb9, 0x04, 0x00, 0xcc},
	{0xb9, 0x05, 0x3c, 0xcc},	{0xb9, 0x06, 0x3c, 0xcc},
	{0xb9, 0x07, 0x3c, 0xcc},
	{0xb9, 0x08, 0x3c, 0xcc},

	{0xb8, 0x8e, 0x00, 0xcc},	{0xb8, 0x8f, 0xff, 0xcc},

	{0x00, 0x29, 0x3c, 0xaa},	{0xb3, 0x01, 0x45, 0xcc},
	{}
};
static const __u8 ov7660_initQVGA_data[][4] = {
	{0xb0, 0x4d, 0x00, 0xcc},	{0xb3, 0x01, 0x01, 0xcc},
	{0x00, 0x00, 0x50, 0xdd},	{0xb0, 0x03, 0x01, 0xcc},
	{0xb3, 0x00, 0x21, 0xcc},	{0xb3, 0x00, 0x26, 0xcc},
	{0xb3, 0x05, 0x01, 0xcc},	{0xb3, 0x06, 0x03, 0xcc},
	{0xb3, 0x03, 0x1f, 0xcc},	{0xb3, 0x04, 0x05, 0xcc},
	{0xb3, 0x05, 0x00, 0xcc},	{0xb3, 0x06, 0x01, 0xcc},
	{0xb3, 0x15, 0x00, 0xcc},/* 0xb315  <-0 href startl */
	{0xb3, 0x16, 0x02, 0xcc},	{0xb3, 0x17, 0x7f, 0xcc},
	{0xb3, 0x21, 0x00, 0xcc},
	{0xb3, 0x23, 0xe0, 0xcc},	{0xb3, 0x1d, 0x01, 0xcc},
	{0xb3, 0x1f, 0x02, 0xcc},	{0xb3, 0x34, 0x01, 0xcc},
	{0xb3, 0x35, 0xa1, 0xcc},	{0xb3, 0x00, 0x26, 0xcc},
	{0xb8, 0x00, 0x33, 0xcc}, /* 13 */
	{0xb8, 0x01, 0x7d, 0xcc},
/* sizer */
	{0xbc, 0x00, 0xd3, 0xcc},
	{0xb8, 0x81, 0x09, 0xcc},	{0xb8, 0x81, 0x09, 0xcc},
	{0xb8, 0x27, 0x20, 0xcc},	{0xb8, 0x8f, 0x50, 0xcc},
	{0x00, 0x01, 0x80, 0xaa},	{0x00, 0x02, 0x80, 0xaa},
	{0x00, 0x12, 0x80, 0xaa},	{0x00, 0x12, 0x05, 0xaa},
	{0x00, 0x1e, 0x01, 0xaa},
	{0x00, 0x3d, 0x40, 0xaa}, /* 0x3d <-40 gamma 01 */
	{0x00, 0x41, 0x00, 0xaa}, /* edge 00 */
	{0x00, 0x0d, 0x48, 0xaa},	{0x00, 0x0e, 0x04, 0xaa},
	{0x00, 0x13, 0xa7, 0xaa},
	{0x00, 0x40, 0xc1, 0xaa},	{0x00, 0x35, 0x00, 0xaa},
	{0x00, 0x36, 0x00, 0xaa},
	{0x00, 0x3c, 0x68, 0xaa},	{0x00, 0x1b, 0x05, 0xaa},
	{0x00, 0x39, 0x43, 0xaa},	{0x00, 0x8d, 0xcf, 0xaa},
	{0x00, 0x8b, 0xcc, 0xaa},	{0x00, 0x8c, 0xcc, 0xaa},
	{0x00, 0x0f, 0x62, 0xaa},	{0x00, 0x35, 0x84, 0xaa},
	{0x00, 0x3b, 0x08, 0xaa}, /* 0  * Nightframe 1/4 + 50Hz -> 0xC8 */
	{0x00, 0x3a, 0x00, 0xaa}, /* mx change yuyv format 00, 04, 01; 08, 0c*/
	{0x00, 0x14, 0x2a, 0xaa}, /* agc ampli */
	{0x00, 0x9e, 0x40, 0xaa},	{0xb8, 0x8f, 0x50, 0xcc},
	{0x00, 0x01, 0x80, 0xaa},
	{0x00, 0x02, 0x80, 0xaa},
/* sizer filters */
	{0xbc, 0x02, 0x08, 0xcc},
	{0xbc, 0x03, 0x70, 0xcc},
	{0xb8, 0x35, 0x00, 0xcc},
	{0xb8, 0x36, 0x00, 0xcc},
	{0xb8, 0x37, 0x00, 0xcc},
	{0xbc, 0x04, 0x08, 0xcc},
	{0xbc, 0x05, 0x00, 0xcc},
	{0xbc, 0x06, 0x00, 0xcc},
	{0xbc, 0x08, 0x3c, 0xcc},
	{0xbc, 0x09, 0x40, 0xcc},
	{0xbc, 0x0a, 0x04, 0xcc},
	{0xbc, 0x0b, 0x00, 0xcc},
	{0xbc, 0x0c, 0x00, 0xcc},
/* */
	{0xb8, 0xfe, 0x00, 0xcc},
	{0xb8, 0xff, 0x28, 0xcc},
/* */
	{0xb9, 0x00, 0x28, 0xcc},	{0xb9, 0x01, 0x28, 0xcc},
	{0xb9, 0x02, 0x28, 0xcc},	{0xb9, 0x03, 0x00, 0xcc},
	{0xb9, 0x04, 0x00, 0xcc},	{0xb9, 0x05, 0x3c, 0xcc},
	{0xb9, 0x06, 0x3c, 0xcc},	{0xb9, 0x07, 0x3c, 0xcc},
	{0xb9, 0x08, 0x3c, 0xcc},
/* */
	{0xb8, 0x8e, 0x00, 0xcc},
	{0xb8, 0x8f, 0xff, 0xcc}, /* ff */
	{0x00, 0x29, 0x3c, 0xaa},
	{0xb3, 0x01, 0x45, 0xcc}, /* 45 */
	{}
};

static const __u8 ov7660_50HZ[][4] = {
	{0x00, 0x3b, 0x08, 0xaa},
	{0x00, 0x9d, 0x40, 0xaa},
	{0x00, 0x13, 0xa7, 0xaa},
	{}
};

static const __u8 ov7660_60HZ[][4] = {
	{0x00, 0x3b, 0x00, 0xaa},
	{0x00, 0x9e, 0x40, 0xaa},
	{0x00, 0x13, 0xa7, 0xaa},
	{}
};

static const __u8 ov7660_NoFliker[][4] = {
	{0x00, 0x13, 0x87, 0xaa},
	{}
};

static const __u8 ov7670_initVGA_JPG[][4] = {
	{0xb3, 0x01, 0x05, 0xcc},
	{0x00, 0x00, 0x30, 0xdd},	{0xb0, 0x03, 0x19, 0xcc},
	{0x00, 0x00, 0x10, 0xdd},
	{0xb0, 0x04, 0x02, 0xcc},	{0x00, 0x00, 0x10, 0xdd},
	{0xb3, 0x00, 0x66, 0xcc},	{0xb3, 0x00, 0x67, 0xcc},
	{0xb3, 0x35, 0xa1, 0xcc},	{0xb3, 0x34, 0x01, 0xcc},
	{0xb3, 0x05, 0x01, 0xcc},	{0xb3, 0x06, 0x01, 0xcc},
	{0xb3, 0x08, 0x01, 0xcc},	{0xb3, 0x09, 0x0c, 0xcc},
	{0xb3, 0x02, 0x02, 0xcc},	{0xb3, 0x03, 0x1f, 0xcc},
	{0xb3, 0x14, 0x00, 0xcc},	{0xb3, 0x15, 0x00, 0xcc},
	{0xb3, 0x16, 0x02, 0xcc},	{0xb3, 0x17, 0x7f, 0xcc},
	{0xb3, 0x04, 0x05, 0xcc},	{0xb3, 0x20, 0x00, 0xcc},
	{0xb3, 0x21, 0x00, 0xcc},	{0xb3, 0x22, 0x01, 0xcc},
	{0xb3, 0x23, 0xe0, 0xcc},	{0xbc, 0x00, 0x41, 0xcc},
	{0xbc, 0x01, 0x01, 0xcc},	{0x00, 0x12, 0x80, 0xaa},
	{0x00, 0x00, 0x20, 0xdd},	{0x00, 0x12, 0x00, 0xaa},
	{0x00, 0x11, 0x40, 0xaa},	{0x00, 0x6b, 0x0a, 0xaa},
	{0x00, 0x3a, 0x04, 0xaa},	{0x00, 0x40, 0xc0, 0xaa},
	{0x00, 0x8c, 0x00, 0xaa},	{0x00, 0x7a, 0x29, 0xaa},
	{0x00, 0x7b, 0x0e, 0xaa},	{0x00, 0x7c, 0x1a, 0xaa},
	{0x00, 0x7d, 0x31, 0xaa},	{0x00, 0x7e, 0x53, 0xaa},
	{0x00, 0x7f, 0x60, 0xaa},	{0x00, 0x80, 0x6b, 0xaa},
	{0x00, 0x81, 0x73, 0xaa},	{0x00, 0x82, 0x7b, 0xaa},
	{0x00, 0x83, 0x82, 0xaa},	{0x00, 0x84, 0x89, 0xaa},
	{0x00, 0x85, 0x96, 0xaa},	{0x00, 0x86, 0xa1, 0xaa},
	{0x00, 0x87, 0xb7, 0xaa},	{0x00, 0x88, 0xcc, 0xaa},
	{0x00, 0x89, 0xe1, 0xaa},	{0x00, 0x13, 0xe0, 0xaa},
	{0x00, 0x00, 0x00, 0xaa},	{0x00, 0x10, 0x00, 0xaa},
	{0x00, 0x0d, 0x40, 0xaa},	{0x00, 0x14, 0x28, 0xaa},
	{0x00, 0xa5, 0x05, 0xaa},	{0x00, 0xab, 0x07, 0xaa},
	{0x00, 0x24, 0x95, 0xaa},	{0x00, 0x25, 0x33, 0xaa},
	{0x00, 0x26, 0xe3, 0xaa},	{0x00, 0x9f, 0x88, 0xaa},
	{0x00, 0xa0, 0x78, 0xaa},	{0x00, 0x55, 0x90, 0xaa},
	{0x00, 0xa1, 0x03, 0xaa},	{0x00, 0xa6, 0xe0, 0xaa},
	{0x00, 0xa7, 0xd8, 0xaa},	{0x00, 0xa8, 0xf0, 0xaa},
	{0x00, 0xa9, 0x90, 0xaa},	{0x00, 0xaa, 0x14, 0xaa},
	{0x00, 0x13, 0xe5, 0xaa},	{0x00, 0x0e, 0x61, 0xaa},
	{0x00, 0x0f, 0x4b, 0xaa},	{0x00, 0x16, 0x02, 0xaa},
	{0x00, 0x1e, 0x07, 0xaa},	{0x00, 0x21, 0x02, 0xaa},
	{0x00, 0x22, 0x91, 0xaa},	{0x00, 0x29, 0x07, 0xaa},
	{0x00, 0x33, 0x0b, 0xaa},	{0x00, 0x35, 0x0b, 0xaa},
	{0x00, 0x37, 0x1d, 0xaa},	{0x00, 0x38, 0x71, 0xaa},
	{0x00, 0x39, 0x2a, 0xaa},	{0x00, 0x3c, 0x78, 0xaa},
	{0x00, 0x4d, 0x40, 0xaa},	{0x00, 0x4e, 0x20, 0xaa},
	{0x00, 0x74, 0x19, 0xaa},	{0x00, 0x8d, 0x4f, 0xaa},
	{0x00, 0x8e, 0x00, 0xaa},	{0x00, 0x8f, 0x00, 0xaa},
	{0x00, 0x90, 0x00, 0xaa},	{0x00, 0x91, 0x00, 0xaa},
	{0x00, 0x96, 0x00, 0xaa},	{0x00, 0x9a, 0x80, 0xaa},
	{0x00, 0xb0, 0x84, 0xaa},	{0x00, 0xb1, 0x0c, 0xaa},
	{0x00, 0xb2, 0x0e, 0xaa},	{0x00, 0xb3, 0x82, 0xaa},
	{0x00, 0xb8, 0x0a, 0xaa},	{0x00, 0x43, 0x14, 0xaa},
	{0x00, 0x44, 0xf0, 0xaa},	{0x00, 0x45, 0x45, 0xaa},
	{0x00, 0x46, 0x63, 0xaa},	{0x00, 0x47, 0x2d, 0xaa},
	{0x00, 0x48, 0x46, 0xaa},	{0x00, 0x59, 0x88, 0xaa},
	{0x00, 0x5a, 0xa0, 0xaa},	{0x00, 0x5b, 0xc6, 0xaa},
	{0x00, 0x5c, 0x7d, 0xaa},	{0x00, 0x5d, 0x5f, 0xaa},
	{0x00, 0x5e, 0x19, 0xaa},	{0x00, 0x6c, 0x0a, 0xaa},
	{0x00, 0x6d, 0x55, 0xaa},	{0x00, 0x6e, 0x11, 0xaa},
	{0x00, 0x6f, 0x9e, 0xaa},	{0x00, 0x69, 0x00, 0xaa},
	{0x00, 0x6a, 0x40, 0xaa},	{0x00, 0x01, 0x40, 0xaa},
	{0x00, 0x02, 0x40, 0xaa},	{0x00, 0x13, 0xe7, 0xaa},
	{0x00, 0x5f, 0xf0, 0xaa},	{0x00, 0x60, 0xf0, 0xaa},
	{0x00, 0x61, 0xf0, 0xaa},	{0x00, 0x27, 0xa0, 0xaa},
	{0x00, 0x28, 0x80, 0xaa},	{0x00, 0x2c, 0x90, 0xaa},
	{0x00, 0x4f, 0x66, 0xaa},	{0x00, 0x50, 0x66, 0xaa},
	{0x00, 0x51, 0x00, 0xaa},	{0x00, 0x52, 0x22, 0xaa},
	{0x00, 0x53, 0x5e, 0xaa},	{0x00, 0x54, 0x80, 0xaa},
	{0x00, 0x58, 0x9e, 0xaa},	{0x00, 0x41, 0x08, 0xaa},
	{0x00, 0x3f, 0x00, 0xaa},	{0x00, 0x75, 0x85, 0xaa},
	{0x00, 0x76, 0xe1, 0xaa},	{0x00, 0x4c, 0x00, 0xaa},
	{0x00, 0x77, 0x0a, 0xaa},	{0x00, 0x3d, 0x88, 0xaa},
	{0x00, 0x4b, 0x09, 0xaa},	{0x00, 0xc9, 0x60, 0xaa},
	{0x00, 0x41, 0x38, 0xaa},	{0x00, 0x62, 0x30, 0xaa},
	{0x00, 0x63, 0x30, 0xaa},	{0x00, 0x64, 0x08, 0xaa},
	{0x00, 0x94, 0x07, 0xaa},	{0x00, 0x95, 0x0b, 0xaa},
	{0x00, 0x65, 0x00, 0xaa},	{0x00, 0x66, 0x05, 0xaa},
	{0x00, 0x56, 0x50, 0xaa},	{0x00, 0x34, 0x11, 0xaa},
	{0x00, 0xa4, 0x88, 0xaa},	{0x00, 0x96, 0x00, 0xaa},
	{0x00, 0x97, 0x30, 0xaa},	{0x00, 0x98, 0x20, 0xaa},
	{0x00, 0x99, 0x30, 0xaa},	{0x00, 0x9a, 0x84, 0xaa},
	{0x00, 0x9b, 0x29, 0xaa},	{0x00, 0x9c, 0x03, 0xaa},
	{0x00, 0x78, 0x04, 0xaa},	{0x00, 0x79, 0x01, 0xaa},
	{0x00, 0xc8, 0xf0, 0xaa},	{0x00, 0x79, 0x0f, 0xaa},
	{0x00, 0xc8, 0x00, 0xaa},	{0x00, 0x79, 0x10, 0xaa},
	{0x00, 0xc8, 0x7e, 0xaa},	{0x00, 0x79, 0x0a, 0xaa},
	{0x00, 0xc8, 0x80, 0xaa},	{0x00, 0x79, 0x0b, 0xaa},
	{0x00, 0xc8, 0x01, 0xaa},	{0x00, 0x79, 0x0c, 0xaa},
	{0x00, 0xc8, 0x0f, 0xaa},	{0x00, 0x79, 0x0d, 0xaa},
	{0x00, 0xc8, 0x20, 0xaa},	{0x00, 0x79, 0x09, 0xaa},
	{0x00, 0xc8, 0x80, 0xaa},	{0x00, 0x79, 0x02, 0xaa},
	{0x00, 0xc8, 0xc0, 0xaa},	{0x00, 0x79, 0x03, 0xaa},
	{0x00, 0xc8, 0x40, 0xaa},	{0x00, 0x79, 0x05, 0xaa},
	{0x00, 0xc8, 0x30, 0xaa},	{0x00, 0x79, 0x26, 0xaa},
	{0x00, 0x11, 0x40, 0xaa},	{0x00, 0x3a, 0x04, 0xaa},
	{0x00, 0x12, 0x00, 0xaa},	{0x00, 0x40, 0xc0, 0xaa},
	{0x00, 0x8c, 0x00, 0xaa},	{0x00, 0x17, 0x14, 0xaa},
	{0x00, 0x18, 0x02, 0xaa},	{0x00, 0x32, 0x92, 0xaa},
	{0x00, 0x19, 0x02, 0xaa},	{0x00, 0x1a, 0x7a, 0xaa},
	{0x00, 0x03, 0x0a, 0xaa},	{0x00, 0x0c, 0x00, 0xaa},
	{0x00, 0x3e, 0x00, 0xaa},	{0x00, 0x70, 0x3a, 0xaa},
	{0x00, 0x71, 0x35, 0xaa},	{0x00, 0x72, 0x11, 0xaa},
	{0x00, 0x73, 0xf0, 0xaa},	{0x00, 0xa2, 0x02, 0xaa},
	{0x00, 0xb1, 0x00, 0xaa},	{0x00, 0xb1, 0x0c, 0xaa},
	{0x00, 0x1e, 0x37, 0xaa},	{0x00, 0xaa, 0x14, 0xaa},
	{0x00, 0x24, 0x80, 0xaa},	{0x00, 0x25, 0x74, 0xaa},
	{0x00, 0x26, 0xd3, 0xaa},	{0x00, 0x0d, 0x00, 0xaa},
	{0x00, 0x14, 0x18, 0xaa},	{0x00, 0x9d, 0x99, 0xaa},
	{0x00, 0x9e, 0x7f, 0xaa},	{0x00, 0x64, 0x08, 0xaa},
	{0x00, 0x94, 0x07, 0xaa},	{0x00, 0x95, 0x06, 0xaa},
	{0x00, 0x66, 0x05, 0xaa},	{0x00, 0x41, 0x08, 0xaa},
	{0x00, 0x3f, 0x00, 0xaa},	{0x00, 0x75, 0x07, 0xaa},
	{0x00, 0x76, 0xe1, 0xaa},	{0x00, 0x4c, 0x00, 0xaa},
	{0x00, 0x77, 0x00, 0xaa},	{0x00, 0x3d, 0xc2, 0xaa},
	{0x00, 0x4b, 0x09, 0xaa},	{0x00, 0xc9, 0x60, 0xaa},
	{0x00, 0x41, 0x38, 0xaa},	{0xb6, 0x00, 0x00, 0xcc},
	{0xb6, 0x03, 0x02, 0xcc},	{0xb6, 0x02, 0x80, 0xcc},
	{0xb6, 0x05, 0x01, 0xcc},	{0xb6, 0x04, 0xe0, 0xcc},
	{0xb6, 0x12, 0xf8, 0xcc},	{0xb6, 0x13, 0x13, 0xcc},
	{0xb6, 0x18, 0x02, 0xcc},	{0xb6, 0x17, 0x58, 0xcc},
	{0xb6, 0x16, 0x00, 0xcc},	{0xb6, 0x22, 0x12, 0xcc},
	{0xb6, 0x23, 0x0b, 0xcc},	{0xbf, 0xc0, 0x39, 0xcc},
	{0xbf, 0xc1, 0x04, 0xcc},	{0xbf, 0xcc, 0x00, 0xcc},
	{0xb3, 0x5c, 0x01, 0xcc},	{0xb3, 0x01, 0x45, 0xcc},
	{0x00, 0x77, 0x05, 0xaa},
	{},
};

static const __u8 ov7670_initQVGA_JPG[][4] = {
	{0xb3, 0x01, 0x05, 0xcc},	{0x00, 0x00, 0x30, 0xdd},
	{0xb0, 0x03, 0x19, 0xcc},	{0x00, 0x00, 0x10, 0xdd},
	{0xb0, 0x04, 0x02, 0xcc},	{0x00, 0x00, 0x10, 0xdd},
	{0xb3, 0x00, 0x66, 0xcc},	{0xb3, 0x00, 0x67, 0xcc},
	{0xb3, 0x35, 0xa1, 0xcc},	{0xb3, 0x34, 0x01, 0xcc},
	{0xb3, 0x05, 0x01, 0xcc},	{0xb3, 0x06, 0x01, 0xcc},
	{0xb3, 0x08, 0x01, 0xcc},	{0xb3, 0x09, 0x0c, 0xcc},
	{0xb3, 0x02, 0x02, 0xcc},	{0xb3, 0x03, 0x1f, 0xcc},
	{0xb3, 0x14, 0x00, 0xcc},	{0xb3, 0x15, 0x00, 0xcc},
	{0xb3, 0x16, 0x02, 0xcc},	{0xb3, 0x17, 0x7f, 0xcc},
	{0xb3, 0x04, 0x05, 0xcc},	{0xb3, 0x20, 0x00, 0xcc},
	{0xb3, 0x21, 0x00, 0xcc},	{0xb3, 0x22, 0x01, 0xcc},
	{0xb3, 0x23, 0xe0, 0xcc},	{0xbc, 0x00, 0xd1, 0xcc},
	{0xbc, 0x01, 0x01, 0xcc},	{0x00, 0x12, 0x80, 0xaa},
	{0x00, 0x00, 0x20, 0xdd},	{0x00, 0x12, 0x00, 0xaa},
	{0x00, 0x11, 0x40, 0xaa},	{0x00, 0x6b, 0x0a, 0xaa},
	{0x00, 0x3a, 0x04, 0xaa},	{0x00, 0x40, 0xc0, 0xaa},
	{0x00, 0x8c, 0x00, 0xaa},	{0x00, 0x7a, 0x29, 0xaa},
	{0x00, 0x7b, 0x0e, 0xaa},	{0x00, 0x7c, 0x1a, 0xaa},
	{0x00, 0x7d, 0x31, 0xaa},	{0x00, 0x7e, 0x53, 0xaa},
	{0x00, 0x7f, 0x60, 0xaa},	{0x00, 0x80, 0x6b, 0xaa},
	{0x00, 0x81, 0x73, 0xaa},	{0x00, 0x82, 0x7b, 0xaa},
	{0x00, 0x83, 0x82, 0xaa},	{0x00, 0x84, 0x89, 0xaa},
	{0x00, 0x85, 0x96, 0xaa},	{0x00, 0x86, 0xa1, 0xaa},
	{0x00, 0x87, 0xb7, 0xaa},	{0x00, 0x88, 0xcc, 0xaa},
	{0x00, 0x89, 0xe1, 0xaa},	{0x00, 0x13, 0xe0, 0xaa},
	{0x00, 0x00, 0x00, 0xaa},	{0x00, 0x10, 0x00, 0xaa},
	{0x00, 0x0d, 0x40, 0xaa},	{0x00, 0x14, 0x28, 0xaa},
	{0x00, 0xa5, 0x05, 0xaa},	{0x00, 0xab, 0x07, 0xaa},
	{0x00, 0x24, 0x95, 0xaa},	{0x00, 0x25, 0x33, 0xaa},
	{0x00, 0x26, 0xe3, 0xaa},	{0x00, 0x9f, 0x88, 0xaa},
	{0x00, 0xa0, 0x78, 0xaa},	{0x00, 0x55, 0x90, 0xaa},
	{0x00, 0xa1, 0x03, 0xaa},	{0x00, 0xa6, 0xe0, 0xaa},
	{0x00, 0xa7, 0xd8, 0xaa},	{0x00, 0xa8, 0xf0, 0xaa},
	{0x00, 0xa9, 0x90, 0xaa},	{0x00, 0xaa, 0x14, 0xaa},
	{0x00, 0x13, 0xe5, 0xaa},	{0x00, 0x0e, 0x61, 0xaa},
	{0x00, 0x0f, 0x4b, 0xaa},	{0x00, 0x16, 0x02, 0xaa},
	{0x00, 0x1e, 0x07, 0xaa},	{0x00, 0x21, 0x02, 0xaa},
	{0x00, 0x22, 0x91, 0xaa},	{0x00, 0x29, 0x07, 0xaa},
	{0x00, 0x33, 0x0b, 0xaa},	{0x00, 0x35, 0x0b, 0xaa},
	{0x00, 0x37, 0x1d, 0xaa},	{0x00, 0x38, 0x71, 0xaa},
	{0x00, 0x39, 0x2a, 0xaa},	{0x00, 0x3c, 0x78, 0xaa},
	{0x00, 0x4d, 0x40, 0xaa},	{0x00, 0x4e, 0x20, 0xaa},
	{0x00, 0x74, 0x19, 0xaa},	{0x00, 0x8d, 0x4f, 0xaa},
	{0x00, 0x8e, 0x00, 0xaa},	{0x00, 0x8f, 0x00, 0xaa},
	{0x00, 0x90, 0x00, 0xaa},	{0x00, 0x91, 0x00, 0xaa},
	{0x00, 0x96, 0x00, 0xaa},	{0x00, 0x9a, 0x80, 0xaa},
	{0x00, 0xb0, 0x84, 0xaa},	{0x00, 0xb1, 0x0c, 0xaa},
	{0x00, 0xb2, 0x0e, 0xaa},	{0x00, 0xb3, 0x82, 0xaa},
	{0x00, 0xb8, 0x0a, 0xaa},	{0x00, 0x43, 0x14, 0xaa},
	{0x00, 0x44, 0xf0, 0xaa},	{0x00, 0x45, 0x45, 0xaa},
	{0x00, 0x46, 0x63, 0xaa},	{0x00, 0x47, 0x2d, 0xaa},
	{0x00, 0x48, 0x46, 0xaa},	{0x00, 0x59, 0x88, 0xaa},
	{0x00, 0x5a, 0xa0, 0xaa},	{0x00, 0x5b, 0xc6, 0xaa},
	{0x00, 0x5c, 0x7d, 0xaa},	{0x00, 0x5d, 0x5f, 0xaa},
	{0x00, 0x5e, 0x19, 0xaa},	{0x00, 0x6c, 0x0a, 0xaa},
	{0x00, 0x6d, 0x55, 0xaa},	{0x00, 0x6e, 0x11, 0xaa},
	{0x00, 0x6f, 0x9e, 0xaa},	{0x00, 0x69, 0x00, 0xaa},
	{0x00, 0x6a, 0x40, 0xaa},	{0x00, 0x01, 0x40, 0xaa},
	{0x00, 0x02, 0x40, 0xaa},	{0x00, 0x13, 0xe7, 0xaa},
	{0x00, 0x5f, 0xf0, 0xaa},	{0x00, 0x60, 0xf0, 0xaa},
	{0x00, 0x61, 0xf0, 0xaa},	{0x00, 0x27, 0xa0, 0xaa},
	{0x00, 0x28, 0x80, 0xaa},	{0x00, 0x2c, 0x90, 0xaa},
	{0x00, 0x4f, 0x66, 0xaa},	{0x00, 0x50, 0x66, 0xaa},
	{0x00, 0x51, 0x00, 0xaa},	{0x00, 0x52, 0x22, 0xaa},
	{0x00, 0x53, 0x5e, 0xaa},	{0x00, 0x54, 0x80, 0xaa},
	{0x00, 0x58, 0x9e, 0xaa},	{0x00, 0x41, 0x08, 0xaa},
	{0x00, 0x3f, 0x00, 0xaa},	{0x00, 0x75, 0x85, 0xaa},
	{0x00, 0x76, 0xe1, 0xaa},	{0x00, 0x4c, 0x00, 0xaa},
	{0x00, 0x77, 0x0a, 0xaa},	{0x00, 0x3d, 0x88, 0xaa},
	{0x00, 0x4b, 0x09, 0xaa},	{0x00, 0xc9, 0x60, 0xaa},
	{0x00, 0x41, 0x38, 0xaa},	{0x00, 0x62, 0x30, 0xaa},
	{0x00, 0x63, 0x30, 0xaa},	{0x00, 0x64, 0x08, 0xaa},
	{0x00, 0x94, 0x07, 0xaa},	{0x00, 0x95, 0x0b, 0xaa},
	{0x00, 0x65, 0x00, 0xaa},	{0x00, 0x66, 0x05, 0xaa},
	{0x00, 0x56, 0x50, 0xaa},	{0x00, 0x34, 0x11, 0xaa},
	{0x00, 0xa4, 0x88, 0xaa},	{0x00, 0x96, 0x00, 0xaa},
	{0x00, 0x97, 0x30, 0xaa},	{0x00, 0x98, 0x20, 0xaa},
	{0x00, 0x99, 0x30, 0xaa},	{0x00, 0x9a, 0x84, 0xaa},
	{0x00, 0x9b, 0x29, 0xaa},	{0x00, 0x9c, 0x03, 0xaa},
	{0x00, 0x78, 0x04, 0xaa},	{0x00, 0x79, 0x01, 0xaa},
	{0x00, 0xc8, 0xf0, 0xaa},	{0x00, 0x79, 0x0f, 0xaa},
	{0x00, 0xc8, 0x00, 0xaa},	{0x00, 0x79, 0x10, 0xaa},
	{0x00, 0xc8, 0x7e, 0xaa},	{0x00, 0x79, 0x0a, 0xaa},
	{0x00, 0xc8, 0x80, 0xaa},	{0x00, 0x79, 0x0b, 0xaa},
	{0x00, 0xc8, 0x01, 0xaa},	{0x00, 0x79, 0x0c, 0xaa},
	{0x00, 0xc8, 0x0f, 0xaa},	{0x00, 0x79, 0x0d, 0xaa},
	{0x00, 0xc8, 0x20, 0xaa},	{0x00, 0x79, 0x09, 0xaa},
	{0x00, 0xc8, 0x80, 0xaa},	{0x00, 0x79, 0x02, 0xaa},
	{0x00, 0xc8, 0xc0, 0xaa},	{0x00, 0x79, 0x03, 0xaa},
	{0x00, 0xc8, 0x40, 0xaa},	{0x00, 0x79, 0x05, 0xaa},
	{0x00, 0xc8, 0x30, 0xaa},	{0x00, 0x79, 0x26, 0xaa},
	{0x00, 0x11, 0x40, 0xaa},	{0x00, 0x3a, 0x04, 0xaa},
	{0x00, 0x12, 0x00, 0xaa},	{0x00, 0x40, 0xc0, 0xaa},
	{0x00, 0x8c, 0x00, 0xaa},	{0x00, 0x17, 0x14, 0xaa},
	{0x00, 0x18, 0x02, 0xaa},	{0x00, 0x32, 0x92, 0xaa},
	{0x00, 0x19, 0x02, 0xaa},	{0x00, 0x1a, 0x7a, 0xaa},
	{0x00, 0x03, 0x0a, 0xaa},	{0x00, 0x0c, 0x00, 0xaa},
	{0x00, 0x3e, 0x00, 0xaa},	{0x00, 0x70, 0x3a, 0xaa},
	{0x00, 0x71, 0x35, 0xaa},	{0x00, 0x72, 0x11, 0xaa},
	{0x00, 0x73, 0xf0, 0xaa},	{0x00, 0xa2, 0x02, 0xaa},
	{0x00, 0xb1, 0x00, 0xaa},	{0x00, 0xb1, 0x0c, 0xaa},
	{0x00, 0x1e, 0x37, 0xaa},	{0x00, 0xaa, 0x14, 0xaa},
	{0x00, 0x24, 0x80, 0xaa},	{0x00, 0x25, 0x74, 0xaa},
	{0x00, 0x26, 0xd3, 0xaa},	{0x00, 0x0d, 0x00, 0xaa},
	{0x00, 0x14, 0x18, 0xaa},	{0x00, 0x9d, 0x99, 0xaa},
	{0x00, 0x9e, 0x7f, 0xaa},	{0x00, 0x64, 0x08, 0xaa},
	{0x00, 0x94, 0x07, 0xaa},	{0x00, 0x95, 0x06, 0xaa},
	{0x00, 0x66, 0x05, 0xaa},	{0x00, 0x41, 0x08, 0xaa},
	{0x00, 0x3f, 0x00, 0xaa},	{0x00, 0x75, 0x07, 0xaa},
	{0x00, 0x76, 0xe1, 0xaa},	{0x00, 0x4c, 0x00, 0xaa},
	{0x00, 0x77, 0x00, 0xaa},	{0x00, 0x3d, 0xc2, 0xaa},
	{0x00, 0x4b, 0x09, 0xaa},	{0x00, 0xc9, 0x60, 0xaa},
	{0x00, 0x41, 0x38, 0xaa},	{0xb6, 0x00, 0x00, 0xcc},
	{0xb6, 0x03, 0x01, 0xcc},	{0xb6, 0x02, 0x40, 0xcc},
	{0xb6, 0x05, 0x00, 0xcc},	{0xb6, 0x04, 0xf0, 0xcc},
	{0xb6, 0x12, 0xf8, 0xcc},	{0xb6, 0x13, 0x21, 0xcc},
	{0xb6, 0x18, 0x00, 0xcc},	{0xb6, 0x17, 0x96, 0xcc},
	{0xb6, 0x16, 0x00, 0xcc},	{0xb6, 0x22, 0x12, 0xcc},
	{0xb6, 0x23, 0x0b, 0xcc},	{0xbf, 0xc0, 0x39, 0xcc},
	{0xbf, 0xc1, 0x04, 0xcc},	{0xbf, 0xcc, 0x00, 0xcc},
	{0xbc, 0x02, 0x18, 0xcc},	{0xbc, 0x03, 0x50, 0xcc},
	{0xbc, 0x04, 0x18, 0xcc},	{0xbc, 0x05, 0x00, 0xcc},
	{0xbc, 0x06, 0x00, 0xcc},	{0xbc, 0x08, 0x30, 0xcc},
	{0xbc, 0x09, 0x40, 0xcc},	{0xbc, 0x0a, 0x10, 0xcc},
	{0xbc, 0x0b, 0x00, 0xcc},	{0xbc, 0x0c, 0x00, 0xcc},
	{0xb3, 0x5c, 0x01, 0xcc},	{0xb3, 0x01, 0x45, 0xcc},
	{0x00, 0x77, 0x05, 0xaa },
	{},
};

struct sensor_info {
	int sensorId;
	__u8 I2cAdd;
	__u8 IdAdd;
	__u16 VpId;
	__u8 m1;
	__u8 m2;
	__u8 op;
	};

static const struct sensor_info sensor_info_data[] = {
/*      sensorId,         I2cAdd,	IdAdd,  VpId,  m1,    m2,  op */
	{SENSOR_HV7131R,    0x80 | 0x11, 0x00, 0x0209, 0x24, 0x25, 0x01},
	{SENSOR_OV7660,     0x80 | 0x21, 0x0a, 0x7660, 0x26, 0x26, 0x05},
	{SENSOR_PO3130NC,   0x80 | 0x76, 0x00, 0x3130, 0x24, 0x25, 0x01},
	{SENSOR_MI1320,     0x80 | 0xc8, 0x00, 0x148c, 0x64, 0x65, 0x01},
	{SENSOR_OV7670,     0x80 | 0x21, 0x0a, 0x7673, 0x66, 0x67, 0x05},
	{SENSOR_MI1310_SOC, 0x80 | 0x5d, 0x00, 0x143a, 0x24, 0x25, 0x01},
};

/* read 'len' bytes in gspca_dev->usb_buf */
static void reg_r(struct gspca_dev *gspca_dev,
		  __u16 req,
		  __u16 index,
		  __u16 len)
{
	usb_control_msg(gspca_dev->dev,
			usb_rcvctrlpipe(gspca_dev->dev, 0),
			req,
			USB_DIR_IN | USB_TYPE_VENDOR | USB_RECIP_DEVICE,
			1,			/* value */
			index, gspca_dev->usb_buf, len,
			500);
}

static void reg_w(struct usb_device *dev,
			    __u16 req,
			    __u16 value,
			    __u16 index)
{
	usb_control_msg(dev,
			usb_sndctrlpipe(dev, 0),
			req,
			USB_DIR_OUT | USB_TYPE_VENDOR | USB_RECIP_DEVICE,
			value, index, NULL, 0,
			500);
}

static void read_sensor_register(struct gspca_dev *gspca_dev,
				__u16 address, __u16 *value)
{
	struct usb_device *dev = gspca_dev->dev;
	__u8 ldata, mdata, hdata;
	int retry = 50;

	*value = 0;

	reg_r(gspca_dev, 0xa1, 0xb33f, 1);
	/*PDEBUG(D_PROBE, " I2c Bus Busy Wait  0x%02X ", tmpvalue); */
	if (!(gspca_dev->usb_buf[0] & 0x02)) {
		PDEBUG(D_ERR, "I2c Bus Busy Wait %d",
			gspca_dev->usb_buf[0] & 0x02);
		return;
	}
	reg_w(dev, 0xa0, address, 0xb33a);
	reg_w(dev, 0xa0, 0x02, 0xb339);

	reg_r(gspca_dev, 0xa1, 0xb33b, 1);
	while (retry-- && gspca_dev->usb_buf[0]) {
		reg_r(gspca_dev, 0xa1, 0xb33b, 1);
/*		PDEBUG(D_PROBE, "Read again 0xb33b %d", tmpvalue); */
		msleep(1);
	}
	reg_r(gspca_dev, 0xa1, 0xb33e, 1);
	hdata = gspca_dev->usb_buf[0];
	reg_r(gspca_dev, 0xa1, 0xb33d, 1);
	mdata = gspca_dev->usb_buf[0];
	reg_r(gspca_dev, 0xa1, 0xb33c, 1);
	ldata = gspca_dev->usb_buf[0];
	PDEBUG(D_PROBE, "Read Sensor h (0x%02X) m (0x%02X) l (0x%02X)",
		hdata, mdata, ldata);
	reg_r(gspca_dev, 0xa1, 0xb334, 1);
	if (gspca_dev->usb_buf[0] == 0x02)
		*value = (ldata << 8) + mdata;
	else
		*value = ldata;
}

static int vc032x_probe_sensor(struct gspca_dev *gspca_dev)
{
	struct usb_device *dev = gspca_dev->dev;
	int i;
	__u16 value;
	const struct sensor_info *ptsensor_info;

	reg_r(gspca_dev, 0xa1, 0xbfcf, 1);
	PDEBUG(D_PROBE, "check sensor header %d", gspca_dev->usb_buf[0]);
	for (i = 0; i < ARRAY_SIZE(sensor_info_data); i++) {
		ptsensor_info = &sensor_info_data[i];
		reg_w(dev, 0xa0, 0x02, 0xb334);
		reg_w(dev, 0xa0, ptsensor_info->m1, 0xb300);
		reg_w(dev, 0xa0, ptsensor_info->m2, 0xb300);
		reg_w(dev, 0xa0, 0x01, 0xb308);
		reg_w(dev, 0xa0, 0x0c, 0xb309);
		reg_w(dev, 0xa0, ptsensor_info->I2cAdd, 0xb335);
/*		PDEBUG(D_PROBE,
			"check sensor VC032X -> %d Add -> ox%02X!",
			i, ptsensor_info->I2cAdd); */
		reg_w(dev, 0xa0, ptsensor_info->op, 0xb301);
		read_sensor_register(gspca_dev, ptsensor_info->IdAdd, &value);
		if (value == ptsensor_info->VpId) {
/*			PDEBUG(D_PROBE, "find sensor VC032X -> ox%04X!",
				ptsensor_info->VpId); */
			return ptsensor_info->sensorId;
		}
	}
	return -1;
}

static __u8 i2c_write(struct gspca_dev *gspca_dev,
			__u8 reg, const __u8 *val, __u8 size)
{
	struct usb_device *dev = gspca_dev->dev;

	if (size > 3 || size < 1)
		return -EINVAL;
	reg_r(gspca_dev, 0xa1, 0xb33f, 1);
	reg_w(dev, 0xa0, size, 0xb334);
	reg_w(dev, 0xa0, reg, 0xb33a);
	switch (size) {
	case 1:
		reg_w(dev, 0xa0, val[0], 0xb336);
		break;
	case 2:
		reg_w(dev, 0xa0, val[0], 0xb336);
		reg_w(dev, 0xa0, val[1], 0xb337);
		break;
	case 3:
		reg_w(dev, 0xa0, val[0], 0xb336);
		reg_w(dev, 0xa0, val[1], 0xb337);
		reg_w(dev, 0xa0, val[2], 0xb338);
		break;
	default:
		reg_w(dev, 0xa0, 0x01, 0xb334);
		return -EINVAL;
	}
	reg_w(dev, 0xa0, 0x01, 0xb339);
	reg_r(gspca_dev, 0xa1, 0xb33b, 1);
	return gspca_dev->usb_buf[0] == 0;
}

static void put_tab_to_reg(struct gspca_dev *gspca_dev,
			const __u8 *tab, __u8 tabsize, __u16 addr)
{
	int j;
	__u16 ad = addr;

	for (j = 0; j < tabsize; j++)
		reg_w(gspca_dev->dev, 0xa0, tab[j], ad++);
}

static void usb_exchange(struct gspca_dev *gspca_dev,
			const __u8 data[][4])
{
	struct usb_device *dev = gspca_dev->dev;
	int i = 0;

	for (;;) {
		switch (data[i][3]) {
		default:
			return;
		case 0xcc:			/* normal write */
			reg_w(dev, 0xa0, data[i][2],
					((data[i][0])<<8) | data[i][1]);
			break;
		case 0xaa:			/* i2c op */
			i2c_write(gspca_dev, data[i][1], &data[i][2], 1);
			break;
		case 0xbb:			/* i2c op */
			i2c_write(gspca_dev, data[i][0], &data[i][1], 2);
			break;
		case 0xdd:
			msleep(data[i][2] + 10);
			break;
		}
		i++;
	}
	/*not reached*/
}

/*
 "GammaT"=hex:04,17,31,4f,6a,83,99,ad,bf,ce,da,e5,ee,f5,fb,ff,ff
 "MatrixT"=hex:60,f9,e5,e7,50,05,f3,e6,66
 */

static void vc0321_reset(struct gspca_dev *gspca_dev)
{
	reg_w(gspca_dev->dev, 0xa0, 0x00, 0xb04d);
	reg_w(gspca_dev->dev, 0xa0, 0x01, 0xb301);
	msleep(100);
	reg_w(gspca_dev->dev, 0xa0, 0x01, 0xb003);
	msleep(100);
}

/* this function is called at probe time */
static int sd_config(struct gspca_dev *gspca_dev,
			const struct usb_device_id *id)
{
	struct sd *sd = (struct sd *) gspca_dev;
	struct usb_device *dev = gspca_dev->dev;
	struct cam *cam;
	int sensor;
	__u16 product;

	product = id->idProduct;
	sd->bridge = BRIDGE_VC0321;
	switch (id->idVendor) {
	case 0x0ac8:		/* Vimicro z-star */
		switch (product) {
		case 0x0323:
			sd->bridge = BRIDGE_VC0323;
			break;
		}
		break;
	case 0x17ef:		/* Lenovo */
/*		switch (product) { */
/*		case 0x4802:	 * Lenovo MI1310_SOC */
			sd->bridge = BRIDGE_VC0323;
/*			break; */
/*		} */
		break;
	}

	cam = &gspca_dev->cam;
	cam->dev_name = (char *) id->driver_info;
	cam->epaddr = 0x02;
	if (sd->bridge == BRIDGE_VC0321) {
		cam->cam_mode = vc0321_mode;
		cam->nmodes = ARRAY_SIZE(vc0321_mode);
	} else {
		cam->cam_mode = vc0323_mode;
		cam->nmodes = ARRAY_SIZE(vc0323_mode);
	}

	vc0321_reset(gspca_dev);
	sensor = vc032x_probe_sensor(gspca_dev);
	switch (sensor) {
	case -1:
		PDEBUG(D_PROBE, "Unknown sensor...");
		return -EINVAL;
	case SENSOR_HV7131R:
		PDEBUG(D_PROBE, "Find Sensor HV7131R");
		sd->sensor = SENSOR_HV7131R;
		break;
	case SENSOR_MI1310_SOC:
		PDEBUG(D_PROBE, "Find Sensor MI1310_SOC");
		sd->sensor = SENSOR_MI1310_SOC;
		break;
	case SENSOR_MI1320:
		PDEBUG(D_PROBE, "Find Sensor MI1320");
		sd->sensor = SENSOR_MI1320;
		break;
	case SENSOR_OV7660:
		PDEBUG(D_PROBE, "Find Sensor OV7660");
		sd->sensor = SENSOR_OV7660;
		break;
	case SENSOR_OV7670:
		PDEBUG(D_PROBE, "Find Sensor OV7670");
		sd->sensor = SENSOR_OV7670;
		break;
	case SENSOR_PO3130NC:
		PDEBUG(D_PROBE, "Find Sensor PO3130NC");
		sd->sensor = SENSOR_PO3130NC;
		break;
	}

	sd->qindex = 7;
	sd->autogain = AUTOGAIN_DEF;
	sd->lightfreq = FREQ_DEF;

	if (sd->bridge == BRIDGE_VC0321) {
		reg_r(gspca_dev, 0x8a, 0, 3);
		reg_w(dev, 0x87, 0x00, 0x0f0f);

		reg_r(gspca_dev, 0x8b, 0, 3);
		reg_w(dev, 0x88, 0x00, 0x0202);
	}
	return 0;
}

/* this function is called at open time */
static int sd_open(struct gspca_dev *gspca_dev)
{
	return 0;
}

static void setquality(struct gspca_dev *gspca_dev)
{
}

static void setautogain(struct gspca_dev *gspca_dev)
{
}

static void setlightfreq(struct gspca_dev *gspca_dev)
{
	struct sd *sd = (struct sd *) gspca_dev;
	static const __u8 (*ov7660_freq_tb[3])[4] =
		{ov7660_NoFliker, ov7660_50HZ, ov7660_60HZ};

	if (sd->sensor != SENSOR_OV7660)
		return;
	usb_exchange(gspca_dev, ov7660_freq_tb[sd->lightfreq]);
}

static void sd_start(struct gspca_dev *gspca_dev)
{
	struct sd *sd = (struct sd *) gspca_dev;
	const __u8 *GammaT = NULL;
	const __u8 *MatrixT = NULL;
	int mode;

	/* Assume start use the good resolution from gspca_dev->mode */
	if (sd->bridge == BRIDGE_VC0321) {
		reg_w(gspca_dev->dev, 0xa0, 0xff, 0xbfec);
		reg_w(gspca_dev->dev, 0xa0, 0xff, 0xbfed);
		reg_w(gspca_dev->dev, 0xa0, 0xff, 0xbfee);
		reg_w(gspca_dev->dev, 0xa0, 0xff, 0xbfef);
	}

	mode = gspca_dev->cam.cam_mode[(int) gspca_dev->curr_mode].priv;
	switch (sd->sensor) {
	case SENSOR_HV7131R:
		GammaT = hv7131r_gamma;
		MatrixT = hv7131r_matrix;
		if (mode) {
			/* 320x240 */
			usb_exchange(gspca_dev, hv7131r_initQVGA_data);
		} else {
			/* 640x480 */
			usb_exchange(gspca_dev, hv7131r_initVGA_data);
		}
		break;
	case SENSOR_OV7660:
		GammaT = ov7660_gamma;
		MatrixT = ov7660_matrix;
		if (mode) {
			/* 320x240 */
			usb_exchange(gspca_dev, ov7660_initQVGA_data);
		} else {
			/* 640x480 */
			usb_exchange(gspca_dev, ov7660_initVGA_data);
		}
		break;
	case SENSOR_OV7670:
		/*GammaT = ov7660_gamma; */
		/*MatrixT = ov7660_matrix; */
		if (mode) {
			/* 320x240 */
			usb_exchange(gspca_dev, ov7670_initQVGA_JPG);
		} else {
			/* 640x480 */
			usb_exchange(gspca_dev, ov7670_initVGA_JPG);
		}
		break;
	case SENSOR_MI1310_SOC:
		if (mode) {
			/* 320x240 */
			usb_exchange(gspca_dev, mi1310_socinitQVGA_JPG);
		} else {
			/* 640x480 */
			usb_exchange(gspca_dev, mi1310_socinitVGA_JPG);
		}
		break;
	case SENSOR_MI1320:
		GammaT = mi1320_gamma;
		MatrixT = mi1320_matrix;
		if (mode) {
			/* 320x240 */
			usb_exchange(gspca_dev, mi1320_initQVGA_data);
		} else {
			/* 640x480 */
			usb_exchange(gspca_dev, mi1320_initVGA_data);
		}
		break;
	case SENSOR_PO3130NC:
		GammaT = po3130_gamma;
		MatrixT = po3130_matrix;
		if (mode) {
			/* 320x240 */
			usb_exchange(gspca_dev, po3130_initQVGA_data);
		} else {
			/* 640x480 */
			usb_exchange(gspca_dev, po3130_initVGA_data);
		}
		usb_exchange(gspca_dev, po3130_rundata);
		break;
	default:
		PDEBUG(D_PROBE, "Damned !! no sensor found Bye");
		return;
	}
	if (GammaT && MatrixT) {
		put_tab_to_reg(gspca_dev, GammaT, 17, 0xb84a);
		put_tab_to_reg(gspca_dev, GammaT, 17, 0xb85b);
		put_tab_to_reg(gspca_dev, GammaT, 17, 0xb86c);
		put_tab_to_reg(gspca_dev, MatrixT, 9, 0xb82c);

		/* Seem SHARPNESS */
		/*
		reg_w(gspca_dev->dev, 0xa0, 0x80, 0xb80a);
		reg_w(gspca_dev->dev, 0xa0, 0xff, 0xb80b);
		reg_w(gspca_dev->dev, 0xa0, 0xff, 0xb80e);
		*/
		/* all 0x40 ??? do nothing
		reg_w(gspca_dev->dev, 0xa0, 0x40, 0xb822);
		reg_w(gspca_dev->dev, 0xa0, 0x40, 0xb823);
		reg_w(gspca_dev->dev, 0xa0, 0x40, 0xb824);
		*/
		/* Only works for HV7131R ??
		reg_r (gspca_dev, 0xa1, 0xb881, 1);
		reg_w(gspca_dev->dev, 0xa0, 0xfe01, 0xb881);
		reg_w(gspca_dev->dev, 0xa0, 0x79, 0xb801);
		*/
		/* only hv7131r et ov7660
		reg_w(gspca_dev->dev, 0xa0, 0x20, 0xb827);
		reg_w(gspca_dev->dev, 0xa0, 0xff, 0xb826); * ISP_GAIN 80
		reg_w(gspca_dev->dev, 0xa0, 0x23, 0xb800); * ISP CTRL_BAS
		*/
		/* set the led on 0x0892 0x0896 */
		reg_w(gspca_dev->dev, 0x89, 0xffff, 0xfdff);
		msleep(100);
		setquality(gspca_dev);
		setautogain(gspca_dev);
		setlightfreq(gspca_dev);
	}
}

static void sd_stopN(struct gspca_dev *gspca_dev)
{
	struct usb_device *dev = gspca_dev->dev;

	reg_w(dev, 0x89, 0xffff, 0xffff);
	reg_w(dev, 0xa0, 0x01, 0xb301);
	reg_w(dev, 0xa0, 0x09, 0xb003);
}

static void sd_stop0(struct gspca_dev *gspca_dev)
{
	struct usb_device *dev = gspca_dev->dev;

	reg_w(dev, 0x89, 0xffff, 0xffff);
}

/* this function is called at close time */
static void sd_close(struct gspca_dev *gspca_dev)
{
/*	struct usb_device *dev = gspca_dev->dev;
	__u8 buffread;

	reg_w(dev, 0x89, 0xffff, 0xffff);
	reg_w(dev, 0xa0, 0x01, 0xb301);
	reg_w(dev, 0xa0, 0x09, 0xb303);
	reg_w(dev, 0x89, 0xffff, 0xffff);
*/
}

static void sd_pkt_scan(struct gspca_dev *gspca_dev,
			struct gspca_frame *frame,	/* target */
			__u8 *data,			/* isoc packet */
			int len)			/* iso pkt length */
{
	struct sd *sd = (struct sd *) gspca_dev;

	if (data[0] == 0xff && data[1] == 0xd8) {
		PDEBUG(D_PACK,
			"vc032x header packet found len %d", len);
		frame = gspca_frame_add(gspca_dev, LAST_PACKET, frame,
						data, 0);
		if (sd->bridge == BRIDGE_VC0321) {
#define VCHDRSZ 46
			data += VCHDRSZ;
			len -= VCHDRSZ;
#undef VCHDRSZ
		}
		gspca_frame_add(gspca_dev, FIRST_PACKET, frame,
				data, len);
		return;
	}
	gspca_frame_add(gspca_dev, INTER_PACKET, frame, data, len);
}

static int sd_setautogain(struct gspca_dev *gspca_dev, __s32 val)
{
	struct sd *sd = (struct sd *) gspca_dev;

	sd->autogain = val;
	if (gspca_dev->streaming)
		setautogain(gspca_dev);
	return 0;
}

static int sd_getautogain(struct gspca_dev *gspca_dev, __s32 *val)
{
	struct sd *sd = (struct sd *) gspca_dev;

	*val = sd->autogain;
	return 0;
}

static int sd_setfreq(struct gspca_dev *gspca_dev, __s32 val)
{
	struct sd *sd = (struct sd *) gspca_dev;

	sd->lightfreq = val;
	if (gspca_dev->streaming)
		setlightfreq(gspca_dev);
	return 0;
}

static int sd_getfreq(struct gspca_dev *gspca_dev, __s32 *val)
{
	struct sd *sd = (struct sd *) gspca_dev;

	*val = sd->lightfreq;
	return 0;
}

static int sd_querymenu(struct gspca_dev *gspca_dev,
			struct v4l2_querymenu *menu)
{
	switch (menu->id) {
	case V4L2_CID_POWER_LINE_FREQUENCY:
		switch (menu->index) {
		case 0:		/* V4L2_CID_POWER_LINE_FREQUENCY_DISABLED */
			strcpy((char *) menu->name, "NoFliker");
			return 0;
		case 1:		/* V4L2_CID_POWER_LINE_FREQUENCY_50HZ */
			strcpy((char *) menu->name, "50 Hz");
			return 0;
		case 2:		/* V4L2_CID_POWER_LINE_FREQUENCY_60HZ */
			strcpy((char *) menu->name, "60 Hz");
			return 0;
		}
		break;
	}
	return -EINVAL;
}

/* sub-driver description */
static const struct sd_desc sd_desc = {
	.name = MODULE_NAME,
	.ctrls = sd_ctrls,
	.nctrls = ARRAY_SIZE(sd_ctrls),
	.config = sd_config,
	.open = sd_open,
	.start = sd_start,
	.stopN = sd_stopN,
	.stop0 = sd_stop0,
	.close = sd_close,
	.pkt_scan = sd_pkt_scan,
	.querymenu = sd_querymenu,
};

/* -- module initialisation -- */
#define DVNM(name) .driver_info = (kernel_ulong_t) name
static const __devinitdata struct usb_device_id device_table[] = {
	{USB_DEVICE(0x046d, 0x0892), DVNM("Logitech Orbicam")},
	{USB_DEVICE(0x046d, 0x0896), DVNM("Logitech Orbicam")},
	{USB_DEVICE(0x0ac8, 0x0321), DVNM("Vimicro generic vc0321")},
	{USB_DEVICE(0x0ac8, 0x0323), DVNM("Vimicro Vc0323")},
	{USB_DEVICE(0x0ac8, 0x0328), DVNM("A4Tech PK-130MG")},
	{USB_DEVICE(0x0ac8, 0xc001), DVNM("Sony embedded vimicro")},
	{USB_DEVICE(0x0ac8, 0xc002), DVNM("Sony embedded vimicro")},
	{USB_DEVICE(0x17ef, 0x4802), DVNM("Lenovo Vc0323+MI1310_SOC")},
	{}
};
MODULE_DEVICE_TABLE(usb, device_table);

/* -- device connect -- */
static int sd_probe(struct usb_interface *intf,
			const struct usb_device_id *id)
{
	return gspca_dev_probe(intf, id, &sd_desc, sizeof(struct sd),
				THIS_MODULE);
}

static struct usb_driver sd_driver = {
	.name = MODULE_NAME,
	.id_table = device_table,
	.probe = sd_probe,
	.disconnect = gspca_disconnect,
};

/* -- module insert / remove -- */
static int __init sd_mod_init(void)
{
	if (usb_register(&sd_driver) < 0)
		return -1;
	PDEBUG(D_PROBE, "v%s registered", version);
	return 0;
}
static void __exit sd_mod_exit(void)
{
	usb_deregister(&sd_driver);
	PDEBUG(D_PROBE, "deregistered");
}

module_init(sd_mod_init);
module_exit(sd_mod_exit);
