<!--
   Copyright 2010 The Android Open Source Project 

   Licensed under the Apache License, Version 2.0 (the "License"); 
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
-->

# Compatibility Test Suite #

## How does the CTS work? ##

<div style="float: right">
    <img src="/images/cts-0.png">
</div>

The CTS is an automated testing harness that includes two major software components:

- The CTS test harness runs on your desktop machine and manages test execution.

- Individual test cases are executed on attached mobile devices or on an
emulator. The test cases are written in Java as JUnit tests and packaged as
Android .apk files to run on the actual device target.

## Workflow ##

1. [Download](downloads.html) the CTS and CTS media files.

1. Attach at least one device (or emulator) to your machine.

1. For CTS 2.1 R2 and beyond, setup your device (or emulator) to run the accessibility tests:

    2. adb install -r android-cts/repository/testcases/CtsDelegatingAccessibilityService.apk

    2. On the device, enable Settings > Accessibility > Accessibility > Delegating Accessibility Service

1. For CTS 2.3 R4 and beyond, setup your device to run the device administration tests:

    2. adb install -r android-cts/repository/testcases/CtsDeviceAdmin.apk

    2. On the device, enable all the android.deviceadmin.cts.* device administrators under Settings > Location & security > Select device administrators

1. For CTS 2.3 R12 and beyond, the CTS media files must be copied to the device's external storage. Check section 4.2 of the latest CTS manual for further details on copying these files:

    2. Unzip the CTS Media zip file.

    2. Run copy_media.sh [720x480|1280x720|1920x1080|all] [-s serial]. If no resolution is specified, the default maximum resolution of 480x360 is assumed.

1. Launch the CTS. The CTS test harness loads the test plan onto the attached devices. For each test in the test harness:

    - The test harness pushes a .apk file to each device, executes the test through instrumentation, and records test results.

    - The test harness removes the .apk file from each device.

1. Once all the tests are executed, you can view the test results in your browser and use the results to adjust your design. You can continue to run the CTS throughout your development process.

When you are ready, you can submit the report generated by the CTS to cts@android.com. The report is a .zip archived file that contains XML results and supplemental information such as screen captures.

## Types of test cases ##

The CTS includes the following types of test cases:

- *Unit tests* test atomic units of code within the Android platform; e.g. a single class, such as java.util.HashMap.

- *Functional tests* test a combination of APIs together in a higher-level use-case.

- *Reference application tests* instrument a complete sample application to exercise a full set of APIs and Android runtime services

Future versions of the CTS will include the following types of test cases:

- *Robustness tests* test the durability of the system under stress.

- *Performance tests* test the performance of the system against defined benchmarks, for example rendering frames per second.

## Areas Covered ##

The unit test cases cover the following areas to ensure compatibility:

Area | Description 
-----|-------------
Signature tests  |  For each Android release, there are XML files describing the signatures of all public APIs contained in the release. The CTS contains a utility to check those API signatures against the APIs available on the device. The results from signature checking are recorded in the test result XML file.
Platform API Tests  |  Test the platform (core libraries and Android Application Framework) APIs as documented in the SDK [Class Index](https://developer.android.com/reference/classes.html) to ensure API correctness, including correct class, attribute and method signatures, correct method behavior, and negative tests to ensure expected behavior for incorrect parameter handling.
Dalvik VM Tests  |  The tests focus on testing the Dalvik VM
Platform Data Model  |  The CTS tests the core platform data model as exposed to application developers through content providers, as documented in the SDK [android.provider](https://developer.android.com/reference/android/provider/package-summary.html) package: contacts, browser, settings, etc.
Platform Intents  |  The CTS tests the core platform intents, as documented in the SDK [Available Intents](https://developer.android.com/guide/appendix/g-app-intents.html).
Platform Permissions  |  The CTS tests the core platform permissions, as documented in the SDK [Available Permissions](https://developer.android.com/reference/android/Manifest.permission.html).
Platform Resources  |  The CTS tests for correct handling of the core platform resource types, as documented in the SDK [Available Resource Types](https://developer.android.com/guide/topics/resources/available-resources.html). This includes tests for: simple values, drawables, nine-patch, animations, layouts, styles and themes, and loading alternate resources.

