<!--
   Copyright 2010 The Android Open Source Project 

   Licensed under the Apache License, Version 2.0 (the "License"); 
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
-->

# Welcome to Android #

<div style="float: right; width: 35%;">

## News ##

### Source Code Available for Android 4.0 ###

The source code for the Android 4.0 platform and software stack has been
released! This release allows OEMs to begin preparing Android 4.0 for
installation on new and existing devices, and allows hobbyists, enthusiasts,
and researchers to develop custom builds. For information on how to obtain the
software, visit our [Getting the Source](source/downloading.html) page.

### Compatibility Definition for Android 2.3 ###

The Compatibility Definition Document for Android 2.3.3 has been published. 
Android 2.3 allows device manufacturers to use the Android source code to ship
a significantly wider variety of devices, including devices with extra-large
screens, such as tablets. Android 2.3.3 adds enhanced Near-Field
Communications support to the Android APIs. For more information, visit the 
[Compatibility](compatibility/index.html) page.

</div>

<img style="float: right; padding-right: 1.5em;" src="images/home-bugdroid.png" alt="Android Mascot"/>

<div style="font-size: 1.3em;">

Here you can find the information and source code you need to build an
Android-compatible device.

Android is an open-source software stack for mobile devices, and a
corresponding open-source project led by Google. We created Android in
response to our own experiences launching mobile apps. We wanted to make
sure that there was no central point of failure, so that no industry player
can restrict or control the innovations of any other.  That's why we
created Android, and made its source code open.

[Learn more »](about/index.html)

</div>
<div style="clear: both;"/>

<table border="0" style="border: 0px; margin: 0px; padding: 0px;"><tr><td align="center" style="border: 0px; margin: 0px; padding: 0px;">
<div style="float: left; width: 15%; margin: 1em;">&nbsp;</div>
<div class="rebox" style="float: left; width: 30%; margin: 1em;"> 
  <h2 style="color: white; background-color: #95C0D0; border: 0px;">Source</h2>
  <div class="p"> 
    <p><img src="images/lil-wrench.png" alt="" style="margin: 1em; margin-bottom: 5em;"/>
    If you're interested in contributing to the Android source code or helping
    out with the open-source project, our Source pages have the information
    you need.</p> 
    <p><a href="source/index.html">Get Involved &raquo;</a></p> 
  </div> 
</div> 

<!--
<div class="rebox" style="float: left; width: 30%; margin: 1em;"> 
  <h2 style="color: white; background-color: #95C0D0; border: 0px;">Porting</h2> 
  <div class="p"> 
    <p><img src="images/lil-wrench.png" alt="" style="margin: 1em; margin-bottom: 5em;"/>
    If you're an engineer building a device
    intended to run the Android software stack, look at our Porting pages for
    information and tips.</p> 
    <p><a href="porting/index.html">Build a Device &raquo;</a></p> 
  </div> 
</div> 
-->

<div class="rebox" style="float: left; width: 30%; margin: 1em;"> 
  <h2 style="color: white; background-color: #95C0D0; border: 0px;">Compatibility</h2> 
  <div class="p"> 
    <p><img src="images/lil-wrench.png" alt="" style="margin: 1em; margin-bottom: 5em;"/>
    If you're an organization building an Android device, you'll want to check out our
    Compatibility pages to find out how to take advantage of the benefits of
    compatibility.</p> 
    <p><a href="compatibility/index.html">Get Compatible &raquo;</a></p> 
  </div> 
</div> 
<div style="float: left; width: 15%; margin: 1em;">&nbsp;</div>
</td></tr></table>

<div style="clear: both;"/>
