/* File automatically generated by Parser/asdl_c.py */

#include "Python.h"
#include "Python-ast.h"

static int marshal_write_mod(PyObject **, int *, mod_ty);
static int marshal_write_stmt(PyObject **, int *, stmt_ty);
static int marshal_write_expr(PyObject **, int *, expr_ty);
static int marshal_write_expr_context(PyObject **, int *, expr_context_ty);
static int marshal_write_slice(PyObject **, int *, slice_ty);
static int marshal_write_boolop(PyObject **, int *, boolop_ty);
static int marshal_write_operator(PyObject **, int *, operator_ty);
static int marshal_write_unaryop(PyObject **, int *, unaryop_ty);
static int marshal_write_cmpop(PyObject **, int *, cmpop_ty);
static int marshal_write_comprehension(PyObject **, int *, comprehension_ty);
static int marshal_write_excepthandler(PyObject **, int *, excepthandler_ty);
static int marshal_write_arguments(PyObject **, int *, arguments_ty);
static int marshal_write_keyword(PyObject **, int *, keyword_ty);
static int marshal_write_alias(PyObject **, int *, alias_ty);

mod_ty
Module(asdl_seq * body)
{
        mod_ty p;
        p = (mod_ty)malloc(sizeof(*p));
        if (!p) {
                PyErr_NoMemory();
                return NULL;
        }
        p->kind = Module_kind;
        p->v.Module.body = body;
        return p;
}

mod_ty
Interactive(asdl_seq * body)
{
        mod_ty p;
        p = (mod_ty)malloc(sizeof(*p));
        if (!p) {
                PyErr_NoMemory();
                return NULL;
        }
        p->kind = Interactive_kind;
        p->v.Interactive.body = body;
        return p;
}

mod_ty
Expression(expr_ty body)
{
        mod_ty p;
        if (!body) {
                PyErr_SetString(PyExc_ValueError,
                                "field body is required for Expression");
                return NULL;
        }
        p = (mod_ty)malloc(sizeof(*p));
        if (!p) {
                PyErr_NoMemory();
                return NULL;
        }
        p->kind = Expression_kind;
        p->v.Expression.body = body;
        return p;
}

mod_ty
Suite(asdl_seq * body)
{
        mod_ty p;
        p = (mod_ty)malloc(sizeof(*p));
        if (!p) {
                PyErr_NoMemory();
                return NULL;
        }
        p->kind = Suite_kind;
        p->v.Suite.body = body;
        return p;
}

stmt_ty
FunctionDef(identifier name, arguments_ty args, asdl_seq * body, asdl_seq *
            decorators, int lineno)
{
        stmt_ty p;
        if (!name) {
                PyErr_SetString(PyExc_ValueError,
                                "field name is required for FunctionDef");
                return NULL;
        }
        if (!args) {
                PyErr_SetString(PyExc_ValueError,
                                "field args is required for FunctionDef");
                return NULL;
        }
        p = (stmt_ty)malloc(sizeof(*p));
        if (!p) {
                PyErr_NoMemory();
                return NULL;
        }
        p->kind = FunctionDef_kind;
        p->v.FunctionDef.name = name;
        p->v.FunctionDef.args = args;
        p->v.FunctionDef.body = body;
        p->v.FunctionDef.decorators = decorators;
        p->lineno = lineno;
        return p;
}

stmt_ty
ClassDef(identifier name, asdl_seq * bases, asdl_seq * body, int lineno)
{
        stmt_ty p;
        if (!name) {
                PyErr_SetString(PyExc_ValueError,
                                "field name is required for ClassDef");
                return NULL;
        }
        p = (stmt_ty)malloc(sizeof(*p));
        if (!p) {
                PyErr_NoMemory();
                return NULL;
        }
        p->kind = ClassDef_kind;
        p->v.ClassDef.name = name;
        p->v.ClassDef.bases = bases;
        p->v.ClassDef.body = body;
        p->lineno = lineno;
        return p;
}

stmt_ty
Return(expr_ty value, int lineno)
{
        stmt_ty p;
        p = (stmt_ty)malloc(sizeof(*p));
        if (!p) {
                PyErr_NoMemory();
                return NULL;
        }
        p->kind = Return_kind;
        p->v.Return.value = value;
        p->lineno = lineno;
        return p;
}

stmt_ty
Delete(asdl_seq * targets, int lineno)
{
        stmt_ty p;
        p = (stmt_ty)malloc(sizeof(*p));
        if (!p) {
                PyErr_NoMemory();
                return NULL;
        }
        p->kind = Delete_kind;
        p->v.Delete.targets = targets;
        p->lineno = lineno;
        return p;
}

stmt_ty
Assign(asdl_seq * targets, expr_ty value, int lineno)
{
        stmt_ty p;
        if (!value) {
                PyErr_SetString(PyExc_ValueError,
                                "field value is required for Assign");
                return NULL;
        }
        p = (stmt_ty)malloc(sizeof(*p));
        if (!p) {
                PyErr_NoMemory();
                return NULL;
        }
        p->kind = Assign_kind;
        p->v.Assign.targets = targets;
        p->v.Assign.value = value;
        p->lineno = lineno;
        return p;
}

stmt_ty
AugAssign(expr_ty target, operator_ty op, expr_ty value, int lineno)
{
        stmt_ty p;
        if (!target) {
                PyErr_SetString(PyExc_ValueError,
                                "field target is required for AugAssign");
                return NULL;
        }
        if (!op) {
                PyErr_SetString(PyExc_ValueError,
                                "field op is required for AugAssign");
                return NULL;
        }
        if (!value) {
                PyErr_SetString(PyExc_ValueError,
                                "field value is required for AugAssign");
                return NULL;
        }
        p = (stmt_ty)malloc(sizeof(*p));
        if (!p) {
                PyErr_NoMemory();
                return NULL;
        }
        p->kind = AugAssign_kind;
        p->v.AugAssign.target = target;
        p->v.AugAssign.op = op;
        p->v.AugAssign.value = value;
        p->lineno = lineno;
        return p;
}

stmt_ty
Print(expr_ty dest, asdl_seq * values, bool nl, int lineno)
{
        stmt_ty p;
        p = (stmt_ty)malloc(sizeof(*p));
        if (!p) {
                PyErr_NoMemory();
                return NULL;
        }
        p->kind = Print_kind;
        p->v.Print.dest = dest;
        p->v.Print.values = values;
        p->v.Print.nl = nl;
        p->lineno = lineno;
        return p;
}

stmt_ty
For(expr_ty target, expr_ty iter, asdl_seq * body, asdl_seq * orelse, int
    lineno)
{
        stmt_ty p;
        if (!target) {
                PyErr_SetString(PyExc_ValueError,
                                "field target is required for For");
                return NULL;
        }
        if (!iter) {
                PyErr_SetString(PyExc_ValueError,
                                "field iter is required for For");
                return NULL;
        }
        p = (stmt_ty)malloc(sizeof(*p));
        if (!p) {
                PyErr_NoMemory();
                return NULL;
        }
        p->kind = For_kind;
        p->v.For.target = target;
        p->v.For.iter = iter;
        p->v.For.body = body;
        p->v.For.orelse = orelse;
        p->lineno = lineno;
        return p;
}

stmt_ty
While(expr_ty test, asdl_seq * body, asdl_seq * orelse, int lineno)
{
        stmt_ty p;
        if (!test) {
                PyErr_SetString(PyExc_ValueError,
                                "field test is required for While");
                return NULL;
        }
        p = (stmt_ty)malloc(sizeof(*p));
        if (!p) {
                PyErr_NoMemory();
                return NULL;
        }
        p->kind = While_kind;
        p->v.While.test = test;
        p->v.While.body = body;
        p->v.While.orelse = orelse;
        p->lineno = lineno;
        return p;
}

stmt_ty
If(expr_ty test, asdl_seq * body, asdl_seq * orelse, int lineno)
{
        stmt_ty p;
        if (!test) {
                PyErr_SetString(PyExc_ValueError,
                                "field test is required for If");
                return NULL;
        }
        p = (stmt_ty)malloc(sizeof(*p));
        if (!p) {
                PyErr_NoMemory();
                return NULL;
        }
        p->kind = If_kind;
        p->v.If.test = test;
        p->v.If.body = body;
        p->v.If.orelse = orelse;
        p->lineno = lineno;
        return p;
}

stmt_ty
Raise(expr_ty type, expr_ty inst, expr_ty tback, int lineno)
{
        stmt_ty p;
        p = (stmt_ty)malloc(sizeof(*p));
        if (!p) {
                PyErr_NoMemory();
                return NULL;
        }
        p->kind = Raise_kind;
        p->v.Raise.type = type;
        p->v.Raise.inst = inst;
        p->v.Raise.tback = tback;
        p->lineno = lineno;
        return p;
}

stmt_ty
TryExcept(asdl_seq * body, asdl_seq * handlers, asdl_seq * orelse, int lineno)
{
        stmt_ty p;
        p = (stmt_ty)malloc(sizeof(*p));
        if (!p) {
                PyErr_NoMemory();
                return NULL;
        }
        p->kind = TryExcept_kind;
        p->v.TryExcept.body = body;
        p->v.TryExcept.handlers = handlers;
        p->v.TryExcept.orelse = orelse;
        p->lineno = lineno;
        return p;
}

stmt_ty
TryFinally(asdl_seq * body, asdl_seq * finalbody, int lineno)
{
        stmt_ty p;
        p = (stmt_ty)malloc(sizeof(*p));
        if (!p) {
                PyErr_NoMemory();
                return NULL;
        }
        p->kind = TryFinally_kind;
        p->v.TryFinally.body = body;
        p->v.TryFinally.finalbody = finalbody;
        p->lineno = lineno;
        return p;
}

stmt_ty
Assert(expr_ty test, expr_ty msg, int lineno)
{
        stmt_ty p;
        if (!test) {
                PyErr_SetString(PyExc_ValueError,
                                "field test is required for Assert");
                return NULL;
        }
        p = (stmt_ty)malloc(sizeof(*p));
        if (!p) {
                PyErr_NoMemory();
                return NULL;
        }
        p->kind = Assert_kind;
        p->v.Assert.test = test;
        p->v.Assert.msg = msg;
        p->lineno = lineno;
        return p;
}

stmt_ty
Import(asdl_seq * names, int lineno)
{
        stmt_ty p;
        p = (stmt_ty)malloc(sizeof(*p));
        if (!p) {
                PyErr_NoMemory();
                return NULL;
        }
        p->kind = Import_kind;
        p->v.Import.names = names;
        p->lineno = lineno;
        return p;
}

stmt_ty
ImportFrom(identifier module, asdl_seq * names, int lineno)
{
        stmt_ty p;
        if (!module) {
                PyErr_SetString(PyExc_ValueError,
                                "field module is required for ImportFrom");
                return NULL;
        }
        p = (stmt_ty)malloc(sizeof(*p));
        if (!p) {
                PyErr_NoMemory();
                return NULL;
        }
        p->kind = ImportFrom_kind;
        p->v.ImportFrom.module = module;
        p->v.ImportFrom.names = names;
        p->lineno = lineno;
        return p;
}

stmt_ty
Exec(expr_ty body, expr_ty globals, expr_ty locals, int lineno)
{
        stmt_ty p;
        if (!body) {
                PyErr_SetString(PyExc_ValueError,
                                "field body is required for Exec");
                return NULL;
        }
        p = (stmt_ty)malloc(sizeof(*p));
        if (!p) {
                PyErr_NoMemory();
                return NULL;
        }
        p->kind = Exec_kind;
        p->v.Exec.body = body;
        p->v.Exec.globals = globals;
        p->v.Exec.locals = locals;
        p->lineno = lineno;
        return p;
}

stmt_ty
Global(asdl_seq * names, int lineno)
{
        stmt_ty p;
        p = (stmt_ty)malloc(sizeof(*p));
        if (!p) {
                PyErr_NoMemory();
                return NULL;
        }
        p->kind = Global_kind;
        p->v.Global.names = names;
        p->lineno = lineno;
        return p;
}

stmt_ty
Expr(expr_ty value, int lineno)
{
        stmt_ty p;
        if (!value) {
                PyErr_SetString(PyExc_ValueError,
                                "field value is required for Expr");
                return NULL;
        }
        p = (stmt_ty)malloc(sizeof(*p));
        if (!p) {
                PyErr_NoMemory();
                return NULL;
        }
        p->kind = Expr_kind;
        p->v.Expr.value = value;
        p->lineno = lineno;
        return p;
}

stmt_ty
Pass(int lineno)
{
        stmt_ty p;
        p = (stmt_ty)malloc(sizeof(*p));
        if (!p) {
                PyErr_NoMemory();
                return NULL;
        }
        p->kind = Pass_kind;
        p->lineno = lineno;
        return p;
}

stmt_ty
Break(int lineno)
{
        stmt_ty p;
        p = (stmt_ty)malloc(sizeof(*p));
        if (!p) {
                PyErr_NoMemory();
                return NULL;
        }
        p->kind = Break_kind;
        p->lineno = lineno;
        return p;
}

stmt_ty
Continue(int lineno)
{
        stmt_ty p;
        p = (stmt_ty)malloc(sizeof(*p));
        if (!p) {
                PyErr_NoMemory();
                return NULL;
        }
        p->kind = Continue_kind;
        p->lineno = lineno;
        return p;
}

expr_ty
BoolOp(boolop_ty op, asdl_seq * values, int lineno)
{
        expr_ty p;
        if (!op) {
                PyErr_SetString(PyExc_ValueError,
                                "field op is required for BoolOp");
                return NULL;
        }
        p = (expr_ty)malloc(sizeof(*p));
        if (!p) {
                PyErr_NoMemory();
                return NULL;
        }
        p->kind = BoolOp_kind;
        p->v.BoolOp.op = op;
        p->v.BoolOp.values = values;
        p->lineno = lineno;
        return p;
}

expr_ty
BinOp(expr_ty left, operator_ty op, expr_ty right, int lineno)
{
        expr_ty p;
        if (!left) {
                PyErr_SetString(PyExc_ValueError,
                                "field left is required for BinOp");
                return NULL;
        }
        if (!op) {
                PyErr_SetString(PyExc_ValueError,
                                "field op is required for BinOp");
                return NULL;
        }
        if (!right) {
                PyErr_SetString(PyExc_ValueError,
                                "field right is required for BinOp");
                return NULL;
        }
        p = (expr_ty)malloc(sizeof(*p));
        if (!p) {
                PyErr_NoMemory();
                return NULL;
        }
        p->kind = BinOp_kind;
        p->v.BinOp.left = left;
        p->v.BinOp.op = op;
        p->v.BinOp.right = right;
        p->lineno = lineno;
        return p;
}

expr_ty
UnaryOp(unaryop_ty op, expr_ty operand, int lineno)
{
        expr_ty p;
        if (!op) {
                PyErr_SetString(PyExc_ValueError,
                                "field op is required for UnaryOp");
                return NULL;
        }
        if (!operand) {
                PyErr_SetString(PyExc_ValueError,
                                "field operand is required for UnaryOp");
                return NULL;
        }
        p = (expr_ty)malloc(sizeof(*p));
        if (!p) {
                PyErr_NoMemory();
                return NULL;
        }
        p->kind = UnaryOp_kind;
        p->v.UnaryOp.op = op;
        p->v.UnaryOp.operand = operand;
        p->lineno = lineno;
        return p;
}

expr_ty
Lambda(arguments_ty args, expr_ty body, int lineno)
{
        expr_ty p;
        if (!args) {
                PyErr_SetString(PyExc_ValueError,
                                "field args is required for Lambda");
                return NULL;
        }
        if (!body) {
                PyErr_SetString(PyExc_ValueError,
                                "field body is required for Lambda");
                return NULL;
        }
        p = (expr_ty)malloc(sizeof(*p));
        if (!p) {
                PyErr_NoMemory();
                return NULL;
        }
        p->kind = Lambda_kind;
        p->v.Lambda.args = args;
        p->v.Lambda.body = body;
        p->lineno = lineno;
        return p;
}

expr_ty
Dict(asdl_seq * keys, asdl_seq * values, int lineno)
{
        expr_ty p;
        p = (expr_ty)malloc(sizeof(*p));
        if (!p) {
                PyErr_NoMemory();
                return NULL;
        }
        p->kind = Dict_kind;
        p->v.Dict.keys = keys;
        p->v.Dict.values = values;
        p->lineno = lineno;
        return p;
}

expr_ty
ListComp(expr_ty elt, asdl_seq * generators, int lineno)
{
        expr_ty p;
        if (!elt) {
                PyErr_SetString(PyExc_ValueError,
                                "field elt is required for ListComp");
                return NULL;
        }
        p = (expr_ty)malloc(sizeof(*p));
        if (!p) {
                PyErr_NoMemory();
                return NULL;
        }
        p->kind = ListComp_kind;
        p->v.ListComp.elt = elt;
        p->v.ListComp.generators = generators;
        p->lineno = lineno;
        return p;
}

expr_ty
GeneratorExp(expr_ty elt, asdl_seq * generators, int lineno)
{
        expr_ty p;
        if (!elt) {
                PyErr_SetString(PyExc_ValueError,
                                "field elt is required for GeneratorExp");
                return NULL;
        }
        p = (expr_ty)malloc(sizeof(*p));
        if (!p) {
                PyErr_NoMemory();
                return NULL;
        }
        p->kind = GeneratorExp_kind;
        p->v.GeneratorExp.elt = elt;
        p->v.GeneratorExp.generators = generators;
        p->lineno = lineno;
        return p;
}

expr_ty
Yield(expr_ty value, int lineno)
{
        expr_ty p;
        p = (expr_ty)malloc(sizeof(*p));
        if (!p) {
                PyErr_NoMemory();
                return NULL;
        }
        p->kind = Yield_kind;
        p->v.Yield.value = value;
        p->lineno = lineno;
        return p;
}

expr_ty
Compare(expr_ty left, asdl_seq * ops, asdl_seq * comparators, int lineno)
{
        expr_ty p;
        if (!left) {
                PyErr_SetString(PyExc_ValueError,
                                "field left is required for Compare");
                return NULL;
        }
        p = (expr_ty)malloc(sizeof(*p));
        if (!p) {
                PyErr_NoMemory();
                return NULL;
        }
        p->kind = Compare_kind;
        p->v.Compare.left = left;
        p->v.Compare.ops = ops;
        p->v.Compare.comparators = comparators;
        p->lineno = lineno;
        return p;
}

expr_ty
Call(expr_ty func, asdl_seq * args, asdl_seq * keywords, expr_ty starargs,
     expr_ty kwargs, int lineno)
{
        expr_ty p;
        if (!func) {
                PyErr_SetString(PyExc_ValueError,
                                "field func is required for Call");
                return NULL;
        }
        p = (expr_ty)malloc(sizeof(*p));
        if (!p) {
                PyErr_NoMemory();
                return NULL;
        }
        p->kind = Call_kind;
        p->v.Call.func = func;
        p->v.Call.args = args;
        p->v.Call.keywords = keywords;
        p->v.Call.starargs = starargs;
        p->v.Call.kwargs = kwargs;
        p->lineno = lineno;
        return p;
}

expr_ty
Repr(expr_ty value, int lineno)
{
        expr_ty p;
        if (!value) {
                PyErr_SetString(PyExc_ValueError,
                                "field value is required for Repr");
                return NULL;
        }
        p = (expr_ty)malloc(sizeof(*p));
        if (!p) {
                PyErr_NoMemory();
                return NULL;
        }
        p->kind = Repr_kind;
        p->v.Repr.value = value;
        p->lineno = lineno;
        return p;
}

expr_ty
Num(object n, int lineno)
{
        expr_ty p;
        if (!n) {
                PyErr_SetString(PyExc_ValueError,
                                "field n is required for Num");
                return NULL;
        }
        p = (expr_ty)malloc(sizeof(*p));
        if (!p) {
                PyErr_NoMemory();
                return NULL;
        }
        p->kind = Num_kind;
        p->v.Num.n = n;
        p->lineno = lineno;
        return p;
}

expr_ty
Str(string s, int lineno)
{
        expr_ty p;
        if (!s) {
                PyErr_SetString(PyExc_ValueError,
                                "field s is required for Str");
                return NULL;
        }
        p = (expr_ty)malloc(sizeof(*p));
        if (!p) {
                PyErr_NoMemory();
                return NULL;
        }
        p->kind = Str_kind;
        p->v.Str.s = s;
        p->lineno = lineno;
        return p;
}

expr_ty
Attribute(expr_ty value, identifier attr, expr_context_ty ctx, int lineno)
{
        expr_ty p;
        if (!value) {
                PyErr_SetString(PyExc_ValueError,
                                "field value is required for Attribute");
                return NULL;
        }
        if (!attr) {
                PyErr_SetString(PyExc_ValueError,
                                "field attr is required for Attribute");
                return NULL;
        }
        if (!ctx) {
                PyErr_SetString(PyExc_ValueError,
                                "field ctx is required for Attribute");
                return NULL;
        }
        p = (expr_ty)malloc(sizeof(*p));
        if (!p) {
                PyErr_NoMemory();
                return NULL;
        }
        p->kind = Attribute_kind;
        p->v.Attribute.value = value;
        p->v.Attribute.attr = attr;
        p->v.Attribute.ctx = ctx;
        p->lineno = lineno;
        return p;
}

expr_ty
Subscript(expr_ty value, slice_ty slice, expr_context_ty ctx, int lineno)
{
        expr_ty p;
        if (!value) {
                PyErr_SetString(PyExc_ValueError,
                                "field value is required for Subscript");
                return NULL;
        }
        if (!slice) {
                PyErr_SetString(PyExc_ValueError,
                                "field slice is required for Subscript");
                return NULL;
        }
        if (!ctx) {
                PyErr_SetString(PyExc_ValueError,
                                "field ctx is required for Subscript");
                return NULL;
        }
        p = (expr_ty)malloc(sizeof(*p));
        if (!p) {
                PyErr_NoMemory();
                return NULL;
        }
        p->kind = Subscript_kind;
        p->v.Subscript.value = value;
        p->v.Subscript.slice = slice;
        p->v.Subscript.ctx = ctx;
        p->lineno = lineno;
        return p;
}

expr_ty
Name(identifier id, expr_context_ty ctx, int lineno)
{
        expr_ty p;
        if (!id) {
                PyErr_SetString(PyExc_ValueError,
                                "field id is required for Name");
                return NULL;
        }
        if (!ctx) {
                PyErr_SetString(PyExc_ValueError,
                                "field ctx is required for Name");
                return NULL;
        }
        p = (expr_ty)malloc(sizeof(*p));
        if (!p) {
                PyErr_NoMemory();
                return NULL;
        }
        p->kind = Name_kind;
        p->v.Name.id = id;
        p->v.Name.ctx = ctx;
        p->lineno = lineno;
        return p;
}

expr_ty
List(asdl_seq * elts, expr_context_ty ctx, int lineno)
{
        expr_ty p;
        if (!ctx) {
                PyErr_SetString(PyExc_ValueError,
                                "field ctx is required for List");
                return NULL;
        }
        p = (expr_ty)malloc(sizeof(*p));
        if (!p) {
                PyErr_NoMemory();
                return NULL;
        }
        p->kind = List_kind;
        p->v.List.elts = elts;
        p->v.List.ctx = ctx;
        p->lineno = lineno;
        return p;
}

expr_ty
Tuple(asdl_seq * elts, expr_context_ty ctx, int lineno)
{
        expr_ty p;
        if (!ctx) {
                PyErr_SetString(PyExc_ValueError,
                                "field ctx is required for Tuple");
                return NULL;
        }
        p = (expr_ty)malloc(sizeof(*p));
        if (!p) {
                PyErr_NoMemory();
                return NULL;
        }
        p->kind = Tuple_kind;
        p->v.Tuple.elts = elts;
        p->v.Tuple.ctx = ctx;
        p->lineno = lineno;
        return p;
}

slice_ty
Ellipsis()
{
        slice_ty p;
        p = (slice_ty)malloc(sizeof(*p));
        if (!p) {
                PyErr_NoMemory();
                return NULL;
        }
        p->kind = Ellipsis_kind;
        return p;
}

slice_ty
Slice(expr_ty lower, expr_ty upper, expr_ty step)
{
        slice_ty p;
        p = (slice_ty)malloc(sizeof(*p));
        if (!p) {
                PyErr_NoMemory();
                return NULL;
        }
        p->kind = Slice_kind;
        p->v.Slice.lower = lower;
        p->v.Slice.upper = upper;
        p->v.Slice.step = step;
        return p;
}

slice_ty
ExtSlice(asdl_seq * dims)
{
        slice_ty p;
        p = (slice_ty)malloc(sizeof(*p));
        if (!p) {
                PyErr_NoMemory();
                return NULL;
        }
        p->kind = ExtSlice_kind;
        p->v.ExtSlice.dims = dims;
        return p;
}

slice_ty
Index(expr_ty value)
{
        slice_ty p;
        if (!value) {
                PyErr_SetString(PyExc_ValueError,
                                "field value is required for Index");
                return NULL;
        }
        p = (slice_ty)malloc(sizeof(*p));
        if (!p) {
                PyErr_NoMemory();
                return NULL;
        }
        p->kind = Index_kind;
        p->v.Index.value = value;
        return p;
}

comprehension_ty
comprehension(expr_ty target, expr_ty iter, asdl_seq * ifs)
{
        comprehension_ty p;
        if (!target) {
                PyErr_SetString(PyExc_ValueError,
                                "field target is required for comprehension");
                return NULL;
        }
        if (!iter) {
                PyErr_SetString(PyExc_ValueError,
                                "field iter is required for comprehension");
                return NULL;
        }
        p = (comprehension_ty)malloc(sizeof(*p));
        if (!p) {
                PyErr_NoMemory();
                return NULL;
        }
        p->target = target;
        p->iter = iter;
        p->ifs = ifs;
        return p;
}

excepthandler_ty
excepthandler(expr_ty type, expr_ty name, asdl_seq * body)
{
        excepthandler_ty p;
        p = (excepthandler_ty)malloc(sizeof(*p));
        if (!p) {
                PyErr_NoMemory();
                return NULL;
        }
        p->type = type;
        p->name = name;
        p->body = body;
        return p;
}

arguments_ty
arguments(asdl_seq * args, identifier vararg, identifier kwarg, asdl_seq *
          defaults)
{
        arguments_ty p;
        p = (arguments_ty)malloc(sizeof(*p));
        if (!p) {
                PyErr_NoMemory();
                return NULL;
        }
        p->args = args;
        p->vararg = vararg;
        p->kwarg = kwarg;
        p->defaults = defaults;
        return p;
}

keyword_ty
keyword(identifier arg, expr_ty value)
{
        keyword_ty p;
        if (!arg) {
                PyErr_SetString(PyExc_ValueError,
                                "field arg is required for keyword");
                return NULL;
        }
        if (!value) {
                PyErr_SetString(PyExc_ValueError,
                                "field value is required for keyword");
                return NULL;
        }
        p = (keyword_ty)malloc(sizeof(*p));
        if (!p) {
                PyErr_NoMemory();
                return NULL;
        }
        p->arg = arg;
        p->value = value;
        return p;
}

alias_ty
alias(identifier name, identifier asname)
{
        alias_ty p;
        if (!name) {
                PyErr_SetString(PyExc_ValueError,
                                "field name is required for alias");
                return NULL;
        }
        p = (alias_ty)malloc(sizeof(*p));
        if (!p) {
                PyErr_NoMemory();
                return NULL;
        }
        p->name = name;
        p->asname = asname;
        return p;
}


static void
free_seq_exprs(asdl_seq *seq)
{
        int i, n;
        n = asdl_seq_LEN(seq);
        for (i = 0; i < n; i++)
                free_expr((expr_ty)asdl_seq_GET(seq, i));
        asdl_seq_free(seq);
}

static void
free_seq_stmts(asdl_seq *seq)
{
        int i, n;
        n = asdl_seq_LEN(seq);
        for (i = 0; i < n; i++)
                free_stmt((stmt_ty)asdl_seq_GET(seq, i));
        asdl_seq_free(seq);
}


void
free_mod(mod_ty o)
{
        if (!o)
                return;

        switch (o->kind) {
        case Module_kind:
                free_seq_stmts(o->v.Module.body);
                break;
        case Interactive_kind:
                free_seq_stmts(o->v.Interactive.body);
                break;
        case Expression_kind:
                free_expr((expr_ty)o->v.Expression.body);
                break;
        case Suite_kind:
                free_seq_stmts(o->v.Suite.body);
                break;
        }

        free(o);
}

void
free_stmt(stmt_ty o)
{
        int i, n;
        asdl_seq *seq;

        if (!o)
                return;

        switch (o->kind) {
        case FunctionDef_kind:
                Py_DECREF((identifier)o->v.FunctionDef.name);
                free_arguments((arguments_ty)o->v.FunctionDef.args);
                free_seq_stmts(o->v.FunctionDef.body);
                free_seq_exprs(o->v.FunctionDef.decorators);
                break;
        case ClassDef_kind:
                Py_DECREF((identifier)o->v.ClassDef.name);
                free_seq_exprs(o->v.ClassDef.bases);
                free_seq_stmts(o->v.ClassDef.body);
                break;
        case Return_kind:
                if (o->v.Return.value) {
                        free_expr((expr_ty)o->v.Return.value);
                }
                break;
        case Delete_kind:
                free_seq_exprs(o->v.Delete.targets);
                break;
        case Assign_kind:
                free_seq_exprs(o->v.Assign.targets);
                free_expr((expr_ty)o->v.Assign.value);
                break;
        case AugAssign_kind:
                free_expr((expr_ty)o->v.AugAssign.target);
                free_operator((operator_ty)o->v.AugAssign.op);
                free_expr((expr_ty)o->v.AugAssign.value);
                break;
        case Print_kind:
                if (o->v.Print.dest) {
                        free_expr((expr_ty)o->v.Print.dest);
                }
                free_seq_exprs(o->v.Print.values);
                break;
        case For_kind:
                free_expr((expr_ty)o->v.For.target);
                free_expr((expr_ty)o->v.For.iter);
                free_seq_stmts(o->v.For.body);
                free_seq_stmts(o->v.For.orelse);
                break;
        case While_kind:
                free_expr((expr_ty)o->v.While.test);
                free_seq_stmts(o->v.While.body);
                free_seq_stmts(o->v.While.orelse);
                break;
        case If_kind:
                free_expr((expr_ty)o->v.If.test);
                free_seq_stmts(o->v.If.body);
                free_seq_stmts(o->v.If.orelse);
                break;
        case Raise_kind:
                if (o->v.Raise.type) {
                        free_expr((expr_ty)o->v.Raise.type);
                }
                if (o->v.Raise.inst) {
                        free_expr((expr_ty)o->v.Raise.inst);
                }
                if (o->v.Raise.tback) {
                        free_expr((expr_ty)o->v.Raise.tback);
                }
                break;
        case TryExcept_kind:
                free_seq_stmts(o->v.TryExcept.body);
                seq = o->v.TryExcept.handlers;
                n = asdl_seq_LEN(seq);
                for (i = 0; i < n; i++)
                        free_excepthandler((excepthandler_ty)asdl_seq_GET(seq,
                                           i));
                asdl_seq_free(seq);
                free_seq_stmts(o->v.TryExcept.orelse);
                break;
        case TryFinally_kind:
                free_seq_stmts(o->v.TryFinally.body);
                free_seq_stmts(o->v.TryFinally.finalbody);
                break;
        case Assert_kind:
                free_expr((expr_ty)o->v.Assert.test);
                if (o->v.Assert.msg) {
                        free_expr((expr_ty)o->v.Assert.msg);
                }
                break;
        case Import_kind:
                seq = o->v.Import.names;
                n = asdl_seq_LEN(seq);
                for (i = 0; i < n; i++)
                        free_alias((alias_ty)asdl_seq_GET(seq, i));
                asdl_seq_free(seq);
                break;
        case ImportFrom_kind:
                Py_DECREF((identifier)o->v.ImportFrom.module);
                seq = o->v.ImportFrom.names;
                n = asdl_seq_LEN(seq);
                for (i = 0; i < n; i++)
                        free_alias((alias_ty)asdl_seq_GET(seq, i));
                asdl_seq_free(seq);
                break;
        case Exec_kind:
                free_expr((expr_ty)o->v.Exec.body);
                if (o->v.Exec.globals) {
                        free_expr((expr_ty)o->v.Exec.globals);
                }
                if (o->v.Exec.locals) {
                        free_expr((expr_ty)o->v.Exec.locals);
                }
                break;
        case Global_kind:
                seq = o->v.Global.names;
                n = asdl_seq_LEN(seq);
                for (i = 0; i < n; i++)
                        Py_DECREF((identifier)asdl_seq_GET(seq, i));
                asdl_seq_free(seq);
                break;
        case Expr_kind:
                free_expr((expr_ty)o->v.Expr.value);
                break;
        case Pass_kind:
                break;
        case Break_kind:
                break;
        case Continue_kind:
                break;
        }

        free(o);
}

void
free_expr(expr_ty o)
{
        int i, n;
        asdl_seq *seq;

        if (!o)
                return;

        switch (o->kind) {
        case BoolOp_kind:
                free_boolop((boolop_ty)o->v.BoolOp.op);
                free_seq_exprs(o->v.BoolOp.values);
                break;
        case BinOp_kind:
                free_expr((expr_ty)o->v.BinOp.left);
                free_operator((operator_ty)o->v.BinOp.op);
                free_expr((expr_ty)o->v.BinOp.right);
                break;
        case UnaryOp_kind:
                free_unaryop((unaryop_ty)o->v.UnaryOp.op);
                free_expr((expr_ty)o->v.UnaryOp.operand);
                break;
        case Lambda_kind:
                free_arguments((arguments_ty)o->v.Lambda.args);
                free_expr((expr_ty)o->v.Lambda.body);
                break;
        case Dict_kind:
                free_seq_exprs(o->v.Dict.keys);
                free_seq_exprs(o->v.Dict.values);
                break;
        case ListComp_kind:
                free_expr((expr_ty)o->v.ListComp.elt);
                seq = o->v.ListComp.generators;
                n = asdl_seq_LEN(seq);
                for (i = 0; i < n; i++)
                        free_comprehension((comprehension_ty)asdl_seq_GET(seq,
                                           i));
                asdl_seq_free(seq);
                break;
        case GeneratorExp_kind:
                free_expr((expr_ty)o->v.GeneratorExp.elt);
                seq = o->v.GeneratorExp.generators;
                n = asdl_seq_LEN(seq);
                for (i = 0; i < n; i++)
                        free_comprehension((comprehension_ty)asdl_seq_GET(seq,
                                           i));
                asdl_seq_free(seq);
                break;
        case Yield_kind:
                if (o->v.Yield.value) {
                        free_expr((expr_ty)o->v.Yield.value);
                }
                break;
        case Compare_kind:
                free_expr((expr_ty)o->v.Compare.left);
                seq = o->v.Compare.ops;
                n = asdl_seq_LEN(seq);
                for (i = 0; i < n; i++)
                        free_cmpop((cmpop_ty)asdl_seq_GET(seq, i));
                asdl_seq_free(seq);
                free_seq_exprs(o->v.Compare.comparators);
                break;
        case Call_kind:
                free_expr((expr_ty)o->v.Call.func);
                free_seq_exprs(o->v.Call.args);
                seq = o->v.Call.keywords;
                n = asdl_seq_LEN(seq);
                for (i = 0; i < n; i++)
                        free_keyword((keyword_ty)asdl_seq_GET(seq, i));
                asdl_seq_free(seq);
                if (o->v.Call.starargs) {
                        free_expr((expr_ty)o->v.Call.starargs);
                }
                if (o->v.Call.kwargs) {
                        free_expr((expr_ty)o->v.Call.kwargs);
                }
                break;
        case Repr_kind:
                free_expr((expr_ty)o->v.Repr.value);
                break;
        case Num_kind:
                Py_DECREF((object)o->v.Num.n);
                break;
        case Str_kind:
                Py_DECREF((string)o->v.Str.s);
                break;
        case Attribute_kind:
                free_expr((expr_ty)o->v.Attribute.value);
                Py_DECREF((identifier)o->v.Attribute.attr);
                free_expr_context((expr_context_ty)o->v.Attribute.ctx);
                break;
        case Subscript_kind:
                free_expr((expr_ty)o->v.Subscript.value);
                free_slice((slice_ty)o->v.Subscript.slice);
                free_expr_context((expr_context_ty)o->v.Subscript.ctx);
                break;
        case Name_kind:
                Py_DECREF((identifier)o->v.Name.id);
                free_expr_context((expr_context_ty)o->v.Name.ctx);
                break;
        case List_kind:
                free_seq_exprs(o->v.List.elts);
                free_expr_context((expr_context_ty)o->v.List.ctx);
                break;
        case Tuple_kind:
                free_seq_exprs(o->v.Tuple.elts);
                free_expr_context((expr_context_ty)o->v.Tuple.ctx);
                break;
        }

        free(o);
}

void
free_expr_context(expr_context_ty o)
{
        if (!o)
                return;

}

void
free_slice(slice_ty o)
{
        int i, n;
        asdl_seq *seq;

        if (!o)
                return;

        switch (o->kind) {
        case Ellipsis_kind:
                break;
        case Slice_kind:
                if (o->v.Slice.lower) {
                        free_expr((expr_ty)o->v.Slice.lower);
                }
                if (o->v.Slice.upper) {
                        free_expr((expr_ty)o->v.Slice.upper);
                }
                if (o->v.Slice.step) {
                        free_expr((expr_ty)o->v.Slice.step);
                }
                break;
        case ExtSlice_kind:
                seq = o->v.ExtSlice.dims;
                n = asdl_seq_LEN(seq);
                for (i = 0; i < n; i++)
                        free_slice((slice_ty)asdl_seq_GET(seq, i));
                asdl_seq_free(seq);
                break;
        case Index_kind:
                free_expr((expr_ty)o->v.Index.value);
                break;
        }

        free(o);
}

void
free_boolop(boolop_ty o)
{
        if (!o)
                return;

}

void
free_operator(operator_ty o)
{
        if (!o)
                return;

}

void
free_unaryop(unaryop_ty o)
{
        if (!o)
                return;

}

void
free_cmpop(cmpop_ty o)
{
        if (!o)
                return;

}

void
free_comprehension(comprehension_ty o)
{
        if (!o)
                return;

        free_expr((expr_ty)o->target);
        free_expr((expr_ty)o->iter);
        free_seq_exprs(o->ifs);

        free(o);
}

void
free_excepthandler(excepthandler_ty o)
{
        if (!o)
                return;

        if (o->type) {
                free_expr((expr_ty)o->type);
        }
        if (o->name) {
                free_expr((expr_ty)o->name);
        }
        free_seq_stmts(o->body);

        free(o);
}

void
free_arguments(arguments_ty o)
{
        if (!o)
                return;

        free_seq_exprs(o->args);
        if (o->vararg) {
                Py_DECREF((identifier)o->vararg);
        }
        if (o->kwarg) {
                Py_DECREF((identifier)o->kwarg);
        }
        free_seq_exprs(o->defaults);

        free(o);
}

void
free_keyword(keyword_ty o)
{
        if (!o)
                return;

        Py_DECREF((identifier)o->arg);
        free_expr((expr_ty)o->value);

        free(o);
}

void
free_alias(alias_ty o)
{
        if (!o)
                return;

        Py_DECREF((identifier)o->name);
        if (o->asname) {
                Py_DECREF((identifier)o->asname);
        }

        free(o);
}



#define CHECKSIZE(BUF, OFF, MIN) { \
	int need = *(OFF) + MIN; \
	if (need >= PyString_GET_SIZE(*(BUF))) { \
		int newsize = PyString_GET_SIZE(*(BUF)) * 2; \
		if (newsize < need) \
			newsize = need; \
		if (_PyString_Resize((BUF), newsize) < 0) \
			return 0; \
	} \
} 

static int 
marshal_write_int(PyObject **buf, int *offset, int x)
{
	char *s;

	CHECKSIZE(buf, offset, 4)
	s = PyString_AS_STRING(*buf) + (*offset);
	s[0] = (x & 0xff);
	s[1] = (x >> 8) & 0xff;
	s[2] = (x >> 16) & 0xff;
	s[3] = (x >> 24) & 0xff;
	*offset += 4;
	return 1;
}

static int 
marshal_write_bool(PyObject **buf, int *offset, bool b)
{
	if (b)
		marshal_write_int(buf, offset, 1);
	else
		marshal_write_int(buf, offset, 0);
	return 1;
}

static int 
marshal_write_identifier(PyObject **buf, int *offset, identifier id)
{
	int l = PyString_GET_SIZE(id);
	marshal_write_int(buf, offset, l);
	CHECKSIZE(buf, offset, l);
	memcpy(PyString_AS_STRING(*buf) + *offset,
	       PyString_AS_STRING(id), l);
	*offset += l;
	return 1;
}

static int 
marshal_write_string(PyObject **buf, int *offset, string s)
{
	int len = PyString_GET_SIZE(s);
	marshal_write_int(buf, offset, len);
	CHECKSIZE(buf, offset, len);
	memcpy(PyString_AS_STRING(*buf) + *offset,
	       PyString_AS_STRING(s), len);
	*offset += len;
	return 1;
}

static int 
marshal_write_object(PyObject **buf, int *offset, object s)
{
	/* XXX */
	return 0;
}


static int
marshal_write_mod(PyObject **buf, int *off, mod_ty o)
{
        int i;
        switch (o->kind) {
        case Module_kind:
                marshal_write_int(buf, off, 1);
                marshal_write_int(buf, off, asdl_seq_LEN(o->v.Module.body));
                for (i = 0; i < asdl_seq_LEN(o->v.Module.body); i++) {
                        void *elt = asdl_seq_GET(o->v.Module.body, i);
                        marshal_write_stmt(buf, off, (stmt_ty)elt);
                }
                break;
        case Interactive_kind:
                marshal_write_int(buf, off, 2);
                marshal_write_int(buf, off,
                                  asdl_seq_LEN(o->v.Interactive.body));
                for (i = 0; i < asdl_seq_LEN(o->v.Interactive.body); i++) {
                        void *elt = asdl_seq_GET(o->v.Interactive.body, i);
                        marshal_write_stmt(buf, off, (stmt_ty)elt);
                }
                break;
        case Expression_kind:
                marshal_write_int(buf, off, 3);
                marshal_write_expr(buf, off, o->v.Expression.body);
                break;
        case Suite_kind:
                marshal_write_int(buf, off, 4);
                marshal_write_int(buf, off, asdl_seq_LEN(o->v.Suite.body));
                for (i = 0; i < asdl_seq_LEN(o->v.Suite.body); i++) {
                        void *elt = asdl_seq_GET(o->v.Suite.body, i);
                        marshal_write_stmt(buf, off, (stmt_ty)elt);
                }
                break;
        }
        return 1;
}

static int
marshal_write_stmt(PyObject **buf, int *off, stmt_ty o)
{
        int i;
        switch (o->kind) {
        case FunctionDef_kind:
                marshal_write_int(buf, off, 1);
                marshal_write_identifier(buf, off, o->v.FunctionDef.name);
                marshal_write_arguments(buf, off, o->v.FunctionDef.args);
                marshal_write_int(buf, off,
                                  asdl_seq_LEN(o->v.FunctionDef.body));
                for (i = 0; i < asdl_seq_LEN(o->v.FunctionDef.body); i++) {
                        void *elt = asdl_seq_GET(o->v.FunctionDef.body, i);
                        marshal_write_stmt(buf, off, (stmt_ty)elt);
                }
                marshal_write_int(buf, off,
                                  asdl_seq_LEN(o->v.FunctionDef.decorators));
                for (i = 0; i < asdl_seq_LEN(o->v.FunctionDef.decorators); i++)
                     {
                        void *elt = asdl_seq_GET(o->v.FunctionDef.decorators,
                                                 i);
                        marshal_write_expr(buf, off, (expr_ty)elt);
                }
                break;
        case ClassDef_kind:
                marshal_write_int(buf, off, 2);
                marshal_write_identifier(buf, off, o->v.ClassDef.name);
                marshal_write_int(buf, off, asdl_seq_LEN(o->v.ClassDef.bases));
                for (i = 0; i < asdl_seq_LEN(o->v.ClassDef.bases); i++) {
                        void *elt = asdl_seq_GET(o->v.ClassDef.bases, i);
                        marshal_write_expr(buf, off, (expr_ty)elt);
                }
                marshal_write_int(buf, off, asdl_seq_LEN(o->v.ClassDef.body));
                for (i = 0; i < asdl_seq_LEN(o->v.ClassDef.body); i++) {
                        void *elt = asdl_seq_GET(o->v.ClassDef.body, i);
                        marshal_write_stmt(buf, off, (stmt_ty)elt);
                }
                break;
        case Return_kind:
                marshal_write_int(buf, off, 3);
                if (o->v.Return.value) {
                        marshal_write_int(buf, off, 1);
                        marshal_write_expr(buf, off, o->v.Return.value);
                }
                else {
                        marshal_write_int(buf, off, 0);
                }
                break;
        case Delete_kind:
                marshal_write_int(buf, off, 4);
                marshal_write_int(buf, off, asdl_seq_LEN(o->v.Delete.targets));
                for (i = 0; i < asdl_seq_LEN(o->v.Delete.targets); i++) {
                        void *elt = asdl_seq_GET(o->v.Delete.targets, i);
                        marshal_write_expr(buf, off, (expr_ty)elt);
                }
                break;
        case Assign_kind:
                marshal_write_int(buf, off, 5);
                marshal_write_int(buf, off, asdl_seq_LEN(o->v.Assign.targets));
                for (i = 0; i < asdl_seq_LEN(o->v.Assign.targets); i++) {
                        void *elt = asdl_seq_GET(o->v.Assign.targets, i);
                        marshal_write_expr(buf, off, (expr_ty)elt);
                }
                marshal_write_expr(buf, off, o->v.Assign.value);
                break;
        case AugAssign_kind:
                marshal_write_int(buf, off, 6);
                marshal_write_expr(buf, off, o->v.AugAssign.target);
                marshal_write_operator(buf, off, o->v.AugAssign.op);
                marshal_write_expr(buf, off, o->v.AugAssign.value);
                break;
        case Print_kind:
                marshal_write_int(buf, off, 7);
                if (o->v.Print.dest) {
                        marshal_write_int(buf, off, 1);
                        marshal_write_expr(buf, off, o->v.Print.dest);
                }
                else {
                        marshal_write_int(buf, off, 0);
                }
                marshal_write_int(buf, off, asdl_seq_LEN(o->v.Print.values));
                for (i = 0; i < asdl_seq_LEN(o->v.Print.values); i++) {
                        void *elt = asdl_seq_GET(o->v.Print.values, i);
                        marshal_write_expr(buf, off, (expr_ty)elt);
                }
                marshal_write_bool(buf, off, o->v.Print.nl);
                break;
        case For_kind:
                marshal_write_int(buf, off, 8);
                marshal_write_expr(buf, off, o->v.For.target);
                marshal_write_expr(buf, off, o->v.For.iter);
                marshal_write_int(buf, off, asdl_seq_LEN(o->v.For.body));
                for (i = 0; i < asdl_seq_LEN(o->v.For.body); i++) {
                        void *elt = asdl_seq_GET(o->v.For.body, i);
                        marshal_write_stmt(buf, off, (stmt_ty)elt);
                }
                marshal_write_int(buf, off, asdl_seq_LEN(o->v.For.orelse));
                for (i = 0; i < asdl_seq_LEN(o->v.For.orelse); i++) {
                        void *elt = asdl_seq_GET(o->v.For.orelse, i);
                        marshal_write_stmt(buf, off, (stmt_ty)elt);
                }
                break;
        case While_kind:
                marshal_write_int(buf, off, 9);
                marshal_write_expr(buf, off, o->v.While.test);
                marshal_write_int(buf, off, asdl_seq_LEN(o->v.While.body));
                for (i = 0; i < asdl_seq_LEN(o->v.While.body); i++) {
                        void *elt = asdl_seq_GET(o->v.While.body, i);
                        marshal_write_stmt(buf, off, (stmt_ty)elt);
                }
                marshal_write_int(buf, off, asdl_seq_LEN(o->v.While.orelse));
                for (i = 0; i < asdl_seq_LEN(o->v.While.orelse); i++) {
                        void *elt = asdl_seq_GET(o->v.While.orelse, i);
                        marshal_write_stmt(buf, off, (stmt_ty)elt);
                }
                break;
        case If_kind:
                marshal_write_int(buf, off, 10);
                marshal_write_expr(buf, off, o->v.If.test);
                marshal_write_int(buf, off, asdl_seq_LEN(o->v.If.body));
                for (i = 0; i < asdl_seq_LEN(o->v.If.body); i++) {
                        void *elt = asdl_seq_GET(o->v.If.body, i);
                        marshal_write_stmt(buf, off, (stmt_ty)elt);
                }
                marshal_write_int(buf, off, asdl_seq_LEN(o->v.If.orelse));
                for (i = 0; i < asdl_seq_LEN(o->v.If.orelse); i++) {
                        void *elt = asdl_seq_GET(o->v.If.orelse, i);
                        marshal_write_stmt(buf, off, (stmt_ty)elt);
                }
                break;
        case Raise_kind:
                marshal_write_int(buf, off, 11);
                if (o->v.Raise.type) {
                        marshal_write_int(buf, off, 1);
                        marshal_write_expr(buf, off, o->v.Raise.type);
                }
                else {
                        marshal_write_int(buf, off, 0);
                }
                if (o->v.Raise.inst) {
                        marshal_write_int(buf, off, 1);
                        marshal_write_expr(buf, off, o->v.Raise.inst);
                }
                else {
                        marshal_write_int(buf, off, 0);
                }
                if (o->v.Raise.tback) {
                        marshal_write_int(buf, off, 1);
                        marshal_write_expr(buf, off, o->v.Raise.tback);
                }
                else {
                        marshal_write_int(buf, off, 0);
                }
                break;
        case TryExcept_kind:
                marshal_write_int(buf, off, 12);
                marshal_write_int(buf, off, asdl_seq_LEN(o->v.TryExcept.body));
                for (i = 0; i < asdl_seq_LEN(o->v.TryExcept.body); i++) {
                        void *elt = asdl_seq_GET(o->v.TryExcept.body, i);
                        marshal_write_stmt(buf, off, (stmt_ty)elt);
                }
                marshal_write_int(buf, off,
                                  asdl_seq_LEN(o->v.TryExcept.handlers));
                for (i = 0; i < asdl_seq_LEN(o->v.TryExcept.handlers); i++) {
                        void *elt = asdl_seq_GET(o->v.TryExcept.handlers, i);
                        marshal_write_excepthandler(buf, off,
                                                    (excepthandler_ty)elt);
                }
                marshal_write_int(buf, off,
                                  asdl_seq_LEN(o->v.TryExcept.orelse));
                for (i = 0; i < asdl_seq_LEN(o->v.TryExcept.orelse); i++) {
                        void *elt = asdl_seq_GET(o->v.TryExcept.orelse, i);
                        marshal_write_stmt(buf, off, (stmt_ty)elt);
                }
                break;
        case TryFinally_kind:
                marshal_write_int(buf, off, 13);
                marshal_write_int(buf, off, asdl_seq_LEN(o->v.TryFinally.body));
                for (i = 0; i < asdl_seq_LEN(o->v.TryFinally.body); i++) {
                        void *elt = asdl_seq_GET(o->v.TryFinally.body, i);
                        marshal_write_stmt(buf, off, (stmt_ty)elt);
                }
                marshal_write_int(buf, off,
                                  asdl_seq_LEN(o->v.TryFinally.finalbody));
                for (i = 0; i < asdl_seq_LEN(o->v.TryFinally.finalbody); i++) {
                        void *elt = asdl_seq_GET(o->v.TryFinally.finalbody, i);
                        marshal_write_stmt(buf, off, (stmt_ty)elt);
                }
                break;
        case Assert_kind:
                marshal_write_int(buf, off, 14);
                marshal_write_expr(buf, off, o->v.Assert.test);
                if (o->v.Assert.msg) {
                        marshal_write_int(buf, off, 1);
                        marshal_write_expr(buf, off, o->v.Assert.msg);
                }
                else {
                        marshal_write_int(buf, off, 0);
                }
                break;
        case Import_kind:
                marshal_write_int(buf, off, 15);
                marshal_write_int(buf, off, asdl_seq_LEN(o->v.Import.names));
                for (i = 0; i < asdl_seq_LEN(o->v.Import.names); i++) {
                        void *elt = asdl_seq_GET(o->v.Import.names, i);
                        marshal_write_alias(buf, off, (alias_ty)elt);
                }
                break;
        case ImportFrom_kind:
                marshal_write_int(buf, off, 16);
                marshal_write_identifier(buf, off, o->v.ImportFrom.module);
                marshal_write_int(buf, off,
                                  asdl_seq_LEN(o->v.ImportFrom.names));
                for (i = 0; i < asdl_seq_LEN(o->v.ImportFrom.names); i++) {
                        void *elt = asdl_seq_GET(o->v.ImportFrom.names, i);
                        marshal_write_alias(buf, off, (alias_ty)elt);
                }
                break;
        case Exec_kind:
                marshal_write_int(buf, off, 17);
                marshal_write_expr(buf, off, o->v.Exec.body);
                if (o->v.Exec.globals) {
                        marshal_write_int(buf, off, 1);
                        marshal_write_expr(buf, off, o->v.Exec.globals);
                }
                else {
                        marshal_write_int(buf, off, 0);
                }
                if (o->v.Exec.locals) {
                        marshal_write_int(buf, off, 1);
                        marshal_write_expr(buf, off, o->v.Exec.locals);
                }
                else {
                        marshal_write_int(buf, off, 0);
                }
                break;
        case Global_kind:
                marshal_write_int(buf, off, 18);
                marshal_write_int(buf, off, asdl_seq_LEN(o->v.Global.names));
                for (i = 0; i < asdl_seq_LEN(o->v.Global.names); i++) {
                        void *elt = asdl_seq_GET(o->v.Global.names, i);
                        marshal_write_identifier(buf, off, (identifier)elt);
                }
                break;
        case Expr_kind:
                marshal_write_int(buf, off, 19);
                marshal_write_expr(buf, off, o->v.Expr.value);
                break;
        case Pass_kind:
                marshal_write_int(buf, off, 20);
                break;
        case Break_kind:
                marshal_write_int(buf, off, 21);
                break;
        case Continue_kind:
                marshal_write_int(buf, off, 22);
                break;
        }
        return 1;
}

static int
marshal_write_expr(PyObject **buf, int *off, expr_ty o)
{
        int i;
        switch (o->kind) {
        case BoolOp_kind:
                marshal_write_int(buf, off, 1);
                marshal_write_boolop(buf, off, o->v.BoolOp.op);
                marshal_write_int(buf, off, asdl_seq_LEN(o->v.BoolOp.values));
                for (i = 0; i < asdl_seq_LEN(o->v.BoolOp.values); i++) {
                        void *elt = asdl_seq_GET(o->v.BoolOp.values, i);
                        marshal_write_expr(buf, off, (expr_ty)elt);
                }
                break;
        case BinOp_kind:
                marshal_write_int(buf, off, 2);
                marshal_write_expr(buf, off, o->v.BinOp.left);
                marshal_write_operator(buf, off, o->v.BinOp.op);
                marshal_write_expr(buf, off, o->v.BinOp.right);
                break;
        case UnaryOp_kind:
                marshal_write_int(buf, off, 3);
                marshal_write_unaryop(buf, off, o->v.UnaryOp.op);
                marshal_write_expr(buf, off, o->v.UnaryOp.operand);
                break;
        case Lambda_kind:
                marshal_write_int(buf, off, 4);
                marshal_write_arguments(buf, off, o->v.Lambda.args);
                marshal_write_expr(buf, off, o->v.Lambda.body);
                break;
        case Dict_kind:
                marshal_write_int(buf, off, 5);
                marshal_write_int(buf, off, asdl_seq_LEN(o->v.Dict.keys));
                for (i = 0; i < asdl_seq_LEN(o->v.Dict.keys); i++) {
                        void *elt = asdl_seq_GET(o->v.Dict.keys, i);
                        marshal_write_expr(buf, off, (expr_ty)elt);
                }
                marshal_write_int(buf, off, asdl_seq_LEN(o->v.Dict.values));
                for (i = 0; i < asdl_seq_LEN(o->v.Dict.values); i++) {
                        void *elt = asdl_seq_GET(o->v.Dict.values, i);
                        marshal_write_expr(buf, off, (expr_ty)elt);
                }
                break;
        case ListComp_kind:
                marshal_write_int(buf, off, 6);
                marshal_write_expr(buf, off, o->v.ListComp.elt);
                marshal_write_int(buf, off,
                                  asdl_seq_LEN(o->v.ListComp.generators));
                for (i = 0; i < asdl_seq_LEN(o->v.ListComp.generators); i++) {
                        void *elt = asdl_seq_GET(o->v.ListComp.generators, i);
                        marshal_write_comprehension(buf, off,
                                                    (comprehension_ty)elt);
                }
                break;
        case GeneratorExp_kind:
                marshal_write_int(buf, off, 7);
                marshal_write_expr(buf, off, o->v.GeneratorExp.elt);
                marshal_write_int(buf, off,
                                  asdl_seq_LEN(o->v.GeneratorExp.generators));
                for (i = 0; i < asdl_seq_LEN(o->v.GeneratorExp.generators);
                     i++) {
                        void *elt = asdl_seq_GET(o->v.GeneratorExp.generators,
                                                 i);
                        marshal_write_comprehension(buf, off,
                                                    (comprehension_ty)elt);
                }
                break;
        case Yield_kind:
                marshal_write_int(buf, off, 8);
                if (o->v.Yield.value) {
                        marshal_write_int(buf, off, 1);
                        marshal_write_expr(buf, off, o->v.Yield.value);
                }
                else {
                        marshal_write_int(buf, off, 0);
                }
                break;
        case Compare_kind:
                marshal_write_int(buf, off, 9);
                marshal_write_expr(buf, off, o->v.Compare.left);
                marshal_write_int(buf, off, asdl_seq_LEN(o->v.Compare.ops));
                for (i = 0; i < asdl_seq_LEN(o->v.Compare.ops); i++) {
                        void *elt = asdl_seq_GET(o->v.Compare.ops, i);
                        marshal_write_cmpop(buf, off, (cmpop_ty)elt);
                }
                marshal_write_int(buf, off,
                                  asdl_seq_LEN(o->v.Compare.comparators));
                for (i = 0; i < asdl_seq_LEN(o->v.Compare.comparators); i++) {
                        void *elt = asdl_seq_GET(o->v.Compare.comparators, i);
                        marshal_write_expr(buf, off, (expr_ty)elt);
                }
                break;
        case Call_kind:
                marshal_write_int(buf, off, 10);
                marshal_write_expr(buf, off, o->v.Call.func);
                marshal_write_int(buf, off, asdl_seq_LEN(o->v.Call.args));
                for (i = 0; i < asdl_seq_LEN(o->v.Call.args); i++) {
                        void *elt = asdl_seq_GET(o->v.Call.args, i);
                        marshal_write_expr(buf, off, (expr_ty)elt);
                }
                marshal_write_int(buf, off, asdl_seq_LEN(o->v.Call.keywords));
                for (i = 0; i < asdl_seq_LEN(o->v.Call.keywords); i++) {
                        void *elt = asdl_seq_GET(o->v.Call.keywords, i);
                        marshal_write_keyword(buf, off, (keyword_ty)elt);
                }
                if (o->v.Call.starargs) {
                        marshal_write_int(buf, off, 1);
                        marshal_write_expr(buf, off, o->v.Call.starargs);
                }
                else {
                        marshal_write_int(buf, off, 0);
                }
                if (o->v.Call.kwargs) {
                        marshal_write_int(buf, off, 1);
                        marshal_write_expr(buf, off, o->v.Call.kwargs);
                }
                else {
                        marshal_write_int(buf, off, 0);
                }
                break;
        case Repr_kind:
                marshal_write_int(buf, off, 11);
                marshal_write_expr(buf, off, o->v.Repr.value);
                break;
        case Num_kind:
                marshal_write_int(buf, off, 12);
                marshal_write_object(buf, off, o->v.Num.n);
                break;
        case Str_kind:
                marshal_write_int(buf, off, 13);
                marshal_write_string(buf, off, o->v.Str.s);
                break;
        case Attribute_kind:
                marshal_write_int(buf, off, 14);
                marshal_write_expr(buf, off, o->v.Attribute.value);
                marshal_write_identifier(buf, off, o->v.Attribute.attr);
                marshal_write_expr_context(buf, off, o->v.Attribute.ctx);
                break;
        case Subscript_kind:
                marshal_write_int(buf, off, 15);
                marshal_write_expr(buf, off, o->v.Subscript.value);
                marshal_write_slice(buf, off, o->v.Subscript.slice);
                marshal_write_expr_context(buf, off, o->v.Subscript.ctx);
                break;
        case Name_kind:
                marshal_write_int(buf, off, 16);
                marshal_write_identifier(buf, off, o->v.Name.id);
                marshal_write_expr_context(buf, off, o->v.Name.ctx);
                break;
        case List_kind:
                marshal_write_int(buf, off, 17);
                marshal_write_int(buf, off, asdl_seq_LEN(o->v.List.elts));
                for (i = 0; i < asdl_seq_LEN(o->v.List.elts); i++) {
                        void *elt = asdl_seq_GET(o->v.List.elts, i);
                        marshal_write_expr(buf, off, (expr_ty)elt);
                }
                marshal_write_expr_context(buf, off, o->v.List.ctx);
                break;
        case Tuple_kind:
                marshal_write_int(buf, off, 18);
                marshal_write_int(buf, off, asdl_seq_LEN(o->v.Tuple.elts));
                for (i = 0; i < asdl_seq_LEN(o->v.Tuple.elts); i++) {
                        void *elt = asdl_seq_GET(o->v.Tuple.elts, i);
                        marshal_write_expr(buf, off, (expr_ty)elt);
                }
                marshal_write_expr_context(buf, off, o->v.Tuple.ctx);
                break;
        }
        return 1;
}

static int
marshal_write_expr_context(PyObject **buf, int *off, expr_context_ty o)
{
        switch (o) {
        case Load:
                marshal_write_int(buf, off, 1);
                break;
        case Store:
                marshal_write_int(buf, off, 2);
                break;
        case Del:
                marshal_write_int(buf, off, 3);
                break;
        case AugLoad:
                marshal_write_int(buf, off, 4);
                break;
        case AugStore:
                marshal_write_int(buf, off, 5);
                break;
        case Param:
                marshal_write_int(buf, off, 6);
                break;
        }
        return 1;
}

static int
marshal_write_slice(PyObject **buf, int *off, slice_ty o)
{
        int i;
        switch (o->kind) {
        case Ellipsis_kind:
                marshal_write_int(buf, off, 1);
                break;
        case Slice_kind:
                marshal_write_int(buf, off, 2);
                if (o->v.Slice.lower) {
                        marshal_write_int(buf, off, 1);
                        marshal_write_expr(buf, off, o->v.Slice.lower);
                }
                else {
                        marshal_write_int(buf, off, 0);
                }
                if (o->v.Slice.upper) {
                        marshal_write_int(buf, off, 1);
                        marshal_write_expr(buf, off, o->v.Slice.upper);
                }
                else {
                        marshal_write_int(buf, off, 0);
                }
                if (o->v.Slice.step) {
                        marshal_write_int(buf, off, 1);
                        marshal_write_expr(buf, off, o->v.Slice.step);
                }
                else {
                        marshal_write_int(buf, off, 0);
                }
                break;
        case ExtSlice_kind:
                marshal_write_int(buf, off, 3);
                marshal_write_int(buf, off, asdl_seq_LEN(o->v.ExtSlice.dims));
                for (i = 0; i < asdl_seq_LEN(o->v.ExtSlice.dims); i++) {
                        void *elt = asdl_seq_GET(o->v.ExtSlice.dims, i);
                        marshal_write_slice(buf, off, (slice_ty)elt);
                }
                break;
        case Index_kind:
                marshal_write_int(buf, off, 4);
                marshal_write_expr(buf, off, o->v.Index.value);
                break;
        }
        return 1;
}

static int
marshal_write_boolop(PyObject **buf, int *off, boolop_ty o)
{
        switch (o) {
        case And:
                marshal_write_int(buf, off, 1);
                break;
        case Or:
                marshal_write_int(buf, off, 2);
                break;
        }
        return 1;
}

static int
marshal_write_operator(PyObject **buf, int *off, operator_ty o)
{
        switch (o) {
        case Add:
                marshal_write_int(buf, off, 1);
                break;
        case Sub:
                marshal_write_int(buf, off, 2);
                break;
        case Mult:
                marshal_write_int(buf, off, 3);
                break;
        case Div:
                marshal_write_int(buf, off, 4);
                break;
        case Mod:
                marshal_write_int(buf, off, 5);
                break;
        case Pow:
                marshal_write_int(buf, off, 6);
                break;
        case LShift:
                marshal_write_int(buf, off, 7);
                break;
        case RShift:
                marshal_write_int(buf, off, 8);
                break;
        case BitOr:
                marshal_write_int(buf, off, 9);
                break;
        case BitXor:
                marshal_write_int(buf, off, 10);
                break;
        case BitAnd:
                marshal_write_int(buf, off, 11);
                break;
        case FloorDiv:
                marshal_write_int(buf, off, 12);
                break;
        }
        return 1;
}

static int
marshal_write_unaryop(PyObject **buf, int *off, unaryop_ty o)
{
        switch (o) {
        case Invert:
                marshal_write_int(buf, off, 1);
                break;
        case Not:
                marshal_write_int(buf, off, 2);
                break;
        case UAdd:
                marshal_write_int(buf, off, 3);
                break;
        case USub:
                marshal_write_int(buf, off, 4);
                break;
        }
        return 1;
}

static int
marshal_write_cmpop(PyObject **buf, int *off, cmpop_ty o)
{
        switch (o) {
        case Eq:
                marshal_write_int(buf, off, 1);
                break;
        case NotEq:
                marshal_write_int(buf, off, 2);
                break;
        case Lt:
                marshal_write_int(buf, off, 3);
                break;
        case LtE:
                marshal_write_int(buf, off, 4);
                break;
        case Gt:
                marshal_write_int(buf, off, 5);
                break;
        case GtE:
                marshal_write_int(buf, off, 6);
                break;
        case Is:
                marshal_write_int(buf, off, 7);
                break;
        case IsNot:
                marshal_write_int(buf, off, 8);
                break;
        case In:
                marshal_write_int(buf, off, 9);
                break;
        case NotIn:
                marshal_write_int(buf, off, 10);
                break;
        }
        return 1;
}

static int
marshal_write_comprehension(PyObject **buf, int *off, comprehension_ty o)
{
        int i;
        marshal_write_expr(buf, off, o->target);
        marshal_write_expr(buf, off, o->iter);
        marshal_write_int(buf, off, asdl_seq_LEN(o->ifs));
        for (i = 0; i < asdl_seq_LEN(o->ifs); i++) {
                void *elt = asdl_seq_GET(o->ifs, i);
                marshal_write_expr(buf, off, (expr_ty)elt);
        }
        return 1;
}

static int
marshal_write_excepthandler(PyObject **buf, int *off, excepthandler_ty o)
{
        int i;
        if (o->type) {
                marshal_write_int(buf, off, 1);
                marshal_write_expr(buf, off, o->type);
        }
        else {
                marshal_write_int(buf, off, 0);
        }
        if (o->name) {
                marshal_write_int(buf, off, 1);
                marshal_write_expr(buf, off, o->name);
        }
        else {
                marshal_write_int(buf, off, 0);
        }
        marshal_write_int(buf, off, asdl_seq_LEN(o->body));
        for (i = 0; i < asdl_seq_LEN(o->body); i++) {
                void *elt = asdl_seq_GET(o->body, i);
                marshal_write_stmt(buf, off, (stmt_ty)elt);
        }
        return 1;
}

static int
marshal_write_arguments(PyObject **buf, int *off, arguments_ty o)
{
        int i;
        marshal_write_int(buf, off, asdl_seq_LEN(o->args));
        for (i = 0; i < asdl_seq_LEN(o->args); i++) {
                void *elt = asdl_seq_GET(o->args, i);
                marshal_write_expr(buf, off, (expr_ty)elt);
        }
        if (o->vararg) {
                marshal_write_int(buf, off, 1);
                marshal_write_identifier(buf, off, o->vararg);
        }
        else {
                marshal_write_int(buf, off, 0);
        }
        if (o->kwarg) {
                marshal_write_int(buf, off, 1);
                marshal_write_identifier(buf, off, o->kwarg);
        }
        else {
                marshal_write_int(buf, off, 0);
        }
        marshal_write_int(buf, off, asdl_seq_LEN(o->defaults));
        for (i = 0; i < asdl_seq_LEN(o->defaults); i++) {
                void *elt = asdl_seq_GET(o->defaults, i);
                marshal_write_expr(buf, off, (expr_ty)elt);
        }
        return 1;
}

static int
marshal_write_keyword(PyObject **buf, int *off, keyword_ty o)
{
        marshal_write_identifier(buf, off, o->arg);
        marshal_write_expr(buf, off, o->value);
        return 1;
}

static int
marshal_write_alias(PyObject **buf, int *off, alias_ty o)
{
        marshal_write_identifier(buf, off, o->name);
        if (o->asname) {
                marshal_write_int(buf, off, 1);
                marshal_write_identifier(buf, off, o->asname);
        }
        else {
                marshal_write_int(buf, off, 0);
        }
        return 1;
}


