/***********************************************************
Copyright 1991-1997 by Stichting Mathematisch Centrum, Amsterdam,
The Netherlands.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the names of Stichting Mathematisch
Centrum or CWI or Corporation for National Research Initiatives or
CNRI not be used in advertising or publicity pertaining to
distribution of the software without specific, written prior
permission.

While CWI is the initial source for this software, a modified version
is made available by the Corporation for National Research Initiatives
(CNRI) at the Internet address ftp://ftp.python.org.

STICHTING MATHEMATISCH CENTRUM AND CNRI DISCLAIM ALL WARRANTIES WITH
REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL STICHTING MATHEMATISCH
CENTRUM OR CNRI BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL
DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.

******************************************************************/

#include <Types.h>
#include <Files.h>
#include <OSUtils.h>
#include <Resources.h>

#include <string.h>

/* Interface used by parsetok.c */

guesstabsize(path)
	char *path;
{
	Str255 s;
	int refnum;
	Handle h;
	int tabsize = 0;
	
	/* Very simple case: stdin (pathname empty) */
	if ( path[0] == '\0' || strcmp(path, "<stdin>") == 0 ) return 0;
	s[0] = strlen(path);
	memcpy(s+1, path, s[0]);
	refnum = OpenResFile(s);
	if (refnum == -1)
		return 0;
	UseResFile(refnum);
	h = GetIndResource('ETAB', 1);
	if (h != 0) {
		tabsize = (*(short**)h)[1];
	}
	CloseResFile(refnum);
	return tabsize;
}
