# This script generates a Python interface for an Apple Macintosh Manager.
# It uses the "bgen" package to generate C code.
# The function specifications are generated by scanning the mamager's header file,
# using the "scantools" package (customized for this particular manager).

import string

# Declarations that change for each manager
MACHEADERFILE = 'Aliases.h'		# The Apple header file
MODNAME = '_Alias'				# The name of the module

# The following is *usually* unchanged but may still require tuning
MODPREFIX = 'Alias'			# The prefix for module-wide routines
INPUTFILE = string.lower(MODPREFIX) + 'gen.py' # The file generated by the scanner
OUTPUTFILE = MODNAME + "module.c"	# The file generated by this program

from macsupport import *


# Create the type objects
		
class VarReverseInputBufferType(ReverseInputBufferMixin, VarInputBufferType):
	pass
	
FullPathName = VarReverseInputBufferType()

AliasHandle = OpaqueByValueType("AliasHandle", "AliasObj")
AliasInfoType = Type("AliasInfoType", "h")
ConstStr31Param = OpaqueArrayType("Str31", "PyMac_BuildStr255", "PyMac_GetStr255")
ConstStr32Param = OpaqueArrayType("Str32", "PyMac_BuildStr255", "PyMac_GetStr255")
#FSSpecArrayPtr
#Ptr
Str63 = OpaqueArrayType("Str63", "PyMac_BuildStr255", "PyMac_GetStr255")
#void_ptr
# class UniCharCountBuffer(InputOnlyType):
# 	pass
# 
# #CatPositionRec
# ConstStr63Param = OpaqueArrayType("Str63", "PyMac_BuildStr255", "PyMac_GetStr255")
# FInfo = OpaqueByValueStructType("FInfo", "PyMac_BuildFInfo", "PyMac_GetFInfo")
# FInfo_ptr = OpaqueType("FInfo", "PyMac_BuildFInfo", "PyMac_GetFInfo")
# FNMessage = Type("FNMessage", "l")
# FSAllocationFlags = Type("FSAllocationFlags", "H")
# #FSCatalogInfo
# FSCatalogInfoBitmap = Type("FSCatalogInfoBitmap", "l")
# #FSForkInfo
# #FSIterator
# FSIteratorFlags = Type("FSIteratorFlags", "l")
# #FSVolumeInfo
# FSVolumeRefNum = Type("FSVolumeRefNum", "h")
# HFSUniStr255 = OpaqueType("HFSUniStr255", "PyMac_BuildHFSUniStr255", "PyMac_GetHFSUniStr255")
# SInt64 = Type("SInt64", "L")
# UInt64 = Type("UInt64", "L")
# #UInt8_ptr
# #UniCharCount
# #char_ptr
# #void_ptr


includestuff = includestuff + """
#ifdef WITHOUT_FRAMEWORKS
#include <Files.h>
#else
#include <Carbon/Carbon.h>
#endif
"""

execfile(string.lower(MODPREFIX) + 'typetest.py')

# From here on it's basically all boiler plate...

# Create the generator groups and link them
module = MacModule(MODNAME, MODPREFIX, includestuff, finalstuff, initstuff)

class AliasDefinition(PEP253Mixin, GlobalObjectDefinition):
	# XXXX Should inherit from resource?

	def outputCheckNewArg(self):
		Output("if (itself == NULL) return PyMac_Error(resNotFound);")
		
	def outputStructMembers(self):
		GlobalObjectDefinition.outputStructMembers(self)
		Output("void (*ob_freeit)(%s ptr);", self.itselftype)
		
	def outputInitStructMembers(self):
		GlobalObjectDefinition.outputInitStructMembers(self)
		Output("it->ob_freeit = NULL;")
		
	def outputCleanupStructMembers(self):
		Output("if (self->ob_freeit && self->ob_itself)")
		OutLbrace()
		Output("self->ob_freeit(self->ob_itself);")
		OutRbrace()
		Output("self->ob_itself = NULL;")


aliasobject = AliasDefinition('Alias', 'AliasObj', 'AliasHandle')
module.addobject(aliasobject)
# Create the generator classes used to populate the lists
Function = OSErrFunctionGenerator
Method = OSErrMethodGenerator

# Create and populate the lists
functions = []
methods = []
execfile(INPUTFILE)

# Manual generators:

# add the populated lists to the generator groups
# (in a different wordl the scan program would generate this)
for f in methods: aliasobject.add(f)
for f in functions: module.add(f)

# generate output (open the output file as late as possible)
SetOutputFileName(OUTPUTFILE)
module.generate()

