/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.asp;

import com.intellij.extapi.psi.ASTWrapperPsiElement;
import com.intellij.extapi.psi.PsiFileBase;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiParser;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.asp.AspElementTypes;
import com.jetbrains.asp.AspFileType;
import com.jetbrains.asp.AspLanguage;
import com.jetbrains.asp.AspLexer;
import org.jetbrains.annotations.NotNull;

public class AspParserDefinition
implements ParserDefinition {
    private final TokenSet ourWhitespaceSet = TokenSet.EMPTY;
    private TokenSet ourStringLiteralsSet = TokenSet.EMPTY;
    private TokenSet ourCommentsSet = TokenSet.EMPTY;

    @NotNull
    public Lexer createLexer(Project project) {
        AspLexer aspLexer = new AspLexer();
        if (aspLexer == null) {
            throw new IllegalStateException("@NotNull method com/jetbrains/asp/AspParserDefinition.createLexer must not return null");
        }
        return aspLexer;
    }

    public PsiParser createParser(Project project) {
        return new PsiParser(){

            @NotNull
            public ASTNode parse(IElementType root, PsiBuilder builder) {
                PsiBuilder.Marker marker = builder.mark();
                while (!builder.eof()) {
                    builder.advanceLexer();
                }
                marker.done(AspElementTypes.ASP_FILE_CONTENT);
                ASTNode aSTNode = builder.getTreeBuilt();
                if (aSTNode == null) {
                    throw new IllegalStateException("@NotNull method com/jetbrains/asp/AspParserDefinition$1.parse must not return null");
                }
                return aSTNode;
            }
        };
    }

    public IFileElementType getFileNodeType() {
        return AspElementTypes.ASP_FILE;
    }

    @NotNull
    public TokenSet getWhitespaceTokens() {
        TokenSet tokenSet = this.ourWhitespaceSet;
        if (tokenSet == null) {
            throw new IllegalStateException("@NotNull method com/jetbrains/asp/AspParserDefinition.getWhitespaceTokens must not return null");
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        TokenSet tokenSet = this.ourCommentsSet;
        if (tokenSet == null) {
            throw new IllegalStateException("@NotNull method com/jetbrains/asp/AspParserDefinition.getCommentTokens must not return null");
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        TokenSet tokenSet = this.ourStringLiteralsSet;
        if (tokenSet == null) {
            throw new IllegalStateException("@NotNull method com/jetbrains/asp/AspParserDefinition.getStringLiteralElements must not return null");
        }
        return tokenSet;
    }

    @NotNull
    public PsiElement createElement(ASTNode node) {
        ASTWrapperPsiElement aSTWrapperPsiElement = new ASTWrapperPsiElement(node);
        if (aSTWrapperPsiElement == null) {
            throw new IllegalStateException("@NotNull method com/jetbrains/asp/AspParserDefinition.createElement must not return null");
        }
        return aSTWrapperPsiElement;
    }

    public PsiFile createFile(FileViewProvider viewProvider) {
        return new PsiFileBase(viewProvider, AspLanguage.INSTANCE){

            @NotNull
            public FileType getFileType() {
                AspFileType aspFileType = AspFileType.INSTANCE;
                if (aspFileType == null) {
                    throw new IllegalStateException("@NotNull method com/jetbrains/asp/AspParserDefinition$2.getFileType must not return null");
                }
                return aspFileType;
            }
        };
    }

    public ParserDefinition.SpaceRequirements spaceExistanceTypeBetweenTokens(ASTNode left, ASTNode right) {
        return ParserDefinition.SpaceRequirements.MAY;
    }
}

