/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.zkm;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.unscramble.UnscrambleSupport;
import com.intellij.zkm.ZKMBundle;
import com.intellij.zkm.ZKMLog;
import java.io.IOException;
import java.util.StringTokenizer;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public class ZKMUnscrambleSupport
implements UnscrambleSupport {
    public String getPresentableName() {
        return ZKMBundle.message("zkm.scrambler.persentable.name", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String unscramble(Project project, String text, String logName) {
        ZKMLog log = null;
        try {
            log = ZKMLog.getLog(logName);
            log.setProject(project);
            String string = log.unscrambleStackTrace(ZKMUnscrambleSupport.mergeLines(text));
            return string;
        }
        catch (IOException e) {
            Messages.showMessageDialog((Project)project, (String)(e.getMessage() + "\n" + e.toString()), (String)ZKMBundle.message("zkm.error.reading.log.file", new Object[0]), (Icon)Messages.getErrorIcon());
        }
        finally {
            if (log != null) {
                log.setProject(null);
            }
        }
        return null;
    }

    private static String mergeLines(String text) {
        text = StringUtil.replace((String)text, (String)"\r\n", (String)"\n");
        text = StringUtil.replace((String)text, (String)"\r", (String)"\n");
        StringBuilder result = new StringBuilder();
        StringTokenizer tokenizer = new StringTokenizer(text, "\n");
        StringBuilder tempBuffer = new StringBuilder();
        while (tokenizer.hasMoreElements()) {
            String s = (String)tokenizer.nextElement();
            if (s.endsWith(" at") || s.endsWith("\tat ")) {
                s = s + ' ';
            }
            s = s + "\n";
            if (tempBuffer.length() == 0 && !ZKMUnscrambleSupport.isStartOfStackLine(s)) {
                result.append(s);
                continue;
            }
            tempBuffer.append(s);
            if (s.indexOf(41) == -1) continue;
            String line = tempBuffer.toString();
            tempBuffer.setLength(0);
            line = ZKMUnscrambleSupport.removeLineBreaks(line);
            result.append(line);
            result.append("\n");
        }
        return result.toString();
    }

    private static String removeLineBreaks(String lines) {
        StringBuilder buffer = new StringBuilder();
        StringTokenizer tokenizer = new StringTokenizer(lines, "\n");
        while (tokenizer.hasMoreElements()) {
            String s = (String)tokenizer.nextElement();
            if (buffer.length() > 0 && StringUtil.startsWithChar((CharSequence)s, (char)'>')) {
                if (s.startsWith("> ")) {
                    if (!StringUtil.startsWithConcatenationOf((String)s, (String)"> ", (String)"at ")) {
                        s = s.substring(2);
                    }
                } else {
                    s = s.substring(1);
                }
            }
            buffer.append(s);
        }
        return buffer.toString();
    }

    private static boolean isStartOfStackLine(String s) {
        return s.contains(" at") || s.contains("\tat ") || s.startsWith("at ");
    }
}

