# encoding: utf-8
# module ConfigParser
# from /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/ConfigParser.pyo by generator 1.99
"""
Configuration file parser.

A setup file consists of sections, lead by a "[section]" header,
and followed by "name: value" entries, with continuations and such in
the style of RFC 822.

The option values can contain format strings which refer to other values in
the same section, or values in a special [DEFAULT] section.

For example:

    something: %(dir)s/whatever

would resolve the "%(dir)s" to the value of dir.  All reference
expansions are done late, on demand.

Intrinsic defaults can be specified by passing them into the
ConfigParser constructor as a dictionary.

class:

ConfigParser -- responsible for parsing a list of
                configuration files, and managing the parsed database.

    methods:

    __init__(defaults=None)
        create the parser and specify a dictionary of intrinsic defaults.  The
        keys must be strings, the values must be appropriate for %()s string
        interpolation.  Note that `__name__' is always an intrinsic default;
        its value is the section's name.

    sections()
        return all the configuration section names, sans DEFAULT

    has_section(section)
        return whether the given section exists

    has_option(section, option)
        return whether the given option exists in the given section

    options(section)
        return list of configuration options for the named section

    read(filenames)
        read and parse the list of named configuration files, given by
        name.  A single filename is also allowed.  Non-existing files
        are ignored.  Return list of successfully read files.

    readfp(fp, filename=None)
        read and parse one configuration file, given as a file object.
        The filename defaults to fp.name; it is only used in error
        messages (if fp has no `name' attribute, the string `<???>' is used).

    get(section, option, raw=False, vars=None)
        return a string value for the named option.  All % interpolations are
        expanded in the return values, based on the defaults passed into the
        constructor and the DEFAULT section.  Additional substitutions may be
        provided using the `vars' argument, which must be a dictionary whose
        contents override any pre-existing defaults.

    getint(section, options)
        like get(), but convert value to an integer

    getfloat(section, options)
        like get(), but convert value to a float

    getboolean(section, options)
        like get(), but convert value to a boolean (currently case
        insensitively defined as 0, false, no, off for False, and 1, true,
        yes, on for True).  Returns False or True.

    items(section, raw=False, vars=None)
        return a list of tuples with (name, value) for each option
        in the section.

    remove_section(section)
        remove the given file section and all its options

    remove_option(section, option)
        remove the given option from the given section

    set(section, option, value)
        set the given option

    write(fp)
        write the configuration state in .ini format
"""

# imports
import re as re # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/re.pyc
import _abcoll as ___abcoll


# Variables with simple values

DEFAULTSECT = 'DEFAULT'

MAX_INTERPOLATION_DEPTH = 10

# no functions
# classes

class Error(Exception):
    """ Base class for ConfigParser exceptions. """
    def _get_message(self, *args, **kwargs): # real signature unknown
        """
        Getter for 'message'; needed only to override deprecation in
                BaseException.
        """
        pass

    def _set_message(self, *args, **kwargs): # real signature unknown
        """
        Setter for 'message'; needed only to override deprecation in
                BaseException.
        """
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    def __repr__(self, *args, **kwargs): # real signature unknown
        pass

    def __str__(self, *args, **kwargs): # real signature unknown
        pass

    message = property(lambda self: object()) # default
    __weakref__ = property(lambda self: object()) # default


class DuplicateSectionError(Error):
    """ Raised when a section is multiply-created. """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class InterpolationError(Error):
    """ Base class for interpolation-related exceptions. """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class InterpolationDepthError(InterpolationError):
    """ Raised when substitutions are nested too deeply. """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class InterpolationMissingOptionError(InterpolationError):
    """ A string substitution required a setting which was not available. """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class InterpolationSyntaxError(InterpolationError):
    """
    Raised when the source text into which substitutions are made
        does not conform to the required syntax.
    """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class ParsingError(Error):
    """ Raised when a configuration file does not follow legal syntax. """
    def append(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class MissingSectionHeaderError(ParsingError):
    """ Raised when a key-value pair is found before any section header. """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class NoOptionError(Error):
    """ A requested option was not found. """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class NoSectionError(Error):
    """ Raised when no section matches a requested option. """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class _default_dict(dict, ___abcoll.MutableMapping):
    """ Dictionary that remembers insertion order """
    def clear(self): # real signature unknown; restored from __doc__
        """ od.clear() -> None.  Remove all items from od. """
        pass

    def copy(self): # real signature unknown; restored from __doc__
        """ od.copy() -> a shallow copy of od """
        pass

    @classmethod
    def fromkeys(cls, S, v=None): # real signature unknown; restored from __doc__
        """
        OD.fromkeys(S[, v]) -> New ordered dictionary with keys from S
                and values equal to v (which defaults to None).
        """
        pass

    def items(self, *args, **kwargs): # real signature unknown
        pass

    def iteritems(self, *args, **kwargs): # real signature unknown
        pass

    def iterkeys(self, *args, **kwargs): # real signature unknown
        pass

    def itervalues(self, *args, **kwargs): # real signature unknown
        pass

    def keys(self, *args, **kwargs): # real signature unknown
        pass

    def pop(self, *args, **kwargs): # real signature unknown
        pass

    def popitem(self): # real signature unknown; restored from __doc__
        """
        od.popitem() -> (k, v), return and remove a (key, value) pair.
                Pairs are returned in LIFO order if last is true or FIFO order if false.
        """
        pass

    def setdefault(self, *args, **kwargs): # real signature unknown
        pass

    def update(self, *args, **kwargs): # real signature unknown
        pass

    def values(self, *args, **kwargs): # real signature unknown
        pass

    def viewitems(self): # real signature unknown; restored from __doc__
        """ od.viewitems() -> a set-like object providing a view on od's items """
        pass

    def viewkeys(self): # real signature unknown; restored from __doc__
        """ od.viewkeys() -> a set-like object providing a view on od's keys """
        pass

    def viewvalues(self): # real signature unknown; restored from __doc__
        """ od.viewvalues() -> an object providing a view on od's values """
        pass

    def __delitem__(self, y): # real signature unknown; restored from __doc__
        """ od.__delitem__(y) <==> del od[y] """
        pass

    def __eq__(self, y): # real signature unknown; restored from __doc__
        """
        od.__eq__(y) <==> od==y.  Comparison to another OD is order-sensitive
                while comparison to a regular mapping is order-insensitive.
        """
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        """
        Initialize an ordered dictionary.  Signature is the same as for
                regular dictionaries, but keyword arguments are not recommended
                because their insertion order is arbitrary.
        """
        pass

    def __iter__(self): # real signature unknown; restored from __doc__
        """ od.__iter__() <==> iter(od) """
        pass

    def __ne__(self, *args, **kwargs): # real signature unknown
        pass

    def __reduce__(self, *args, **kwargs): # real signature unknown
        """ Return state information for pickling """
        pass

    def __repr__(self): # real signature unknown; restored from __doc__
        """ od.__repr__() <==> repr(od) """
        pass

    def __reversed__(self): # real signature unknown; restored from __doc__
        """ od.__reversed__() <==> reversed(od) """
        pass

    def __setitem__(self, i, y): # real signature unknown; restored from __doc__
        """ od.__setitem__(i, y) <==> od[i]=y """
        pass

    __weakref__ = property(lambda self: object()) # default

    _abc_cache = None # (!) real value is ''
    _abc_negative_cache = None # (!) real value is ''
    _abc_negative_cache_version = 10
    _abc_registry = None # (!) real value is ''
    __abstractmethods__ = None # (!) real value is ''
    __dict__ = None # (!) real value is ''


# variables with complex values

ConfigParser = None # (!) real value is ''

RawConfigParser = None # (!) real value is ''

SafeConfigParser = None # (!) real value is ''

__all__ = [
    'NoSectionError',
    'DuplicateSectionError',
    'NoOptionError',
    'InterpolationError',
    'InterpolationDepthError',
    'InterpolationSyntaxError',
    'ParsingError',
    'MissingSectionHeaderError',
    'ConfigParser',
    'SafeConfigParser',
    'RawConfigParser',
    'DEFAULTSECT',
    'MAX_INTERPOLATION_DEPTH',
]

