# encoding: utf-8
# module argparse
# from /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/argparse.pyo by generator 1.99
"""
Command-line parsing library

This module is an optparse-inspired command-line parsing library that:

    - handles both optional and positional arguments
    - produces highly informative usage messages
    - supports parsers that dispatch to sub-parsers

The following is a simple usage example that sums integers from the
command-line and writes the result to a file::

    parser = argparse.ArgumentParser(
        description='sum the integers at the command line')
    parser.add_argument(
        'integers', metavar='int', nargs='+', type=int,
        help='an integer to be summed')
    parser.add_argument(
        '--log', default=sys.stdout, type=argparse.FileType('w'),
        help='the file where the sum should be written')
    args = parser.parse_args()
    args.log.write('%s' % sum(args.integers))
    args.log.close()

The module contains the following public classes:

    - ArgumentParser -- The main entry point for command-line parsing. As the
        example above shows, the add_argument() method is used to populate
        the parser with actions for optional and positional arguments. Then
        the parse_args() method is invoked to convert the args at the
        command-line into an object with attributes.

    - ArgumentError -- The exception raised by ArgumentParser objects when
        there are errors with the parser's actions. Errors raised while
        parsing the command-line are caught by ArgumentParser and emitted
        as command-line messages.

    - FileType -- A factory for defining types of files to be created. As the
        example above shows, instances of FileType are typically passed as
        the type= argument of add_argument() calls.

    - Action -- The base class for parser actions. Typically actions are
        selected by passing strings like 'store_true' or 'append_const' to
        the action= argument of add_argument(). However, for greater
        customization of ArgumentParser actions, subclasses of Action may
        be defined and passed as the action= argument.

    - HelpFormatter, RawDescriptionHelpFormatter, RawTextHelpFormatter,
        ArgumentDefaultsHelpFormatter -- Formatter classes which
        may be passed as the formatter_class= argument to the
        ArgumentParser constructor. HelpFormatter is the default,
        RawDescriptionHelpFormatter and RawTextHelpFormatter tell the parser
        not to change the formatting for help text, and
        ArgumentDefaultsHelpFormatter adds information about argument defaults
        to the help.

All other classes in this module are considered implementation details.
(Also note that HelpFormatter and RawDescriptionHelpFormatter are only
considered public as object names -- the API of the formatter objects is
still considered an implementation detail.)
"""

# imports
import re as _re # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/re.pyc
import copy as _copy # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/copy.pyc
import os as _os # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/os.pyc
import sys as _sys # <module 'sys' (built-in)>
import textwrap as _textwrap # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/textwrap.pyc

# Variables with simple values

ONE_OR_MORE = '+'

OPTIONAL = '?'

PARSER = 'A...'

REMAINDER = '...'

SUPPRESS = '==SUPPRESS=='

ZERO_OR_MORE = '*'

_UNRECOGNIZED_ARGS_ATTR = '_unrecognized_args'

__version__ = '1.1'

# functions

def _(message): # reliably restored by inspect
    # no doc
    pass


def _callable(obj): # reliably restored by inspect
    # no doc
    pass


def _ensure_value(namespace, name, value): # reliably restored by inspect
    # no doc
    pass


def _get_action_name(argument): # reliably restored by inspect
    # no doc
    pass


# classes

class _AttributeHolder(object):
    """
    Abstract base class that provides __repr__.
    
        The __repr__ method returns a string in the format::
            ClassName(attr=name, attr=name, ...)
        The attributes are determined either by a class-level attribute,
        '_kwarg_names', or by inspecting the instance __dict__.
    """
    def _get_args(self, *args, **kwargs): # real signature unknown
        pass

    def _get_kwargs(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    def __repr__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default

    __dict__ = None # (!) real value is ''


class Action(_AttributeHolder):
    """
    Information about how to convert command line strings to Python objects.
    
        Action objects are used by an ArgumentParser to represent the information
        needed to parse a single argument from one or more strings from the
        command line. The keyword arguments to the Action constructor are also
        all attributes of Action instances.
    
        Keyword Arguments:
    
            - option_strings -- A list of command-line option strings which
                should be associated with this action.
    
            - dest -- The name of the attribute to hold the created object(s)
    
            - nargs -- The number of command-line arguments that should be
                consumed. By default, one argument will be consumed and a single
                value will be produced.  Other values include:
                    - N (an integer) consumes N arguments (and produces a list)
                    - '?' consumes zero or one arguments
                    - '*' consumes zero or more arguments (and produces a list)
                    - '+' consumes one or more arguments (and produces a list)
                Note that the difference between the default and nargs=1 is that
                with the default, a single value will be produced, while with
                nargs=1, a list containing a single value will be produced.
    
            - const -- The value to be produced if the option is specified and the
                option uses an action that takes no values.
    
            - default -- The value to be produced if the option is not specified.
    
            - type -- The type which the command-line arguments should be converted
                to, should be one of 'string', 'int', 'float', 'complex' or a
                callable object that accepts a single string argument. If None,
                'string' is assumed.
    
            - choices -- A container of values that should be allowed. If not None,
                after a command-line argument has been converted to the appropriate
                type, an exception will be raised if it is not a member of this
                collection.
    
            - required -- True if the action must always be specified at the
                command line. This is only meaningful for optional command-line
                arguments.
    
            - help -- The help string describing the argument.
    
            - metavar -- The name to be used for the option's argument with the
                help string. If None, the 'dest' value will be used as the name.
    """
    def _get_kwargs(self, *args, **kwargs): # real signature unknown
        pass

    def __call__(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class HelpFormatter(object):
    """
    Formatter for generating usage messages and argument help strings.
    
        Only the name of this class is considered a public API. All the methods
        provided by the class are considered an implementation detail.
    """
    def add_argument(self, *args, **kwargs): # real signature unknown
        pass

    def add_arguments(self, *args, **kwargs): # real signature unknown
        pass

    def add_text(self, *args, **kwargs): # real signature unknown
        pass

    def add_usage(self, *args, **kwargs): # real signature unknown
        pass

    def end_section(self, *args, **kwargs): # real signature unknown
        pass

    def format_help(self, *args, **kwargs): # real signature unknown
        pass

    def start_section(self, *args, **kwargs): # real signature unknown
        pass

    def _add_item(self, *args, **kwargs): # real signature unknown
        pass

    def _dedent(self, *args, **kwargs): # real signature unknown
        pass

    def _expand_help(self, *args, **kwargs): # real signature unknown
        pass

    def _fill_text(self, *args, **kwargs): # real signature unknown
        pass

    def _format_action(self, *args, **kwargs): # real signature unknown
        pass

    def _format_actions_usage(self, *args, **kwargs): # real signature unknown
        pass

    def _format_action_invocation(self, *args, **kwargs): # real signature unknown
        pass

    def _format_args(self, *args, **kwargs): # real signature unknown
        pass

    def _format_text(self, *args, **kwargs): # real signature unknown
        pass

    def _format_usage(self, *args, **kwargs): # real signature unknown
        pass

    def _get_help_string(self, *args, **kwargs): # real signature unknown
        pass

    def _indent(self, *args, **kwargs): # real signature unknown
        pass

    def _iter_indented_subactions(self, *args, **kwargs): # real signature unknown
        pass

    def _join_parts(self, *args, **kwargs): # real signature unknown
        pass

    def _metavar_formatter(self, *args, **kwargs): # real signature unknown
        pass

    def _Section(self, *args, **kwargs): # real signature unknown
        pass

    def _split_lines(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default

    __dict__ = None # (!) real value is ''


class ArgumentDefaultsHelpFormatter(HelpFormatter):
    """
    Help message formatter which adds default values to argument help.
    
        Only the name of this class is considered a public API. All the methods
        provided by the class are considered an implementation detail.
    """
    def _get_help_string(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class ArgumentError(Exception):
    """
    An error from creating or using an argument (optional or positional).
    
        The string value of this exception is the message, augmented with
        information about the argument that caused it.
    """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    def __str__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default


class _ActionsContainer(object):
    # no doc
    def add_argument(self, dest, *more, **kwargs): # real signature unknown; NOTE: unreliably restored from __doc__ 
        """
        add_argument(dest, ..., name=value, ...)
                add_argument(option_string, option_string, ..., name=value, ...)
        """
        pass

    def add_argument_group(self, *args, **kwargs): # real signature unknown
        pass

    def add_mutually_exclusive_group(self, *args, **kwargs): # real signature unknown
        pass

    def get_default(self, *args, **kwargs): # real signature unknown
        pass

    def register(self, *args, **kwargs): # real signature unknown
        pass

    def set_defaults(self, *args, **kwargs): # real signature unknown
        pass

    def _add_action(self, *args, **kwargs): # real signature unknown
        pass

    def _add_container_actions(self, *args, **kwargs): # real signature unknown
        pass

    def _check_conflict(self, *args, **kwargs): # real signature unknown
        pass

    def _get_handler(self, *args, **kwargs): # real signature unknown
        pass

    def _get_optional_kwargs(self, *args, **kwargs): # real signature unknown
        pass

    def _get_positional_kwargs(self, *args, **kwargs): # real signature unknown
        pass

    def _handle_conflict_error(self, *args, **kwargs): # real signature unknown
        pass

    def _handle_conflict_resolve(self, *args, **kwargs): # real signature unknown
        pass

    def _pop_action_class(self, *args, **kwargs): # real signature unknown
        pass

    def _registry_get(self, *args, **kwargs): # real signature unknown
        pass

    def _remove_action(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default

    __dict__ = None # (!) real value is ''


class ArgumentParser(_AttributeHolder, _ActionsContainer):
    """
    Object for parsing command line strings into Python objects.
    
        Keyword Arguments:
            - prog -- The name of the program (default: sys.argv[0])
            - usage -- A usage message (default: auto-generated from arguments)
            - description -- A description of what the program does
            - epilog -- Text following the argument descriptions
            - parents -- Parsers whose arguments should be copied into this one
            - formatter_class -- HelpFormatter class for printing help messages
            - prefix_chars -- Characters that prefix optional arguments
            - fromfile_prefix_chars -- Characters that prefix files containing
                additional arguments
            - argument_default -- The default value for all arguments
            - conflict_handler -- String indicating how to handle conflicts
            - add_help -- Add a -h/-help option
    """
    def add_subparsers(self, *args, **kwargs): # real signature unknown
        pass

    def convert_arg_line_to_args(self, *args, **kwargs): # real signature unknown
        pass

    def error(self, message): # real signature unknown; restored from __doc__
        """
        error(message: string)
        
                Prints a usage message incorporating the message to stderr and
                exits.
        
                If you override this in a subclass, it should not return -- it
                should either exit or raise an exception.
        """
        pass

    def exit(self, *args, **kwargs): # real signature unknown
        pass

    def format_help(self, *args, **kwargs): # real signature unknown
        pass

    def format_usage(self, *args, **kwargs): # real signature unknown
        pass

    def format_version(self, *args, **kwargs): # real signature unknown
        pass

    def parse_args(self, *args, **kwargs): # real signature unknown
        pass

    def parse_known_args(self, *args, **kwargs): # real signature unknown
        pass

    def print_help(self, *args, **kwargs): # real signature unknown
        pass

    def print_usage(self, *args, **kwargs): # real signature unknown
        pass

    def print_version(self, *args, **kwargs): # real signature unknown
        pass

    def _add_action(self, *args, **kwargs): # real signature unknown
        pass

    def _check_value(self, *args, **kwargs): # real signature unknown
        pass

    def _get_formatter(self, *args, **kwargs): # real signature unknown
        pass

    def _get_kwargs(self, *args, **kwargs): # real signature unknown
        pass

    def _get_nargs_pattern(self, *args, **kwargs): # real signature unknown
        pass

    def _get_optional_actions(self, *args, **kwargs): # real signature unknown
        pass

    def _get_option_tuples(self, *args, **kwargs): # real signature unknown
        pass

    def _get_positional_actions(self, *args, **kwargs): # real signature unknown
        pass

    def _get_value(self, *args, **kwargs): # real signature unknown
        pass

    def _get_values(self, *args, **kwargs): # real signature unknown
        pass

    def _match_argument(self, *args, **kwargs): # real signature unknown
        pass

    def _match_arguments_partial(self, *args, **kwargs): # real signature unknown
        pass

    def _parse_known_args(self, *args, **kwargs): # real signature unknown
        pass

    def _parse_optional(self, *args, **kwargs): # real signature unknown
        pass

    def _print_message(self, *args, **kwargs): # real signature unknown
        pass

    def _read_args_from_files(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class ArgumentTypeError(Exception):
    """ An error from trying to convert a command line string to a type. """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default


class FileType(object):
    """
    Factory for creating file object types
    
        Instances of FileType are typically passed as type= arguments to the
        ArgumentParser add_argument() method.
    
        Keyword Arguments:
            - mode -- A string indicating how the file is to be opened. Accepts the
                same values as the builtin open() function.
            - bufsize -- The file's desired buffer size. Accepts the same values as
                the builtin open() function.
    """
    def __call__(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    def __repr__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default

    __dict__ = None # (!) real value is ''


class Namespace(_AttributeHolder):
    """
    Simple object for storing attributes.
    
        Implements equality by attribute names and values, and provides a simple
        string representation.
    """
    def __contains__(self, *args, **kwargs): # real signature unknown
        pass

    def __eq__(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    def __ne__(self, *args, **kwargs): # real signature unknown
        pass

    __hash__ = None


class RawDescriptionHelpFormatter(HelpFormatter):
    """
    Help message formatter which retains any formatting in descriptions.
    
        Only the name of this class is considered a public API. All the methods
        provided by the class are considered an implementation detail.
    """
    def _fill_text(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class RawTextHelpFormatter(RawDescriptionHelpFormatter):
    """
    Help message formatter which retains formatting of all help text.
    
        Only the name of this class is considered a public API. All the methods
        provided by the class are considered an implementation detail.
    """
    def _split_lines(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class _AppendAction(Action):
    # no doc
    def __call__(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class _AppendConstAction(Action):
    # no doc
    def __call__(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class _ArgumentGroup(_ActionsContainer):
    # no doc
    def _add_action(self, *args, **kwargs): # real signature unknown
        pass

    def _remove_action(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class _CountAction(Action):
    # no doc
    def __call__(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class _HelpAction(Action):
    # no doc
    def __call__(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class _MutuallyExclusiveGroup(_ArgumentGroup):
    # no doc
    def _add_action(self, *args, **kwargs): # real signature unknown
        pass

    def _remove_action(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class _StoreAction(Action):
    # no doc
    def __call__(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class _StoreConstAction(Action):
    # no doc
    def __call__(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class _StoreFalseAction(_StoreConstAction):
    # no doc
    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class _StoreTrueAction(_StoreConstAction):
    # no doc
    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class _SubParsersAction(Action):
    # no doc
    def add_parser(self, *args, **kwargs): # real signature unknown
        pass

    def _ChoicesPseudoAction(self, *args, **kwargs): # real signature unknown
        pass

    def _get_subactions(self, *args, **kwargs): # real signature unknown
        pass

    def __call__(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class _VersionAction(Action):
    # no doc
    def __call__(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass


# variables with complex values

__all__ = [
    'ArgumentParser',
    'ArgumentError',
    'ArgumentTypeError',
    'FileType',
    'HelpFormatter',
    'ArgumentDefaultsHelpFormatter',
    'RawDescriptionHelpFormatter',
    'RawTextHelpFormatter',
    'Namespace',
    'Action',
    'ONE_OR_MORE',
    'OPTIONAL',
    'PARSER',
    'REMAINDER',
    'SUPPRESS',
    'ZERO_OR_MORE',
]

