# encoding: utf-8
# module asyncore
# from /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/asyncore.pyo by generator 1.99
"""
Basic infrastructure for asynchronous socket service clients and servers.

There are only two ways to have a program on a single processor do "more
than one thing at a time".  Multi-threaded programming is the simplest and
most popular way to do it, but there is another very different technique,
that lets you have nearly all the advantages of multi-threading, without
actually using multiple threads. it's really only practical if your program
is largely I/O bound. If your program is CPU bound, then pre-emptive
scheduled threads are probably what you really need. Network servers are
rarely CPU-bound, however.

If your operating system supports the select() system call in its I/O
library (and nearly all do), then you can use it to juggle multiple
communication channels at once; doing other work while your I/O is taking
place in the "background."  Although this strategy can seem strange and
complex, especially at first, it is in many ways easier to understand and
control than multi-threaded programming. The module documented here solves
many of the difficult problems for you, making the task of building
sophisticated high-performance network servers and clients a snap.
"""

# imports
import select as select # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/lib-dynload/select.so
import fcntl as fcntl # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/lib-dynload/fcntl.so
import warnings as warnings # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/warnings.pyc
import sys as sys # <module 'sys' (built-in)>
import socket as socket # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/socket.pyc
import time as time # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/lib-dynload/time.so
import os as os # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/os.pyc

# Variables with simple values

EALREADY = 37

EBADF = 9

ECONNABORTED = 53
ECONNRESET = 54

EINPROGRESS = 36
EINTR = 4
EINVAL = 22
EISCONN = 56

ENOTCONN = 57

ESHUTDOWN = 58

EWOULDBLOCK = 35

# functions

def close_all(map=None, ignore_all=False): # reliably restored by inspect
    # no doc
    pass


def compact_traceback(): # reliably restored by inspect
    # no doc
    pass


def loop(timeout=30.0, use_poll=False, map=None, count=None): # reliably restored by inspect
    # no doc
    pass


def poll(timeout=0.0, map=None): # reliably restored by inspect
    # no doc
    pass


def poll2(timeout=0.0, map=None): # reliably restored by inspect
    # no doc
    pass


def poll3(timeout=0.0, map=None): # reliably restored by inspect
    # no doc
    pass


def read(obj): # reliably restored by inspect
    # no doc
    pass


def readwrite(obj, flags): # reliably restored by inspect
    # no doc
    pass


def write(obj): # reliably restored by inspect
    # no doc
    pass


def _exception(obj): # reliably restored by inspect
    # no doc
    pass


def _strerror(err): # reliably restored by inspect
    # no doc
    pass


# classes

class ExitNow(Exception):
    # no doc
    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default


# variables with complex values

dispatcher = None # (!) real value is ''

dispatcher_with_send = None # (!) real value is ''

errorcode = {
    1: 'EPERM',
    2: 'ENOENT',
    3: 'ESRCH',
    4: 'EINTR',
    5: 'EIO',
    6: 'ENXIO',
    7: 'E2BIG',
    8: 'ENOEXEC',
    9: 'EBADF',
    10: 'ECHILD',
    11: 'EDEADLK',
    12: 'ENOMEM',
    13: 'EACCES',
    14: 'EFAULT',
    15: 'ENOTBLK',
    16: 'EBUSY',
    17: 'EEXIST',
    18: 'EXDEV',
    19: 'ENODEV',
    20: 'ENOTDIR',
    21: 'EISDIR',
    22: 'EINVAL',
    23: 'ENFILE',
    24: 'EMFILE',
    25: 'ENOTTY',
    26: 'ETXTBSY',
    27: 'EFBIG',
    28: 'ENOSPC',
    29: 'ESPIPE',
    30: 'EROFS',
    31: 'EMLINK',
    32: 'EPIPE',
    33: 'EDOM',
    34: 'ERANGE',
    35: 'EAGAIN',
    36: 'EINPROGRESS',
    37: 'EALREADY',
    38: 'ENOTSOCK',
    39: 'EDESTADDRREQ',
    40: 'EMSGSIZE',
    41: 'EPROTOTYPE',
    42: 'ENOPROTOOPT',
    43: 'EPROTONOSUPPORT',
    44: 'ESOCKTNOSUPPORT',
    45: 'ENOTSUP',
    46: 'EPFNOSUPPORT',
    47: 'EAFNOSUPPORT',
    48: 'EADDRINUSE',
    49: 'EADDRNOTAVAIL',
    50: 'ENETDOWN',
    51: 'ENETUNREACH',
    52: 'ENETRESET',
    53: 'ECONNABORTED',
    54: 'ECONNRESET',
    55: 'ENOBUFS',
    56: 'EISCONN',
    57: 'ENOTCONN',
    58: 'ESHUTDOWN',
    59: 'ETOOMANYREFS',
    60: 'ETIMEDOUT',
    61: 'ECONNREFUSED',
    62: 'ELOOP',
    63: 'ENAMETOOLONG',
    64: 'EHOSTDOWN',
    65: 'EHOSTUNREACH',
    66: 'ENOTEMPTY',
    67: 'EPROCLIM',
    68: 'EUSERS',
    69: 'EDQUOT',
    70: 'ESTALE',
    71: 'EREMOTE',
    72: 'EBADRPC',
    73: 'ERPCMISMATCH',
    74: 'EPROGUNAVAIL',
    75: 'EPROGMISMATCH',
    76: 'EPROCUNAVAIL',
    77: 'ENOLCK',
    78: 'ENOSYS',
    79: 'EFTYPE',
    80: 'EAUTH',
    81: 'ENEEDAUTH',
    82: 'EPWROFF',
    83: 'EDEVERR',
    84: 'EOVERFLOW',
    85: 'EBADEXEC',
    86: 'EBADARCH',
    87: 'ESHLIBVERS',
    88: 'EBADMACHO',
    89: 'ECANCELED',
    90: 'EIDRM',
    91: 'ENOMSG',
    92: 'EILSEQ',
    93: 'ENOATTR',
    94: 'EBADMSG',
    95: 'EMULTIHOP',
    96: 'ENODATA',
    97: 'ENOLINK',
    98: 'ENOSR',
    99: 'ENOSTR',
    100: 'EPROTO',
    101: 'ETIME',
    102: 'EOPNOTSUPP',
    103: 'ENOPOLICY',
    104: 'ENOTRECOVERABLE',
    105: 'EOWNERDEAD',
}

file_dispatcher = None # (!) real value is ''

file_wrapper = None # (!) real value is ''

socket_map = {}

_reraised_exceptions = (
    ExitNow,
    KeyboardInterrupt,
    SystemExit,
)

