# encoding: utf-8
# module contextlib
# from /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/contextlib.pyo by generator 1.99
""" Utilities for with-statement contexts.  See PEP 343. """

# imports
import sys as sys # <module 'sys' (built-in)>
from _warnings import warn


# functions

def contextmanager(func): # reliably restored by inspect
    """
    @contextmanager decorator.
    
        Typical usage:
    
            @contextmanager
            def some_generator(<arguments>):
                <setup>
                try:
                    yield <value>
                finally:
                    <cleanup>
    
        This makes this:
    
            with some_generator(<arguments>) as <variable>:
                <body>
    
        equivalent to this:
    
            <setup>
            try:
                <variable> = <value>
                <body>
            finally:
                <cleanup>
    """
    pass


def nested(*args, **kwds): # reliably restored by inspect
    """
    Combine multiple context managers into a single nested context manager.
    
       This function has been deprecated in favour of the multiple manager form
       of the with statement.
    
       The one advantage of this function over the multiple manager form of the
       with statement is that argument unpacking allows it to be
       used with a variable number of context managers as follows:
    
          with nested(*managers):
              do_something()
    """
    pass


def wraps(wrapped, assigned="('__module__', '__name__', '__doc__')", updated="('__dict__',)"): # reliably restored by inspect
    """
    Decorator factory to apply update_wrapper() to a wrapper function
    
           Returns a decorator that invokes update_wrapper() with the decorated
           function as the wrapper argument and the arguments to wraps() as the
           remaining arguments. Default arguments are as for update_wrapper().
           This is a convenience function to simplify applying partial() to
           update_wrapper().
    """
    pass


# classes

class closing(object):
    """
    Context to automatically close something at the end of a block.
    
        Code like this:
    
            with closing(<module>.open(<arguments>)) as f:
                <block>
    
        is equivalent to this:
    
            f = <module>.open(<arguments>)
            try:
                <block>
            finally:
                f.close()
    """
    def __enter__(self, *args, **kwargs): # real signature unknown
        pass

    def __exit__(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default

    __dict__ = None # (!) real value is ''


class GeneratorContextManager(object):
    """ Helper for @contextmanager decorator. """
    def __enter__(self, *args, **kwargs): # real signature unknown
        pass

    def __exit__(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default

    __dict__ = None # (!) real value is ''


# variables with complex values

__all__ = [
    'contextmanager',
    'nested',
    'closing',
]

