# encoding: utf-8
# module distutils.archive_util
# from /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/distutils/archive_util.pyo by generator 1.99
"""
distutils.archive_util

Utility functions for creating archive files (tarballs, zip files,
that sort of thing).
"""

# imports
import distutils.log as log # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/distutils/log.pyc
import sys as sys # <module 'sys' (built-in)>
import os as os # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/os.pyc
from grp import getgrnam

from pwd import getpwnam

from _warnings import warn

import distutils.errors as __distutils_errors


# Variables with simple values

__revision__ = '$Id: archive_util.py 75659 2009-10-24 13:29:44Z tarek.ziade $'

# functions

def check_archive_formats(formats): # reliably restored by inspect
    """
    Returns the first format from the 'format' list that is unknown.
    
        If all formats are known, returns None
    """
    pass


def make_archive(base_name, format, root_dir=None, base_dir=None, verbose=0, dry_run=0, owner=None, group=None): # reliably restored by inspect
    """
    Create an archive file (eg. zip or tar).
    
        'base_name' is the name of the file to create, minus any format-specific
        extension; 'format' is the archive format: one of "zip", "tar", "ztar",
        or "gztar".
    
        'root_dir' is a directory that will be the root directory of the
        archive; ie. we typically chdir into 'root_dir' before creating the
        archive.  'base_dir' is the directory where we start archiving from;
        ie. 'base_dir' will be the common prefix of all files and
        directories in the archive.  'root_dir' and 'base_dir' both default
        to the current directory.  Returns the name of the archive file.
    
        'owner' and 'group' are used when creating a tar archive. By default,
        uses the current owner and group.
    """
    pass


def make_tarball(base_name, base_dir, compress=None, verbose=0, dry_run=0, owner=None, group=None): # reliably restored by inspect
    """
    Create a (possibly compressed) tar file from all the files under
        'base_dir'.
    
        'compress' must be "gzip" (the default), "compress", "bzip2", or None.
        (compress will be deprecated in Python 3.2)
    
        'owner' and 'group' can be used to define an owner and a group for the
        archive that is being built. If not provided, the current owner and group
        will be used.
    
        The output tar file will be named 'base_dir' +  ".tar", possibly plus
        the appropriate compression extension (".gz", ".bz2" or ".Z").
    
        Returns the output filename.
    """
    pass


def make_zipfile(base_name, base_dir, verbose=0, dry_run=0): # reliably restored by inspect
    """
    Create a zip file from all the files under 'base_dir'.
    
        The output zip file will be named 'base_dir' + ".zip".  Uses either the
        "zipfile" Python module (if available) or the InfoZIP "zip" utility
        (if installed and found on the default search path).  If neither tool is
        available, raises DistutilsExecError.  Returns the name of the output zip
        file.
    """
    pass


def mkpath(name, mode=511, verbose=1, dry_run=0): # reliably restored by inspect
    """
    Create a directory and any missing ancestor directories.
    
        If the directory already exists (or if 'name' is the empty string, which
        means the current directory, which of course exists), then do nothing.
        Raise DistutilsFileError if unable to create some directory along the way
        (eg. some sub-path exists, but is a file rather than a directory).
        If 'verbose' is true, print a one-line summary of each mkdir to stdout.
        Return the list of directories actually created.
    """
    pass


def spawn(cmd, search_path=1, verbose=0, dry_run=0): # reliably restored by inspect
    """
    Run another program, specified as a command list 'cmd', in a new process.
    
        'cmd' is just the argument list for the new process, ie.
        cmd[0] is the program to run and cmd[1:] are the rest of its arguments.
        There is no way to run a program with a name different from that of its
        executable.
    
        If 'search_path' is true (the default), the system's executable
        search path will be used to find the program; otherwise, cmd[0]
        must be the exact path to the executable.  If 'dry_run' is true,
        the command will not actually be run.
    
        Raise DistutilsExecError if running the program fails in any way; just
        return on success.
    """
    pass


def _get_gid(name): # reliably restored by inspect
    """ Returns a gid, given a group name. """
    pass


def _get_uid(name): # reliably restored by inspect
    """ Returns an uid, given a user name. """
    pass


# classes

class DistutilsExecError(__distutils_errors.DistutilsError):
    """
    Any problems executing an external program (such as the C
        compiler, when compiling C files).
    """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass


# variables with complex values

ARCHIVE_FORMATS = {
    'bztar': (
        make_tarball,
        [
            (
                'compress',
                'bzip2',
            ),
        ],
        "bzip2'ed tar-file",
    ),
    'gztar': (
        '<value is a self-reference, replaced by this string>',
        [
            (
                'compress',
                'gzip',
            ),
        ],
        "gzip'ed tar-file",
    ),
    'tar': (
        '<value is a self-reference, replaced by this string>',
        [
            (
                'compress',
                None,
            ),
        ],
        'uncompressed tar file',
    ),
    'zip': (
        make_zipfile,
        [],
        'ZIP file',
    ),
    'ztar': (
        '<value is a self-reference, replaced by this string>',
        [
            (
                'compress',
                'compress',
            ),
        ],
        'compressed tar file',
    ),
}

