# encoding: utf-8
# module distutils.core
# from /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/distutils/core.pyo by generator 1.99
"""
distutils.core

The only module that needs to be imported to use the Distutils; provides
the 'setup' function (which is to be called from the setup script).  Also
indirectly provides the Distribution and Command classes, although they are
really defined in distutils.dist and distutils.cmd.
"""

# imports
import sys as sys # <module 'sys' (built-in)>
import os as os # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/os.pyc
import distutils.errors as __distutils_errors


# Variables with simple values

DEBUG = None

USAGE = 'usage: %(script)s [global_opts] cmd1 [cmd1_opts] [cmd2 [cmd2_opts] ...]\n   or: %(script)s --help [cmd1 cmd2 ...]\n   or: %(script)s --help-commands\n   or: %(script)s cmd --help\n'

_setup_distribution = None

_setup_stop_after = None

__revision__ = '$Id: core.py 86238 2010-11-06 04:06:18Z eric.araujo $'

# functions

def gen_usage(script_name): # reliably restored by inspect
    # no doc
    pass


def grok_environment_error(exc, prefix=None): # reliably restored by inspect
    """
    Generate a useful error message from an EnvironmentError (IOError or
        OSError) exception object.  Handles Python 1.5.1 and 1.5.2 styles, and
        does what it can to deal with exception objects that don't have a
        filename (which happens when the error is due to a two-file operation,
        such as 'rename()' or 'link()'.  Returns the error message as a string
        prefixed with 'prefix'.
    """
    pass


def run_setup(script_name, script_args=None, stop_after=None): # reliably restored by inspect
    """
    Run a setup script in a somewhat controlled environment, and
        return the Distribution instance that drives things.  This is useful
        if you need to find out the distribution meta-data (passed as
        keyword args from 'script' to 'setup()', or the contents of the
        config files or command-line.
    
        'script_name' is a file that will be run with 'execfile()';
        'sys.argv[0]' will be replaced with 'script' for the duration of the
        call.  'script_args' is a list of strings; if supplied,
        'sys.argv[1:]' will be replaced by 'script_args' for the duration of
        the call.
    
        'stop_after' tells 'setup()' when to stop processing; possible
        values:
          init
            stop after the Distribution instance has been created and
            populated with the keyword arguments to 'setup()'
          config
            stop after config files have been parsed (and their data
            stored in the Distribution instance)
          commandline
            stop after the command-line ('sys.argv[1:]' or 'script_args')
            have been parsed (and the data stored in the Distribution)
          run [default]
            stop after all commands have been run (the same as if 'setup()'
            had been called in the usual way
    
        Returns the Distribution instance, which provides all information
        used to drive the Distutils.
    """
    pass


def setup(**attrs): # reliably restored by inspect
    """
    The gateway to the Distutils: do everything your setup script needs
        to do, in a highly flexible and user-driven way.  Briefly: create a
        Distribution instance; find and parse config files; parse the command
        line; run each Distutils command found there, customized by the options
        supplied to 'setup()' (as keyword arguments), in config files, and on
        the command line.
    
        The Distribution instance might be an instance of a class supplied via
        the 'distclass' keyword argument to 'setup'; if no such class is
        supplied, then the Distribution class (in dist.py) is instantiated.
        All other arguments to 'setup' (except for 'cmdclass') are used to set
        attributes of the Distribution instance.
    
        The 'cmdclass' argument, if supplied, is a dictionary mapping command
        names to command classes.  Each command encountered on the command line
        will be turned into a command class, which is in turn instantiated; any
        class found in 'cmdclass' is used in place of the default, which is
        (for command 'foo_bar') class 'foo_bar' in module
        'distutils.command.foo_bar'.  The command class must provide a
        'user_options' attribute which is a list of option specifiers for
        'distutils.fancy_getopt'.  Any command-line options between the current
        and the next command are used to set attributes of the current command
        object.
    
        When the entire command-line has been successfully parsed, calls the
        'run()' method on each command object in turn.  This method will be
        driven entirely by the Distribution object (which each command object
        has a reference to, thanks to its constructor), and the
        command-specific options that became attributes of each command
        object.
    """
    pass


# classes

class CCompilerError(Exception):
    """ Some compile/link operation failed. """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default


class DistutilsError(Exception):
    """ The root of all Distutils evil. """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default


class DistutilsArgError(__distutils_errors.DistutilsError):
    """
    Raised by fancy_getopt in response to getopt.error -- ie. an
        error in the command line usage.
    """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class DistutilsSetupError(__distutils_errors.DistutilsError):
    """
    For errors that can be definitely blamed on the setup script,
        such as invalid keyword arguments to 'setup()'.
    """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass


# variables with complex values

Command = None # (!) real value is ''

Distribution = None # (!) real value is ''

Extension = None # (!) real value is ''

extension_keywords = (
    'name',
    'sources',
    'include_dirs',
    'define_macros',
    'undef_macros',
    'library_dirs',
    'libraries',
    'runtime_library_dirs',
    'extra_objects',
    'extra_compile_args',
    'extra_link_args',
    'swig_opts',
    'export_symbols',
    'depends',
    'language',
)

PyPIRCCommand = None # (!) real value is ''

setup_keywords = (
    'distclass',
    'script_name',
    'script_args',
    'options',
    'name',
    'version',
    'author',
    'author_email',
    'maintainer',
    'maintainer_email',
    'url',
    'license',
    'description',
    'long_description',
    'keywords',
    'platforms',
    'classifiers',
    'download_url',
    'requires',
    'provides',
    'obsoletes',
)

