# encoding: utf-8
# module distutils.dep_util
# from /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/distutils/dep_util.pyo by generator 1.99
"""
distutils.dep_util

Utility functions for simple, timestamp-based dependency of files
and groups of files; also, function based entirely on such
timestamp dependency analysis.
"""

# imports
import os as os # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/os.pyc
import distutils.errors as __distutils_errors


# Variables with simple values

__revision__ = '$Id: dep_util.py 76746 2009-12-10 15:29:03Z tarek.ziade $'

# functions

def newer(source, target): # reliably restored by inspect
    """
    Tells if the target is newer than the source.
    
        Return true if 'source' exists and is more recently modified than
        'target', or if 'source' exists and 'target' doesn't.
    
        Return false if both exist and 'target' is the same age or younger
        than 'source'. Raise DistutilsFileError if 'source' does not exist.
    
        Note that this test is not very accurate: files created in the same second
        will have the same "age".
    """
    pass


def newer_group(sources, target, missing=None): # reliably restored by inspect
    """
    Return true if 'target' is out-of-date with respect to any file
        listed in 'sources'.
    
        In other words, if 'target' exists and is newer
        than every file in 'sources', return false; otherwise return true.
        'missing' controls what we do when a source file is missing; the
        default ("error") is to blow up with an OSError from inside 'stat()';
        if it is "ignore", we silently drop any missing source files; if it is
        "newer", any missing source files make us assume that 'target' is
        out-of-date (this is handy in "dry-run" mode: it'll make you pretend to
        carry out commands that wouldn't work because inputs are missing, but
        that doesn't matter because you're not actually going to run the
        commands).
    """
    pass


def newer_pairwise(sources, targets): # reliably restored by inspect
    """
    Walk two filename lists in parallel, testing if each source is newer
        than its corresponding target.  Return a pair of lists (sources,
        targets) where source is newer than target, according to the semantics
        of 'newer()'.
    """
    pass


# classes

class DistutilsFileError(__distutils_errors.DistutilsError):
    """
    Any problems in the filesystem: expected file not found, etc.
        Typically this is for problems that we detect before IOError or
        OSError could be raised.
    """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass


