# encoding: utf-8
# module distutils.util
# from /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/distutils/util.pyo by generator 1.99
"""
distutils.util

Miscellaneous utility functions -- anything that doesn't fit into
one of the other *util.py modules.
"""

# imports
import distutils.log as log # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/distutils/log.pyc
import re as re # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/re.pyc
import string as string # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/string.pyc
import sys as sys # <module 'sys' (built-in)>
import os as os # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/os.pyc
import distutils.errors as __distutils_errors


# Variables with simple values

_dquote_re = None

_environ_checked = 0

_squote_re = None

_wordchars_re = None

__revision__ = '$Id: util.py 86238 2010-11-06 04:06:18Z eric.araujo $'

# functions

def byte_compile(py_files, optimize=0, force=0, prefix=None, base_dir=None, verbose=1, dry_run=0, direct=None): # reliably restored by inspect
    """
    Byte-compile a collection of Python source files to either .pyc
        or .pyo files in the same directory.  'py_files' is a list of files
        to compile; any files that don't end in ".py" are silently skipped.
        'optimize' must be one of the following:
          0 - don't optimize (generate .pyc)
          1 - normal optimization (like "python -O")
          2 - extra optimization (like "python -OO")
        If 'force' is true, all files are recompiled regardless of
        timestamps.
    
        The source filename encoded in each bytecode file defaults to the
        filenames listed in 'py_files'; you can modify these with 'prefix' and
        'basedir'.  'prefix' is a string that will be stripped off of each
        source filename, and 'base_dir' is a directory name that will be
        prepended (after 'prefix' is stripped).  You can supply either or both
        (or neither) of 'prefix' and 'base_dir', as you wish.
    
        If 'dry_run' is true, doesn't actually do anything that would
        affect the filesystem.
    
        Byte-compilation is either done directly in this interpreter process
        with the standard py_compile module, or indirectly by writing a
        temporary script and executing it.  Normally, you should let
        'byte_compile()' figure out to use direct compilation or not (see
        the source for details).  The 'direct' flag is used by the script
        generated in indirect mode; unless you know what you're doing, leave
        it set to None.
    """
    pass


def change_root(new_root, pathname): # reliably restored by inspect
    """
    Return 'pathname' with 'new_root' prepended.  If 'pathname' is
        relative, this is equivalent to "os.path.join(new_root,pathname)".
        Otherwise, it requires making 'pathname' relative and then joining the
        two, which is tricky on DOS/Windows and Mac OS.
    """
    pass


def check_environ(): # reliably restored by inspect
    """
    Ensure that 'os.environ' has all the environment variables we
        guarantee that users can use in config files, command-line options,
        etc.  Currently this includes:
          HOME - user's home directory (Unix only)
          PLAT - description of the current platform, including hardware
                 and OS (see 'get_platform()')
    """
    pass


def convert_path(pathname): # reliably restored by inspect
    """
    Return 'pathname' as a name that will work on the native filesystem,
        i.e. split it on '/' and put it back together again using the current
        directory separator.  Needed because filenames in the setup script are
        always supplied in Unix style, and have to be converted to the local
        convention before we can actually use them in the filesystem.  Raises
        ValueError on non-Unix-ish systems if 'pathname' either starts or
        ends with a slash.
    """
    pass


def execute(func, args, msg=None, verbose=0, dry_run=0): # reliably restored by inspect
    """
    Perform some action that affects the outside world (eg.  by
        writing to the filesystem).  Such actions are special because they
        are disabled by the 'dry_run' flag.  This method takes care of all
        that bureaucracy for you; all you have to do is supply the
        function to call and an argument tuple for it (to embody the
        "external action" being performed), and an optional message to
        print.
    """
    pass


def get_platform(): # reliably restored by inspect
    """
    Return a string that identifies the current platform.  This is used
        mainly to distinguish platform-specific build directories and
        platform-specific built distributions.  Typically includes the OS name
        and version and the architecture (as supplied by 'os.uname()'),
        although the exact information included depends on the OS; eg. for IRIX
        the architecture isn't particularly important (IRIX only runs on SGI
        hardware), but for Linux the kernel version isn't particularly
        important.
    
        Examples of returned values:
           linux-i586
           linux-alpha (?)
           solaris-2.6-sun4u
           irix-5.3
           irix64-6.2
    
        Windows will return one of:
           win-amd64 (64bit Windows on AMD64 (aka x86_64, Intel64, EM64T, etc)
           win-ia64 (64bit Windows on Itanium)
           win32 (all others - specifically, sys.platform is returned)
    
        For other non-POSIX platforms, currently just returns 'sys.platform'.
    """
    pass


def grok_environment_error(exc, prefix=None): # reliably restored by inspect
    """
    Generate a useful error message from an EnvironmentError (IOError or
        OSError) exception object.  Handles Python 1.5.1 and 1.5.2 styles, and
        does what it can to deal with exception objects that don't have a
        filename (which happens when the error is due to a two-file operation,
        such as 'rename()' or 'link()'.  Returns the error message as a string
        prefixed with 'prefix'.
    """
    pass


def newer(source, target): # reliably restored by inspect
    """
    Tells if the target is newer than the source.
    
        Return true if 'source' exists and is more recently modified than
        'target', or if 'source' exists and 'target' doesn't.
    
        Return false if both exist and 'target' is the same age or younger
        than 'source'. Raise DistutilsFileError if 'source' does not exist.
    
        Note that this test is not very accurate: files created in the same second
        will have the same "age".
    """
    pass


def rfc822_escape(header): # reliably restored by inspect
    """
    Return a version of the string escaped for inclusion in an
        RFC-822 header, by ensuring there are 8 spaces space after each newline.
    """
    pass


def spawn(cmd, search_path=1, verbose=0, dry_run=0): # reliably restored by inspect
    """
    Run another program, specified as a command list 'cmd', in a new process.
    
        'cmd' is just the argument list for the new process, ie.
        cmd[0] is the program to run and cmd[1:] are the rest of its arguments.
        There is no way to run a program with a name different from that of its
        executable.
    
        If 'search_path' is true (the default), the system's executable
        search path will be used to find the program; otherwise, cmd[0]
        must be the exact path to the executable.  If 'dry_run' is true,
        the command will not actually be run.
    
        Raise DistutilsExecError if running the program fails in any way; just
        return on success.
    """
    pass


def split_quoted(s): # reliably restored by inspect
    """
    Split a string up according to Unix shell-like rules for quotes and
        backslashes.  In short: words are delimited by spaces, as long as those
        spaces are not escaped by a backslash, or inside a quoted string.
        Single and double quotes are equivalent, and the quote characters can
        be backslash-escaped.  The backslash is stripped from any two-character
        escape sequence, leaving only the escaped character.  The quote
        characters are stripped from any quoted string.  Returns a list of
        words.
    """
    pass


def strtobool(val): # reliably restored by inspect
    """
    Convert a string representation of truth to true (1) or false (0).
    
        True values are 'y', 'yes', 't', 'true', 'on', and '1'; false values
        are 'n', 'no', 'f', 'false', 'off', and '0'.  Raises ValueError if
        'val' is anything else.
    """
    pass


def subst_vars(s, local_vars): # reliably restored by inspect
    """
    Perform shell/Perl-style variable substitution on 'string'.  Every
        occurrence of '$' followed by a name is considered a variable, and
        variable is substituted by the value found in the 'local_vars'
        dictionary, or in 'os.environ' if it's not in 'local_vars'.
        'os.environ' is first checked/augmented to guarantee that it contains
        certain values: see 'check_environ()'.  Raise ValueError for any
        variables not found in either 'local_vars' or 'os.environ'.
    """
    pass


def _init_regex(): # reliably restored by inspect
    # no doc
    pass


# classes

class DistutilsByteCompileError(__distutils_errors.DistutilsError):
    """ Byte compile error. """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class DistutilsPlatformError(__distutils_errors.DistutilsError):
    """
    We don't know how to do something on the current platform (but
        we do know how to do it on some platform) -- eg. trying to compile
        C files on a platform not supported by a CCompiler subclass.
    """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass


