# encoding: utf-8
# module email.quoprimime
# from /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/email/quoprimime.pyo by generator 1.99
"""
Quoted-printable content transfer encoding per RFCs 2045-2047.

This module handles the content transfer encoding method defined in RFC 2045
to encode US ASCII-like 8-bit data called `quoted-printable'.  It is used to
safely encode text that is in a character set similar to the 7-bit US ASCII
character set, but that includes some 8-bit characters that are normally not
allowed in email bodies or headers.

Quoted-printable is very space-inefficient for encoding binary files; use the
email.base64mime module for that instead.

This module provides an interface to encode and decode both headers and bodies
with quoted-printable encoding.

RFC 2045 defines a method for including character set information in an
`encoded-word' in a header.  This method is commonly used for 8-bit real names
in To:/From:/Cc: etc. fields, as well as Subject: lines.

This module does not do the line wrapping or end-of-line character
conversion necessary for proper internationalized headers; it only
does dumb encoding and decoding.  To deal with the various line
wrapping issues, use the email.header module.
"""

# imports
import re as re # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/re.pyc

# Variables with simple values

CRLF = '\r\n'

hexdigits = '0123456789abcdefABCDEF'

MISC_LEN = 7

NL = '\n'

# functions

def body_decode(encoded, eol=None): # reliably restored by inspect
    """
    Decode a quoted-printable string.
    
        Lines are separated with eol, which defaults to \n.
    """
    pass


def body_encode(body, binary=False, maxlinelen=76, eol=None): # reliably restored by inspect
    """
    Encode with quoted-printable, wrapping at maxlinelen characters.
    
        If binary is False (the default), end-of-line characters will be converted
        to the canonical email end-of-line sequence \r\n.  Otherwise they will
        be left verbatim.
    
        Each line of encoded text will end with eol, which defaults to "\n".  Set
        this to "\r\n" if you will be using the result of this function directly
        in an email.
    
        Each line will be wrapped at, at most, maxlinelen characters (defaults to
        76 characters).  Long lines will have the `soft linefeed' quoted-printable
        character "=" appended to them, so the decoded text will be identical to
        the original text.
    """
    pass


def body_quopri_check(c): # reliably restored by inspect
    """ Return True if the character should be escaped with body quopri. """
    pass


def body_quopri_len(str): # reliably restored by inspect
    """ Return the length of str when it is encoded with body quopri. """
    pass


def decode(encoded, eol=None): # reliably restored by inspect
    """
    Decode a quoted-printable string.
    
        Lines are separated with eol, which defaults to \n.
    """
    pass


def decodestring(encoded, eol=None): # reliably restored by inspect
    """
    Decode a quoted-printable string.
    
        Lines are separated with eol, which defaults to \n.
    """
    pass


def encode(body, binary=False, maxlinelen=76, eol=None): # reliably restored by inspect
    """
    Encode with quoted-printable, wrapping at maxlinelen characters.
    
        If binary is False (the default), end-of-line characters will be converted
        to the canonical email end-of-line sequence \r\n.  Otherwise they will
        be left verbatim.
    
        Each line of encoded text will end with eol, which defaults to "\n".  Set
        this to "\r\n" if you will be using the result of this function directly
        in an email.
    
        Each line will be wrapped at, at most, maxlinelen characters (defaults to
        76 characters).  Long lines will have the `soft linefeed' quoted-printable
        character "=" appended to them, so the decoded text will be identical to
        the original text.
    """
    pass


def encodestring(body, binary=False, maxlinelen=76, eol=None): # reliably restored by inspect
    """
    Encode with quoted-printable, wrapping at maxlinelen characters.
    
        If binary is False (the default), end-of-line characters will be converted
        to the canonical email end-of-line sequence \r\n.  Otherwise they will
        be left verbatim.
    
        Each line of encoded text will end with eol, which defaults to "\n".  Set
        this to "\r\n" if you will be using the result of this function directly
        in an email.
    
        Each line will be wrapped at, at most, maxlinelen characters (defaults to
        76 characters).  Long lines will have the `soft linefeed' quoted-printable
        character "=" appended to them, so the decoded text will be identical to
        the original text.
    """
    pass


def fix_eols(s): # reliably restored by inspect
    """
    Replace all line-ending characters with 
    .
    """
    pass


def header_decode(s): # reliably restored by inspect
    """
    Decode a string encoded with RFC 2045 MIME header `Q' encoding.
    
        This function does not parse a full MIME header value encoded with
        quoted-printable (like =?iso-8895-1?q?Hello_World?=) -- please use
        the high level email.header class for that functionality.
    """
    pass


def header_encode(header, charset=None, keep_eols=False, maxlinelen=76, eol=None): # reliably restored by inspect
    """
    Encode a single header line with quoted-printable (like) encoding.
    
        Defined in RFC 2045, this `Q' encoding is similar to quoted-printable, but
        used specifically for email header fields to allow charsets with mostly 7
        bit characters (and some 8 bit) to remain more or less readable in non-RFC
        2045 aware mail clients.
    
        charset names the character set to use to encode the header.  It defaults
        to iso-8859-1.
    
        The resulting string will be in the form:
    
        "=?charset?q?I_f=E2rt_in_your_g=E8n=E8ral_dire=E7tion?\n
          =?charset?q?Silly_=C8nglish_Kn=EEghts?="
    
        with each line wrapped safely at, at most, maxlinelen characters (defaults
        to 76 characters).  If maxlinelen is None, the entire string is encoded in
        one chunk with no splitting.
    
        End-of-line characters (\r, \n, \r\n) will be automatically converted
        to the canonical email line separator \r\n unless the keep_eols
        parameter is True (the default is False).
    
        Each line of the header will be terminated in the value of eol, which
        defaults to "\n".  Set this to "\r\n" if you are using the result of
        this function directly in email.
    """
    pass


def header_quopri_check(c): # reliably restored by inspect
    """ Return True if the character should be escaped with header quopri. """
    pass


def header_quopri_len(s): # reliably restored by inspect
    """ Return the length of str when it is encoded with header quopri. """
    pass


def quote(c): # reliably restored by inspect
    # no doc
    pass


def unquote(s): # reliably restored by inspect
    """ Turn a string in the form =AB to the ASCII character with value 0xab """
    pass


def _max_append(L, s, maxlen, extra=None): # reliably restored by inspect
    # no doc
    pass


def _unquote_match(match): # reliably restored by inspect
    """ Turn a match in the form =AB to the ASCII character with value 0xab """
    pass


# no classes
# variables with complex values

bqre = None # (!) real value is ''

hqre = None # (!) real value is ''

__all__ = [
    'body_decode',
    'body_encode',
    'body_quopri_check',
    'body_quopri_len',
    'decode',
    'decodestring',
    'encode',
    'encodestring',
    'header_decode',
    'header_encode',
    'header_quopri_check',
    'header_quopri_len',
    'quote',
    'unquote',
]

