# encoding: utf-8
# module getpass
# from /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/getpass.pyo by generator 1.99
"""
Utilities to get a password and/or the current user name.

getpass(prompt[, stream]) - Prompt for a password, with echo turned off.
getuser() - Get the user name from the environment or password database.

GetPassWarning - This UserWarning is issued when getpass() cannot prevent
                 echoing of the password contents while reading.

On Windows, the msvcrt module will be used.
On the Mac EasyDialogs.AskPassword is used, if available.
"""

# imports
import warnings as warnings # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/warnings.pyc
import termios as termios # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/lib-dynload/termios.so
import sys as sys # <module 'sys' (built-in)>
import os as os # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/os.pyc

# functions

def fallback_getpass(prompt=None, stream=None): # reliably restored by inspect
    # no doc
    pass


def getpass(prompt=None, stream=None): # reliably restored by inspect
    """
    Prompt for a password, with echo turned off.
    
        Args:
          prompt: Written on stream to ask for the input.  Default: 'Password: '
          stream: A writable file object to display the prompt.  Defaults to
                  the tty.  If no tty is available defaults to sys.stderr.
        Returns:
          The seKr3t input.
        Raises:
          EOFError: If our input tty or stdin was closed.
          GetPassWarning: When we were unable to turn echo off on the input.
    
        Always restores terminal settings before returning.
    """
    pass


def getuser(): # reliably restored by inspect
    """
    Get the username from the environment or password database.
    
        First try various environment variables, then the password
        database.  This works on Windows as long as USERNAME is set.
    """
    pass


def unix_getpass(prompt=None, stream=None): # reliably restored by inspect
    """
    Prompt for a password, with echo turned off.
    
        Args:
          prompt: Written on stream to ask for the input.  Default: 'Password: '
          stream: A writable file object to display the prompt.  Defaults to
                  the tty.  If no tty is available defaults to sys.stderr.
        Returns:
          The seKr3t input.
        Raises:
          EOFError: If our input tty or stdin was closed.
          GetPassWarning: When we were unable to turn echo off on the input.
    
        Always restores terminal settings before returning.
    """
    pass


def win_getpass(prompt=None, stream=None): # reliably restored by inspect
    """ Prompt for password with echo off, using Windows getch(). """
    pass


def _raw_input(prompt=None, stream=None, input=None): # reliably restored by inspect
    # no doc
    pass


# classes

class GetPassWarning(UserWarning):
    # no doc
    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default


# variables with complex values

__all__ = [
    'getpass',
    'getuser',
    'GetPassWarning',
]

