# encoding: utf-8
# module gzip
# from /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/gzip.pyo by generator 1.99
"""
Functions that read and write gzipped files.

The user of the file doesn't have to worry about the compression,
but random access is not allowed.
"""

# imports
import __builtin__ as __builtin__ # <module '__builtin__' (built-in)>
import io as io # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/io.pyc
import struct as struct # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/struct.pyc
import sys as sys # <module 'sys' (built-in)>
import zlib as zlib # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/lib-dynload/zlib.so
import time as time # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/lib-dynload/time.so
import os as os # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/os.pyc
import io as __io


# Variables with simple values

FCOMMENT = 16

FEXTRA = 4

FHCRC = 2

FNAME = 8

FTEXT = 1

READ = 1

WRITE = 2

# functions

def open(filename, mode=None, compresslevel=9): # reliably restored by inspect
    """
    Shorthand for GzipFile(filename, mode, compresslevel).
    
        The filename argument is required; mode defaults to 'rb'
        and compresslevel defaults to 9.
    """
    pass


def read32(input): # reliably restored by inspect
    # no doc
    pass


def write32u(output, value): # reliably restored by inspect
    # no doc
    pass


def _test(): # reliably restored by inspect
    # no doc
    pass


# classes

class GzipFile(__io.BufferedIOBase):
    """
    The GzipFile class simulates most of the methods of a file object with
        the exception of the readinto() and truncate() methods.
    """
    def close(self, *args, **kwargs): # real signature unknown
        pass

    def fileno(self): # real signature unknown; restored from __doc__
        """
        Invoke the underlying file object's fileno() method.
        
                This will raise AttributeError if the underlying file object
                doesn't support fileno().
        """
        pass

    def flush(self, *args, **kwargs): # real signature unknown
        pass

    def read(self, *args, **kwargs): # real signature unknown
        pass

    def readable(self, *args, **kwargs): # real signature unknown
        pass

    def readline(self, *args, **kwargs): # real signature unknown
        pass

    def rewind(self, *args, **kwargs): # real signature unknown
        """
        Return the uncompressed stream file position indicator to the
                beginning of the file
        """
        pass

    def seek(self, *args, **kwargs): # real signature unknown
        pass

    def seekable(self, *args, **kwargs): # real signature unknown
        pass

    def writable(self, *args, **kwargs): # real signature unknown
        pass

    def write(self, *args, **kwargs): # real signature unknown
        pass

    def _add_read_data(self, *args, **kwargs): # real signature unknown
        pass

    def _check_closed(self, *args, **kwargs): # real signature unknown
        """ Raises a ValueError if the underlying file object has been closed. """
        pass

    def _init_read(self, *args, **kwargs): # real signature unknown
        pass

    def _init_write(self, *args, **kwargs): # real signature unknown
        pass

    def _read(self, *args, **kwargs): # real signature unknown
        pass

    def _read_eof(self, *args, **kwargs): # real signature unknown
        pass

    def _read_gzip_header(self, *args, **kwargs): # real signature unknown
        pass

    def _unread(self, *args, **kwargs): # real signature unknown
        pass

    def _write_gzip_header(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        """
        Constructor for the GzipFile class.
        
                At least one of fileobj and filename must be given a
                non-trivial value.
        
                The new class instance is based on fileobj, which can be a regular
                file, a StringIO object, or any other object which simulates a file.
                It defaults to None, in which case filename is opened to provide
                a file object.
        
                When fileobj is not None, the filename argument is only used to be
                included in the gzip file header, which may includes the original
                filename of the uncompressed file.  It defaults to the filename of
                fileobj, if discernible; otherwise, it defaults to the empty string,
                and in this case the original filename is not included in the header.
        
                The mode argument can be any of 'r', 'rb', 'a', 'ab', 'w', or 'wb',
                depending on whether the file will be read or written.  The default
                is the mode of fileobj if discernible; otherwise, the default is 'rb'.
                Be aware that only the 'rb', 'ab', and 'wb' values should be used
                for cross-platform portability.
        
                The compresslevel argument is an integer from 1 to 9 controlling the
                level of compression; 1 is fastest and produces the least compression,
                and 9 is slowest and produces the most compression.  The default is 9.
        
                The mtime argument is an optional numeric timestamp to be written
                to the stream when compressing.  All gzip compressed streams
                are required to contain a timestamp.  If omitted or None, the
                current time is used.  This module ignores the timestamp when
                decompressing; however, some programs, such as gunzip, make use
                of it.  The format of the timestamp is the same as that of the
                return value of time.time() and of the st_mtime member of the
                object returned by os.stat().
        """
        pass

    def __repr__(self, *args, **kwargs): # real signature unknown
        pass

    closed = property(lambda self: object()) # default
    filename = property(lambda self: object()) # default

    max_read_chunk = 10485760
    myfileobj = None
    _abc_cache = None # (!) real value is ''
    _abc_negative_cache = None # (!) real value is ''
    _abc_negative_cache_version = 18
    _abc_registry = None # (!) real value is ''
    __abstractmethods__ = None # (!) real value is ''


# variables with complex values

__all__ = [
    'GzipFile',
    'open',
]

