# encoding: utf-8
# module httplib
# from /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/httplib.pyo by generator 1.99
"""
HTTP/1.1 client library

<intro stuff goes here>
<other stuff, too>

HTTPConnection goes through a number of "states", which define when a client
may legally make another request or fetch the response for a particular
request. This diagram details these state transitions:

    (null)
      |
      | HTTPConnection()
      v
    Idle
      |
      | putrequest()
      v
    Request-started
      |
      | ( putheader() )*  endheaders()
      v
    Request-sent
      |
      | response = getresponse()
      v
    Unread-response   [Response-headers-read]
      |\____________________
      |                     |
      | response.read()     | putrequest()
      v                     v
    Idle                  Req-started-unread-response
                     ______/|
                   /        |
   response.read() |        | ( putheader() )*  endheaders()
                   v        v
       Request-started    Req-sent-unread-response
                            |
                            | response.read()
                            v
                          Request-sent

This diagram presents the following rules:
  -- a second request may not be started until {response-headers-read}
  -- a response [object] cannot be retrieved until {request-sent}
  -- there is no differentiation between an unread response body and a
     partially read response body

Note: this enforcement is applied by the HTTPConnection class. The
      HTTPResponse class does not enforce this state machine, which
      implies sophisticated clients may accelerate the request/response
      pipeline. Caution should be taken, though: accelerating the states
      beyond the above pattern may imply knowledge of the server's
      connection-close behavior for certain requests. For example, it
      is impossible to tell whether the server will close the connection
      UNTIL the response headers have been read; this means that further
      requests cannot be placed into the pipeline until it is known that
      the server will NOT be closing the connection.

Logical State                  __state            __response
-------------                  -------            ----------
Idle                           _CS_IDLE           None
Request-started                _CS_REQ_STARTED    None
Request-sent                   _CS_REQ_SENT       None
Unread-response                _CS_IDLE           <response_class>
Req-started-unread-response    _CS_REQ_STARTED    <response_class>
Req-sent-unread-response       _CS_REQ_SENT       <response_class>
"""

# imports
import ssl as ssl # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/ssl.pyc
import os as os # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/os.pyc
import socket as socket # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/socket.pyc
import mimetools as mimetools # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/mimetools.pyc
import warnings as warnings # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/warnings.pyc
from array import array

from cStringIO import StringIO


# Variables with simple values

ACCEPTED = 202

BAD_GATEWAY = 502
BAD_REQUEST = 400

CONFLICT = 409
CONTINUE = 100

CREATED = 201

EXPECTATION_FAILED = 417

FAILED_DEPENDENCY = 424

FORBIDDEN = 403
FOUND = 302

GATEWAY_TIMEOUT = 504

GONE = 410

HTTPS_PORT = 443

HTTP_PORT = 80

HTTP_VERSION_NOT_SUPPORTED = 505

IM_USED = 226

INSUFFICIENT_STORAGE = 507

INTERNAL_SERVER_ERROR = 500

LENGTH_REQUIRED = 411

LOCKED = 423

MAXAMOUNT = 1048576

METHOD_NOT_ALLOWED = 405

MOVED_PERMANENTLY = 301

MULTIPLE_CHOICES = 300

MULTI_STATUS = 207

NON_AUTHORITATIVE_INFORMATION = 203

NOT_ACCEPTABLE = 406
NOT_EXTENDED = 510
NOT_FOUND = 404
NOT_IMPLEMENTED = 501
NOT_MODIFIED = 304

NO_CONTENT = 204

OK = 200

PARTIAL_CONTENT = 206

PAYMENT_REQUIRED = 402

PRECONDITION_FAILED = 412

PROCESSING = 102

PROXY_AUTHENTICATION_REQUIRED = 407

py3kwarning = False

REQUESTED_RANGE_NOT_SATISFIABLE = 416

REQUEST_ENTITY_TOO_LARGE = 413

REQUEST_TIMEOUT = 408

REQUEST_URI_TOO_LONG = 414

RESET_CONTENT = 205

SEE_OTHER = 303

SERVICE_UNAVAILABLE = 503

SWITCHING_PROTOCOLS = 101

TEMPORARY_REDIRECT = 307

UNAUTHORIZED = 401

UNPROCESSABLE_ENTITY = 422

UNSUPPORTED_MEDIA_TYPE = 415

UPGRADE_REQUIRED = 426

USE_PROXY = 305

_CS_IDLE = 'Idle'

_CS_REQ_SENT = 'Request-sent'
_CS_REQ_STARTED = 'Request-started'

_UNKNOWN = 'UNKNOWN'

# functions

def FakeSocket(sock, sslobj): # reliably restored by inspect
    # no doc
    pass


def test(): # reliably restored by inspect
    """
    Test this module.
    
        A hodge podge of tests collected here, because they have too many
        external dependencies for the regular test suite.
    """
    pass


def urlsplit(url, scheme=None, allow_fragments=True): # reliably restored by inspect
    """
    Parse a URL into 5 components:
        <scheme>://<netloc>/<path>?<query>#<fragment>
        Return a 5-tuple: (scheme, netloc, path, query, fragment).
        Note that we don't break the components up in smaller bits
        (e.g. netloc is a single string) and we don't expand % escapes.
    """
    pass


# classes

class HTTPException(Exception):
    # no doc
    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default


error = HTTPException


class BadStatusLine(HTTPException):
    # no doc
    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class ImproperConnectionState(HTTPException):
    # no doc
    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class CannotSendHeader(ImproperConnectionState):
    # no doc
    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class CannotSendRequest(ImproperConnectionState):
    # no doc
    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class IncompleteRead(HTTPException):
    # no doc
    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    def __repr__(self, *args, **kwargs): # real signature unknown
        pass

    def __str__(self, *args, **kwargs): # real signature unknown
        pass


class InvalidURL(HTTPException):
    # no doc
    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class NotConnected(HTTPException):
    # no doc
    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class ResponseNotReady(ImproperConnectionState):
    # no doc
    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class UnimplementedFileMode(HTTPException):
    # no doc
    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class UnknownProtocol(HTTPException):
    # no doc
    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class UnknownTransferEncoding(HTTPException):
    # no doc
    def __init__(self, *args, **kwargs): # real signature unknown
        pass


# variables with complex values

HTTP = None # (!) real value is ''

HTTPConnection = None # (!) real value is ''

HTTPMessage = None # (!) real value is ''

HTTPResponse = None # (!) real value is ''

HTTPS = None # (!) real value is ''

HTTPSConnection = None # (!) real value is ''

LineAndFileWrapper = None # (!) real value is ''

responses = {
    100: 'Continue',
    101: 'Switching Protocols',
    200: 'OK',
    201: 'Created',
    202: 'Accepted',
    203: 'Non-Authoritative Information',
    204: 'No Content',
    205: 'Reset Content',
    206: 'Partial Content',
    300: 'Multiple Choices',
    301: 'Moved Permanently',
    302: 'Found',
    303: 'See Other',
    304: 'Not Modified',
    305: 'Use Proxy',
    306: '(Unused)',
    307: 'Temporary Redirect',
    400: 'Bad Request',
    401: 'Unauthorized',
    402: 'Payment Required',
    403: 'Forbidden',
    404: 'Not Found',
    405: 'Method Not Allowed',
    406: 'Not Acceptable',
    407: 'Proxy Authentication Required',
    408: 'Request Timeout',
    409: 'Conflict',
    410: 'Gone',
    411: 'Length Required',
    412: 'Precondition Failed',
    413: 'Request Entity Too Large',
    414: 'Request-URI Too Long',
    415: 'Unsupported Media Type',
    416: 'Requested Range Not Satisfiable',
    417: 'Expectation Failed',
    500: 'Internal Server Error',
    501: 'Not Implemented',
    502: 'Bad Gateway',
    503: 'Service Unavailable',
    504: 'Gateway Timeout',
    505: 'HTTP Version Not Supported',
}

__all__ = [
    'HTTP',
    'HTTPResponse',
    'HTTPConnection',
    'HTTPException',
    'NotConnected',
    'UnknownProtocol',
    'UnknownTransferEncoding',
    'UnimplementedFileMode',
    'IncompleteRead',
    'InvalidURL',
    'ImproperConnectionState',
    'CannotSendRequest',
    'CannotSendHeader',
    'ResponseNotReady',
    'BadStatusLine',
    'error',
    'responses',
    'HTTPSConnection',
]

