# encoding: utf-8
# module inspect
# from /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/inspect.pyo by generator 1.99
"""
Get useful information from live Python objects.

This module encapsulates the interface provided by the internal special
attributes (func_*, co_*, im_*, tb_*, etc.) in a friendlier fashion.
It also provides some help for examining source code and class layout.

Here are some of the useful functions provided by this module:

    ismodule(), isclass(), ismethod(), isfunction(), isgeneratorfunction(),
        isgenerator(), istraceback(), isframe(), iscode(), isbuiltin(),
        isroutine() - check object types
    getmembers() - get members of an object that satisfy a given condition

    getfile(), getsourcefile(), getsource() - find an object's source code
    getdoc(), getcomments() - get documentation on an object
    getmodule() - determine the module that an object came from
    getclasstree() - arrange classes so as to represent their hierarchy

    getargspec(), getargvalues(), getcallargs() - get info about function arguments
    formatargspec(), formatargvalues() - format an argument spec
    getouterframes(), getinnerframes() - get info about frames
    currentframe() - get the current stack frame
    stack(), trace() - get info about frames on the stack or in a traceback
"""

# imports
import re as re # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/re.pyc
import imp as imp # <module 'imp' (built-in)>
import string as string # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/string.pyc
import dis as dis # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/dis.pyc
import os as os # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/os.pyc
import tokenize as tokenize # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/tokenize.pyc
import sys as sys # <module 'sys' (built-in)>
import types as types # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/types.pyc
import linecache as linecache # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/linecache.pyc
from operator import attrgetter

from sys import currentframe


# Variables with simple values

CO_GENERATOR = 32
CO_NESTED = 16
CO_NEWLOCALS = 2
CO_NOFREE = 64
CO_OPTIMIZED = 1
CO_VARARGS = 4
CO_VARKEYWORDS = 8

TPFLAGS_IS_ABSTRACT = 1048576

__author__ = 'Ka-Ping Yee <ping@lfw.org>'

__date__ = '1 Jan 2001'

# functions

def classify_class_attrs(cls): # reliably restored by inspect
    """
    Return list of attribute-descriptor tuples.
    
        For each name in dir(cls), the return list contains a 4-tuple
        with these elements:
    
            0. The name (a string).
    
            1. The kind of attribute this is, one of these strings:
                   'class method'    created via classmethod()
                   'static method'   created via staticmethod()
                   'property'        created via property()
                   'method'          any other flavor of method
                   'data'            not a method
    
            2. The class which defined this attribute (a class).
    
            3. The object as obtained directly from the defining class's
               __dict__, not via getattr.  This is especially important for
               data attributes:  C.data is just a data object, but
               C.__dict__['data'] may be a data descriptor with additional
               info, like a __doc__ string.
    """
    pass


def cleandoc(doc): # reliably restored by inspect
    """
    Clean up indentation from docstrings.
    
        Any whitespace that can be uniformly removed from the second line
        onwards is removed.
    """
    pass


def findsource(object): # reliably restored by inspect
    """
    Return the entire source file and starting line number for an object.
    
        The argument may be a module, class, method, function, traceback, frame,
        or code object.  The source code is returned as a list of all the lines
        in the file and the line number indexes a line in that list.  An IOError
        is raised if the source code cannot be retrieved.
    """
    pass


def formatargspec(args, varargs=None, varkw=None, defaults=None, formatarg=str, formatvarargs='<function <lambda> at 0x106d09a28>', formatvarkw='<function <lambda> at 0x106d09aa0>', formatvalue='<function <lambda> at 0x106d09b18>', join='<function joinseq at 0x106d09938>'): # reliably restored by inspect
    """
    Format an argument spec from the 4 values returned by getargspec.
    
        The first four arguments are (args, varargs, varkw, defaults).  The
        other four arguments are the corresponding optional formatting functions
        that are called to turn names and values into strings.  The ninth
        argument is an optional function to format the sequence of arguments.
    """
    pass


def formatargvalues(args, varargs, varkw, locals, formatarg=str, formatvarargs='<function <lambda> at 0x106d09c80>', formatvarkw='<function <lambda> at 0x106d09cf8>', formatvalue='<function <lambda> at 0x106d09d70>', join='<function joinseq at 0x106d09938>'): # reliably restored by inspect
    """
    Format an argument spec from the 4 values returned by getargvalues.
    
        The first four arguments are (args, varargs, varkw, locals).  The
        next four arguments are the corresponding optional formatting functions
        that are called to turn names and values into strings.  The ninth
        argument is an optional function to format the sequence of arguments.
    """
    pass


def getabsfile(object, _filename=None): # reliably restored by inspect
    """
    Return an absolute path to the source or compiled file for an object.
    
        The idea is for each object to have a unique origin, so this routine
        normalizes the result as much as possible.
    """
    pass


def getargs(co): # reliably restored by inspect
    """
    Get information about the arguments accepted by a code object.
    
        Three things are returned: (args, varargs, varkw), where 'args' is
        a list of argument names (possibly containing nested lists), and
        'varargs' and 'varkw' are the names of the * and ** arguments or None.
    """
    pass


def getargspec(func): # reliably restored by inspect
    """
    Get the names and default values of a function's arguments.
    
        A tuple of four things is returned: (args, varargs, varkw, defaults).
        'args' is a list of the argument names (it may contain nested lists).
        'varargs' and 'varkw' are the names of the * and ** arguments or None.
        'defaults' is an n-tuple of the default values of the last n arguments.
    """
    pass


def getargvalues(frame): # reliably restored by inspect
    """
    Get information about arguments passed into a particular frame.
    
        A tuple of four things is returned: (args, varargs, varkw, locals).
        'args' is a list of the argument names (it may contain nested lists).
        'varargs' and 'varkw' are the names of the * and ** arguments or None.
        'locals' is the locals dictionary of the given frame.
    """
    pass


def getblock(lines): # reliably restored by inspect
    """ Extract the block of code at the top of the given list of lines. """
    pass


def getcallargs(func, *positional, **named): # reliably restored by inspect
    """
    Get the mapping of arguments to values.
    
        A dict is returned, with keys the function argument names (including the
        names of the * and ** arguments, if any), and values the respective bound
        values from 'positional' and 'named'.
    """
    pass


def getclasstree(classes, unique=0): # reliably restored by inspect
    """
    Arrange the given list of classes into a hierarchy of nested lists.
    
        Where a nested list appears, it contains classes derived from the class
        whose entry immediately precedes the list.  Each entry is a 2-tuple
        containing a class and a tuple of its base classes.  If the 'unique'
        argument is true, exactly one entry appears in the returned structure
        for each class in the given list.  Otherwise, classes using multiple
        inheritance and their descendants will appear multiple times.
    """
    pass


def getcomments(object): # reliably restored by inspect
    """
    Get lines of comments immediately preceding an object's source code.
    
        Returns None when source can't be found.
    """
    pass


def getdoc(object): # reliably restored by inspect
    """
    Get the documentation string for an object.
    
        All tabs are expanded to spaces.  To clean up docstrings that are
        indented to line up with blocks of code, any whitespace than can be
        uniformly removed from the second line onwards is removed.
    """
    pass


def getfile(object): # reliably restored by inspect
    """ Work out which source or compiled file an object was defined in. """
    pass


def getframeinfo(frame, context=1): # reliably restored by inspect
    """
    Get information about a frame or traceback object.
    
        A tuple of five things is returned: the filename, the line number of
        the current line, the function name, a list of lines of context from
        the source code, and the index of the current line within that list.
        The optional second argument specifies the number of lines of context
        to return, which are centered around the current line.
    """
    pass


def getinnerframes(tb, context=1): # reliably restored by inspect
    """
    Get a list of records for a traceback's frame and all lower frames.
    
        Each record contains a frame object, filename, line number, function
        name, a list of lines of context, and index within the context.
    """
    pass


def getlineno(frame): # reliably restored by inspect
    """ Get the line number from a frame object, allowing for optimization. """
    pass


def getmembers(object, predicate=None): # reliably restored by inspect
    """
    Return all members of an object as (name, value) pairs sorted by name.
        Optionally, only return members that satisfy a given predicate.
    """
    pass


def getmodule(object, _filename=None): # reliably restored by inspect
    """ Return the module an object was defined in, or None if not found. """
    pass


def getmoduleinfo(path): # reliably restored by inspect
    """ Get the module name, suffix, mode, and module type for a given file. """
    pass


def getmodulename(path): # reliably restored by inspect
    """ Return the module name for a given file, or None. """
    pass


def getmro(cls): # reliably restored by inspect
    """ Return tuple of base classes (including cls) in method resolution order. """
    pass


def getouterframes(frame, context=1): # reliably restored by inspect
    """
    Get a list of records for a frame and all higher (calling) frames.
    
        Each record contains a frame object, filename, line number, function
        name, a list of lines of context, and index within the context.
    """
    pass


def getsource(object): # reliably restored by inspect
    """
    Return the text of the source code for an object.
    
        The argument may be a module, class, method, function, traceback, frame,
        or code object.  The source code is returned as a single string.  An
        IOError is raised if the source code cannot be retrieved.
    """
    pass


def getsourcefile(object): # reliably restored by inspect
    """
    Return the filename that can be used to locate an object's source.
        Return None if no way can be identified to get the source.
    """
    pass


def getsourcelines(object): # reliably restored by inspect
    """
    Return a list of source lines and starting line number for an object.
    
        The argument may be a module, class, method, function, traceback, frame,
        or code object.  The source code is returned as a list of the lines
        corresponding to the object and the line number indicates where in the
        original source file the first line of code was found.  An IOError is
        raised if the source code cannot be retrieved.
    """
    pass


def indentsize(line): # reliably restored by inspect
    """ Return the indent size, in spaces, at the start of a line of text. """
    pass


def isabstract(object): # reliably restored by inspect
    """ Return true if the object is an abstract base class (ABC). """
    pass


def isbuiltin(object): # reliably restored by inspect
    """
    Return true if the object is a built-in function or method.
    
        Built-in functions and methods provide these attributes:
            __doc__         documentation string
            __name__        original name of this function or method
            __self__        instance to which a method is bound, or None
    """
    pass


def isclass(object): # reliably restored by inspect
    """
    Return true if the object is a class.
    
        Class objects provide these attributes:
            __doc__         documentation string
            __module__      name of module in which this class was defined
    """
    pass


def iscode(object): # reliably restored by inspect
    """
    Return true if the object is a code object.
    
        Code objects provide these attributes:
            co_argcount     number of arguments (not including * or ** args)
            co_code         string of raw compiled bytecode
            co_consts       tuple of constants used in the bytecode
            co_filename     name of file in which this code object was created
            co_firstlineno  number of first line in Python source code
            co_flags        bitmap: 1=optimized | 2=newlocals | 4=*arg | 8=**arg
            co_lnotab       encoded mapping of line numbers to bytecode indices
            co_name         name with which this code object was defined
            co_names        tuple of names of local variables
            co_nlocals      number of local variables
            co_stacksize    virtual machine stack space required
            co_varnames     tuple of names of arguments and local variables
    """
    pass


def isdatadescriptor(object): # reliably restored by inspect
    """
    Return true if the object is a data descriptor.
    
        Data descriptors have both a __get__ and a __set__ attribute.  Examples are
        properties (defined in Python) and getsets and members (defined in C).
        Typically, data descriptors will also have __name__ and __doc__ attributes
        (properties, getsets, and members have both of these attributes), but this
        is not guaranteed.
    """
    pass


def isframe(object): # reliably restored by inspect
    """
    Return true if the object is a frame object.
    
        Frame objects provide these attributes:
            f_back          next outer frame object (this frame's caller)
            f_builtins      built-in namespace seen by this frame
            f_code          code object being executed in this frame
            f_exc_traceback traceback if raised in this frame, or None
            f_exc_type      exception type if raised in this frame, or None
            f_exc_value     exception value if raised in this frame, or None
            f_globals       global namespace seen by this frame
            f_lasti         index of last attempted instruction in bytecode
            f_lineno        current line number in Python source code
            f_locals        local namespace seen by this frame
            f_restricted    0 or 1 if frame is in restricted execution mode
            f_trace         tracing function for this frame, or None
    """
    pass


def isfunction(object): # reliably restored by inspect
    """
    Return true if the object is a user-defined function.
    
        Function objects provide these attributes:
            __doc__         documentation string
            __name__        name with which this function was defined
            func_code       code object containing compiled function bytecode
            func_defaults   tuple of any default values for arguments
            func_doc        (same as __doc__)
            func_globals    global namespace in which this function was defined
            func_name       (same as __name__)
    """
    pass


def isgenerator(object): # reliably restored by inspect
    """
    Return true if the object is a generator.
    
        Generator objects provide these attributes:
            __iter__        defined to support interation over container
            close           raises a new GeneratorExit exception inside the
                            generator to terminate the iteration
            gi_code         code object
            gi_frame        frame object or possibly None once the generator has
                            been exhausted
            gi_running      set to 1 when generator is executing, 0 otherwise
            next            return the next item from the container
            send            resumes the generator and "sends" a value that becomes
                            the result of the current yield-expression
            throw           used to raise an exception inside the generator
    """
    pass


def isgeneratorfunction(object): # reliably restored by inspect
    """
    Return true if the object is a user-defined generator function.
    
        Generator function objects provides same attributes as functions.
    
        See help(isfunction) for attributes listing.
    """
    pass


def isgetsetdescriptor(object): # reliably restored by inspect
    """
    Return true if the object is a getset descriptor.
    
            getset descriptors are specialized descriptors defined in extension
            modules.
    """
    pass


def ismemberdescriptor(object): # reliably restored by inspect
    """
    Return true if the object is a member descriptor.
    
            Member descriptors are specialized descriptors defined in extension
            modules.
    """
    pass


def ismethod(object): # reliably restored by inspect
    """
    Return true if the object is an instance method.
    
        Instance method objects provide these attributes:
            __doc__         documentation string
            __name__        name with which this method was defined
            im_class        class object in which this method belongs
            im_func         function object containing implementation of method
            im_self         instance to which this method is bound, or None
    """
    pass


def ismethoddescriptor(object): # reliably restored by inspect
    """
    Return true if the object is a method descriptor.
    
        But not if ismethod() or isclass() or isfunction() are true.
    
        This is new in Python 2.2, and, for example, is true of int.__add__.
        An object passing this test has a __get__ attribute but not a __set__
        attribute, but beyond that the set of attributes varies.  __name__ is
        usually sensible, and __doc__ often is.
    
        Methods implemented via descriptors that also pass one of the other
        tests return false from the ismethoddescriptor() test, simply because
        the other tests promise more -- you can, e.g., count on having the
        im_func attribute (etc) when an object passes ismethod().
    """
    pass


def ismodule(object): # reliably restored by inspect
    """
    Return true if the object is a module.
    
        Module objects provide these attributes:
            __doc__         documentation string
            __file__        filename (missing for built-in modules)
    """
    pass


def isroutine(object): # reliably restored by inspect
    """ Return true if the object is any kind of function or method. """
    pass


def istraceback(object): # reliably restored by inspect
    """
    Return true if the object is a traceback.
    
        Traceback objects provide these attributes:
            tb_frame        frame object at this level
            tb_lasti        index of last attempted instruction in bytecode
            tb_lineno       current line number in Python source code
            tb_next         next inner traceback object (called by this level)
    """
    pass


def joinseq(seq): # reliably restored by inspect
    # no doc
    pass


def namedtuple(typename, field_names, verbose=False, rename=False): # reliably restored by inspect
    """
    Returns a new subclass of tuple with named fields.
    
        >>> Point = namedtuple('Point', 'x y')
        >>> Point.__doc__                   # docstring for the new class
        'Point(x, y)'
        >>> p = Point(11, y=22)             # instantiate with positional args or keywords
        >>> p[0] + p[1]                     # indexable like a plain tuple
        33
        >>> x, y = p                        # unpack like a regular tuple
        >>> x, y
        (11, 22)
        >>> p.x + p.y                       # fields also accessable by name
        33
        >>> d = p._asdict()                 # convert to a dictionary
        >>> d['x']
        11
        >>> Point(**d)                      # convert from a dictionary
        Point(x=11, y=22)
        >>> p._replace(x=100)               # _replace() is like str.replace() but targets named fields
        Point(x=100, y=22)
    """
    pass


def stack(context=1): # reliably restored by inspect
    """ Return a list of records for the stack above the caller's frame. """
    pass


def strseq(object, convert, join='<function joinseq at 0x106d09938>'): # reliably restored by inspect
    """ Recursively walk a sequence, stringifying each element. """
    pass


def trace(context=1): # reliably restored by inspect
    """ Return a list of records for the stack below the current exception. """
    pass


def walktree(classes, children, parent): # reliably restored by inspect
    """ Recursive helper function for getclasstree(). """
    pass


def _searchbases(cls, accum): # reliably restored by inspect
    # no doc
    pass


# classes

class ArgInfo(tuple):
    """ ArgInfo(args, varargs, keywords, locals) """
    def _asdict(self, *args, **kwargs): # real signature unknown
        """ Return a new OrderedDict which maps field names to their values """
        pass

    @classmethod
    def _make(cls, *args, **kwargs): # real signature unknown
        """ Make a new ArgInfo object from a sequence or iterable """
        pass

    def _replace(self, *args, **kwargs): # real signature unknown
        """ Return a new ArgInfo object replacing specified fields with new values """
        pass

    def __getnewargs__(self, *args, **kwargs): # real signature unknown
        """ Return self as a plain tuple.  Used by copy and pickle. """
        pass

    def __init__(self, args, varargs, keywords, locals): # real signature unknown; restored from __doc__
        pass

    @staticmethod # known case of __new__
    def __new__(_cls, args, varargs, keywords, locals): # reliably restored by inspect
        """ Create new instance of ArgInfo(args, varargs, keywords, locals) """
        pass

    def __repr__(self, *args, **kwargs): # real signature unknown
        """ Return a nicely formatted representation string """
        pass

    args = property(lambda self: object()) # default
    keywords = property(lambda self: object()) # default
    locals = property(lambda self: object()) # default
    varargs = property(lambda self: object()) # default

    _fields = (
        'args',
        'varargs',
        'keywords',
        'locals',
    )
    __slots__ = ()


class ArgSpec(tuple):
    """ ArgSpec(args, varargs, keywords, defaults) """
    def _asdict(self, *args, **kwargs): # real signature unknown
        """ Return a new OrderedDict which maps field names to their values """
        pass

    @classmethod
    def _make(cls, *args, **kwargs): # real signature unknown
        """ Make a new ArgSpec object from a sequence or iterable """
        pass

    def _replace(self, *args, **kwargs): # real signature unknown
        """ Return a new ArgSpec object replacing specified fields with new values """
        pass

    def __getnewargs__(self, *args, **kwargs): # real signature unknown
        """ Return self as a plain tuple.  Used by copy and pickle. """
        pass

    def __init__(self, args, varargs, keywords, defaults): # real signature unknown; restored from __doc__
        pass

    @staticmethod # known case of __new__
    def __new__(_cls, args, varargs, keywords, defaults): # reliably restored by inspect
        """ Create new instance of ArgSpec(args, varargs, keywords, defaults) """
        pass

    def __repr__(self, *args, **kwargs): # real signature unknown
        """ Return a nicely formatted representation string """
        pass

    args = property(lambda self: object()) # default
    defaults = property(lambda self: object()) # default
    keywords = property(lambda self: object()) # default
    varargs = property(lambda self: object()) # default

    _fields = (
        'args',
        'varargs',
        'keywords',
        'defaults',
    )
    __slots__ = ()


class Arguments(tuple):
    """ Arguments(args, varargs, keywords) """
    def _asdict(self, *args, **kwargs): # real signature unknown
        """ Return a new OrderedDict which maps field names to their values """
        pass

    @classmethod
    def _make(cls, *args, **kwargs): # real signature unknown
        """ Make a new Arguments object from a sequence or iterable """
        pass

    def _replace(self, *args, **kwargs): # real signature unknown
        """ Return a new Arguments object replacing specified fields with new values """
        pass

    def __getnewargs__(self, *args, **kwargs): # real signature unknown
        """ Return self as a plain tuple.  Used by copy and pickle. """
        pass

    def __init__(self, args, varargs, keywords): # real signature unknown; restored from __doc__
        pass

    @staticmethod # known case of __new__
    def __new__(_cls, args, varargs, keywords): # reliably restored by inspect
        """ Create new instance of Arguments(args, varargs, keywords) """
        pass

    def __repr__(self, *args, **kwargs): # real signature unknown
        """ Return a nicely formatted representation string """
        pass

    args = property(lambda self: object()) # default
    keywords = property(lambda self: object()) # default
    varargs = property(lambda self: object()) # default

    _fields = (
        'args',
        'varargs',
        'keywords',
    )
    __slots__ = ()


class Attribute(tuple):
    """ Attribute(name, kind, defining_class, object) """
    def _asdict(self, *args, **kwargs): # real signature unknown
        """ Return a new OrderedDict which maps field names to their values """
        pass

    @classmethod
    def _make(cls, *args, **kwargs): # real signature unknown
        """ Make a new Attribute object from a sequence or iterable """
        pass

    def _replace(self, *args, **kwargs): # real signature unknown
        """ Return a new Attribute object replacing specified fields with new values """
        pass

    def __getnewargs__(self, *args, **kwargs): # real signature unknown
        """ Return self as a plain tuple.  Used by copy and pickle. """
        pass

    def __init__(self, name, kind, defining_class, p_object): # real signature unknown; restored from __doc__
        pass

    @staticmethod # known case of __new__
    def __new__(_cls, name, kind, defining_class, object): # reliably restored by inspect
        """ Create new instance of Attribute(name, kind, defining_class, object) """
        pass

    def __repr__(self, *args, **kwargs): # real signature unknown
        """ Return a nicely formatted representation string """
        pass

    defining_class = property(lambda self: object()) # default
    kind = property(lambda self: object()) # default
    name = property(lambda self: object()) # default
    object = property(lambda self: object()) # default

    _fields = (
        'name',
        'kind',
        'defining_class',
        'object',
    )
    __slots__ = ()


class EndOfBlock(Exception):
    # no doc
    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default


class ModuleInfo(tuple):
    """ ModuleInfo(name, suffix, mode, module_type) """
    def _asdict(self, *args, **kwargs): # real signature unknown
        """ Return a new OrderedDict which maps field names to their values """
        pass

    @classmethod
    def _make(cls, *args, **kwargs): # real signature unknown
        """ Make a new ModuleInfo object from a sequence or iterable """
        pass

    def _replace(self, *args, **kwargs): # real signature unknown
        """ Return a new ModuleInfo object replacing specified fields with new values """
        pass

    def __getnewargs__(self, *args, **kwargs): # real signature unknown
        """ Return self as a plain tuple.  Used by copy and pickle. """
        pass

    def __init__(self, name, suffix, mode, module_type): # real signature unknown; restored from __doc__
        pass

    @staticmethod # known case of __new__
    def __new__(_cls, name, suffix, mode, module_type): # reliably restored by inspect
        """ Create new instance of ModuleInfo(name, suffix, mode, module_type) """
        pass

    def __repr__(self, *args, **kwargs): # real signature unknown
        """ Return a nicely formatted representation string """
        pass

    mode = property(lambda self: object()) # default
    module_type = property(lambda self: object()) # default
    name = property(lambda self: object()) # default
    suffix = property(lambda self: object()) # default

    _fields = (
        'name',
        'suffix',
        'mode',
        'module_type',
    )
    __slots__ = ()


class Traceback(tuple):
    """ Traceback(filename, lineno, function, code_context, index) """
    def _asdict(self, *args, **kwargs): # real signature unknown
        """ Return a new OrderedDict which maps field names to their values """
        pass

    @classmethod
    def _make(cls, *args, **kwargs): # real signature unknown
        """ Make a new Traceback object from a sequence or iterable """
        pass

    def _replace(self, *args, **kwargs): # real signature unknown
        """ Return a new Traceback object replacing specified fields with new values """
        pass

    def __getnewargs__(self, *args, **kwargs): # real signature unknown
        """ Return self as a plain tuple.  Used by copy and pickle. """
        pass

    def __init__(self, filename, lineno, function, code_context, index): # real signature unknown; restored from __doc__
        pass

    @staticmethod # known case of __new__
    def __new__(_cls, filename, lineno, function, code_context, index): # reliably restored by inspect
        """ Create new instance of Traceback(filename, lineno, function, code_context, index) """
        pass

    def __repr__(self, *args, **kwargs): # real signature unknown
        """ Return a nicely formatted representation string """
        pass

    code_context = property(lambda self: object()) # default
    filename = property(lambda self: object()) # default
    function = property(lambda self: object()) # default
    index = property(lambda self: object()) # default
    lineno = property(lambda self: object()) # default

    _fields = (
        'filename',
        'lineno',
        'function',
        'code_context',
        'index',
    )
    __slots__ = ()


# variables with complex values

BlockFinder = None # (!) real value is ''

modulesbyfile = {}

_filesbymodname = {}

