# encoding: utf-8
# module json.decoder
# from /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/json/decoder.pyo by generator 1.99
""" Implementation of JSONDecoder """

# imports
import struct as struct # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/struct.pyc
import re as re # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/re.pyc
import sys as sys # <module 'sys' (built-in)>
from _json import c_scanstring, make_scanner, scanstring


# Variables with simple values

DEFAULT_ENCODING = 'utf-8'

FLAGS = 88

NaN = nan

NegInf = -inf

PosInf = inf

WHITESPACE_STR = ' \t\n\r'

# functions

def errmsg(msg, doc, pos, end=None): # reliably restored by inspect
    # no doc
    pass


def JSONArray(s_and_end, scan_once, _w='<built-in method match of _sre.SRE_Pattern object at 0x108a17780>', _ws=None): # reliably restored by inspect
    # no doc
    pass


def JSONObject(s_and_end, encoding, strict, scan_once, object_hook, object_pairs_hook, _w='<built-in method match of _sre.SRE_Pattern object at 0x108a17780>', _ws=None): # reliably restored by inspect
    # no doc
    pass


def linecol(doc, pos): # reliably restored by inspect
    # no doc
    pass


def py_scanstring(s, end, encoding=None, strict=True, _b='{\'r\': u\'\\r\', \'"\': u\'"\', \'t\': u\'\\t\', \'f\': u\'\\x0c\', \'b\': u\'\\x08\', \'\\\\\': u\'\\\\\', \'/\': u\'/\', \'n\': u\'\\n\'}', _m='<built-in method match of _sre.SRE_Pattern object at 0x1089ca570>'): # reliably restored by inspect
    """
    Scan the string s for a JSON string. End is the index of the
        character in s after the quote that started the JSON string.
        Unescapes all valid JSON string escape sequences and raises ValueError
        on attempt to decode an invalid string. If strict is False then literal
        control characters are allowed in the string.
    
        Returns a tuple of the decoded string and the index of the character in s
        after the end quote.
    """
    pass


def _floatconstants(): # reliably restored by inspect
    # no doc
    pass


# classes

class JSONDecoder(object):
    """
    Simple JSON <http://json.org> decoder
    
        Performs the following translations in decoding by default:
    
        +---------------+-------------------+
        | JSON          | Python            |
        +===============+===================+
        | object        | dict              |
        +---------------+-------------------+
        | array         | list              |
        +---------------+-------------------+
        | string        | unicode           |
        +---------------+-------------------+
        | number (int)  | int, long         |
        +---------------+-------------------+
        | number (real) | float             |
        +---------------+-------------------+
        | true          | True              |
        +---------------+-------------------+
        | false         | False             |
        +---------------+-------------------+
        | null          | None              |
        +---------------+-------------------+
    
        It also understands ``NaN``, ``Infinity``, and ``-Infinity`` as
        their corresponding ``float`` values, which is outside the JSON spec.
    """
    def decode(self, *args, **kwargs): # real signature unknown
        """
        Return the Python representation of ``s`` (a ``str`` or ``unicode``
                instance containing a JSON document)
        """
        pass

    def raw_decode(self, *args, **kwargs): # real signature unknown
        """
        Decode a JSON document from ``s`` (a ``str`` or ``unicode``
                beginning with a JSON document) and return a 2-tuple of the Python
                representation and the index in ``s`` where the document ended.
        
                This can be used to decode a JSON document from a string that may
                have extraneous data at the end.
        """
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        """
        ``encoding`` determines the encoding used to interpret any ``str``
                objects decoded by this instance (utf-8 by default).  It has no
                effect when decoding ``unicode`` objects.
        
                Note that currently only encodings that are a superset of ASCII work,
                strings of other encodings should be passed in as ``unicode``.
        
                ``object_hook``, if specified, will be called with the result
                of every JSON object decoded and its return value will be used in
                place of the given ``dict``.  This can be used to provide custom
                deserializations (e.g. to support JSON-RPC class hinting).
        
                ``object_pairs_hook``, if specified will be called with the result of
                every JSON object decoded with an ordered list of pairs.  The return
                value of ``object_pairs_hook`` will be used instead of the ``dict``.
                This feature can be used to implement custom decoders that rely on the
                order that the key and value pairs are decoded (for example,
                collections.OrderedDict will remember the order of insertion). If
                ``object_hook`` is also defined, the ``object_pairs_hook`` takes
                priority.
        
                ``parse_float``, if specified, will be called with the string
                of every JSON float to be decoded. By default this is equivalent to
                float(num_str). This can be used to use another datatype or parser
                for JSON floats (e.g. decimal.Decimal).
        
                ``parse_int``, if specified, will be called with the string
                of every JSON int to be decoded. By default this is equivalent to
                int(num_str). This can be used to use another datatype or parser
                for JSON integers (e.g. float).
        
                ``parse_constant``, if specified, will be called with one of the
                following strings: -Infinity, Infinity, NaN.
                This can be used to raise an exception if invalid JSON numbers
                are encountered.
        
                If ``strict`` is false (true is the default), then control
                characters will be allowed inside strings.  Control characters in
                this context are those with character codes in the 0-31 range,
                including ``'\t'`` (tab), ``'\n'``, ``'\r'`` and ``'\0'``.
        """
        pass

    __weakref__ = property(lambda self: object()) # default

    __dict__ = None # (!) real value is ''


# variables with complex values

BACKSLASH = {
    '"': u'"',
    '/': u'/',
    '\\': u'\\',
    'b': u'\x08',
    'f': u'\x0c',
    'n': u'\n',
    'r': u'\r',
    't': u'\t',
}

STRINGCHUNK = None # (!) real value is ''

WHITESPACE = None # (!) real value is ''

_CONSTANTS = {
    '-Infinity': -inf,
    'Infinity': inf,
    'NaN': nan,
}

__all__ = [
    'JSONDecoder',
]

