# encoding: utf-8
# module lib2to3.btm_matcher
# from /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/lib2to3/btm_matcher.pyo by generator 1.99
"""
A bottom-up tree matching algorithm implementation meant to speed
up 2to3's matching process. After the tree patterns are reduced to
their rarest linear path, a linear Aho-Corasick automaton is
created. The linear automaton traverses the linear paths from the
leaves to the root of the AST and returns a set of nodes for further
matching. This reduces significantly the number of candidate nodes.
"""

# imports
import logging as logging # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/logging/__init__.pyc
import lib2to3.pytree as pytree # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/lib2to3/pytree.pyc
import itertools as itertools # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/lib-dynload/itertools.so

# Variables with simple values

__author__ = 'George Boutsioukis <gboutsioukis@gmail.com>'

# functions

def reduce_tree(node, parent=None): # reliably restored by inspect
    """
    Internal function. Reduces a compiled pattern tree to an
        intermediate representation suitable for feeding the
        automaton. This also trims off any optional pattern elements(like
        [a], a*).
    """
    pass


def type_repr(type_num): # reliably restored by inspect
    # no doc
    pass


# classes

class BMNode(object):
    """ Class for a node of the Aho-Corasick automaton used in matching """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default

    count = None # (!) real value is ''
    __dict__ = None # (!) real value is ''


class BottomMatcher(object):
    """
    The main matcher class. After instantiating the patterns should
        be added using the add_fixer method
    """
    def add(self, *args, **kwargs): # real signature unknown
        """ Recursively adds a linear pattern to the AC automaton """
        pass

    def add_fixer(self, *args, **kwargs): # real signature unknown
        """
        Reduces a fixer's pattern tree to a linear path and adds it
                to the matcher(a common Aho-Corasick automaton). The fixer is
                appended on the matching states and called when they are
                reached
        """
        pass

    def print_ac(self, *args, **kwargs): # real signature unknown
        """ Prints a graphviz diagram of the BM automaton(for debugging) """
        pass

    def run(self, *args, **kwargs): # real signature unknown
        """
        The main interface with the bottom matcher. The tree is
                traversed from the bottom using the constructed
                automaton. Nodes are only checked once as the tree is
                retraversed. When the automaton fails, we give it one more
                shot(in case the above tree matches as a whole with the
                rejected leaf), then we break for the next leaf. There is the
                special case of multiple arguments(see code comments) where we
                recheck the nodes
        
                Args:
                   The leaves of the AST tree to be matched
        
                Returns:
                   A dictionary of node matches with fixers as the keys
        """
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default

    __dict__ = None # (!) real value is ''


class defaultdict(dict):
    """
    defaultdict(default_factory) --> dict with default factory
    
    The default factory is called without arguments to produce
    a new value when a key is not present, in __getitem__ only.
    A defaultdict compares equal to a dict with the same items.
    """
    def copy(self): # real signature unknown; restored from __doc__
        """ D.copy() -> a shallow copy of D. """
        pass

    def __copy__(self, *args, **kwargs): # real signature unknown
        """ D.copy() -> a shallow copy of D. """
        pass

    def __getattribute__(self, name): # real signature unknown; restored from __doc__
        """ x.__getattribute__('name') <==> x.name """
        pass

    def __init__(self, default_factory): # real signature unknown; restored from __doc__
        pass

    def __missing__(self, key): # real signature unknown; restored from __doc__
        """
        __missing__(key) # Called by __getitem__ for missing key; pseudo-code:
          if self.default_factory is None: raise KeyError((key,))
          self[key] = value = self.default_factory()
          return value
        """
        pass

    def __reduce__(self, *args, **kwargs): # real signature unknown
        """ Return state information for pickling. """
        pass

    def __repr__(self): # real signature unknown; restored from __doc__
        """ x.__repr__() <==> repr(x) """
        pass

    default_factory = property(lambda self: object()) # default


# variables with complex values

_type_reprs = {}

