# encoding: utf-8
# module lib2to3.fixer_base
# from /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/lib2to3/fixer_base.pyo by generator 1.99
""" Base class for fixers (optional, but recommended). """

# imports
import logging as logging # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/logging/__init__.pyc
import lib2to3.pygram as pygram # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/lib2to3/pygram.pyc
import itertools as itertools # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/lib-dynload/itertools.so

# functions

def does_tree_import(package, name, node): # reliably restored by inspect
    """
    Returns true if name is imported from package at the
            top level of the tree which node belongs to.
            To cover the case of an import like 'import foo', use
            None for the package and 'foo' for the name.
    """
    pass


# classes

class BaseFix(object):
    """
    Optional base class for fixers.
    
        The subclass name must be FixFooBar where FooBar is the result of
        removing underscores and capitalizing the words of the fix name.
        For example, the class name for a fixer named 'has_key' should be
        FixHasKey.
    """
    def cannot_convert(self, *args, **kwargs): # real signature unknown
        """
        Warn the user that a given chunk of code is not valid Python 3,
                but that it cannot be converted automatically.
        
                First argument is the top-level node for the code in question.
                Optional second argument is why it can't be converted.
        """
        pass

    def compile_pattern(self, *args, **kwargs): # real signature unknown
        """
        Compiles self.PATTERN into self.pattern.
        
                Subclass may override if it doesn't want to use
                self.{pattern,PATTERN} in .match().
        """
        pass

    def finish_tree(self, *args, **kwargs): # real signature unknown
        """
        Some fixers need to maintain tree-wide state.
                This method is called once, at the conclusion of tree fix-up.
        
                tree - the root node of the tree to be processed.
                filename - the name of the file the tree came from.
        """
        pass

    def log_message(self, *args, **kwargs): # real signature unknown
        pass

    def match(self, *args, **kwargs): # real signature unknown
        """
        Returns match for a given parse tree node.
        
                Should return a true or false object (not necessarily a bool).
                It may return a non-empty dict of matching sub-nodes as
                returned by a matching pattern.
        
                Subclass may override.
        """
        pass

    def new_name(self, *args, **kwargs): # real signature unknown
        """
        Return a string suitable for use as an identifier
        
                The new name is guaranteed not to conflict with other identifiers.
        """
        pass

    def set_filename(self, *args, **kwargs): # real signature unknown
        """
        Set the filename, and a logger derived from it.
        
                The main refactoring tool should call this.
        """
        pass

    def start_tree(self, *args, **kwargs): # real signature unknown
        """
        Some fixers need to maintain tree-wide state.
                This method is called once, at the start of tree fix-up.
        
                tree - the root node of the tree to be processed.
                filename - the name of the file the tree came from.
        """
        pass

    def transform(self, *args, **kwargs): # real signature unknown
        """
        Returns the transformation for a given parse tree node.
        
                Args:
                  node: the root of the parse tree that matched the fixer.
                  results: a dict mapping symbolic names to part of the match.
        
                Returns:
                  None, or a node that is a modified copy of the
                  argument node.  The node argument may also be modified in-place to
                  effect the same change.
        
                Subclass *must* override.
        """
        pass

    def warning(self, *args, **kwargs): # real signature unknown
        """
        Used for warning the user about possible uncertainty in the
                translation.
        
                First argument is the top-level node for the code in question.
                Optional second argument is why it can't be converted.
        """
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        """
        Initializer.  Subclass may override.
        
                Args:
                    options: an dict containing the options passed to RefactoringTool
                    that could be used to customize the fixer through the command line.
                    log: a list to append warnings and other messages to.
        """
        pass

    __weakref__ = property(lambda self: object()) # default

    BM_compatible = False
    explicit = False
    filename = None
    keep_line_order = False
    logger = None
    numbers = None # (!) real value is ''
    options = None
    order = 'post'
    PATTERN = None
    pattern = None
    pattern_tree = None
    run_order = 5
    syms = pygram.python_symbols
    used_names = None # (!) real value is ''
    _accept_type = None
    __dict__ = None # (!) real value is ''


class ConditionalFix(BaseFix):
    """ Base class for fixers which not execute if an import is found. """
    def should_skip(self, *args, **kwargs): # real signature unknown
        pass

    def start_tree(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        """
        Initializer.  Subclass may override.
        
                Args:
                    options: an dict containing the options passed to RefactoringTool
                    that could be used to customize the fixer through the command line.
                    log: a list to append warnings and other messages to.
        """
        pass

    skip_on = None


class PatternCompiler(object):
    # no doc
    def compile_basic(self, *args, **kwargs): # real signature unknown
        pass

    def compile_node(self, *args, **kwargs): # real signature unknown
        """
        Compiles a node, recursively.
        
                This is one big switch on the node type.
        """
        pass

    def compile_pattern(self, *args, **kwargs): # real signature unknown
        """ Compiles a pattern string to a nested pytree.*Pattern object. """
        pass

    def get_int(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        """
        Initializer.
        
                Takes an optional alternative filename for the pattern grammar.
        """
        pass

    __weakref__ = property(lambda self: object()) # default

    __dict__ = None # (!) real value is ''


