# encoding: utf-8
# module lib2to3.fixes.fix_has_key
# from /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/lib2to3/fixes/fix_has_key.pyo by generator 1.99
"""
Fixer for has_key().

Calls to .has_key() methods are expressed in terms of the 'in'
operator:

    d.has_key(k) -> k in d

CAVEATS:
1) While the primary target of this fixer is dict.has_key(), the
   fixer will change any has_key() method call, regardless of its
   class.

2) Cases like this will not be converted:

    m = d.has_key
    if m(k):
        ...

   Only *calls* to has_key() are converted. While it is possible to
   convert the above to something like

    m = d.__contains__
    if m(k):
        ...

   this is currently not done.
"""

# imports
import lib2to3.pytree as pytree # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/lib2to3/pytree.pyc
import lib2to3.fixer_base as fixer_base # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/lib2to3/fixer_base.pyc
import lib2to3.pgen2.token as token # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/lib2to3/pgen2/token.pyc
import lib2to3.fixer_base as __lib2to3_fixer_base


# functions

def Name(name, prefix=None): # reliably restored by inspect
    """ Return a NAME leaf """
    pass


def parenthesize(node): # reliably restored by inspect
    # no doc
    pass


# classes

class FixHasKey(__lib2to3_fixer_base.BaseFix):
    # no doc
    def transform(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        """
        Initializer.  Subclass may override.
        
                Args:
                    options: an dict containing the options passed to RefactoringTool
                    that could be used to customize the fixer through the command line.
                    log: a list to append warnings and other messages to.
        """
        pass

    BM_compatible = True
    PATTERN = "\n    anchor=power<\n        before=any+\n        trailer< '.' 'has_key' >\n        trailer<\n            '('\n            ( not(arglist | argument<any '=' any>) arg=any\n            | arglist<(not argument<any '=' any>) arg=any ','>\n            )\n            ')'\n        >\n        after=any*\n    >\n    |\n    negation=not_test<\n        'not'\n        anchor=power<\n            before=any+\n            trailer< '.' 'has_key' >\n            trailer<\n                '('\n                ( not(arglist | argument<any '=' any>) arg=any\n                | arglist<(not argument<any '=' any>) arg=any ','>\n                )\n                ')'\n            >\n        >\n    >\n    "


