# encoding: utf-8
# module lib2to3.fixes.fix_types
# from /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/lib2to3/fixes/fix_types.pyo by generator 1.99
"""
Fixer for removing uses of the types module.

These work for only the known names in the types module.  The forms above
can include types. or not.  ie, It is assumed the module is imported either as:

    import types
    from types import ... # either * or specific types

The import statements are not modified.

There should be another fixer that handles at least the following constants:

   type([]) -> list
   type(()) -> tuple
   type('') -> str
"""

# imports
import lib2to3.fixer_base as fixer_base # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/lib2to3/fixer_base.pyc
import lib2to3.pgen2.token as token # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/lib2to3/pgen2/token.pyc
import lib2to3.fixer_base as __lib2to3_fixer_base


# Variables with simple values
t = 'ObjectType'

# functions

def Name(name, prefix=None): # reliably restored by inspect
    """ Return a NAME leaf """
    pass


# classes

class FixTypes(__lib2to3_fixer_base.BaseFix):
    # no doc
    def transform(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        """
        Initializer.  Subclass may override.
        
                Args:
                    options: an dict containing the options passed to RefactoringTool
                    that could be used to customize the fixer through the command line.
                    log: a list to append warnings and other messages to.
        """
        pass

    BM_compatible = True
    PATTERN = "power< 'types' trailer< '.' name='DictType' > >|power< 'types' trailer< '.' name='StringType' > >|power< 'types' trailer< '.' name='LongType' > >|power< 'types' trailer< '.' name='NotImplementedType' > >|power< 'types' trailer< '.' name='BufferType' > >|power< 'types' trailer< '.' name='FloatType' > >|power< 'types' trailer< '.' name='TypeType' > >|power< 'types' trailer< '.' name='ClassType' > >|power< 'types' trailer< '.' name='DictionaryType' > >|power< 'types' trailer< '.' name='ComplexType' > >|power< 'types' trailer< '.' name='StringTypes' > >|power< 'types' trailer< '.' name='UnicodeType' > >|power< 'types' trailer< '.' name='EllipsisType' > >|power< 'types' trailer< '.' name='BooleanType' > >|power< 'types' trailer< '.' name='ListType' > >|power< 'types' trailer< '.' name='IntType' > >|power< 'types' trailer< '.' name='TupleType' > >|power< 'types' trailer< '.' name='SliceType' > >|power< 'types' trailer< '.' name='XRangeType' > >|power< 'types' trailer< '.' name='NoneType' > >|power< 'types' trailer< '.' name='ObjectType' > >"


# variables with complex values

_pats = [
    "power< 'types' trailer< '.' name='DictType' > >",
    "power< 'types' trailer< '.' name='StringType' > >",
    "power< 'types' trailer< '.' name='LongType' > >",
    "power< 'types' trailer< '.' name='NotImplementedType' > >",
    "power< 'types' trailer< '.' name='BufferType' > >",
    "power< 'types' trailer< '.' name='FloatType' > >",
    "power< 'types' trailer< '.' name='TypeType' > >",
    "power< 'types' trailer< '.' name='ClassType' > >",
    "power< 'types' trailer< '.' name='DictionaryType' > >",
    "power< 'types' trailer< '.' name='ComplexType' > >",
    "power< 'types' trailer< '.' name='StringTypes' > >",
    "power< 'types' trailer< '.' name='UnicodeType' > >",
    "power< 'types' trailer< '.' name='EllipsisType' > >",
    "power< 'types' trailer< '.' name='BooleanType' > >",
    "power< 'types' trailer< '.' name='ListType' > >",
    "power< 'types' trailer< '.' name='IntType' > >",
    "power< 'types' trailer< '.' name='TupleType' > >",
    "power< 'types' trailer< '.' name='SliceType' > >",
    "power< 'types' trailer< '.' name='XRangeType' > >",
    "power< 'types' trailer< '.' name='NoneType' > >",
    "power< 'types' trailer< '.' name='ObjectType' > >",
]

_TYPE_MAPPING = {
    'BooleanType': 'bool',
    'BufferType': 'memoryview',
    'ClassType': 'type',
    'ComplexType': 'complex',
    'DictType': 'dict',
    'DictionaryType': 'dict',
    'EllipsisType': 'type(Ellipsis)',
    'FloatType': 'float',
    'IntType': 'int',
    'ListType': 'list',
    'LongType': 'int',
    'NoneType': 'type(None)',
    'NotImplementedType': 'type(NotImplemented)',
    'ObjectType': 'object',
    'SliceType': 'slice',
    'StringType': 'bytes',
    'StringTypes': 'str',
    'TupleType': 'tuple',
    'TypeType': 'type',
    'UnicodeType': 'str',
    'XRangeType': 'range',
}

