# encoding: utf-8
# module lib2to3.fixes.fix_urllib
# from /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/lib2to3/fixes/fix_urllib.pyo by generator 1.99
"""
Fix changes imports of urllib which are now incompatible.
   This is rather similar to fix_imports, but because of the more
   complex nature of the fixing for urllib, it has its own fixer.
"""

# imports
import lib2to3.fixer_base as fixer_base # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/lib2to3/fixer_base.pyc
import lib2to3.fixer_base as __lib2to3_fixer_base
import lib2to3.fixes.fix_imports as __lib2to3_fixes_fix_imports
import lib2to3.pytree as __lib2to3_pytree


# functions

def alternates(members): # reliably restored by inspect
    # no doc
    pass


def build_pattern(): # reliably restored by inspect
    # no doc
    pass


def Comma(): # reliably restored by inspect
    """ A comma leaf """
    pass


def find_indentation(node): # reliably restored by inspect
    """ Find the indentation of *node*. """
    pass


def FromImport(package_name, name_leafs): # reliably restored by inspect
    """
    Return an import statement in the form:
            from package import name_leafs
    """
    pass


def Name(name, prefix=None): # reliably restored by inspect
    """ Return a NAME leaf """
    pass


def Newline(): # reliably restored by inspect
    """ A newline literal """
    pass


# classes

class FixImports(__lib2to3_fixer_base.BaseFix):
    # no doc
    def build_pattern(self, *args, **kwargs): # real signature unknown
        pass

    def compile_pattern(self, *args, **kwargs): # real signature unknown
        pass

    def match(self, *args, **kwargs): # real signature unknown
        pass

    def start_tree(self, *args, **kwargs): # real signature unknown
        pass

    def transform(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        """
        Initializer.  Subclass may override.
        
                Args:
                    options: an dict containing the options passed to RefactoringTool
                    that could be used to customize the fixer through the command line.
                    log: a list to append warnings and other messages to.
        """
        pass

    BM_compatible = True
    keep_line_order = True
    mapping = {
        'BaseHTTPServer': 'http.server',
        'CGIHTTPServer': 'http.server',
        'ConfigParser': 'configparser',
        'Cookie': 'http.cookies',
        'Dialog': 'tkinter.dialog',
        'DocXMLRPCServer': 'xmlrpc.server',
        'FileDialog': 'tkinter.filedialog',
        'HTMLParser': 'html.parser',
        'Queue': 'queue',
        'ScrolledText': 'tkinter.scrolledtext',
        'SimpleDialog': 'tkinter.simpledialog',
        'SimpleHTTPServer': 'http.server',
        'SimpleXMLRPCServer': 'xmlrpc.server',
        'SocketServer': 'socketserver',
        'StringIO': 'io',
        'Tix': 'tkinter.tix',
        'Tkconstants': 'tkinter.constants',
        'Tkdnd': 'tkinter.dnd',
        'Tkinter': 'tkinter',
        'UserList': 'collections',
        'UserString': 'collections',
        '__builtin__': 'builtins',
        '_winreg': 'winreg',
        'cPickle': 'pickle',
        'cStringIO': 'io',
        'commands': 'subprocess',
        'cookielib': 'http.cookiejar',
        'copy_reg': 'copyreg',
        'dbhash': 'dbm.bsd',
        'dbm': 'dbm.ndbm',
        'dumbdbm': 'dbm.dumb',
        'dummy_thread': '_dummy_thread',
        'gdbm': 'dbm.gnu',
        'htmlentitydefs': 'html.entities',
        'httplib': 'http.client',
        'markupbase': '_markupbase',
        'repr': 'reprlib',
        'robotparser': 'urllib.robotparser',
        'thread': '_thread',
        'tkColorChooser': 'tkinter.colorchooser',
        'tkCommonDialog': 'tkinter.commondialog',
        'tkFileDialog': 'tkinter.filedialog',
        'tkFont': 'tkinter.font',
        'tkMessageBox': 'tkinter.messagebox',
        'tkSimpleDialog': 'tkinter.simpledialog',
        'ttk': 'tkinter.ttk',
        'urlparse': 'urllib.parse',
        'xmlrpclib': 'xmlrpc.client',
    }
    run_order = 6


class FixUrllib(__lib2to3_fixes_fix_imports.FixImports):
    # no doc
    def build_pattern(self, *args, **kwargs): # real signature unknown
        pass

    def transform(self, *args, **kwargs): # real signature unknown
        pass

    def transform_dot(self, *args, **kwargs): # real signature unknown
        """ Transform for calls to module members in code. """
        pass

    def transform_import(self, *args, **kwargs): # real signature unknown
        """
        Transform for the basic import case. Replaces the old
                   import name with a comma separated list of its
                   replacements.
        """
        pass

    def transform_member(self, *args, **kwargs): # real signature unknown
        """
        Transform for imports of specific module elements. Replaces
                   the module to be imported from with the appropriate new
                   module.
        """
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        """
        Initializer.  Subclass may override.
        
                Args:
                    options: an dict containing the options passed to RefactoringTool
                    that could be used to customize the fixer through the command line.
                    log: a list to append warnings and other messages to.
        """
        pass


class Node(__lib2to3_pytree.Base):
    """ Concrete implementation for interior nodes. """
    def append_child(self, *args, **kwargs): # real signature unknown
        """
        Equivalent to 'node.children.append(child)'. This method also sets the
                child's parent attribute appropriately.
        """
        pass

    def clone(self, *args, **kwargs): # real signature unknown
        """ Return a cloned (deep) copy of self. """
        pass

    def insert_child(self, *args, **kwargs): # real signature unknown
        """
        Equivalent to 'node.children.insert(i, child)'. This method also sets
                the child's parent attribute appropriately.
        """
        pass

    def post_order(self, *args, **kwargs): # real signature unknown
        """ Return a post-order iterator for the tree. """
        pass

    def pre_order(self, *args, **kwargs): # real signature unknown
        """ Return a pre-order iterator for the tree. """
        pass

    def set_child(self, *args, **kwargs): # real signature unknown
        """
        Equivalent to 'node.children[i] = child'. This method also sets the
                child's parent attribute appropriately.
        """
        pass

    def _eq(self, *args, **kwargs): # real signature unknown
        """ Compare two nodes for equality. """
        pass

    def _prefix_getter(self, *args, **kwargs): # real signature unknown
        """ The whitespace and comments preceding this node in the input. """
        pass

    def _prefix_setter(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        """
        Initializer.
        
                Takes a type constant (a symbol number >= 256), a sequence of
                child nodes, and an optional context keyword argument.
        
                As a side effect, the parent pointers of the children are updated.
        """
        pass

    def __repr__(self, *args, **kwargs): # real signature unknown
        """ Return a canonical string representation. """
        pass

    def __unicode__(self, *args, **kwargs): # real signature unknown
        """
        Return a pretty string representation.
        
                This reproduces the input source exactly.
        """
        pass

    prefix = property(lambda self: object()) # default


# variables with complex values

MAPPING = {
    'urllib': [
        (
            'urllib.request',
            [
                'URLOpener',
                'FancyURLOpener',
                'urlretrieve',
                '_urlopener',
                'urlopen',
                'urlcleanup',
                'pathname2url',
                'url2pathname',
            ],
        ),
        (
            'urllib.parse',
            [
                'quote',
                'quote_plus',
                'unquote',
                'unquote_plus',
                'urlencode',
                'splitattr',
                'splithost',
                'splitnport',
                'splitpasswd',
                'splitport',
                'splitquery',
                'splittag',
                'splittype',
                'splituser',
                'splitvalue',
            ],
        ),
        (
            'urllib.error',
            [
                'ContentTooShortError',
            ],
        ),
    ],
    'urllib2': [
        (
            'urllib.request',
            [
                'urlopen',
                'install_opener',
                'build_opener',
                'Request',
                'OpenerDirector',
                'BaseHandler',
                'HTTPDefaultErrorHandler',
                'HTTPRedirectHandler',
                'HTTPCookieProcessor',
                'ProxyHandler',
                'HTTPPasswordMgr',
                'HTTPPasswordMgrWithDefaultRealm',
                'AbstractBasicAuthHandler',
                'HTTPBasicAuthHandler',
                'ProxyBasicAuthHandler',
                'AbstractDigestAuthHandler',
                'HTTPDigestAuthHandler',
                'ProxyDigestAuthHandler',
                'HTTPHandler',
                'HTTPSHandler',
                'FileHandler',
                'FTPHandler',
                'CacheFTPHandler',
                'UnknownHandler',
            ],
        ),
        (
            'urllib.error',
            [
                'URLError',
                'HTTPError',
            ],
        ),
        '<value is a self-reference, replaced by this string>',
    ],
}

syms = None # (!) real value is ''

