# encoding: utf-8
# module lib2to3.pytree
# from /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/lib2to3/pytree.pyo by generator 1.99
"""
Python parse tree definitions.

This is a very concrete parse tree; we need to keep every token and
even the comments and whitespace between tokens.

There's also a pattern matching implementation here.
"""

# imports
import warnings as warnings # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/warnings.pyc
import sys as sys # <module 'sys' (built-in)>

# Variables with simple values

HUGE = 2147483647

__author__ = 'Guido van Rossum <guido@python.org>'

# functions

def convert(gr, raw_node): # reliably restored by inspect
    """
    Convert raw node information to a Node or Leaf instance.
    
        This is passed to the parser driver which calls it whenever a reduction of a
        grammar rule produces a new complete node, so that the tree is build
        strictly bottom-up.
    """
    pass


def generate_matches(patterns, nodes): # reliably restored by inspect
    """
    Generator yielding matches for a sequence of patterns and nodes.
    
        Args:
            patterns: a sequence of patterns
            nodes: a sequence of nodes
    
        Yields:
            (count, results) tuples where:
            count: the entire sequence of patterns matches nodes[:count];
            results: dict containing named submatches.
    """
    pass


def type_repr(type_num): # reliably restored by inspect
    # no doc
    pass


# classes

class Base(object):
    """
    Abstract base class for Node and Leaf.
    
        This provides some default functionality and boilerplate using the
        template pattern.
    
        A node may be a subnode of at most one parent.
    """
    def changed(self, *args, **kwargs): # real signature unknown
        pass

    def clone(self, *args, **kwargs): # real signature unknown
        """
        Return a cloned (deep) copy of self.
        
                This must be implemented by the concrete subclass.
        """
        pass

    def depth(self, *args, **kwargs): # real signature unknown
        pass

    def get_lineno(self, *args, **kwargs): # real signature unknown
        """ Return the line number which generated the invocant node. """
        pass

    def get_prefix(self, *args, **kwargs): # real signature unknown
        """
        Return the prefix for the node (see Leaf class).
        
                DEPRECATED; use the prefix property directly.
        """
        pass

    def get_suffix(self, *args, **kwargs): # real signature unknown
        """
        Return the string immediately following the invocant node. This is
                effectively equivalent to node.next_sibling.prefix
        """
        pass

    def leaves(self, *args, **kwargs): # real signature unknown
        pass

    def post_order(self, *args, **kwargs): # real signature unknown
        """
        Return a post-order iterator for the tree.
        
                This must be implemented by the concrete subclass.
        """
        pass

    def pre_order(self, *args, **kwargs): # real signature unknown
        """
        Return a pre-order iterator for the tree.
        
                This must be implemented by the concrete subclass.
        """
        pass

    def remove(self, *args, **kwargs): # real signature unknown
        """
        Remove the node from the tree. Returns the position of the node in its
                parent's children before it was removed.
        """
        pass

    def replace(self, *args, **kwargs): # real signature unknown
        """ Replace this node with a new one in the parent. """
        pass

    def set_prefix(self, *args, **kwargs): # real signature unknown
        """
        Set the prefix for the node (see Leaf class).
        
                DEPRECATED; use the prefix property directly.
        """
        pass

    def _eq(self, *args, **kwargs): # real signature unknown
        """
        Compare two nodes for equality.
        
                This is called by __eq__ and __ne__.  It is only called if the two nodes
                have the same type.  This must be implemented by the concrete subclass.
                Nodes should be considered equal if they have the same structure,
                ignoring the prefix string and other context information.
        """
        pass

    def __eq__(self, *args, **kwargs): # real signature unknown
        """
        Compare two nodes for equality.
        
                This calls the method _eq().
        """
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    @staticmethod # known case of __new__
    def __new__(cls, *args, **kwds): # reliably restored by inspect
        """ Constructor that prevents Base from being instantiated. """
        pass

    def __ne__(self, *args, **kwargs): # real signature unknown
        """
        Compare two nodes for inequality.
        
                This calls the method _eq().
        """
        pass

    def __str__(self, *args, **kwargs): # real signature unknown
        pass

    next_sibling = property(lambda self: object()) # default
    prev_sibling = property(lambda self: object()) # default
    __weakref__ = property(lambda self: object()) # default

    children = ()
    parent = None
    type = None
    was_changed = False
    was_checked = False
    __dict__ = None # (!) real value is ''
    __hash__ = None


class BasePattern(object):
    """
    A pattern is a tree matching pattern.
    
        It looks for a specific node type (token or symbol), and
        optionally for a specific content.
    
        This is an abstract base class.  There are three concrete
        subclasses:
    
        - LeafPattern matches a single leaf node;
        - NodePattern matches a single node (usually non-leaf);
        - WildcardPattern matches a sequence of nodes of variable length.
    """
    def generate_matches(self, *args, **kwargs): # real signature unknown
        """
        Generator yielding all matches for this pattern.
        
                Default implementation for non-wildcard patterns.
        """
        pass

    def match(self, *args, **kwargs): # real signature unknown
        """
        Does this pattern exactly match a node?
        
                Returns True if it matches, False if not.
        
                If results is not None, it must be a dict which will be
                updated with the nodes matching named subpatterns.
        
                Default implementation for non-wildcard patterns.
        """
        pass

    def match_seq(self, *args, **kwargs): # real signature unknown
        """
        Does this pattern exactly match a sequence of nodes?
        
                Default implementation for non-wildcard patterns.
        """
        pass

    def optimize(self, *args, **kwargs): # real signature unknown
        """
        A subclass can define this as a hook for optimizations.
        
                Returns either self or another node with the same effect.
        """
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    @staticmethod # known case of __new__
    def __new__(cls, *args, **kwds): # reliably restored by inspect
        """ Constructor that prevents BasePattern from being instantiated. """
        pass

    def __repr__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default

    content = None
    name = None
    type = None
    __dict__ = None # (!) real value is ''


class Leaf(Base):
    """ Concrete implementation for leaf nodes. """
    def clone(self, *args, **kwargs): # real signature unknown
        """ Return a cloned (deep) copy of self. """
        pass

    def leaves(self, *args, **kwargs): # real signature unknown
        pass

    def post_order(self, *args, **kwargs): # real signature unknown
        """ Return a post-order iterator for the tree. """
        pass

    def pre_order(self, *args, **kwargs): # real signature unknown
        """ Return a pre-order iterator for the tree. """
        pass

    def _eq(self, *args, **kwargs): # real signature unknown
        """ Compare two nodes for equality. """
        pass

    def _prefix_getter(self, *args, **kwargs): # real signature unknown
        """ The whitespace and comments preceding this token in the input. """
        pass

    def _prefix_setter(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        """
        Initializer.
        
                Takes a type constant (a token number < 256), a string value, and an
                optional context keyword argument.
        """
        pass

    def __repr__(self, *args, **kwargs): # real signature unknown
        """ Return a canonical string representation. """
        pass

    def __unicode__(self, *args, **kwargs): # real signature unknown
        """
        Return a pretty string representation.
        
                This reproduces the input source exactly.
        """
        pass

    prefix = property(lambda self: object()) # default

    column = 0
    lineno = 0
    _prefix = ''


class LeafPattern(BasePattern):
    # no doc
    def match(self): # real signature unknown; restored from __doc__
        """ Override match() to insist on a leaf node. """
        pass

    def _submatch(self, *args, **kwargs): # real signature unknown
        """
        Match the pattern's content to the node's children.
        
                This assumes the node type matches and self.content is not None.
        
                Returns True if it matches, False if not.
        
                If results is not None, it must be a dict which will be
                updated with the nodes matching named subpatterns.
        
                When returning False, the results dict may still be updated.
        """
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        """
        Initializer.  Takes optional type, content, and name.
        
                The type, if given must be a token type (< 256).  If not given,
                this matches any *leaf* node; the content may still be required.
        
                The content, if given, must be a string.
        
                If a name is given, the matching node is stored in the results
                dict under that key.
        """
        pass


class NegatedPattern(BasePattern):
    # no doc
    def generate_matches(self, *args, **kwargs): # real signature unknown
        pass

    def match(self, *args, **kwargs): # real signature unknown
        pass

    def match_seq(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        """
        Initializer.
        
                The argument is either a pattern or None.  If it is None, this
                only matches an empty sequence (effectively '$' in regex
                lingo).  If it is not None, this matches whenever the argument
                pattern doesn't have any matches.
        """
        pass


class Node(Base):
    """ Concrete implementation for interior nodes. """
    def append_child(self, *args, **kwargs): # real signature unknown
        """
        Equivalent to 'node.children.append(child)'. This method also sets the
                child's parent attribute appropriately.
        """
        pass

    def clone(self, *args, **kwargs): # real signature unknown
        """ Return a cloned (deep) copy of self. """
        pass

    def insert_child(self, *args, **kwargs): # real signature unknown
        """
        Equivalent to 'node.children.insert(i, child)'. This method also sets
                the child's parent attribute appropriately.
        """
        pass

    def post_order(self, *args, **kwargs): # real signature unknown
        """ Return a post-order iterator for the tree. """
        pass

    def pre_order(self, *args, **kwargs): # real signature unknown
        """ Return a pre-order iterator for the tree. """
        pass

    def set_child(self, *args, **kwargs): # real signature unknown
        """
        Equivalent to 'node.children[i] = child'. This method also sets the
                child's parent attribute appropriately.
        """
        pass

    def _eq(self, *args, **kwargs): # real signature unknown
        """ Compare two nodes for equality. """
        pass

    def _prefix_getter(self, *args, **kwargs): # real signature unknown
        """ The whitespace and comments preceding this node in the input. """
        pass

    def _prefix_setter(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        """
        Initializer.
        
                Takes a type constant (a symbol number >= 256), a sequence of
                child nodes, and an optional context keyword argument.
        
                As a side effect, the parent pointers of the children are updated.
        """
        pass

    def __repr__(self, *args, **kwargs): # real signature unknown
        """ Return a canonical string representation. """
        pass

    def __unicode__(self, *args, **kwargs): # real signature unknown
        """
        Return a pretty string representation.
        
                This reproduces the input source exactly.
        """
        pass

    prefix = property(lambda self: object()) # default


class NodePattern(BasePattern):
    # no doc
    def _submatch(self, *args, **kwargs): # real signature unknown
        """
        Match the pattern's content to the node's children.
        
                This assumes the node type matches and self.content is not None.
        
                Returns True if it matches, False if not.
        
                If results is not None, it must be a dict which will be
                updated with the nodes matching named subpatterns.
        
                When returning False, the results dict may still be updated.
        """
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        """
        Initializer.  Takes optional type, content, and name.
        
                The type, if given, must be a symbol type (>= 256).  If the
                type is None this matches *any* single node (leaf or not),
                except if content is not None, in which it only matches
                non-leaf nodes that also match the content pattern.
        
                The content, if not None, must be a sequence of Patterns that
                must match the node's children exactly.  If the content is
                given, the type must not be None.
        
                If a name is given, the matching node is stored in the results
                dict under that key.
        """
        pass

    wildcards = False


class WildcardPattern(BasePattern):
    """
    A wildcard pattern can match zero or more nodes.
    
        This has all the flexibility needed to implement patterns like:
    
        .*      .+      .?      .{m,n}
        (a b c | d e | f)
        (...)*  (...)+  (...)?  (...){m,n}
    
        except it always uses non-greedy matching.
    """
    def generate_matches(self, *args, **kwargs): # real signature unknown
        """
        Generator yielding matches for a sequence of nodes.
        
                Args:
                    nodes: sequence of nodes
        
                Yields:
                    (count, results) tuples where:
                    count: the match comprises nodes[:count];
                    results: dict containing named submatches.
        """
        pass

    def match(self, *args, **kwargs): # real signature unknown
        """ Does this pattern exactly match a node? """
        pass

    def match_seq(self, *args, **kwargs): # real signature unknown
        """ Does this pattern exactly match a sequence of nodes? """
        pass

    def optimize(self, *args, **kwargs): # real signature unknown
        """ Optimize certain stacked wildcard patterns. """
        pass

    def _bare_name_matches(self, *args, **kwargs): # real signature unknown
        """ Special optimized matcher for bare_name. """
        pass

    def _iterative_matches(self, *args, **kwargs): # real signature unknown
        """ Helper to iteratively yield the matches. """
        pass

    def _recursive_matches(self, *args, **kwargs): # real signature unknown
        """ Helper to recursively yield the matches. """
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        """
        Initializer.
        
                Args:
                    content: optional sequence of subsequences of patterns;
                             if absent, matches one node;
                             if present, each subsequence is an alternative [*]
                    min: optinal minumum number of times to match, default 0
                    max: optional maximum number of times tro match, default HUGE
                    name: optional name assigned to this match
        
                [*] Thus, if content is [[a, b, c], [d, e], [f, g, h]] this is
                    equivalent to (a b c | d e | f g h); if content is None,
                    this is equivalent to '.' in regular expression terms.
                    The min and max parameters work as follows:
                        min=0, max=maxint: .*
                        min=1, max=maxint: .+
                        min=0, max=1: .?
                        min=1, max=1: .
                    If content is not None, replace the dot with the parenthesized
                    list of alternatives, e.g. (a b c | d e | f g h)*
        """
        pass


# variables with complex values

StringIO = None # (!) real value is ''

_type_reprs = {}

