# encoding: utf-8
# module logging.__init__
# from /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/logging/__init__.pyo by generator 1.99
"""
Logging package for Python. Based on PEP 282 and comments thereto in
comp.lang.python, and influenced by Apache's log4j system.

Copyright (C) 2001-2010 Vinay Sajip. All Rights Reserved.

To use, simply 'import logging' and log away!
"""

# imports
import cStringIO as cStringIO # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/lib-dynload/cStringIO.so
import atexit as atexit # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/atexit.pyc
import weakref as weakref # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/weakref.pyc
import warnings as warnings # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/warnings.pyc
import sys as sys # <module 'sys' (built-in)>
import codecs as codecs # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/codecs.pyc
import thread as thread # <module 'thread' (built-in)>
import traceback as traceback # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/traceback.pyc
import threading as threading # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/threading.pyc
import time as time # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/lib-dynload/time.so
import os as os # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/os.pyc

# Variables with simple values

BASIC_FORMAT = '%(levelname)s:%(name)s:%(message)s'

CRITICAL = 50

DEBUG = 10

ERROR = 40

FATAL = 50

INFO = 20

logMultiprocessing = 1
logProcesses = 1
logThreads = 1

NOTSET = 0

raiseExceptions = 1

WARN = 30
WARNING = 30

_srcfile = '/System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/logging/__init__.py'
_startTime = 1322221478.579702

_unicode = True

_warnings_showwarning = None

__author__ = 'Vinay Sajip <vinay_sajip@red-dove.com>'

__date__ = '07 February 2010'

__status__ = 'production'

__version__ = '0.5.1.2'

# functions

def addLevelName(level, levelName): # reliably restored by inspect
    """
    Associate 'levelName' with 'level'.
    
        This is used when converting levels to text during message formatting.
    """
    pass


def basicConfig(**kwargs): # reliably restored by inspect
    """
    Do basic configuration for the logging system.
    
        This function does nothing if the root logger already has handlers
        configured. It is a convenience method intended for use by simple scripts
        to do one-shot configuration of the logging package.
    
        The default behaviour is to create a StreamHandler which writes to
        sys.stderr, set a formatter using the BASIC_FORMAT format string, and
        add the handler to the root logger.
    
        A number of optional keyword arguments may be specified, which can alter
        the default behaviour.
    
        filename  Specifies that a FileHandler be created, using the specified
                  filename, rather than a StreamHandler.
        filemode  Specifies the mode to open the file, if filename is specified
                  (if filemode is unspecified, it defaults to 'a').
        format    Use the specified format string for the handler.
        datefmt   Use the specified date/time format.
        level     Set the root logger level to the specified level.
        stream    Use the specified stream to initialize the StreamHandler. Note
                  that this argument is incompatible with 'filename' - if both
                  are present, 'stream' is ignored.
    
        Note that you could specify a stream created using open(filename, mode)
        rather than passing the filename and mode in. However, it should be
        remembered that StreamHandler does not close its stream (since it may be
        using sys.stdout or sys.stderr), whereas FileHandler closes its stream
        when the handler is closed.
    """
    pass


def captureWarnings(capture): # reliably restored by inspect
    """
    If capture is true, redirect all warnings to the logging package.
        If capture is False, ensure that warnings are not redirected to logging
        but to their original destinations.
    """
    pass


def critical(msg, *args, **kwargs): # reliably restored by inspect
    """ Log a message with severity 'CRITICAL' on the root logger. """
    pass


def currentframe(): # reliably restored by inspect
    # no doc
    pass


def debug(msg, *args, **kwargs): # reliably restored by inspect
    """ Log a message with severity 'DEBUG' on the root logger. """
    pass


def disable(level): # reliably restored by inspect
    """ Disable all logging calls of severity 'level' and below. """
    pass


def error(msg, *args, **kwargs): # reliably restored by inspect
    """ Log a message with severity 'ERROR' on the root logger. """
    pass


def exception(msg, *args): # reliably restored by inspect
    """
    Log a message with severity 'ERROR' on the root logger,
        with exception information.
    """
    pass


def fatal(msg, *args, **kwargs): # reliably restored by inspect
    """ Log a message with severity 'CRITICAL' on the root logger. """
    pass


def getLevelName(level): # reliably restored by inspect
    """
    Return the textual representation of logging level 'level'.
    
        If the level is one of the predefined levels (CRITICAL, ERROR, WARNING,
        INFO, DEBUG) then you get the corresponding string. If you have
        associated levels with names using addLevelName then the name you have
        associated with 'level' is returned.
    
        If a numeric value corresponding to one of the defined levels is passed
        in, the corresponding string representation is returned.
    
        Otherwise, the string "Level %s" % level is returned.
    """
    pass


def getLogger(name=None): # reliably restored by inspect
    """
    Return a logger with the specified name, creating it if necessary.
    
        If no name is specified, return the root logger.
    """
    pass


def getLoggerClass(): # reliably restored by inspect
    """ Return the class to be used when instantiating a logger. """
    pass


def info(msg, *args, **kwargs): # reliably restored by inspect
    """ Log a message with severity 'INFO' on the root logger. """
    pass


def log(level, msg, *args, **kwargs): # reliably restored by inspect
    """ Log 'msg % args' with the integer severity 'level' on the root logger. """
    pass


def makeLogRecord(dict): # reliably restored by inspect
    """
    Make a LogRecord whose attributes are defined by the specified dictionary,
        This function is useful for converting a logging event received over
        a socket connection (which is sent as a dictionary) into a LogRecord
        instance.
    """
    pass


def setLoggerClass(klass): # reliably restored by inspect
    """
    Set the class to be used when instantiating a logger. The class should
        define __init__() such that only a name argument is required, and the
        __init__() should call Logger.__init__()
    """
    pass


def shutdown(handlerList='[]'): # reliably restored by inspect
    """
    Perform any cleanup actions in the logging system (e.g. flushing
        buffers).
    
        Should be called at application exit.
    """
    pass


def warn(msg, *args, **kwargs): # reliably restored by inspect
    """ Log a message with severity 'WARNING' on the root logger. """
    pass


def warning(msg, *args, **kwargs): # reliably restored by inspect
    """ Log a message with severity 'WARNING' on the root logger. """
    pass


def _acquireLock(): # reliably restored by inspect
    """
    Acquire the module-level lock for serializing access to shared data.
    
        This should be released with _releaseLock().
    """
    pass


def _addHandlerRef(handler): # reliably restored by inspect
    """ Add a handler to the internal cleanup list using a weak reference. """
    pass


def _checkLevel(level): # reliably restored by inspect
    # no doc
    pass


def _releaseLock(): # reliably restored by inspect
    """ Release the module-level lock acquired by calling _acquireLock(). """
    pass


def _removeHandlerRef(wr): # reliably restored by inspect
    """ Remove a handler reference from the internal cleanup list. """
    pass


def _showwarning(message, category, filename, lineno, file=None, line=None): # reliably restored by inspect
    """
    Implementation of showwarnings which redirects to logging, which will first
        check to see if the file parameter is None. If a file is specified, it will
        delegate to the original warnings implementation of showwarning. Otherwise,
        it will call warnings.formatwarning and will log the resulting string to a
        warnings logger named "py.warnings" with level logging.WARNING.
    """
    pass


# classes

class BufferingFormatter(object):
    """ A formatter suitable for formatting a number of records. """
    def format(self, *args, **kwargs): # real signature unknown
        """ Format the specified records and return the result as a string. """
        pass

    def formatFooter(self, *args, **kwargs): # real signature unknown
        """ Return the footer string for the specified records. """
        pass

    def formatHeader(self, *args, **kwargs): # real signature unknown
        """ Return the header string for the specified records. """
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        """
        Optionally specify a formatter which will be used to format each
                individual record.
        """
        pass

    __weakref__ = property(lambda self: object()) # default

    __dict__ = None # (!) real value is ''


class Filterer(object):
    """
    A base class for loggers and handlers which allows them to share
        common code.
    """
    def addFilter(self, *args, **kwargs): # real signature unknown
        """ Add the specified filter to this handler. """
        pass

    def filter(self, *args, **kwargs): # real signature unknown
        """
        Determine if a record is loggable by consulting all the filters.
        
                The default is to allow the record to be logged; any filter can veto
                this and the record is then dropped. Returns a zero value if a record
                is to be dropped, else non-zero.
        """
        pass

    def removeFilter(self, *args, **kwargs): # real signature unknown
        """ Remove the specified filter from this handler. """
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        """ Initialize the list of filters to be an empty list. """
        pass

    __weakref__ = property(lambda self: object()) # default

    __dict__ = None # (!) real value is ''


class Handler(Filterer):
    """
    Handler instances dispatch logging events to specific destinations.
    
        The base handler class. Acts as a placeholder which defines the Handler
        interface. Handlers can optionally use Formatter instances to format
        records as desired. By default, no formatter is specified; in this case,
        the 'raw' message as determined by record.message is logged.
    """
    def acquire(self, *args, **kwargs): # real signature unknown
        """ Acquire the I/O thread lock. """
        pass

    def close(self): # real signature unknown; restored from __doc__
        """
        Tidy up any resources used by the handler.
        
                This version removes the handler from an internal map of handlers,
                _handlers, which is used for handler lookup by name. Subclasses
                should ensure that this gets called from overridden close()
                methods.
        """
        pass

    def createLock(self, *args, **kwargs): # real signature unknown
        """ Acquire a thread lock for serializing access to the underlying I/O. """
        pass

    def emit(self, *args, **kwargs): # real signature unknown
        """
        Do whatever it takes to actually log the specified logging record.
        
                This version is intended to be implemented by subclasses and so
                raises a NotImplementedError.
        """
        pass

    def flush(self, *args, **kwargs): # real signature unknown
        """
        Ensure all logging output has been flushed.
        
                This version does nothing and is intended to be implemented by
                subclasses.
        """
        pass

    def format(self, *args, **kwargs): # real signature unknown
        """
        Format the specified record.
        
                If a formatter is set, use it. Otherwise, use the default formatter
                for the module.
        """
        pass

    def get_name(self, *args, **kwargs): # real signature unknown
        pass

    def handle(self, *args, **kwargs): # real signature unknown
        """
        Conditionally emit the specified logging record.
        
                Emission depends on filters which may have been added to the handler.
                Wrap the actual emission of the record with acquisition/release of
                the I/O thread lock. Returns whether the filter passed the record for
                emission.
        """
        pass

    def handleError(self, *args, **kwargs): # real signature unknown
        """
        Handle errors which occur during an emit() call.
        
                This method should be called from handlers when an exception is
                encountered during an emit() call. If raiseExceptions is false,
                exceptions get silently ignored. This is what is mostly wanted
                for a logging system - most users will not care about errors in
                the logging system, they are more interested in application errors.
                You could, however, replace this with a custom handler if you wish.
                The record which was being processed is passed in to this method.
        """
        pass

    def release(self, *args, **kwargs): # real signature unknown
        """ Release the I/O thread lock. """
        pass

    def setFormatter(self, *args, **kwargs): # real signature unknown
        """ Set the formatter for this handler. """
        pass

    def setLevel(self, *args, **kwargs): # real signature unknown
        """ Set the logging level of this handler. """
        pass

    def set_name(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        """
        Initializes the instance - basically setting the formatter to None
                and the filter list to empty.
        """
        pass

    name = property(lambda self: object()) # default


class StreamHandler(Handler):
    """
    A handler class which writes logging records, appropriately formatted,
        to a stream. Note that this class does not close the stream, as
        sys.stdout or sys.stderr may be used.
    """
    def emit(self, *args, **kwargs): # real signature unknown
        """
        Emit a record.
        
                If a formatter is specified, it is used to format the record.
                The record is then written to the stream with a trailing newline.  If
                exception information is present, it is formatted using
                traceback.print_exception and appended to the stream.  If the stream
                has an 'encoding' attribute, it is used to determine how to do the
                output to the stream.
        """
        pass

    def flush(self, *args, **kwargs): # real signature unknown
        """ Flushes the stream. """
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        """
        Initialize the handler.
        
                If stream is not specified, sys.stderr is used.
        """
        pass


class FileHandler(StreamHandler):
    """ A handler class which writes formatted logging records to disk files. """
    def close(self, *args, **kwargs): # real signature unknown
        """ Closes the stream. """
        pass

    def emit(self, *args, **kwargs): # real signature unknown
        """
        Emit a record.
        
                If the stream was not opened because 'delay' was specified in the
                constructor, open it before calling the superclass's emit.
        """
        pass

    def _open(self, *args, **kwargs): # real signature unknown
        """
        Open the current base file with the (original) mode and encoding.
                Return the resulting stream.
        """
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        """ Open the specified file and use it as the stream for logging. """
        pass


class Filter(object):
    """
    Filter instances are used to perform arbitrary filtering of LogRecords.
    
        Loggers and Handlers can optionally use Filter instances to filter
        records as desired. The base filter class only allows events which are
        below a certain point in the logger hierarchy. For example, a filter
        initialized with "A.B" will allow events logged by loggers "A.B",
        "A.B.C", "A.B.C.D", "A.B.D" etc. but not "A.BB", "B.A.B" etc. If
        initialized with the empty string, all events are passed.
    """
    def filter(self, *args, **kwargs): # real signature unknown
        """
        Determine if the specified record is to be logged.
        
                Is the specified record to be logged? Returns 0 for no, nonzero for
                yes. If deemed appropriate, the record may be modified in-place.
        """
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        """
        Initialize a filter.
        
                Initialize with the name of the logger which, together with its
                children, will have its events allowed through the filter. If no
                name is specified, allow every event.
        """
        pass

    __weakref__ = property(lambda self: object()) # default

    __dict__ = None # (!) real value is ''


class Formatter(object):
    """
    Formatter instances are used to convert a LogRecord to text.
    
        Formatters need to know how a LogRecord is constructed. They are
        responsible for converting a LogRecord to (usually) a string which can
        be interpreted by either a human or an external system. The base Formatter
        allows a formatting string to be specified. If none is supplied, the
        default value of "%s(message)\n" is used.
    
        The Formatter can be initialized with a format string which makes use of
        knowledge of the LogRecord attributes - e.g. the default value mentioned
        above makes use of the fact that the user's message and arguments are pre-
        formatted into a LogRecord's message attribute. Currently, the useful
        attributes in a LogRecord are described by:
    
        %(name)s            Name of the logger (logging channel)
        %(levelno)s         Numeric logging level for the message (DEBUG, INFO,
                            WARNING, ERROR, CRITICAL)
        %(levelname)s       Text logging level for the message ("DEBUG", "INFO",
                            "WARNING", "ERROR", "CRITICAL")
        %(pathname)s        Full pathname of the source file where the logging
                            call was issued (if available)
        %(filename)s        Filename portion of pathname
        %(module)s          Module (name portion of filename)
        %(lineno)d          Source line number where the logging call was issued
                            (if available)
        %(funcName)s        Function name
        %(created)f         Time when the LogRecord was created (time.time()
                            return value)
        %(asctime)s         Textual time when the LogRecord was created
        %(msecs)d           Millisecond portion of the creation time
        %(relativeCreated)d Time in milliseconds when the LogRecord was created,
                            relative to the time the logging module was loaded
                            (typically at application startup time)
        %(thread)d          Thread ID (if available)
        %(threadName)s      Thread name (if available)
        %(process)d         Process ID (if available)
        %(message)s         The result of record.getMessage(), computed just as
                            the record is emitted
    """
    def converter(self, *args, **kwargs): # real signature unknown
        """
        localtime([seconds]) -> (tm_year,tm_mon,tm_mday,tm_hour,tm_min,
                                  tm_sec,tm_wday,tm_yday,tm_isdst)
        
        Convert seconds since the Epoch to a time tuple expressing local time.
        When 'seconds' is not passed in, convert the current time instead.
        """
        pass

    def format(self, *args, **kwargs): # real signature unknown
        """
        Format the specified record as text.
        
                The record's attribute dictionary is used as the operand to a
                string formatting operation which yields the returned string.
                Before formatting the dictionary, a couple of preparatory steps
                are carried out. The message attribute of the record is computed
                using LogRecord.getMessage(). If the formatting string uses the
                time (as determined by a call to usesTime(), formatTime() is
                called to format the event time. If there is exception information,
                it is formatted using formatException() and appended to the message.
        """
        pass

    def formatException(self, *args, **kwargs): # real signature unknown
        """
        Format and return the specified exception information as a string.
        
                This default implementation just uses
                traceback.print_exception()
        """
        pass

    def formatTime(self, *args, **kwargs): # real signature unknown
        """
        Return the creation time of the specified LogRecord as formatted text.
        
                This method should be called from format() by a formatter which
                wants to make use of a formatted time. This method can be overridden
                in formatters to provide for any specific requirement, but the
                basic behaviour is as follows: if datefmt (a string) is specified,
                it is used with time.strftime() to format the creation time of the
                record. Otherwise, the ISO8601 format is used. The resulting
                string is returned. This function uses a user-configurable function
                to convert the creation time to a tuple. By default, time.localtime()
                is used; to change this for a particular formatter instance, set the
                'converter' attribute to a function with the same signature as
                time.localtime() or time.gmtime(). To change it for all formatters,
                for example if you want all logging times to be shown in GMT,
                set the 'converter' attribute in the Formatter class.
        """
        pass

    def usesTime(self, *args, **kwargs): # real signature unknown
        """ Check if the format uses the creation time of the record. """
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        """
        Initialize the formatter with specified format strings.
        
                Initialize the formatter either with the specified format string, or a
                default as described above. Allow for specialized date formatting with
                the optional datefmt argument (if omitted, you get the ISO8601 format).
        """
        pass

    __weakref__ = property(lambda self: object()) # default

    __dict__ = None # (!) real value is ''


class _loggerClass(Filterer):
    """
    Instances of the Logger class represent a single logging channel. A
        "logging channel" indicates an area of an application. Exactly how an
        "area" is defined is up to the application developer. Since an
        application can have any number of areas, logging channels are identified
        by a unique string. Application areas can be nested (e.g. an area
        of "input processing" might include sub-areas "read CSV files", "read
        XLS files" and "read Gnumeric files"). To cater for this natural nesting,
        channel names are organized into a namespace hierarchy where levels are
        separated by periods, much like the Java or Python package namespace. So
        in the instance given above, channel names might be "input" for the upper
        level, and "input.csv", "input.xls" and "input.gnu" for the sub-levels.
        There is no arbitrary limit to the depth of nesting.
    """
    def addHandler(self, *args, **kwargs): # real signature unknown
        """ Add the specified handler to this logger. """
        pass

    def callHandlers(self, *args, **kwargs): # real signature unknown
        """
        Pass a record to all relevant handlers.
        
                Loop through all handlers for this logger and its parents in the
                logger hierarchy. If no handler was found, output a one-off error
                message to sys.stderr. Stop searching up the hierarchy whenever a
                logger with the "propagate" attribute set to zero is found - that
                will be the last logger whose handlers are called.
        """
        pass

    def critical(self, *args, **kwargs): # real signature unknown; NOTE: unreliably restored from __doc__ 
        """
        Log 'msg % args' with severity 'CRITICAL'.
        
                To pass exception information, use the keyword argument exc_info with
                a true value, e.g.
        
                logger.critical("Houston, we have a %s", "major disaster", exc_info=1)
        """
        pass

    def debug(self, *args, **kwargs): # real signature unknown; NOTE: unreliably restored from __doc__ 
        """
        Log 'msg % args' with severity 'DEBUG'.
        
                To pass exception information, use the keyword argument exc_info with
                a true value, e.g.
        
                logger.debug("Houston, we have a %s", "thorny problem", exc_info=1)
        """
        pass

    def error(self, *args, **kwargs): # real signature unknown; NOTE: unreliably restored from __doc__ 
        """
        Log 'msg % args' with severity 'ERROR'.
        
                To pass exception information, use the keyword argument exc_info with
                a true value, e.g.
        
                logger.error("Houston, we have a %s", "major problem", exc_info=1)
        """
        pass

    def exception(self, *args, **kwargs): # real signature unknown
        """ Convenience method for logging an ERROR with exception information. """
        pass

    def fatal(self, *args, **kwargs): # real signature unknown
        """
        Log 'msg % args' with severity 'CRITICAL'.
        
                To pass exception information, use the keyword argument exc_info with
                a true value, e.g.
        
                logger.critical("Houston, we have a %s", "major disaster", exc_info=1)
        """
        pass

    def findCaller(self, *args, **kwargs): # real signature unknown
        """
        Find the stack frame of the caller so that we can note the source
                file name, line number and function name.
        """
        pass

    def getChild(self, def_ghi): # real signature unknown; restored from __doc__
        """
        Get a logger which is a descendant to this one.
        
                This is a convenience method, such that
        
                logging.getLogger('abc').getChild('def.ghi')
        
                is the same as
        
                logging.getLogger('abc.def.ghi')
        
                It's useful, for example, when the parent logger is named using
                __name__ rather than a literal string.
        """
        pass

    def getEffectiveLevel(self, *args, **kwargs): # real signature unknown
        """
        Get the effective level for this logger.
        
                Loop through this logger and its parents in the logger hierarchy,
                looking for a non-zero logging level. Return the first one found.
        """
        pass

    def handle(self, *args, **kwargs): # real signature unknown
        """
        Call the handlers for the specified record.
        
                This method is used for unpickled records received from a socket, as
                well as those created locally. Logger-level filtering is applied.
        """
        pass

    def info(self, *args, **kwargs): # real signature unknown; NOTE: unreliably restored from __doc__ 
        """
        Log 'msg % args' with severity 'INFO'.
        
                To pass exception information, use the keyword argument exc_info with
                a true value, e.g.
        
                logger.info("Houston, we have a %s", "interesting problem", exc_info=1)
        """
        pass

    def isEnabledFor(self, *args, **kwargs): # real signature unknown
        """ Is this logger enabled for level 'level'? """
        pass

    def log(self, level, *args, **kwargs): # real signature unknown; NOTE: unreliably restored from __doc__ 
        """
        Log 'msg % args' with the integer severity 'level'.
        
                To pass exception information, use the keyword argument exc_info with
                a true value, e.g.
        
                logger.log(level, "We have a %s", "mysterious problem", exc_info=1)
        """
        pass

    def makeRecord(self, *args, **kwargs): # real signature unknown
        """
        A factory method which can be overridden in subclasses to create
                specialized LogRecords.
        """
        pass

    def removeHandler(self, *args, **kwargs): # real signature unknown
        """ Remove the specified handler from this logger. """
        pass

    def setLevel(self, *args, **kwargs): # real signature unknown
        """ Set the logging level of this logger. """
        pass

    def warn(self, *args, **kwargs): # real signature unknown
        """
        Log 'msg % args' with severity 'WARNING'.
        
                To pass exception information, use the keyword argument exc_info with
                a true value, e.g.
        
                logger.warning("Houston, we have a %s", "bit of a problem", exc_info=1)
        """
        pass

    def warning(self, *args, **kwargs): # real signature unknown; NOTE: unreliably restored from __doc__ 
        """
        Log 'msg % args' with severity 'WARNING'.
        
                To pass exception information, use the keyword argument exc_info with
                a true value, e.g.
        
                logger.warning("Houston, we have a %s", "bit of a problem", exc_info=1)
        """
        pass

    def _log(self, *args, **kwargs): # real signature unknown
        """
        Low-level logging routine which creates a LogRecord and then calls
                all the handlers of this logger to handle the record.
        """
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        """ Initialize the logger with a name and an optional level. """
        pass

    manager = None # (!) real value is ''
    root = None # (!) forward: root, real value is ''


Logger = _loggerClass


class LoggerAdapter(object):
    """
    An adapter for loggers which makes it easier to specify contextual
        information in logging output.
    """
    def critical(self, *args, **kwargs): # real signature unknown
        """
        Delegate a critical call to the underlying logger, after adding
                contextual information from this adapter instance.
        """
        pass

    def debug(self, *args, **kwargs): # real signature unknown
        """
        Delegate a debug call to the underlying logger, after adding
                contextual information from this adapter instance.
        """
        pass

    def error(self, *args, **kwargs): # real signature unknown
        """
        Delegate an error call to the underlying logger, after adding
                contextual information from this adapter instance.
        """
        pass

    def exception(self, *args, **kwargs): # real signature unknown
        """
        Delegate an exception call to the underlying logger, after adding
                contextual information from this adapter instance.
        """
        pass

    def info(self, *args, **kwargs): # real signature unknown
        """
        Delegate an info call to the underlying logger, after adding
                contextual information from this adapter instance.
        """
        pass

    def isEnabledFor(self, *args, **kwargs): # real signature unknown
        """ See if the underlying logger is enabled for the specified level. """
        pass

    def log(self, *args, **kwargs): # real signature unknown
        """
        Delegate a log call to the underlying logger, after adding
                contextual information from this adapter instance.
        """
        pass

    def process(self, *args, **kwargs): # real signature unknown
        """
        Process the logging message and keyword arguments passed in to
                a logging call to insert contextual information. You can either
                manipulate the message itself, the keyword args or both. Return
                the message and kwargs modified (or not) to suit your needs.
        
                Normally, you'll only need to override this one method in a
                LoggerAdapter subclass for your specific needs.
        """
        pass

    def warning(self, *args, **kwargs): # real signature unknown
        """
        Delegate a warning call to the underlying logger, after adding
                contextual information from this adapter instance.
        """
        pass

    def __init__(self, someLogger, dict, *args, **kwargs): # real signature unknown; NOTE: unreliably restored from __doc__ 
        """
        Initialize the adapter with a logger and a dict-like object which
                provides contextual information. This constructor signature allows
                easy stacking of LoggerAdapters, if so desired.
        
                You can effectively pass keyword arguments as shown in the
                following example:
        
                adapter = LoggerAdapter(someLogger, dict(p1=v1, p2="v2"))
        """
        pass

    __weakref__ = property(lambda self: object()) # default

    __dict__ = None # (!) real value is ''


class LogRecord(object):
    """
    A LogRecord instance represents an event being logged.
    
        LogRecord instances are created every time something is logged. They
        contain all the information pertinent to the event being logged. The
        main information passed in is in msg and args, which are combined
        using str(msg) % args to create the message field of the record. The
        record also includes information such as when the record was created,
        the source line where the logging call was made, and any exception
        information to be logged.
    """
    def getMessage(self, *args, **kwargs): # real signature unknown
        """
        Return the message for this LogRecord.
        
                Return the message for this LogRecord after merging any user-supplied
                arguments with the message.
        """
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        """ Initialize a logging record with interesting information. """
        pass

    def __str__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default

    __dict__ = None # (!) real value is ''


class Manager(object):
    """
    There is [under normal circumstances] just one Manager instance, which
        holds the hierarchy of loggers.
    """
    def getLogger(self, *args, **kwargs): # real signature unknown
        """
        Get a logger with the specified name (channel name), creating it
                if it doesn't yet exist. This name is a dot-separated hierarchical
                name, such as "a", "a.b", "a.b.c" or similar.
        
                If a PlaceHolder existed for the specified name [i.e. the logger
                didn't exist but a child of it did], replace it with the created
                logger and fix up the parent/child references which pointed to the
                placeholder to now point to the logger.
        """
        pass

    def setLoggerClass(self, *args, **kwargs): # real signature unknown
        """ Set the class to be used when instantiating a logger with this Manager. """
        pass

    def _fixupChildren(self, *args, **kwargs): # real signature unknown
        """
        Ensure that children of the placeholder ph are connected to the
                specified logger.
        """
        pass

    def _fixupParents(self, *args, **kwargs): # real signature unknown
        """
        Ensure that there are either loggers or placeholders all the way
                from the specified logger to the root of the logger hierarchy.
        """
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        """ Initialize the manager with the root node of the logger hierarchy. """
        pass

    __weakref__ = property(lambda self: object()) # default

    __dict__ = None # (!) real value is ''


class NullHandler(Handler):
    """
    This handler does nothing. It's intended to be used to avoid the
        "No handlers could be found for logger XXX" one-off warning. This is
        important for library code, which may contain code to log events. If a user
        of the library does not configure logging, the one-off warning might be
        produced; to avoid this, the library developer simply needs to instantiate
        a NullHandler and add it to the top-level logger of the library module or
        package.
    """
    def createLock(self, *args, **kwargs): # real signature unknown
        pass

    def emit(self, *args, **kwargs): # real signature unknown
        pass

    def handle(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        """
        Initializes the instance - basically setting the formatter to None
                and the filter list to empty.
        """
        pass


class PlaceHolder(object):
    """
    PlaceHolder instances are used in the Manager logger hierarchy to take
        the place of nodes for which no loggers have been defined. This class is
        intended for internal use only and not as part of the public API.
    """
    def append(self, *args, **kwargs): # real signature unknown
        """ Add the specified logger as a child of this placeholder. """
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        """ Initialize with the specified logger being a child of this placeholder. """
        pass

    __weakref__ = property(lambda self: object()) # default

    __dict__ = None # (!) real value is ''


class RootLogger(Logger):
    """
    A root logger is not that different to any other logger, except that
        it must have a logging level and there is only one instance of it in
        the hierarchy.
    """
    def __init__(self, *args, **kwargs): # real signature unknown
        """ Initialize the logger with the name "root". """
        pass


# variables with complex values

root = None # (!) real value is ''

_defaultFormatter = None # (!) real value is ''

_handlerList = []

_handlers = None # (!) real value is ''

_levelNames = {
    0: 'NOTSET',
    10: 'DEBUG',
    20: 'INFO',
    30: 'WARNING',
    40: 'ERROR',
    50: 'CRITICAL',
    'CRITICAL': 50,
    'DEBUG': 10,
    'ERROR': 40,
    'INFO': 20,
    'NOTSET': 0,
    'WARN': 30,
    'WARNING': 30,
}

_lock = None # (!) real value is ''

__all__ = [
    'BASIC_FORMAT',
    'BufferingFormatter',
    'CRITICAL',
    'DEBUG',
    'ERROR',
    'FATAL',
    'FileHandler',
    'Filter',
    'Formatter',
    'Handler',
    'INFO',
    'LogRecord',
    'Logger',
    'LoggerAdapter',
    'NOTSET',
    'NullHandler',
    'StreamHandler',
    'WARN',
    'WARNING',
    'addLevelName',
    'basicConfig',
    'captureWarnings',
    'critical',
    'debug',
    'disable',
    'error',
    'exception',
    'fatal',
    'getLevelName',
    'getLogger',
    'getLoggerClass',
    'info',
    'log',
    'makeLogRecord',
    'setLoggerClass',
    'warn',
    'warning',
]

