# encoding: utf-8
# module mimetypes
# from /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/mimetypes.pyo by generator 1.99
"""
Guess the MIME type of a file.

This module defines two useful functions:

guess_type(url, strict=1) -- guess the MIME type and encoding of a URL.

guess_extension(type, strict=1) -- guess the extension for a given MIME type.

It also contains the following, for tuning the behavior:

Data:

knownfiles -- list of files to parse
inited -- flag set when init() has been called
suffix_map -- dictionary mapping suffixes to suffixes
encodings_map -- dictionary mapping suffixes to encodings
types_map -- dictionary mapping suffixes to types

Functions:

init([files]) -- parse a list of files, default knownfiles (on Windows, the
  default values are taken from the registry)
read_mime_types(file) -- parse one file, return a dictionary or None
"""

# imports
import posixpath as posixpath # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/posixpath.pyc
import urllib as urllib # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/urllib.py
import sys as sys # <module 'sys' (built-in)>
import os as os # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/os.pyc

# Variables with simple values

inited = False

_db = None

_winreg = None

# functions

def add_type(type, ext, strict=True): # reliably restored by inspect
    """
    Add a mapping between a type and an extension.
    
        When the extension is already known, the new
        type will replace the old one. When the type
        is already known the extension will be added
        to the list of known extensions.
    
        If strict is true, information will be added to
        list of standard types, else to the list of non-standard
        types.
    """
    pass


def guess_all_extensions(type, strict=True): # reliably restored by inspect
    """
    Guess the extensions for a file based on its MIME type.
    
        Return value is a list of strings giving the possible filename
        extensions, including the leading dot ('.').  The extension is not
        guaranteed to have been associated with any particular data
        stream, but would be mapped to the MIME type `type' by
        guess_type().  If no extension can be guessed for `type', None
        is returned.
    
        Optional `strict' argument when false adds a bunch of commonly found,
        but non-standard types.
    """
    pass


def guess_extension(type, strict=True): # reliably restored by inspect
    """
    Guess the extension for a file based on its MIME type.
    
        Return value is a string giving a filename extension, including the
        leading dot ('.').  The extension is not guaranteed to have been
        associated with any particular data stream, but would be mapped to the
        MIME type `type' by guess_type().  If no extension can be guessed for
        `type', None is returned.
    
        Optional `strict' argument when false adds a bunch of commonly found,
        but non-standard types.
    """
    pass


def guess_type(url, strict=True): # reliably restored by inspect
    """
    Guess the type of a file based on its URL.
    
        Return value is a tuple (type, encoding) where type is None if the
        type can't be guessed (no or unknown suffix) or a string of the
        form type/subtype, usable for a MIME Content-type header; and
        encoding is None for no encoding or the name of the program used
        to encode (e.g. compress or gzip).  The mappings are table
        driven.  Encoding suffixes are case sensitive; type suffixes are
        first tried case sensitive, then case insensitive.
    
        The suffixes .tgz, .taz and .tz (case sensitive!) are all mapped
        to ".tar.gz".  (This is table-driven too, using the dictionary
        suffix_map).
    
        Optional `strict' argument when false adds a bunch of commonly found, but
        non-standard types.
    """
    pass


def init(files=None): # reliably restored by inspect
    # no doc
    pass


def read_mime_types(file): # reliably restored by inspect
    # no doc
    pass


def _default_mime_types(): # reliably restored by inspect
    # no doc
    pass


# no classes
# variables with complex values

common_types = {
    '.jpg': 'image/jpg',
    '.mid': 'audio/midi',
    '.midi': 'audio/midi',
    '.pct': 'image/pict',
    '.pic': 'image/pict',
    '.pict': 'image/pict',
    '.rtf': 'application/rtf',
    '.xul': 'text/xul',
}

encodings_map = {
    '.Z': 'compress',
    '.bz2': 'bzip2',
    '.gz': 'gzip',
}

knownfiles = [
    '/etc/mime.types',
    '/etc/httpd/mime.types',
    '/etc/httpd/conf/mime.types',
    '/etc/apache/mime.types',
    '/etc/apache2/mime.types',
    '/usr/local/etc/httpd/conf/mime.types',
    '/usr/local/lib/netscape/mime.types',
    '/usr/local/etc/httpd/conf/mime.types',
    '/usr/local/etc/mime.types',
]

MimeTypes = None # (!) real value is ''

suffix_map = {
    '.taz': '.tar.gz',
    '.tbz2': '.tar.bz2',
    '.tgz': '.tar.gz',
    '.tz': '.tar.gz',
}

types_map = {
    '.a': 'application/octet-stream',
    '.ai': 'application/postscript',
    '.aif': 'audio/x-aiff',
    '.aifc': 'audio/x-aiff',
    '.aiff': 'audio/x-aiff',
    '.au': 'audio/basic',
    '.avi': 'video/x-msvideo',
    '.bat': 'text/plain',
    '.bcpio': 'application/x-bcpio',
    '.bin': 'application/octet-stream',
    '.bmp': 'image/x-ms-bmp',
    '.c': 'text/plain',
    '.cdf': 'application/x-netcdf',
    '.cpio': 'application/x-cpio',
    '.csh': 'application/x-csh',
    '.css': 'text/css',
    '.dll': 'application/octet-stream',
    '.doc': 'application/msword',
    '.dot': 'application/msword',
    '.dvi': 'application/x-dvi',
    '.eml': 'message/rfc822',
    '.eps': 'application/postscript',
    '.etx': 'text/x-setext',
    '.exe': 'application/octet-stream',
    '.gif': 'image/gif',
    '.gtar': 'application/x-gtar',
    '.h': 'text/plain',
    '.hdf': 'application/x-hdf',
    '.htm': 'text/html',
    '.html': 'text/html',
    '.ief': 'image/ief',
    '.jpe': 'image/jpeg',
    '.jpeg': 'image/jpeg',
    '.jpg': 'image/jpeg',
    '.js': 'application/x-javascript',
    '.ksh': 'text/plain',
    '.latex': 'application/x-latex',
    '.m1v': 'video/mpeg',
    '.man': 'application/x-troff-man',
    '.me': 'application/x-troff-me',
    '.mht': 'message/rfc822',
    '.mhtml': 'message/rfc822',
    '.mif': 'application/x-mif',
    '.mov': 'video/quicktime',
    '.movie': 'video/x-sgi-movie',
    '.mp2': 'audio/mpeg',
    '.mp3': 'audio/mpeg',
    '.mp4': 'video/mp4',
    '.mpa': 'video/mpeg',
    '.mpe': 'video/mpeg',
    '.mpeg': 'video/mpeg',
    '.mpg': 'video/mpeg',
    '.ms': 'application/x-troff-ms',
    '.nc': 'application/x-netcdf',
    '.nws': 'message/rfc822',
    '.o': 'application/octet-stream',
    '.obj': 'application/octet-stream',
    '.oda': 'application/oda',
    '.p12': 'application/x-pkcs12',
    '.p7c': 'application/pkcs7-mime',
    '.pbm': 'image/x-portable-bitmap',
    '.pdf': 'application/pdf',
    '.pfx': 'application/x-pkcs12',
    '.pgm': 'image/x-portable-graymap',
    '.pl': 'text/plain',
    '.png': 'image/png',
    '.pnm': 'image/x-portable-anymap',
    '.pot': 'application/vnd.ms-powerpoint',
    '.ppa': 'application/vnd.ms-powerpoint',
    '.ppm': 'image/x-portable-pixmap',
    '.pps': 'application/vnd.ms-powerpoint',
    '.ppt': 'application/vnd.ms-powerpoint',
    '.ps': 'application/postscript',
    '.pwz': 'application/vnd.ms-powerpoint',
    '.py': 'text/x-python',
    '.pyc': 'application/x-python-code',
    '.pyo': 'application/x-python-code',
    '.qt': 'video/quicktime',
    '.ra': 'audio/x-pn-realaudio',
    '.ram': 'application/x-pn-realaudio',
    '.ras': 'image/x-cmu-raster',
    '.rdf': 'application/xml',
    '.rgb': 'image/x-rgb',
    '.roff': 'application/x-troff',
    '.rtx': 'text/richtext',
    '.sgm': 'text/x-sgml',
    '.sgml': 'text/x-sgml',
    '.sh': 'application/x-sh',
    '.shar': 'application/x-shar',
    '.snd': 'audio/basic',
    '.so': 'application/octet-stream',
    '.src': 'application/x-wais-source',
    '.sv4cpio': 'application/x-sv4cpio',
    '.sv4crc': 'application/x-sv4crc',
    '.swf': 'application/x-shockwave-flash',
    '.t': 'application/x-troff',
    '.tar': 'application/x-tar',
    '.tcl': 'application/x-tcl',
    '.tex': 'application/x-tex',
    '.texi': 'application/x-texinfo',
    '.texinfo': 'application/x-texinfo',
    '.tif': 'image/tiff',
    '.tiff': 'image/tiff',
    '.tr': 'application/x-troff',
    '.tsv': 'text/tab-separated-values',
    '.txt': 'text/plain',
    '.ustar': 'application/x-ustar',
    '.vcf': 'text/x-vcard',
    '.wav': 'audio/x-wav',
    '.wiz': 'application/msword',
    '.wsdl': 'application/xml',
    '.xbm': 'image/x-xbitmap',
    '.xlb': 'application/vnd.ms-excel',
    '.xls': 'application/vnd.ms-excel',
    '.xml': 'text/xml',
    '.xpdl': 'application/xml',
    '.xpm': 'image/x-xpixmap',
    '.xsl': 'application/xml',
    '.xwd': 'image/x-xwindowdump',
    '.zip': 'application/zip',
}

__all__ = [
    'guess_type',
    'guess_extension',
    'guess_all_extensions',
    'add_type',
    'read_mime_types',
    'init',
]

