# encoding: utf-8
# module posixfile
# from /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/posixfile.pyo by generator 1.99
"""
Extended file operations available in POSIX.

f = posixfile.open(filename, [mode, [bufsize]])
      will create a new posixfile object

f = posixfile.fileopen(fileobject)
      will create a posixfile object from a builtin file object

f.file()
      will return the original builtin file object

f.dup()
      will return a new file object based on a new filedescriptor

f.dup2(fd)
      will return a new file object based on the given filedescriptor

f.flags(mode)
      will turn on the associated flag (merge)
      mode can contain the following characters:

  (character representing a flag)
      a       append only flag
      c       close on exec flag
      n       no delay flag
      s       synchronization flag
  (modifiers)
      !       turn flags 'off' instead of default 'on'
      =       copy flags 'as is' instead of default 'merge'
      ?       return a string in which the characters represent the flags
              that are set

      note: - the '!' and '=' modifiers are mutually exclusive.
            - the '?' modifier will return the status of the flags after they
              have been changed by other characters in the mode string

f.lock(mode [, len [, start [, whence]]])
      will (un)lock a region
      mode can contain the following characters:

  (character representing type of lock)
      u       unlock
      r       read lock
      w       write lock
  (modifiers)
      |       wait until the lock can be granted
      ?       return the first lock conflicting with the requested lock
              or 'None' if there is no conflict. The lock returned is in the
              format (mode, len, start, whence, pid) where mode is a
              character representing the type of lock ('r' or 'w')

      note: - the '?' modifier prevents a region from being locked; it is
              query only
"""

# imports
import warnings as warnings # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/warnings.pyc

# Variables with simple values

SEEK_CUR = 1
SEEK_END = 2
SEEK_SET = 0

# functions

def fileopen(file): # reliably restored by inspect
    """ Public routine to get a posixfile object from a Python file object. """
    pass


def open(name, mode=None, bufsize=-1): # reliably restored by inspect
    """ Public routine to open a file as a posixfile object. """
    pass


# no classes
# variables with complex values

_posixfile_ = None # (!) real value is ''

