# encoding: utf-8
# module pyclbr
# from /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/pyclbr.pyo by generator 1.99
"""
Parse a Python module and describe its classes and methods.

Parse enough of a Python file to recognize imports and class and
method definitions, and to find out the superclasses of a class.

The interface consists of a single function:
        readmodule_ex(module [, path])
where module is the name of a Python module, and path is an optional
list of directories where the module is to be searched.  If present,
path is prepended to the system search path sys.path.  The return
value is a dictionary.  The keys of the dictionary are the names of
the classes defined in the module (including classes that are defined
via the from XXX import YYY construct).  The values are class
instances of the class Class defined here.  One special key/value pair
is present for packages: the key '__path__' has a list as its value
which contains the package search path.

A class is described by the class Class in this module.  Instances
of this class have the following instance variables:
        module -- the module name
        name -- the name of the class
        super -- a list of super classes (Class instances)
        methods -- a dictionary of methods
        file -- the file in which the class was defined
        lineno -- the line in the file on which the class statement occurred
The dictionary of methods uses the method names as keys and the line
numbers on which the method was defined as values.
If the name of a super class is not recognized, the corresponding
entry in the list of super classes is not a class instance but a
string giving the name of the super class.  Since import statements
are recognized and imported modules are scanned as well, this
shouldn't happen often.

A function is described by the class Function in this module.
Instances of this class have the following instance variables:
        module -- the module name
        name -- the name of the class
        file -- the file in which the class was defined
        lineno -- the line in the file on which the class statement occurred
"""

# imports
import imp as imp # <module 'imp' (built-in)>
import tokenize as tokenize # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/tokenize.pyc
import sys as sys # <module 'sys' (built-in)>
from operator import itemgetter


# Variables with simple values

DEDENT = 6

NAME = 1

OP = 51

# functions

def readmodule(module, path=None): # reliably restored by inspect
    """
    Backwards compatible interface.
    
        Call readmodule_ex() and then only keep Class objects from the
        resulting dictionary.
    """
    pass


def readmodule_ex(module, path=None): # reliably restored by inspect
    """
    Read a module file and return a dictionary of classes.
    
        Search for MODULE in PATH and sys.path, read and parse the
        module and return a dictionary with one entry for each class
        found in the module.
    """
    pass


def _getname(g): # reliably restored by inspect
    # no doc
    pass


def _getnamelist(g): # reliably restored by inspect
    # no doc
    pass


def _main(): # reliably restored by inspect
    # no doc
    pass


def _readmodule(module, path, inpackage=None): # reliably restored by inspect
    """
    Do the hard work for readmodule[_ex].
    
        If INPACKAGE is given, it must be the dotted name of the package in
        which we are searching for a submodule, and then PATH must be the
        package search path; otherwise, we are searching for a top-level
        module, and PATH is combined with sys.path.
    """
    pass


# no classes
# variables with complex values

Class = None # (!) real value is ''

Function = None # (!) real value is ''

_modules = {}

__all__ = [
    'readmodule',
    'readmodule_ex',
    'Class',
    'Function',
]

