# encoding: utf-8
# module tempfile
# from /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/tempfile.pyo by generator 1.99
"""
Temporary files.

This module provides generic, low- and high-level interfaces for
creating temporary files and directories.  The interfaces listed
as "safe" just below can be used without fear of race conditions.
Those listed as "unsafe" cannot, and are provided for backward
compatibility only.

This module also provides some data items to the user:

  TMP_MAX  - maximum number of names that will be tried before
             giving up.
  template - the default prefix for all temporary names.
             You may change this to control the default prefix.
  tempdir  - If this is set to a string before the first use of
             any routine from this module, it will be considered as
             another candidate location to store temporary files.
"""

# imports
import fcntl as _fcntl # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/lib-dynload/fcntl.so
import thread as _thread # <module 'thread' (built-in)>
import errno as _errno # <module 'errno' (built-in)>
import os as _os # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/os.pyc
from cStringIO import _StringIO

from posix import _stat

from thread import _allocate_lock

import _random as ___random


# Variables with simple values

tempdir = None
template = 'tmp'

TMP_MAX = 308915776

_bin_openflags = 2818

_name_sequence = None

_text_openflags = 2818

# functions

def gettempdir(): # reliably restored by inspect
    """ Accessor for tempfile.tempdir. """
    pass


def gettempprefix(): # reliably restored by inspect
    """ Accessor for tempdir.template. """
    pass


def mkdtemp(suffix=None, prefix=None, dir=None): # reliably restored by inspect
    """
    User-callable function to create and return a unique temporary
        directory.  The return value is the pathname of the directory.
    
        Arguments are as for mkstemp, except that the 'text' argument is
        not accepted.
    
        The directory is readable, writable, and searchable only by the
        creating user.
    
        Caller is responsible for deleting the directory when done with it.
    """
    pass


def mkstemp(suffix=None, prefix=None, dir=None, text=False): # reliably restored by inspect
    """
    User-callable function to create and return a unique temporary
        file.  The return value is a pair (fd, name) where fd is the
        file descriptor returned by os.open, and name is the filename.
    
        If 'suffix' is specified, the file name will end with that suffix,
        otherwise there will be no suffix.
    
        If 'prefix' is specified, the file name will begin with that prefix,
        otherwise a default prefix is used.
    
        If 'dir' is specified, the file will be created in that directory,
        otherwise a default directory is used.
    
        If 'text' is specified and true, the file is opened in text
        mode.  Else (the default) the file is opened in binary mode.  On
        some operating systems, this makes no difference.
    
        The file is readable and writable only by the creating user ID.
        If the operating system uses permission bits to indicate whether a
        file is executable, the file is executable by no one. The file
        descriptor is not inherited by children of this process.
    
        Caller is responsible for deleting the file when done with it.
    """
    pass


def mktemp(suffix=None, prefix=None, dir=None): # reliably restored by inspect
    """
    User-callable function to return a unique temporary file name.  The
        file is not created.
    
        Arguments are as for mkstemp, except that the 'text' argument is
        not accepted.
    
        This function is unsafe and should not be used.  The file name
        refers to a file that did not exist at some point, but by the time
        you get around to creating it, someone else may have beaten you to
        the punch.
    """
    pass


def NamedTemporaryFile(mode=None, bufsize=-1, suffix=None, prefix=None, dir=None, delete=True): # reliably restored by inspect
    """
    Create and return a temporary file.
        Arguments:
        'prefix', 'suffix', 'dir' -- as for mkstemp.
        'mode' -- the mode argument to os.fdopen (default "w+b").
        'bufsize' -- the buffer size argument to os.fdopen (default -1).
        'delete' -- whether the file is deleted on close (default True).
        The file is created as mkstemp() would do it.
    
        Returns an object with a file-like interface; the name of the file
        is accessible as file.name.  The file will be automatically deleted
        when it is closed unless the 'delete' argument is set to False.
    """
    pass


def TemporaryFile(mode=None, bufsize=-1, suffix=None, prefix=None, dir=None): # reliably restored by inspect
    """
    Create and return a temporary file.
            Arguments:
            'prefix', 'suffix', 'dir' -- as for mkstemp.
            'mode' -- the mode argument to os.fdopen (default "w+b").
            'bufsize' -- the buffer size argument to os.fdopen (default -1).
            The file is created as mkstemp() would do it.
    
            Returns an object with a file-like interface.  The file has no
            name, and will cease to exist when it is closed.
    """
    pass


def _candidate_tempdir_list(): # reliably restored by inspect
    """
    Generate a list of candidate temporary directories which
        _get_default_tempdir will try.
    """
    pass


def _exists(fn): # reliably restored by inspect
    # no doc
    pass


def _get_candidate_names(): # reliably restored by inspect
    """ Common setup sequence for all user-callable interfaces. """
    pass


def _get_default_tempdir(): # reliably restored by inspect
    """
    Calculate the default directory to use for temporary files.
        This routine should be called exactly once.
    
        We determine whether or not a candidate temp dir is usable by
        trying to create and write to a file in that directory.  If this
        is successful, the test file is deleted.  To prevent denial of
        service, the name of the test file must be randomized.
    """
    pass


def _mkstemp_inner(dir, pre, suf, flags): # reliably restored by inspect
    """ Code common to mkstemp, TemporaryFile, and NamedTemporaryFile. """
    pass


def _set_cloexec(fd): # reliably restored by inspect
    # no doc
    pass


# classes

class _Random(___random.Random):
    """
    Random number generator base class used by bound module functions.
    
        Used to instantiate instances of Random to get generators that don't
        share state.  Especially useful for multi-threaded programs, creating
        a different instance of Random for each thread, and using the jumpahead()
        method to ensure that the generated sequences seen by each thread don't
        overlap.
    
        Class Random can also be subclassed if you want to use a different basic
        generator of your own devising: in that case, override the following
        methods: random(), seed(), getstate(), setstate() and jumpahead().
        Optionally, implement a getrandbits() method so that randrange() can cover
        arbitrarily large ranges.
    """
    def betavariate(self, *args, **kwargs): # real signature unknown
        """
        Beta distribution.
        
                Conditions on the parameters are alpha > 0 and beta > 0.
                Returned values range between 0 and 1.
        """
        pass

    def choice(self, *args, **kwargs): # real signature unknown
        """ Choose a random element from a non-empty sequence. """
        pass

    def expovariate(self, *args, **kwargs): # real signature unknown
        """
        Exponential distribution.
        
                lambd is 1.0 divided by the desired mean.  It should be
                nonzero.  (The parameter would be called "lambda", but that is
                a reserved word in Python.)  Returned values range from 0 to
                positive infinity if lambd is positive, and from negative
                infinity to 0 if lambd is negative.
        """
        pass

    def gammavariate(self, *args, **kwargs): # real signature unknown
        """
        Gamma distribution.  Not the gamma function!
        
                Conditions on the parameters are alpha > 0 and beta > 0.
        """
        pass

    def gauss(self, *args, **kwargs): # real signature unknown
        """
        Gaussian distribution.
        
                mu is the mean, and sigma is the standard deviation.  This is
                slightly faster than the normalvariate() function.
        
                Not thread-safe without a lock around calls.
        """
        pass

    def getstate(self, *args, **kwargs): # real signature unknown
        """ Return internal state; can be passed to setstate() later. """
        pass

    def jumpahead(self, *args, **kwargs): # real signature unknown
        """
        Change the internal state to one that is likely far away
                from the current state.  This method will not be in Py3.x,
                so it is better to simply reseed.
        """
        pass

    def lognormvariate(self, *args, **kwargs): # real signature unknown
        """
        Log normal distribution.
        
                If you take the natural logarithm of this distribution, you'll get a
                normal distribution with mean mu and standard deviation sigma.
                mu can have any value, and sigma must be greater than zero.
        """
        pass

    def normalvariate(self, *args, **kwargs): # real signature unknown
        """
        Normal distribution.
        
                mu is the mean, and sigma is the standard deviation.
        """
        pass

    def paretovariate(self, *args, **kwargs): # real signature unknown
        """ Pareto distribution.  alpha is the shape parameter. """
        pass

    def randint(self, *args, **kwargs): # real signature unknown
        """ Return random integer in range [a, b], including both end points. """
        pass

    def randrange(self, *args, **kwargs): # real signature unknown
        """
        Choose a random item from range(start, stop[, step]).
        
                This fixes the problem with randint() which includes the
                endpoint; in Python this is usually not what you want.
                Do not supply the 'int', 'default', and 'maxwidth' arguments.
        """
        pass

    def sample(self, xrange, *args, **kwargs): # real signature unknown; NOTE: unreliably restored from __doc__ 
        """
        Chooses k unique random elements from a population sequence.
        
                Returns a new list containing elements from the population while
                leaving the original population unchanged.  The resulting list is
                in selection order so that all sub-slices will also be valid random
                samples.  This allows raffle winners (the sample) to be partitioned
                into grand prize and second place winners (the subslices).
        
                Members of the population need not be hashable or unique.  If the
                population contains repeats, then each occurrence is a possible
                selection in the sample.
        
                To choose a sample in a range of integers, use xrange as an argument.
                This is especially fast and space efficient for sampling from a
                large population:   sample(xrange(10000000), 60)
        """
        pass

    def seed(self, *args, **kwargs): # real signature unknown
        """
        Initialize internal state from hashable object.
        
                None or no argument seeds from current time or from an operating
                system specific randomness source if available.
        
                If a is not None or an int or long, hash(a) is used instead.
        """
        pass

    def setstate(self, *args, **kwargs): # real signature unknown
        """ Restore internal state from object returned by getstate(). """
        pass

    def shuffle(self, *args, **kwargs): # real signature unknown
        """
        x, random=random.random -> shuffle list x in place; return None.
        
                Optional arg random is a 0-argument function returning a random
                float in [0.0, 1.0); by default, the standard random.random.
        """
        pass

    def triangular(self, *args, **kwargs): # real signature unknown
        """
        Triangular distribution.
        
                Continuous distribution bounded by given lower and upper limits,
                and having a given mode value in-between.
        
                http://en.wikipedia.org/wiki/Triangular_distribution
        """
        pass

    def uniform(self, *args, **kwargs): # real signature unknown
        """ Get a random number in the range [a, b) or [a, b] depending on rounding. """
        pass

    def vonmisesvariate(self, *args, **kwargs): # real signature unknown
        """
        Circular data distribution.
        
                mu is the mean angle, expressed in radians between 0 and 2*pi, and
                kappa is the concentration parameter, which must be greater than or
                equal to zero.  If kappa is equal to zero, this distribution reduces
                to a uniform random angle over the range 0 to 2*pi.
        """
        pass

    def weibullvariate(self, *args, **kwargs): # real signature unknown
        """
        Weibull distribution.
        
                alpha is the scale parameter and beta is the shape parameter.
        """
        pass

    def _randbelow(self, *args, **kwargs): # real signature unknown
        """
        Return a random int in the range [0,n)
        
                Handles the case where n has more bits than returned
                by a single call to the underlying generator.
        """
        pass

    def __getstate__(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        """
        Initialize an instance.
        
                Optional argument x controls seeding, as for Random.seed().
        """
        pass

    def __reduce__(self, *args, **kwargs): # real signature unknown
        pass

    def __setstate__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default

    VERSION = 3
    __dict__ = None # (!) real value is ''


# variables with complex values

SpooledTemporaryFile = None # (!) real value is ''

_once_lock = None # (!) real value is ''

_RandomNameSequence = None # (!) real value is ''

_TemporaryFileWrapper = None # (!) real value is ''

__all__ = [
    'NamedTemporaryFile',
    'TemporaryFile',
    'SpooledTemporaryFile',
    'mkstemp',
    'mkdtemp',
    'mktemp',
    'TMP_MAX',
    'gettempprefix',
    'tempdir',
    'gettempdir',
]

