# encoding: utf-8
# module turtle
# from /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/lib-tk/turtle.pyo by generator 1.99
"""
Turtle graphics is a popular way for introducing programming to
kids. It was part of the original Logo programming language developed
by Wally Feurzig and Seymour Papert in 1966.

Imagine a robotic turtle starting at (0, 0) in the x-y plane. Give it
the command turtle.forward(15), and it moves (on-screen!) 15 pixels in
the direction it is facing, drawing a line as it moves. Give it the
command turtle.left(25), and it rotates in-place 25 degrees clockwise.

By combining together these and similar commands, intricate shapes and
pictures can easily be drawn.

----- turtle.py

This module is an extended reimplementation of turtle.py from the
Python standard distribution up to Python 2.5. (See: http://www.python.org)

It tries to keep the merits of turtle.py and to be (nearly) 100%
compatible with it. This means in the first place to enable the
learning programmer to use all the commands, classes and methods
interactively when using the module from within IDLE run with
the -n switch.

Roughly it has the following features added:

- Better animation of the turtle movements, especially of turning the
  turtle. So the turtles can more easily be used as a visual feedback
  instrument by the (beginning) programmer.

- Different turtle shapes, gif-images as turtle shapes, user defined
  and user controllable turtle shapes, among them compound
  (multicolored) shapes. Turtle shapes can be stretched and tilted, which
  makes turtles very versatile geometrical objects.

- Fine control over turtle movement and screen updates via delay(),
  and enhanced tracer() and speed() methods.

- Aliases for the most commonly used commands, like fd for forward etc.,
  following the early Logo traditions. This reduces the boring work of
  typing long sequences of commands, which often occur in a natural way
  when kids try to program fancy pictures on their first encounter with
  turtle graphics.

- Turtles now have an undo()-method with configurable undo-buffer.

- Some simple commands/methods for creating event driven programs
  (mouse-, key-, timer-events). Especially useful for programming games.

- A scrollable Canvas class. The default scrollable Canvas can be
  extended interactively as needed while playing around with the turtle(s).

- A TurtleScreen class with methods controlling background color or
  background image, window and canvas size and other properties of the
  TurtleScreen.

- There is a method, setworldcoordinates(), to install a user defined
  coordinate-system for the TurtleScreen.

- The implementation uses a 2-vector class named Vec2D, derived from tuple.
  This class is public, so it can be imported by the application programmer,
  which makes certain types of computations very natural and compact.

- Appearance of the TurtleScreen and the Turtles at startup/import can be
  configured by means of a turtle.cfg configuration file.
  The default configuration mimics the appearance of the old turtle module.

- If configured appropriately the module reads in docstrings from a docstring
  dictionary in some different language, supplied separately  and replaces
  the English ones by those read in. There is a utility function
  write_docstringdict() to write a dictionary with the original (English)
  docstrings to disc, so it can serve as a template for translations.

Behind the scenes there are some features included with possible
extensions in in mind. These will be commented and documented elsewhere.
"""

# imports
import Tkinter as TK # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/lib-tk/Tkinter.pyc
import math as math # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/lib-dynload/math.so
import os as os # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/os.pyc
import types as types # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/types.pyc
import time as time # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/lib-dynload/time.so
from math import (acos, acosh, asin, asinh, atan, atan2, atanh, ceil, 
    copysign, cos, cosh, erf, erfc, exp, expm1, fabs, factorial, floor, fmod, 
    frexp, fsum, gamma, hypot, isinf, isnan, ldexp, lgamma, log, log10, log1p, 
    modf, pow, sin, sinh, sqrt, tan, tanh, trunc)


# Variables with simple values
e = 2.718281828459045

methodname = 'ycor'

pi = 3.141592653589793

_LANGUAGE = 'english'

_ver = 'turtle 1.0b1 - for Python 2.6   -  30. 5. 2008, 18:08'

__stringBody = 'def %(method)s(self, *args, **kw): return self.%(attribute)s.%(method)s(*args, **kw)'

# functions

def addshape(name, shape=None): # reliably restored by inspect
    """
    Adds a turtle shape to TurtleScreen's shapelist.
    
            Arguments:
            (1) name is the name of a gif-file and shape is None.
                Installs the corresponding image shape.
                !! Image-shapes DO NOT rotate when turning the turtle,
                !! so they do not display the heading of the turtle!
            (2) name is an arbitrary string and shape is a tuple
                of pairs of coordinates. Installs the corresponding
                polygon shape
            (3) name is an arbitrary string and shape is a
                (compound) Shape object. Installs the corresponding
                compound shape.
            To use a shape, you have to issue the command shape(shapename).
    
            call: register_shape("turtle.gif")
            --or: register_shape("tri", ((0,0), (10,10), (-10,10)))
    
            Example:
            >>> register_shape("triangle", ((5,-3),(0,5),(-5,-3)))
    """
    pass


def back(distance): # reliably restored by inspect
    """
    Move the turtle backward by distance.
    
            Aliases: back | backward | bk
    
            Argument:
            distance -- a number
    
            Move the turtle backward by distance ,opposite to the direction the
            turtle is headed. Do not change the turtle's heading.
    
            Example:
            >>> position()
            (0.00, 0.00)
            >>> backward(30)
            >>> position()
            (-30.00, 0.00)
    """
    pass


def backward(distance): # reliably restored by inspect
    """
    Move the turtle backward by distance.
    
            Aliases: back | backward | bk
    
            Argument:
            distance -- a number
    
            Move the turtle backward by distance ,opposite to the direction the
            turtle is headed. Do not change the turtle's heading.
    
            Example:
            >>> position()
            (0.00, 0.00)
            >>> backward(30)
            >>> position()
            (-30.00, 0.00)
    """
    pass


def begin_fill(): # reliably restored by inspect
    """
    Called just before drawing a shape to be filled.
    
            No argument.
    
            Example:
            >>> begin_fill()
            >>> forward(100)
            >>> left(90)
            >>> forward(100)
            >>> left(90)
            >>> forward(100)
            >>> left(90)
            >>> forward(100)
            >>> end_fill()
    """
    pass


def begin_poly(): # reliably restored by inspect
    """
    Start recording the vertices of a polygon.
    
            No argument.
    
            Start recording the vertices of a polygon. Current turtle position
            is first point of polygon.
    
            Example:
            >>> begin_poly()
    """
    pass


def bgcolor(*args): # reliably restored by inspect
    """
    Set or return backgroundcolor of the TurtleScreen.
    
            Arguments (if given): a color string or three numbers
            in the range 0..colormode or a 3-tuple of such numbers.
    
            Example:
            >>> bgcolor("orange")
            >>> bgcolor()
            'orange'
            >>> bgcolor(0.5,0,0.5)
            >>> bgcolor()
            '#800080'
    """
    pass


def bgpic(picname=None): # reliably restored by inspect
    """
    Set background image or return name of current backgroundimage.
    
            Optional argument:
            picname -- a string, name of a gif-file or "nopic".
    
            If picname is a filename, set the corresponing image as background.
            If picname is "nopic", delete backgroundimage, if present.
            If picname is None, return the filename of the current backgroundimage.
    
            Example:
            >>> bgpic()
            'nopic'
            >>> bgpic("landscape.gif")
            >>> bgpic()
            'landscape.gif'
    """
    pass


def bk(distance): # reliably restored by inspect
    """
    Move the turtle backward by distance.
    
            Aliases: back | backward | bk
    
            Argument:
            distance -- a number
    
            Move the turtle backward by distance ,opposite to the direction the
            turtle is headed. Do not change the turtle's heading.
    
            Example:
            >>> position()
            (0.00, 0.00)
            >>> backward(30)
            >>> position()
            (-30.00, 0.00)
    """
    pass


def bye(): # reliably restored by inspect
    """
    Shut the turtlegraphics window.
    
            Example:
            >>> bye()
    """
    pass


def circle(radius, extent=None, steps=None): # reliably restored by inspect
    """
    Draw a circle with given radius.
    
            Arguments:
            radius -- a number
            extent (optional) -- a number
            steps (optional) -- an integer
    
            Draw a circle with given radius. The center is radius units left
            of the turtle; extent - an angle - determines which part of the
            circle is drawn. If extent is not given, draw the entire circle.
            If extent is not a full circle, one endpoint of the arc is the
            current pen position. Draw the arc in counterclockwise direction
            if radius is positive, otherwise in clockwise direction. Finally
            the direction of the turtle is changed by the amount of extent.
    
            As the circle is approximated by an inscribed regular polygon,
            steps determines the number of steps to use. If not given,
            it will be calculated automatically. Maybe used to draw regular
            polygons.
    
            call: circle(radius)                  # full circle
            --or: circle(radius, extent)          # arc
            --or: circle(radius, extent, steps)
            --or: circle(radius, steps=6)         # 6-sided polygon
    
            Example:
            >>> circle(50)
            >>> circle(120, 180)  # semicircle
    """
    pass


def clear(): # reliably restored by inspect
    """
    Delete the turtle's drawings from the screen. Do not move 
    
            No arguments.
    
            Delete the turtle's drawings from the screen. Do not move 
            State and position of the turtle as well as drawings of other
            turtles are not affected.
    
            Examples:
            >>> clear()
    """
    pass


def clearscreen(): # reliably restored by inspect
    """
    Delete all drawings and all turtles from the TurtleScreen.
    
            Reset empty TurtleScreen to its initial state: white background,
            no backgroundimage, no eventbindings and tracing on.
    
            No argument.
    
            Example:
            clear()
    
            Note: this method is not available as function.
    """
    pass


def clearstamp(stampid): # reliably restored by inspect
    """
    Delete stamp with given stampid
    
            Argument:
            stampid - an integer, must be return value of previous stamp() call.
    
            Example:
            >>> color("blue")
            >>> astamp = stamp()
            >>> fd(50)
            >>> clearstamp(astamp)
    """
    pass


def clearstamps(n=None): # reliably restored by inspect
    """
    Delete all or first/last n of turtle's stamps.
    
            Optional argument:
            n -- an integer
    
            If n is None, delete all of pen's stamps,
            else if n > 0 delete first n stamps
            else if n < 0 delete last n stamps.
    
            Example:
            >>> for i in range(8):
                    stamp(); fd(30)
            ...
            >>> clearstamps(2)
            >>> clearstamps(-2)
            >>> clearstamps()
    """
    pass


def clone(): # reliably restored by inspect
    """
    Create and return a clone of the 
    
            No argument.
    
            Create and return a clone of the turtle with same position, heading
            and turtle properties.
    
            Example (for a Turtle instance named mick):
            mick = Turtle()
            joe = mick.clone()
    """
    pass


def color(*args): # reliably restored by inspect
    """
    Return or set the pencolor and fillcolor.
    
            Arguments:
            Several input formats are allowed.
            They use 0, 1, 2, or 3 arguments as follows:
    
            color()
                Return the current pencolor and the current fillcolor
                as a pair of color specification strings as are returned
                by pencolor and fillcolor.
            color(colorstring), color((r,g,b)), color(r,g,b)
                inputs as in pencolor, set both, fillcolor and pencolor,
                to the given value.
            color(colorstring1, colorstring2),
            color((r1,g1,b1), (r2,g2,b2))
                equivalent to pencolor(colorstring1) and fillcolor(colorstring2)
                and analogously, if the other input format is used.
    
            If turtleshape is a polygon, outline and interior of that polygon
            is drawn with the newly set colors.
            For mor info see: pencolor, fillcolor
    
            Example:
            >>> color('red', 'green')
            >>> color()
            ('red', 'green')
            >>> colormode(255)
            >>> color((40, 80, 120), (160, 200, 240))
            >>> color()
            ('#285078', '#a0c8f0')
    """
    pass


def colormode(cmode=None): # reliably restored by inspect
    """
    Return the colormode or set it to 1.0 or 255.
    
            Optional argument:
            cmode -- one of the values 1.0 or 255
    
            r, g, b values of colortriples have to be in range 0..cmode.
    
            Example:
            >>> colormode()
            1.0
            >>> colormode(255)
            >>> turtle.pencolor(240,160,80)
    """
    pass


def config_dict(filename): # reliably restored by inspect
    """ Convert content of config-file into dictionary. """
    pass


def deepcopy(x, memo=None, _nil='[]'): # reliably restored by inspect
    """
    Deep copy operation on arbitrary Python objects.
    
        See the module's __doc__ string for more info.
    """
    pass


def degrees(fullcircle=360.0): # reliably restored by inspect
    """
    Set angle measurement units to degrees.
    
            Optional argument:
            fullcircle -  a number
    
            Set angle measurement units, i. e. set number
            of 'degrees' for a full circle. Dafault value is
            360 degrees.
    
            Example:
            >>> left(90)
            >>> heading()
            90
    
            Change angle measurement unit to grad (also known as gon,
            grade, or gradian and equals 1/100-th of the right angle.)
            >>> degrees(400.0)
            >>> heading()
            100
    """
    pass


def delay(delay=None): # reliably restored by inspect
    """
    Return or set the drawing delay in milliseconds.
    
            Optional argument:
            delay -- positive integer
    
            Example:
            >>> delay(15)
            >>> delay()
            15
    """
    pass


def distance(x, y=None): # reliably restored by inspect
    """
    Return the distance from the turtle to (x,y) in turtle step units.
    
            Arguments:
            x -- a number   or  a pair/vector of numbers   or   a turtle instance
            y -- a number       None                            None
    
            call: distance(x, y)         # two coordinates
            --or: distance((x, y))       # a pair (tuple) of coordinates
            --or: distance(vec)          # e.g. as returned by pos()
            --or: distance(mypen)        # where mypen is another turtle
    
            Example:
            >>> pos()
            (0.00, 0.00)
            >>> distance(30,40)
            50.0
            >>> pen = Turtle()
            >>> pen.forward(77)
            >>> distance(pen)
            77.0
    """
    pass


def done(n=0): # reliably restored by inspect
    """ Run the main loop of Tcl. """
    pass


def dot(size=None, *color): # reliably restored by inspect
    """
    Draw a dot with diameter size, using color.
    
            Optional argumentS:
            size -- an integer >= 1 (if given)
            color -- a colorstring or a numeric color tuple
    
            Draw a circular dot with diameter size, using color.
            If size is not given, the maximum of pensize+4 and 2*pensize is used.
    
            Example:
            >>> dot()
            >>> fd(50); dot(20, "blue"); fd(50)
    """
    pass


def down(): # reliably restored by inspect
    """
    Pull the pen down -- drawing when moving.
    
            Aliases: pendown | pd | down
    
            No argument.
    
            Example:
            >>> pendown()
    """
    pass


def end_fill(): # reliably restored by inspect
    """
    Fill the shape drawn after the call begin_fill().
    
            No argument.
    
            Example:
            >>> begin_fill()
            >>> forward(100)
            >>> left(90)
            >>> forward(100)
            >>> left(90)
            >>> forward(100)
            >>> left(90)
            >>> forward(100)
            >>> end_fill()
    """
    pass


def end_poly(): # reliably restored by inspect
    """
    Stop recording the vertices of a polygon.
    
            No argument.
    
            Stop recording the vertices of a polygon. Current turtle position is
            last point of polygon. This will be connected with the first point.
    
            Example:
            >>> end_poly()
    """
    pass


def exitonclick(): # reliably restored by inspect
    """
    Go into mainloop until the mouse is clicked.
    
            No arguments.
    
            Bind bye() method to mouseclick on TurtleScreen.
            If "using_IDLE" - value in configuration dictionary is False
            (default value), enter mainloop.
            If IDLE with -n switch (no subprocess) is used, this value should be
            set to True in turtle.cfg. In this case IDLE's mainloop
            is active also for the client script.
    
            This is a method of the Screen-class and not available for
            TurtleScreen instances.
    
            Example:
            >>> exitonclick()
    """
    pass


def fd(distance): # reliably restored by inspect
    """
    Move the turtle forward by the specified distance.
    
            Aliases: forward | fd
    
            Argument:
            distance -- a number (integer or float)
    
            Move the turtle forward by the specified distance, in the direction
            the turtle is headed.
    
            Example:
            >>> position()
            (0.00, 0.00)
            >>> forward(25)
            >>> position()
            (25.00,0.00)
            >>> forward(-75)
            >>> position()
            (-50.00,0.00)
    """
    pass


def fill(flag=None): # reliably restored by inspect
    """
    Call fill(True) before drawing a shape to fill, fill(False) when done.
    
            Optional argument:
            flag -- True/False (or 1/0 respectively)
    
            Call fill(True) before drawing the shape you want to fill,
            and  fill(False) when done.
            When used without argument: return fillstate (True if filling,
            False else)
    
            Example:
            >>> fill(True)
            >>> forward(100)
            >>> left(90)
            >>> forward(100)
            >>> left(90)
            >>> forward(100)
            >>> left(90)
            >>> forward(100)
            >>> fill(False)
    """
    pass


def fillcolor(*args): # reliably restored by inspect
    """
    Return or set the fillcolor.
    
            Arguments:
            Four input formats are allowed:
              - fillcolor()
                Return the current fillcolor as color specification string,
                possibly in hex-number format (see example).
                May be used as input to another color/pencolor/fillcolor call.
              - fillcolor(colorstring)
                s is a Tk color specification string, such as "red" or "yellow"
              - fillcolor((r, g, b))
                *a tuple* of r, g, and b, which represent, an RGB color,
                and each of r, g, and b are in the range 0..colormode,
                where colormode is either 1.0 or 255
              - fillcolor(r, g, b)
                r, g, and b represent an RGB color, and each of r, g, and b
                are in the range 0..colormode
    
            If turtleshape is a polygon, the interior of that polygon is drawn
            with the newly set fillcolor.
    
            Example:
            >>> fillcolor('violet')
            >>> col = pencolor()
            >>> fillcolor(col)
            >>> fillcolor(0, .5, 0)
    """
    pass


def forward(distance): # reliably restored by inspect
    """
    Move the turtle forward by the specified distance.
    
            Aliases: forward | fd
    
            Argument:
            distance -- a number (integer or float)
    
            Move the turtle forward by the specified distance, in the direction
            the turtle is headed.
    
            Example:
            >>> position()
            (0.00, 0.00)
            >>> forward(25)
            >>> position()
            (25.00,0.00)
            >>> forward(-75)
            >>> position()
            (-50.00,0.00)
    """
    pass


def getcanvas(): # reliably restored by inspect
    """
    Return the Canvas of this TurtleScreen.
    
            No argument.
    
            Example:
            >>> cv = getcanvas()
            >>> cv
            <turtle.ScrolledCanvas instance at 0x010742D8>
    """
    pass


def getmethparlist(ob): # reliably restored by inspect
    """ Get strings describing the arguments for the given object """
    pass


def getpen(): # reliably restored by inspect
    """
    Return the Turtleobject itself.
    
            No argument.
    
            Only reasonable use: as a function to return the 'anonymous turtle':
    
            Example:
            >>> pet = getturtle()
            >>> pet.fd(50)
            >>> pet
            <Turtle object at 0x0187D810>
            >>> turtles()
            [<Turtle object at 0x0187D810>]
    """
    pass


def getscreen(): # reliably restored by inspect
    """
    Return the TurtleScreen object, the turtle is drawing  on.
    
            No argument.
    
            Return the TurtleScreen object, the turtle is drawing  on.
            So TurtleScreen-methods can be called for that object.
    
            Example:
            >>> ts = getscreen()
            >>> ts
            <TurtleScreen object at 0x0106B770>
            >>> ts.bgcolor("pink")
    """
    pass


def getshapes(): # reliably restored by inspect
    """
    Return a list of names of all currently available turtle shapes.
    
            No argument.
    
            Example:
            >>> getshapes()
            ['arrow', 'blank', 'circle', ... , 'turtle']
    """
    pass


def getturtle(): # reliably restored by inspect
    """
    Return the Turtleobject itself.
    
            No argument.
    
            Only reasonable use: as a function to return the 'anonymous turtle':
    
            Example:
            >>> pet = getturtle()
            >>> pet.fd(50)
            >>> pet
            <Turtle object at 0x0187D810>
            >>> turtles()
            [<Turtle object at 0x0187D810>]
    """
    pass


def get_poly(): # reliably restored by inspect
    """
    Return the lastly recorded polygon.
    
            No argument.
    
            Example:
            >>> p = get_poly()
            >>> register_shape("myFavouriteShape", p)
    """
    pass


def goto(x, y=None): # reliably restored by inspect
    """
    Move turtle to an absolute position.
    
            Aliases: setpos | setposition | goto:
    
            Arguments:
            x -- a number      or     a pair/vector of numbers
            y -- a number             None
    
            call: goto(x, y)         # two coordinates
            --or: goto((x, y))       # a pair (tuple) of coordinates
            --or: goto(vec)          # e.g. as returned by pos()
    
            Move turtle to an absolute position. If the pen is down,
            a line will be drawn. The turtle's orientation does not change.
    
            Example:
            >>> tp = pos()
            >>> tp
            (0.00, 0.00)
            >>> setpos(60,30)
            >>> pos()
            (60.00,30.00)
            >>> setpos((20,80))
            >>> pos()
            (20.00,80.00)
            >>> setpos(tp)
            >>> pos()
            (0.00,0.00)
    """
    pass


def heading(): # reliably restored by inspect
    """
    Return the turtle's current heading.
    
            No arguments.
    
            Example:
            >>> left(67)
            >>> heading()
            67.0
    """
    pass


def hideturtle(): # reliably restored by inspect
    """
    Makes the turtle invisible.
    
            Aliases: hideturtle | ht
    
            No argument.
    
            It's a good idea to do this while you're in the
            middle of a complicated drawing, because hiding
            the turtle speeds up the drawing observably.
    
            Example:
            >>> hideturtle()
    """
    pass


def home(): # reliably restored by inspect
    """
    Move turtle to the origin - coordinates (0,0).
    
            No arguments.
    
            Move turtle to the origin - coordinates (0,0) and set its
            heading to its start-orientation (which depends on mode).
    
            Example:
            >>> home()
    """
    pass


def ht(): # reliably restored by inspect
    """
    Makes the turtle invisible.
    
            Aliases: hideturtle | ht
    
            No argument.
    
            It's a good idea to do this while you're in the
            middle of a complicated drawing, because hiding
            the turtle speeds up the drawing observably.
    
            Example:
            >>> hideturtle()
    """
    pass


def isdown(): # reliably restored by inspect
    """
    Return True if pen is down, False if it's up.
    
            No argument.
    
            Example:
            >>> penup()
            >>> isdown()
            False
            >>> pendown()
            >>> isdown()
            True
    """
    pass


def isfile(path): # reliably restored by inspect
    """ Test whether a path is a regular file """
    pass


def isvisible(): # reliably restored by inspect
    """
    Return True if the Turtle is shown, False if it's hidden.
    
            No argument.
    
            Example:
            >>> hideturtle()
            >>> print isvisible():
            False
    """
    pass


def join(a, *p): # reliably restored by inspect
    """
    Join two or more pathname components, inserting '/' as needed.
        If any component is an absolute path, all previous path components
        will be discarded.
    """
    pass


def left(angle): # reliably restored by inspect
    """
    Turn turtle left by angle units.
    
            Aliases: left | lt
    
            Argument:
            angle -- a number (integer or float)
    
            Turn turtle left by angle units. (Units are by default degrees,
            but can be set via the degrees() and radians() functions.)
            Angle orientation depends on mode. (See this.)
    
            Example:
            >>> heading()
            22.0
            >>> left(45)
            >>> heading()
            67.0
    """
    pass


def listen(xdummy=None, ydummy=None): # reliably restored by inspect
    """
    Set focus on TurtleScreen (in order to collect key-events)
    
            No arguments.
            Dummy arguments are provided in order
            to be able to pass listen to the onclick method.
    
            Example:
            >>> listen()
    """
    pass


def lt(angle): # reliably restored by inspect
    """
    Turn turtle left by angle units.
    
            Aliases: left | lt
    
            Argument:
            angle -- a number (integer or float)
    
            Turn turtle left by angle units. (Units are by default degrees,
            but can be set via the degrees() and radians() functions.)
            Angle orientation depends on mode. (See this.)
    
            Example:
            >>> heading()
            22.0
            >>> left(45)
            >>> heading()
            67.0
    """
    pass


def mainloop(n=0): # reliably restored by inspect
    """ Run the main loop of Tcl. """
    pass


def mode(mode=None): # reliably restored by inspect
    """
    Set turtle-mode ('standard', 'logo' or 'world') and perform reset.
    
            Optional argument:
            mode -- on of the strings 'standard', 'logo' or 'world'
    
            Mode 'standard' is compatible with turtle.py.
            Mode 'logo' is compatible with most Logo-Turtle-Graphics.
            Mode 'world' uses userdefined 'worldcoordinates'. *Attention*: in
            this mode angles appear distorted if x/y unit-ratio doesn't equal 1.
            If mode is not given, return the current mode.
    
                 Mode      Initial turtle heading     positive angles
             ------------|-------------------------|-------------------
              'standard'    to the right (east)       counterclockwise
                'logo'        upward    (north)         clockwise
    
            Examples:
            >>> mode('logo')   # resets turtle heading to north
            >>> mode()
            'logo'
    """
    pass


def onclick(fun, btn=1, add=None): # reliably restored by inspect
    """
    Bind fun to mouse-click event on this turtle on canvas.
    
            Arguments:
            fun --  a function with two arguments, to which will be assigned
                    the coordinates of the clicked point on the canvas.
            num --  number of the mouse-button defaults to 1 (left mouse button).
            add --  True or False. If True, new binding will be added, otherwise
                    it will replace a former binding.
    
            Example for the anonymous turtle, i. e. the procedural way:
    
            >>> def turn(x, y):
                    left(360)
    
            >>> onclick(turn) # Now clicking into the turtle will turn it.
            >>> onclick(None)  # event-binding will be removed
    """
    pass


def ondrag(fun, btn=1, add=None): # reliably restored by inspect
    """
    Bind fun to mouse-move event on this turtle on canvas.
    
            Arguments:
            fun -- a function with two arguments, to which will be assigned
                   the coordinates of the clicked point on the canvas.
            num -- number of the mouse-button defaults to 1 (left mouse button).
    
            Every sequence of mouse-move-events on a turtle is preceded by a
            mouse-click event on that 
    
            Example:
            >>> ondrag(goto)
    
            ### Subsequently clicking and dragging a Turtle will
            ### move it across the screen thereby producing handdrawings
            ### (if pen is down).
    """
    pass


def onkey(fun, key): # reliably restored by inspect
    """
    Bind fun to key-release event of key.
    
            Arguments:
            fun -- a function with no arguments
            key -- a string: key (e.g. "a") or key-symbol (e.g. "space")
    
            In order to be able to register key-events, TurtleScreen
            must have focus. (See method listen.)
    
            Example (for a TurtleScreen instance named screen
            and a Turtle instance named turtle):
    
            >>> def f():
                    fd(50)
                    lt(60)
    
    
            >>> onkey(f, "Up")
            >>> listen()
    
            ### Subsequently the turtle can be moved by
            ### repeatedly pressing the up-arrow key,
            ### consequently drawing a hexagon
    """
    pass


def onrelease(fun, btn=1, add=None): # reliably restored by inspect
    """
    Bind fun to mouse-button-release event on this turtle on canvas.
    
            Arguments:
            fun -- a function with two arguments, to which will be assigned
                    the coordinates of the clicked point on the canvas.
            num --  number of the mouse-button defaults to 1 (left mouse button).
    
            Example (for a MyTurtle instance named joe):
            >>> class MyTurtle(Turtle):
                    def glow(self,x,y):
                            self.fillcolor("red")
                    def unglow(self,x,y):
                            self.fillcolor("")
    
            >>> joe = MyTurtle()
            >>> joe.onclick(joe.glow)
            >>> joe.onrelease(joe.unglow)
            ### clicking on joe turns fillcolor red,
            ### unclicking turns it to transparent.
    """
    pass


def onscreenclick(fun, btn=1, add=None): # reliably restored by inspect
    """
    Bind fun to mouse-click event on canvas.
    
            Arguments:
            fun -- a function with two arguments, the coordinates of the
                   clicked point on the canvas.
            num -- the number of the mouse-button, defaults to 1
    
            Example (for a TurtleScreen instance named screen
            and a Turtle instance named turtle):
    
            >>> onclick(turtle.goto)
    
            ### Subsequently clicking into the TurtleScreen will
            ### make the turtle move to the clicked point.
            >>> onclick(None)
    
            ### event-binding will be removed
    """
    pass


def ontimer(fun, t=0): # reliably restored by inspect
    """
    Install a timer, which calls fun after t milliseconds.
    
            Arguments:
            fun -- a function with no arguments.
            t -- a number >= 0
    
            Example:
    
            >>> running = True
            >>> def f():
                    if running:
                            fd(50)
                            lt(60)
                            ontimer(f, 250)
    
            >>> f()   ### makes the turtle marching around
            >>> running = False
    """
    pass


def pd(): # reliably restored by inspect
    """
    Pull the pen down -- drawing when moving.
    
            Aliases: pendown | pd | down
    
            No argument.
    
            Example:
            >>> pendown()
    """
    pass


def pen(pen=None, **pendict): # reliably restored by inspect
    """
    Return or set the pen's attributes.
    
            Arguments:
                pen -- a dictionary with some or all of the below listed keys.
                **pendict -- one or more keyword-arguments with the below
                             listed keys as keywords.
    
            Return or set the pen's attributes in a 'pen-dictionary'
            with the following key/value pairs:
               "shown"      :   True/False
               "pendown"    :   True/False
               "pencolor"   :   color-string or color-tuple
               "fillcolor"  :   color-string or color-tuple
               "pensize"    :   positive number
               "speed"      :   number in range 0..10
               "resizemode" :   "auto" or "user" or "noresize"
               "stretchfactor": (positive number, positive number)
               "outline"    :   positive number
               "tilt"       :   number
    
            This dictionary can be used as argument for a subsequent
            pen()-call to restore the former pen-state. Moreover one
            or more of these attributes can be provided as keyword-arguments.
            This can be used to set several pen attributes in one statement.
    
    
            Examples:
            >>> pen(fillcolor="black", pencolor="red", pensize=10)
            >>> pen()
            {'pensize': 10, 'shown': True, 'resizemode': 'auto', 'outline': 1,
            'pencolor': 'red', 'pendown': True, 'fillcolor': 'black',
            'stretchfactor': (1,1), 'speed': 3}
            >>> penstate=pen()
            >>> color("yellow","")
            >>> penup()
            >>> pen()
            {'pensize': 10, 'shown': True, 'resizemode': 'auto', 'outline': 1,
            'pencolor': 'yellow', 'pendown': False, 'fillcolor': '',
            'stretchfactor': (1,1), 'speed': 3}
            >>> p.pen(penstate, fillcolor="green")
            >>> p.pen()
            {'pensize': 10, 'shown': True, 'resizemode': 'auto', 'outline': 1,
            'pencolor': 'red', 'pendown': True, 'fillcolor': 'green',
            'stretchfactor': (1,1), 'speed': 3}
    """
    pass


def pencolor(*args): # reliably restored by inspect
    """
    Return or set the pencolor.
    
            Arguments:
            Four input formats are allowed:
              - pencolor()
                Return the current pencolor as color specification string,
                possibly in hex-number format (see example).
                May be used as input to another color/pencolor/fillcolor call.
              - pencolor(colorstring)
                s is a Tk color specification string, such as "red" or "yellow"
              - pencolor((r, g, b))
                *a tuple* of r, g, and b, which represent, an RGB color,
                and each of r, g, and b are in the range 0..colormode,
                where colormode is either 1.0 or 255
              - pencolor(r, g, b)
                r, g, and b represent an RGB color, and each of r, g, and b
                are in the range 0..colormode
    
            If turtleshape is a polygon, the outline of that polygon is drawn
            with the newly set pencolor.
    
            Example:
            >>> pencolor('brown')
            >>> tup = (0.2, 0.8, 0.55)
            >>> pencolor(tup)
            >>> pencolor()
            '#33cc8c'
    """
    pass


def pendown(): # reliably restored by inspect
    """
    Pull the pen down -- drawing when moving.
    
            Aliases: pendown | pd | down
    
            No argument.
    
            Example:
            >>> pendown()
    """
    pass


def pensize(width=None): # reliably restored by inspect
    """
    Set or return the line thickness.
    
            Aliases:  pensize | width
    
            Argument:
            width -- positive number
    
            Set the line thickness to width or return it. If resizemode is set
            to "auto" and turtleshape is a polygon, that polygon is drawn with
            the same line thickness. If no argument is given, current pensize
            is returned.
    
            Example:
            >>> pensize()
            1
            pensize(10)   # from here on lines of width 10 are drawn
    """
    pass


def penup(): # reliably restored by inspect
    """
    Pull the pen up -- no drawing when moving.
    
            Aliases: penup | pu | up
    
            No argument
    
            Example:
            >>> penup()
    """
    pass


def pos(): # reliably restored by inspect
    """
    Return the turtle's current location (x,y), as a Vec2D-vector.
    
            Aliases: pos | position
    
            No arguments.
    
            Example:
            >>> pos()
            (0.00, 240.00)
    """
    pass


def position(): # reliably restored by inspect
    """
    Return the turtle's current location (x,y), as a Vec2D-vector.
    
            Aliases: pos | position
    
            No arguments.
    
            Example:
            >>> pos()
            (0.00, 240.00)
    """
    pass


def pu(): # reliably restored by inspect
    """
    Pull the pen up -- no drawing when moving.
    
            Aliases: penup | pu | up
    
            No argument
    
            Example:
            >>> penup()
    """
    pass


def radians(): # reliably restored by inspect
    """
    Set the angle measurement units to radians.
    
            No arguments.
    
            Example:
            >>> heading()
            90
            >>> radians()
            >>> heading()
            1.5707963267948966
    """
    pass


def readconfig(cfgdict): # reliably restored by inspect
    """
    Read config-files, change configuration-dict accordingly.
    
        If there is a turtle.cfg file in the current working directory,
        read it from there. If this contains an importconfig-value,
        say 'myway', construct filename turtle_mayway.cfg else use
        turtle.cfg and read it from the import-directory, where
        turtle.py is located.
        Update configuration dictionary first according to config-file,
        in the import directory, then according to config-file in the
        current working directory.
        If no config-file is found, the default configuration is used.
    """
    pass


def read_docstrings(lang): # reliably restored by inspect
    """
    Read in docstrings from lang-specific docstring dictionary.
    
        Transfer docstrings, translated to lang, from a dictionary-file
        to the methods of classes Screen and Turtle and - in revised form -
        to the corresponding functions.
    """
    pass


def register_shape(name, shape=None): # reliably restored by inspect
    """
    Adds a turtle shape to TurtleScreen's shapelist.
    
            Arguments:
            (1) name is the name of a gif-file and shape is None.
                Installs the corresponding image shape.
                !! Image-shapes DO NOT rotate when turning the turtle,
                !! so they do not display the heading of the turtle!
            (2) name is an arbitrary string and shape is a tuple
                of pairs of coordinates. Installs the corresponding
                polygon shape
            (3) name is an arbitrary string and shape is a
                (compound) Shape object. Installs the corresponding
                compound shape.
            To use a shape, you have to issue the command shape(shapename).
    
            call: register_shape("turtle.gif")
            --or: register_shape("tri", ((0,0), (10,10), (-10,10)))
    
            Example:
            >>> register_shape("triangle", ((5,-3),(0,5),(-5,-3)))
    """
    pass


def reset(): # reliably restored by inspect
    """
    Delete the turtle's drawings and restore its default values.
    
            No argument.
    ,
            Delete the turtle's drawings from the screen, re-center the turtle
            and set variables to the default values.
    
            Example:
            >>> position()
            (0.00,-22.00)
            >>> heading()
            100.0
            >>> reset()
            >>> position()
            (0.00,0.00)
            >>> heading()
            0.0
    """
    pass


def resetscreen(): # reliably restored by inspect
    """
    Reset all Turtles on the Screen to their initial state.
    
            No argument.
    
            Example:
            >>> reset()
    """
    pass


def resizemode(rmode=None): # reliably restored by inspect
    """
    Set resizemode to one of the values: "auto", "user", "noresize".
    
            (Optional) Argument:
            rmode -- one of the strings "auto", "user", "noresize"
    
            Different resizemodes have the following effects:
              - "auto" adapts the appearance of the turtle
                       corresponding to the value of pensize.
              - "user" adapts the appearance of the turtle according to the
                       values of stretchfactor and outlinewidth (outline),
                       which are set by shapesize()
              - "noresize" no adaption of the turtle's appearance takes place.
            If no argument is given, return current resizemode.
            resizemode("user") is called by a call of shapesize with arguments.
    
    
            Examples:
            >>> resizemode("noresize")
            >>> resizemode()
            'noresize'
    """
    pass


def right(angle): # reliably restored by inspect
    """
    Turn turtle right by angle units.
    
            Aliases: right | rt
    
            Argument:
            angle -- a number (integer or float)
    
            Turn turtle right by angle units. (Units are by default degrees,
            but can be set via the degrees() and radians() functions.)
            Angle orientation depends on mode. (See this.)
    
            Example:
            >>> heading()
            22.0
            >>> right(45)
            >>> heading()
            337.0
    """
    pass


def rt(angle): # reliably restored by inspect
    """
    Turn turtle right by angle units.
    
            Aliases: right | rt
    
            Argument:
            angle -- a number (integer or float)
    
            Turn turtle right by angle units. (Units are by default degrees,
            but can be set via the degrees() and radians() functions.)
            Angle orientation depends on mode. (See this.)
    
            Example:
            >>> heading()
            22.0
            >>> right(45)
            >>> heading()
            337.0
    """
    pass


def Screen(): # reliably restored by inspect
    """
    Return the singleton screen object.
        If none exists at the moment, create a new one and return it,
        else return the existing one.
    """
    pass


def screensize(canvwidth=None, canvheight=None, bg=None): # reliably restored by inspect
    """
    Resize the canvas the turtles are drawing on.
    
            Optional arguments:
            canvwidth -- positive integer, new width of canvas in pixels
            canvheight --  positive integer, new height of canvas in pixels
            bg -- colorstring or color-tupel, new backgroundcolor
            If no arguments are given, return current (canvaswidth, canvasheight)
    
            Do not alter the drawing window. To observe hidden parts of
            the canvas use the scrollbars. (Can make visible those parts
            of a drawing, which were outside the canvas before!)
    
            Example (for a Turtle instance named turtle):
            >>> turtle.screensize(2000,1500)
                ### e. g. to search for an erroneously escaped turtle ;-)
    """
    pass


def seth(to_angle): # reliably restored by inspect
    """
    Set the orientation of the turtle to to_angle.
    
            Aliases:  setheading | seth
    
            Argument:
            to_angle -- a number (integer or float)
    
            Set the orientation of the turtle to to_angle.
            Here are some common directions in degrees:
    
             standard - mode:          logo-mode:
            -------------------|--------------------
               0 - east                0 - north
              90 - north              90 - east
             180 - west              180 - south
             270 - south             270 - west
    
            Example:
            >>> setheading(90)
            >>> heading()
            90
    """
    pass


def setheading(to_angle): # reliably restored by inspect
    """
    Set the orientation of the turtle to to_angle.
    
            Aliases:  setheading | seth
    
            Argument:
            to_angle -- a number (integer or float)
    
            Set the orientation of the turtle to to_angle.
            Here are some common directions in degrees:
    
             standard - mode:          logo-mode:
            -------------------|--------------------
               0 - east                0 - north
              90 - north              90 - east
             180 - west              180 - south
             270 - south             270 - west
    
            Example:
            >>> setheading(90)
            >>> heading()
            90
    """
    pass


def setpos(x, y=None): # reliably restored by inspect
    """
    Move turtle to an absolute position.
    
            Aliases: setpos | setposition | goto:
    
            Arguments:
            x -- a number      or     a pair/vector of numbers
            y -- a number             None
    
            call: goto(x, y)         # two coordinates
            --or: goto((x, y))       # a pair (tuple) of coordinates
            --or: goto(vec)          # e.g. as returned by pos()
    
            Move turtle to an absolute position. If the pen is down,
            a line will be drawn. The turtle's orientation does not change.
    
            Example:
            >>> tp = pos()
            >>> tp
            (0.00, 0.00)
            >>> setpos(60,30)
            >>> pos()
            (60.00,30.00)
            >>> setpos((20,80))
            >>> pos()
            (20.00,80.00)
            >>> setpos(tp)
            >>> pos()
            (0.00,0.00)
    """
    pass


def setposition(x, y=None): # reliably restored by inspect
    """
    Move turtle to an absolute position.
    
            Aliases: setpos | setposition | goto:
    
            Arguments:
            x -- a number      or     a pair/vector of numbers
            y -- a number             None
    
            call: goto(x, y)         # two coordinates
            --or: goto((x, y))       # a pair (tuple) of coordinates
            --or: goto(vec)          # e.g. as returned by pos()
    
            Move turtle to an absolute position. If the pen is down,
            a line will be drawn. The turtle's orientation does not change.
    
            Example:
            >>> tp = pos()
            >>> tp
            (0.00, 0.00)
            >>> setpos(60,30)
            >>> pos()
            (60.00,30.00)
            >>> setpos((20,80))
            >>> pos()
            (20.00,80.00)
            >>> setpos(tp)
            >>> pos()
            (0.00,0.00)
    """
    pass


def settiltangle(angle): # reliably restored by inspect
    """
    Rotate the turtleshape to point in the specified direction
    
            Optional argument:
            angle -- number
    
            Rotate the turtleshape to point in the direction specified by angle,
            regardless of its current tilt-angle. DO NOT change the turtle's
            heading (direction of movement).
    
    
            Examples:
            >>> shape("circle")
            >>> shapesize(5,2)
            >>> settiltangle(45)
            >>> stamp()
            >>> fd(50)
            >>> settiltangle(-45)
            >>> stamp()
            >>> fd(50)
    """
    pass


def setundobuffer(size): # reliably restored by inspect
    """
    Set or disable undobuffer.
    
            Argument:
            size -- an integer or None
    
            If size is an integer an empty undobuffer of given size is installed.
            Size gives the maximum number of turtle-actions that can be undone
            by the undo() function.
            If size is None, no undobuffer is present.
    
            Example:
            >>> setundobuffer(42)
    """
    pass


def setup(width=0.5, height=0.75, startx=None, starty=None): # reliably restored by inspect
    """
    Set the size and position of the main window.
    
            Arguments:
            width: as integer a size in pixels, as float a fraction of the 
              Default is 50% of 
            height: as integer the height in pixels, as float a fraction of the
               Default is 75% of 
            startx: if positive, starting position in pixels from the left
              edge of the screen, if negative from the right edge
              Default, startx=None is to center window horizontally.
            starty: if positive, starting position in pixels from the top
              edge of the screen, if negative from the bottom edge
              Default, starty=None is to center window vertically.
    
            Examples:
            >>> setup (width=200, height=200, startx=0, starty=0)
    
            sets window to 200x200 pixels, in upper left of screen
    
            >>> setup(width=.75, height=0.5, startx=None, starty=None)
    
            sets window to 75% of screen by 50% of screen and centers
    """
    pass


def setworldcoordinates(llx, lly, urx, ury): # reliably restored by inspect
    """
    Set up a user defined coordinate-system.
    
            Arguments:
            llx -- a number, x-coordinate of lower left corner of canvas
            lly -- a number, y-coordinate of lower left corner of canvas
            urx -- a number, x-coordinate of upper right corner of canvas
            ury -- a number, y-coordinate of upper right corner of canvas
    
            Set up user coodinat-system and switch to mode 'world' if necessary.
            This performs a reset. If mode 'world' is already active,
            all drawings are redrawn according to the new coordinates.
    
            But ATTENTION: in user-defined coordinatesystems angles may appear
            distorted. (see Screen.mode())
    
            Example:
            >>> setworldcoordinates(-10,-0.5,50,1.5)
            >>> for _ in range(36):
                    left(10)
                    forward(0.5)
    """
    pass


def setx(x): # reliably restored by inspect
    """
    Set the turtle's first coordinate to x
    
            Argument:
            x -- a number (integer or float)
    
            Set the turtle's first coordinate to x, leave second coordinate
            unchanged.
    
            Example:
            >>> position()
            (0.00, 240.00)
            >>> setx(10)
            >>> position()
            (10.00, 240.00)
    """
    pass


def sety(y): # reliably restored by inspect
    """
    Set the turtle's second coordinate to y
    
            Argument:
            y -- a number (integer or float)
    
            Set the turtle's first coordinate to x, second coordinate remains
            unchanged.
    
            Example:
            >>> position()
            (0.00, 40.00)
            >>> sety(-10)
            >>> position()
            (0.00, -10.00)
    """
    pass


def shape(name=None): # reliably restored by inspect
    """
    Set turtle shape to shape with given name / return current shapename.
    
            Optional argument:
            name -- a string, which is a valid shapename
    
            Set turtle shape to shape with given name or, if name is not given,
            return name of current shape.
            Shape with name must exist in the TurtleScreen's shape dictionary.
            Initially there are the following polygon shapes:
            'arrow', 'turtle', 'circle', 'square', 'triangle', 'classic'.
            To learn about how to deal with shapes see Screen-method register_shape.
    
            Example:
            >>> shape()
            'arrow'
            >>> shape("turtle")
            >>> shape()
            'turtle'
    """
    pass


def shapesize(stretch_wid=None, stretch_len=None, outline=None): # reliably restored by inspect
    """
    Set/return turtle's stretchfactors/outline. Set resizemode to "user".
    
            Optinonal arguments:
               stretch_wid : positive number
               stretch_len : positive number
               outline  : positive number
    
            Return or set the pen's attributes x/y-stretchfactors and/or outline.
            Set resizemode to "user".
            If and only if resizemode is set to "user", the turtle will be displayed
            stretched according to its stretchfactors:
            stretch_wid is stretchfactor perpendicular to orientation
            stretch_len is stretchfactor in direction of turtles orientation.
            outline determines the width of the shapes's outline.
    
            Examples:
            >>> resizemode("user")
            >>> shapesize(5, 5, 12)
            >>> shapesize(outline=8)
    """
    pass


def showturtle(): # reliably restored by inspect
    """
    Makes the turtle visible.
    
            Aliases: showturtle | st
    
            No argument.
    
            Example:
            >>> hideturtle()
            >>> showturtle()
    """
    pass


def speed(speed=None): # reliably restored by inspect
    """
    Return or set the turtle's speed.
    
            Optional argument:
            speed -- an integer in the range 0..10 or a speedstring (see below)
    
            Set the turtle's speed to an integer value in the range 0 .. 10.
            If no argument is given: return current speed.
    
            If input is a number greater than 10 or smaller than 0.5,
            speed is set to 0.
            Speedstrings  are mapped to speedvalues in the following way:
                'fastest' :  0
                'fast'    :  10
                'normal'  :  6
                'slow'    :  3
                'slowest' :  1
            speeds from 1 to 10 enforce increasingly faster animation of
            line drawing and turtle turning.
    
            Attention:
            speed = 0 : *no* animation takes place. forward/back makes turtle jump
            and likewise left/right make the turtle turn instantly.
    
            Example:
            >>> speed(3)
    """
    pass


def split(p): # reliably restored by inspect
    """
    Split a pathname.  Returns tuple "(head, tail)" where "tail" is
        everything after the final slash.  Either part may be empty.
    """
    pass


def st(): # reliably restored by inspect
    """
    Makes the turtle visible.
    
            Aliases: showturtle | st
    
            No argument.
    
            Example:
            >>> hideturtle()
            >>> showturtle()
    """
    pass


def stamp(): # reliably restored by inspect
    """
    Stamp a copy of the turtleshape onto the canvas and return its id.
    
            No argument.
    
            Stamp a copy of the turtle shape onto the canvas at the current
            turtle position. Return a stamp_id for that stamp, which can be
            used to delete it by calling clearstamp(stamp_id).
    
            Example:
            >>> color("blue")
            >>> stamp()
            13
            >>> fd(50)
    """
    pass


def tilt(angle): # reliably restored by inspect
    """
    Rotate the turtleshape by angle.
    
            Argument:
            angle - a number
    
            Rotate the turtleshape by angle from its current tilt-angle,
            but do NOT change the turtle's heading (direction of movement).
    
            Examples:
            >>> shape("circle")
            >>> shapesize(5,2)
            >>> tilt(30)
            >>> fd(50)
            >>> tilt(30)
            >>> fd(50)
    """
    pass


def tiltangle(): # reliably restored by inspect
    """
    Return the current tilt-angle.
    
            No argument.
    
            Return the current tilt-angle, i. e. the angle between the
            orientation of the turtleshape and the heading of the turtle
            (its direction of movement).
    
            Examples:
            >>> shape("circle")
            >>> shapesize(5,2)
            >>> tilt(45)
            >>> tiltangle()
            >>>
    """
    pass


def title(titlestring): # reliably restored by inspect
    """
    Set title of turtle-window
    
            Argument:
            titlestring -- a string, to appear in the titlebar of the
                           turtle graphics window.
    
            This is a method of Screen-class. Not available for TurtleScreen-
            objects.
    
            Example:
            >>> title("Welcome to the turtle-zoo!")
    """
    pass


def towards(x, y=None): # reliably restored by inspect
    """
    Return the angle of the line from the turtle's position to (x, y).
    
            Arguments:
            x -- a number   or  a pair/vector of numbers   or   a turtle instance
            y -- a number       None                            None
    
            call: distance(x, y)         # two coordinates
            --or: distance((x, y))       # a pair (tuple) of coordinates
            --or: distance(vec)          # e.g. as returned by pos()
            --or: distance(mypen)        # where mypen is another turtle
    
            Return the angle, between the line from turtle-position to position
            specified by x, y and the turtle's start orientation. (Depends on
            modes - "standard" or "logo")
    
            Example:
            >>> pos()
            (10.00, 10.00)
            >>> towards(0,0)
            225.0
    """
    pass


def tracer(flag=None, delay=None): # reliably restored by inspect
    """
    Turns turtle animation on/off and set delay for update drawings.
    
            Optional arguments:
            n -- nonnegative  integer
            delay -- nonnegative  integer
    
            If n is given, only each n-th regular screen update is really performed.
            (Can be used to accelerate the drawing of complex graphics.)
            Second arguments sets delay value (see RawTurtle.delay())
    
            Example:
            >>> tracer(8, 25)
            >>> dist = 2
            >>> for i in range(200):
                    fd(dist)
                    rt(90)
                    dist += 2
    """
    pass


def turtles(): # reliably restored by inspect
    """
    Return the list of turtles on the 
    
            Example:
            >>> turtles()
            [<turtle.Turtle object at 0x00E11FB0>]
    """
    pass


def turtlesize(stretch_wid=None, stretch_len=None, outline=None): # reliably restored by inspect
    """
    Set/return turtle's stretchfactors/outline. Set resizemode to "user".
    
            Optinonal arguments:
               stretch_wid : positive number
               stretch_len : positive number
               outline  : positive number
    
            Return or set the pen's attributes x/y-stretchfactors and/or outline.
            Set resizemode to "user".
            If and only if resizemode is set to "user", the turtle will be displayed
            stretched according to its stretchfactors:
            stretch_wid is stretchfactor perpendicular to orientation
            stretch_len is stretchfactor in direction of turtles orientation.
            outline determines the width of the shapes's outline.
    
            Examples:
            >>> resizemode("user")
            >>> shapesize(5, 5, 12)
            >>> shapesize(outline=8)
    """
    pass


def undo(): # reliably restored by inspect
    """
    undo (repeatedly) the last turtle action.
    
            No argument.
    
            undo (repeatedly) the last turtle action.
            Number of available undo actions is determined by the size of
            the undobuffer.
    
            Example:
            >>> for i in range(4):
                    fd(50); lt(80)
    
            >>> for i in range(8):
                    undo()
    """
    pass


def undobufferentries(): # reliably restored by inspect
    """
    Return count of entries in the undobuffer.
    
            No argument.
    
            Example:
            >>> while undobufferentries():
                    undo()
    """
    pass


def up(): # reliably restored by inspect
    """
    Pull the pen up -- no drawing when moving.
    
            Aliases: penup | pu | up
    
            No argument
    
            Example:
            >>> penup()
    """
    pass


def update(): # reliably restored by inspect
    """ Perform a TurtleScreen update. """
    pass


def width(width=None): # reliably restored by inspect
    """
    Set or return the line thickness.
    
            Aliases:  pensize | width
    
            Argument:
            width -- positive number
    
            Set the line thickness to width or return it. If resizemode is set
            to "auto" and turtleshape is a polygon, that polygon is drawn with
            the same line thickness. If no argument is given, current pensize
            is returned.
    
            Example:
            >>> pensize()
            1
            pensize(10)   # from here on lines of width 10 are drawn
    """
    pass


def window_height(): # reliably restored by inspect
    """
    Return the height of the turtle window.
    
            No argument.
    
            Example (for a TurtleScreen instance named screen):
            >>> screen.window_height()
            480
    """
    pass


def window_width(): # reliably restored by inspect
    """
    Returns the width of the turtle window.
    
            No argument.
    
            Example (for a TurtleScreen instance named screen):
            >>> screen.window_width()
            640
    """
    pass


def write(arg, move=False, align=None, font="('Arial', 8, 'normal')"): # reliably restored by inspect
    """
    Write text at the current turtle position.
    
            Arguments:
            arg -- info, which is to be written to the TurtleScreen
            move (optional) -- True/False
            align (optional) -- one of the strings "left", "center" or right"
            font (optional) -- a triple (fontname, fontsize, fonttype)
    
            Write text - the string representation of arg - at the current
            turtle position according to align ("left", "center" or right")
            and with the given font.
            If move is True, the pen is moved to the bottom-right corner
            of the text. By default, move is False.
    
            Example:
            >>> write('Home = ', True, align="center")
            >>> write((0,0), True)
    """
    pass


def write_docstringdict(filename=None): # reliably restored by inspect
    """
    Create and write docstring-dictionary to file.
    
        Optional argument:
        filename -- a string, used as filename
                    default value is turtle_docstringdict
    
        Has to be called explicitely, (not used by the turtle-graphics classes)
        The docstring dictionary will be written to the Python script <filname>.py
        It is intended to serve as a template for translation of the docstrings
        into different languages.
    """
    pass


def xcor(): # reliably restored by inspect
    """
    Return the turtle's x coordinate.
    
            No arguments.
    
            Example:
            >>> reset()
            >>> left(60)
            >>> forward(100)
            >>> print xcor()
            50.0
    """
    pass


def ycor(): # reliably restored by inspect
    """
    Return the turtle's y coordinate
            ---
            No arguments.
    
            Example:
            >>> reset()
            >>> left(60)
            >>> forward(100)
            >>> print ycor()
            86.6025403784
    """
    pass


def _getpen(): # reliably restored by inspect
    """ Create the 'anonymous' turtle if not already present. """
    pass


def _getscreen(): # reliably restored by inspect
    """ Create a TurtleScreen if not already present. """
    pass


def _screen_docrevise(docstr): # reliably restored by inspect
    """ To reduce docstrings from TurtleScreen class for functions """
    pass


def _turtle_docrevise(docstr): # reliably restored by inspect
    """ To reduce docstrings from RawTurtle class for functions """
    pass


def __forwardmethods(fromClass, toClass, toPart, exclude='()'): # reliably restored by inspect
    """
    Helper functions for Scrolled Canvas, used to forward
        ScrolledCanvas-methods to Tkinter.Canvas class.
    """
    pass


def __methodDict(cls, _dict): # reliably restored by inspect
    """ helper function for Scrolled Canvas """
    pass


def __methods(cls): # reliably restored by inspect
    """ helper function for Scrolled Canvas """
    pass


# classes

class TNavigator(object):
    """
    Navigation part of the RawTurtle.
        Implements methods for turtle movement.
    """
    def back(self, *args, **kwargs): # real signature unknown
        """
        Move the turtle backward by distance.
        
                Aliases: back | backward | bk
        
                Argument:
                distance -- a number
        
                Move the turtle backward by distance ,opposite to the direction the
                turtle is headed. Do not change the turtle's heading.
        
                Example (for a Turtle instance named turtle):
                >>> turtle.position()
                (0.00, 0.00)
                >>> turtle.backward(30)
                >>> turtle.position()
                (-30.00, 0.00)
        """
        pass

    def backward(self, *args, **kwargs): # real signature unknown; NOTE: unreliably restored from __doc__ 
        """
        Move the turtle backward by distance.
        
                Aliases: back | backward | bk
        
                Argument:
                distance -- a number
        
                Move the turtle backward by distance ,opposite to the direction the
                turtle is headed. Do not change the turtle's heading.
        
                Example (for a Turtle instance named turtle):
                >>> turtle.position()
                (0.00, 0.00)
                >>> turtle.backward(30)
                >>> turtle.position()
                (-30.00, 0.00)
        """
        pass

    def bk(self, *args, **kwargs): # real signature unknown
        """
        Move the turtle backward by distance.
        
                Aliases: back | backward | bk
        
                Argument:
                distance -- a number
        
                Move the turtle backward by distance ,opposite to the direction the
                turtle is headed. Do not change the turtle's heading.
        
                Example (for a Turtle instance named turtle):
                >>> turtle.position()
                (0.00, 0.00)
                >>> turtle.backward(30)
                >>> turtle.position()
                (-30.00, 0.00)
        """
        pass

    def circle(self, radius): # real signature unknown; restored from __doc__
        """
        Draw a circle with given radius.
        
                Arguments:
                radius -- a number
                extent (optional) -- a number
                steps (optional) -- an integer
        
                Draw a circle with given radius. The center is radius units left
                of the turtle; extent - an angle - determines which part of the
                circle is drawn. If extent is not given, draw the entire circle.
                If extent is not a full circle, one endpoint of the arc is the
                current pen position. Draw the arc in counterclockwise direction
                if radius is positive, otherwise in clockwise direction. Finally
                the direction of the turtle is changed by the amount of extent.
        
                As the circle is approximated by an inscribed regular polygon,
                steps determines the number of steps to use. If not given,
                it will be calculated automatically. Maybe used to draw regular
                polygons.
        
                call: circle(radius)                  # full circle
                --or: circle(radius, extent)          # arc
                --or: circle(radius, extent, steps)
                --or: circle(radius, steps=6)         # 6-sided polygon
        
                Example (for a Turtle instance named turtle):
                >>> turtle.circle(50)
                >>> turtle.circle(120, 180)  # semicircle
        """
        pass

    def degrees(self, *args, **kwargs): # real signature unknown; NOTE: unreliably restored from __doc__ 
        """
        Set angle measurement units to degrees.
        
                Optional argument:
                fullcircle -  a number
        
                Set angle measurement units, i. e. set number
                of 'degrees' for a full circle. Dafault value is
                360 degrees.
        
                Example (for a Turtle instance named turtle):
                >>> turtle.left(90)
                >>> turtle.heading()
                90
        
                Change angle measurement unit to grad (also known as gon,
                grade, or gradian and equals 1/100-th of the right angle.)
                >>> turtle.degrees(400.0)
                >>> turtle.heading()
                100
        """
        pass

    def distance(self, x, y): # real signature unknown; restored from __doc__
        """
        Return the distance from the turtle to (x,y) in turtle step units.
        
                Arguments:
                x -- a number   or  a pair/vector of numbers   or   a turtle instance
                y -- a number       None                            None
        
                call: distance(x, y)         # two coordinates
                --or: distance((x, y))       # a pair (tuple) of coordinates
                --or: distance(vec)          # e.g. as returned by pos()
                --or: distance(mypen)        # where mypen is another turtle
        
                Example (for a Turtle instance named turtle):
                >>> turtle.pos()
                (0.00, 0.00)
                >>> turtle.distance(30,40)
                50.0
                >>> pen = Turtle()
                >>> pen.forward(77)
                >>> turtle.distance(pen)
                77.0
        """
        pass

    def fd(self, *args, **kwargs): # real signature unknown
        """
        Move the turtle forward by the specified distance.
        
                Aliases: forward | fd
        
                Argument:
                distance -- a number (integer or float)
        
                Move the turtle forward by the specified distance, in the direction
                the turtle is headed.
        
                Example (for a Turtle instance named turtle):
                >>> turtle.position()
                (0.00, 0.00)
                >>> turtle.forward(25)
                >>> turtle.position()
                (25.00,0.00)
                >>> turtle.forward(-75)
                >>> turtle.position()
                (-50.00,0.00)
        """
        pass

    def forward(self, *args, **kwargs): # real signature unknown; NOTE: unreliably restored from __doc__ 
        """
        Move the turtle forward by the specified distance.
        
                Aliases: forward | fd
        
                Argument:
                distance -- a number (integer or float)
        
                Move the turtle forward by the specified distance, in the direction
                the turtle is headed.
        
                Example (for a Turtle instance named turtle):
                >>> turtle.position()
                (0.00, 0.00)
                >>> turtle.forward(25)
                >>> turtle.position()
                (25.00,0.00)
                >>> turtle.forward(-75)
                >>> turtle.position()
                (-50.00,0.00)
        """
        pass

    def goto(self, x, y): # real signature unknown; restored from __doc__
        """
        Move turtle to an absolute position.
        
                Aliases: setpos | setposition | goto:
        
                Arguments:
                x -- a number      or     a pair/vector of numbers
                y -- a number             None
        
                call: goto(x, y)         # two coordinates
                --or: goto((x, y))       # a pair (tuple) of coordinates
                --or: goto(vec)          # e.g. as returned by pos()
        
                Move turtle to an absolute position. If the pen is down,
                a line will be drawn. The turtle's orientation does not change.
        
                Example (for a Turtle instance named turtle):
                >>> tp = turtle.pos()
                >>> tp
                (0.00, 0.00)
                >>> turtle.setpos(60,30)
                >>> turtle.pos()
                (60.00,30.00)
                >>> turtle.setpos((20,80))
                >>> turtle.pos()
                (20.00,80.00)
                >>> turtle.setpos(tp)
                >>> turtle.pos()
                (0.00,0.00)
        """
        pass

    def heading(self): # real signature unknown; restored from __doc__
        """
        Return the turtle's current heading.
        
                No arguments.
        
                Example (for a Turtle instance named turtle):
                >>> turtle.left(67)
                >>> turtle.heading()
                67.0
        """
        pass

    def home(self): # real signature unknown; restored from __doc__
        """
        Move turtle to the origin - coordinates (0,0).
        
                No arguments.
        
                Move turtle to the origin - coordinates (0,0) and set its
                heading to its start-orientation (which depends on mode).
        
                Example (for a Turtle instance named turtle):
                >>> turtle.home()
        """
        pass

    def left(self, *args, **kwargs): # real signature unknown; NOTE: unreliably restored from __doc__ 
        """
        Turn turtle left by angle units.
        
                Aliases: left | lt
        
                Argument:
                angle -- a number (integer or float)
        
                Turn turtle left by angle units. (Units are by default degrees,
                but can be set via the degrees() and radians() functions.)
                Angle orientation depends on mode. (See this.)
        
                Example (for a Turtle instance named turtle):
                >>> turtle.heading()
                22.0
                >>> turtle.left(45)
                >>> turtle.heading()
                67.0
        """
        pass

    def lt(self, *args, **kwargs): # real signature unknown
        """
        Turn turtle left by angle units.
        
                Aliases: left | lt
        
                Argument:
                angle -- a number (integer or float)
        
                Turn turtle left by angle units. (Units are by default degrees,
                but can be set via the degrees() and radians() functions.)
                Angle orientation depends on mode. (See this.)
        
                Example (for a Turtle instance named turtle):
                >>> turtle.heading()
                22.0
                >>> turtle.left(45)
                >>> turtle.heading()
                67.0
        """
        pass

    def pos(self): # real signature unknown; restored from __doc__
        """
        Return the turtle's current location (x,y), as a Vec2D-vector.
        
                Aliases: pos | position
        
                No arguments.
        
                Example (for a Turtle instance named turtle):
                >>> turtle.pos()
                (0.00, 240.00)
        """
        pass

    def position(self, *args, **kwargs): # real signature unknown
        """
        Return the turtle's current location (x,y), as a Vec2D-vector.
        
                Aliases: pos | position
        
                No arguments.
        
                Example (for a Turtle instance named turtle):
                >>> turtle.pos()
                (0.00, 240.00)
        """
        pass

    def radians(self): # real signature unknown; restored from __doc__
        """
        Set the angle measurement units to radians.
        
                No arguments.
        
                Example (for a Turtle instance named turtle):
                >>> turtle.heading()
                90
                >>> turtle.radians()
                >>> turtle.heading()
                1.5707963267948966
        """
        pass

    def reset(self, *args, **kwargs): # real signature unknown
        """
        reset turtle to its initial values
        
                Will be overwritten by parent class
        """
        pass

    def right(self, *args, **kwargs): # real signature unknown; NOTE: unreliably restored from __doc__ 
        """
        Turn turtle right by angle units.
        
                Aliases: right | rt
        
                Argument:
                angle -- a number (integer or float)
        
                Turn turtle right by angle units. (Units are by default degrees,
                but can be set via the degrees() and radians() functions.)
                Angle orientation depends on mode. (See this.)
        
                Example (for a Turtle instance named turtle):
                >>> turtle.heading()
                22.0
                >>> turtle.right(45)
                >>> turtle.heading()
                337.0
        """
        pass

    def rt(self, *args, **kwargs): # real signature unknown
        """
        Turn turtle right by angle units.
        
                Aliases: right | rt
        
                Argument:
                angle -- a number (integer or float)
        
                Turn turtle right by angle units. (Units are by default degrees,
                but can be set via the degrees() and radians() functions.)
                Angle orientation depends on mode. (See this.)
        
                Example (for a Turtle instance named turtle):
                >>> turtle.heading()
                22.0
                >>> turtle.right(45)
                >>> turtle.heading()
                337.0
        """
        pass

    def seth(self, *args, **kwargs): # real signature unknown
        """
        Set the orientation of the turtle to to_angle.
        
                Aliases:  setheading | seth
        
                Argument:
                to_angle -- a number (integer or float)
        
                Set the orientation of the turtle to to_angle.
                Here are some common directions in degrees:
        
                 standard - mode:          logo-mode:
                -------------------|--------------------
                   0 - east                0 - north
                  90 - north              90 - east
                 180 - west              180 - south
                 270 - south             270 - west
        
                Example (for a Turtle instance named turtle):
                >>> turtle.setheading(90)
                >>> turtle.heading()
                90
        """
        pass

    def setheading(self, *args, **kwargs): # real signature unknown; NOTE: unreliably restored from __doc__ 
        """
        Set the orientation of the turtle to to_angle.
        
                Aliases:  setheading | seth
        
                Argument:
                to_angle -- a number (integer or float)
        
                Set the orientation of the turtle to to_angle.
                Here are some common directions in degrees:
        
                 standard - mode:          logo-mode:
                -------------------|--------------------
                   0 - east                0 - north
                  90 - north              90 - east
                 180 - west              180 - south
                 270 - south             270 - west
        
                Example (for a Turtle instance named turtle):
                >>> turtle.setheading(90)
                >>> turtle.heading()
                90
        """
        pass

    def setpos(self, *args, **kwargs): # real signature unknown; NOTE: unreliably restored from __doc__ 
        """
        Move turtle to an absolute position.
        
                Aliases: setpos | setposition | goto:
        
                Arguments:
                x -- a number      or     a pair/vector of numbers
                y -- a number             None
        
                call: goto(x, y)         # two coordinates
                --or: goto((x, y))       # a pair (tuple) of coordinates
                --or: goto(vec)          # e.g. as returned by pos()
        
                Move turtle to an absolute position. If the pen is down,
                a line will be drawn. The turtle's orientation does not change.
        
                Example (for a Turtle instance named turtle):
                >>> tp = turtle.pos()
                >>> tp
                (0.00, 0.00)
                >>> turtle.setpos(60,30)
                >>> turtle.pos()
                (60.00,30.00)
                >>> turtle.setpos((20,80))
                >>> turtle.pos()
                (20.00,80.00)
                >>> turtle.setpos(tp)
                >>> turtle.pos()
                (0.00,0.00)
        """
        pass

    def setposition(self, *args, **kwargs): # real signature unknown
        """
        Move turtle to an absolute position.
        
                Aliases: setpos | setposition | goto:
        
                Arguments:
                x -- a number      or     a pair/vector of numbers
                y -- a number             None
        
                call: goto(x, y)         # two coordinates
                --or: goto((x, y))       # a pair (tuple) of coordinates
                --or: goto(vec)          # e.g. as returned by pos()
        
                Move turtle to an absolute position. If the pen is down,
                a line will be drawn. The turtle's orientation does not change.
        
                Example (for a Turtle instance named turtle):
                >>> tp = turtle.pos()
                >>> tp
                (0.00, 0.00)
                >>> turtle.setpos(60,30)
                >>> turtle.pos()
                (60.00,30.00)
                >>> turtle.setpos((20,80))
                >>> turtle.pos()
                (20.00,80.00)
                >>> turtle.setpos(tp)
                >>> turtle.pos()
                (0.00,0.00)
        """
        pass

    def setx(self, *args, **kwargs): # real signature unknown; NOTE: unreliably restored from __doc__ 
        """
        Set the turtle's first coordinate to x
        
                Argument:
                x -- a number (integer or float)
        
                Set the turtle's first coordinate to x, leave second coordinate
                unchanged.
        
                Example (for a Turtle instance named turtle):
                >>> turtle.position()
                (0.00, 240.00)
                >>> turtle.setx(10)
                >>> turtle.position()
                (10.00, 240.00)
        """
        pass

    def sety(self, *args, **kwargs): # real signature unknown; NOTE: unreliably restored from __doc__ 
        """
        Set the turtle's second coordinate to y
        
                Argument:
                y -- a number (integer or float)
        
                Set the turtle's first coordinate to x, second coordinate remains
                unchanged.
        
                Example (for a Turtle instance named turtle):
                >>> turtle.position()
                (0.00, 40.00)
                >>> turtle.sety(-10)
                >>> turtle.position()
                (0.00, -10.00)
        """
        pass

    def speed(self, *args, **kwargs): # real signature unknown
        """ dummy method - to be overwritten by child class """
        pass

    def towards(self, *args, **kwargs): # real signature unknown; NOTE: unreliably restored from __doc__ 
        """
        Return the angle of the line from the turtle's position to (x, y).
        
                Arguments:
                x -- a number   or  a pair/vector of numbers   or   a turtle instance
                y -- a number       None                            None
        
                call: distance(x, y)         # two coordinates
                --or: distance((x, y))       # a pair (tuple) of coordinates
                --or: distance(vec)          # e.g. as returned by pos()
                --or: distance(mypen)        # where mypen is another turtle
        
                Return the angle, between the line from turtle-position to position
                specified by x, y and the turtle's start orientation. (Depends on
                modes - "standard" or "logo")
        
                Example (for a Turtle instance named turtle):
                >>> turtle.pos()
                (10.00, 10.00)
                >>> turtle.towards(0,0)
                225.0
        """
        pass

    def tracer(self, *args, **kwargs): # real signature unknown
        """ dummy method - to be overwritten by child class """
        pass

    def xcor(self): # real signature unknown; restored from __doc__
        """
        Return the turtle's x coordinate.
        
                No arguments.
        
                Example (for a Turtle instance named turtle):
                >>> reset()
                >>> turtle.left(60)
                >>> turtle.forward(100)
                >>> print turtle.xcor()
                50.0
        """
        pass

    def ycor(self): # real signature unknown; restored from __doc__
        """
        Return the turtle's y coordinate
                ---
                No arguments.
        
                Example (for a Turtle instance named turtle):
                >>> reset()
                >>> turtle.left(60)
                >>> turtle.forward(100)
                >>> print turtle.ycor()
                86.6025403784
        """
        pass

    def _delay(self, *args, **kwargs): # real signature unknown
        """ dummy method - to be overwritten by child class """
        pass

    def _go(self, *args, **kwargs): # real signature unknown
        """ move turtle forward by specified distance """
        pass

    def _goto(self, *args, **kwargs): # real signature unknown
        """ move turtle to position end. """
        pass

    def _rotate(self, *args, **kwargs): # real signature unknown
        """ Turn turtle counterclockwise by specified angle if angle > 0. """
        pass

    def _setDegreesPerAU(self, *args, **kwargs): # real signature unknown
        """ Helper function for degrees() and radians() """
        pass

    def _setmode(self, *args, **kwargs): # real signature unknown
        """ Set turtle-mode to 'standard', 'world' or 'logo'. """
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default

    DEFAULT_ANGLEOFFSET = 0
    DEFAULT_ANGLEORIENT = 1
    DEFAULT_MODE = 'standard'
    START_ORIENTATION = {
        'logo': (
            0.0,
            1.0,
        ),
        'standard': (
            1.0,
            0.0,
        ),
        'world': '<value is a self-reference, replaced by this string>',
    }
    __dict__ = None # (!) real value is ''


class TPen(object):
    """
    Drawing part of the RawTurtle.
        Implements drawing properties.
    """
    def color(self): # real signature unknown; restored from __doc__
        """
        Return or set the pencolor and fillcolor.
        
                Arguments:
                Several input formats are allowed.
                They use 0, 1, 2, or 3 arguments as follows:
        
                color()
                    Return the current pencolor and the current fillcolor
                    as a pair of color specification strings as are returned
                    by pencolor and fillcolor.
                color(colorstring), color((r,g,b)), color(r,g,b)
                    inputs as in pencolor, set both, fillcolor and pencolor,
                    to the given value.
                color(colorstring1, colorstring2),
                color((r1,g1,b1), (r2,g2,b2))
                    equivalent to pencolor(colorstring1) and fillcolor(colorstring2)
                    and analogously, if the other input format is used.
        
                If turtleshape is a polygon, outline and interior of that polygon
                is drawn with the newly set colors.
                For mor info see: pencolor, fillcolor
        
                Example (for a Turtle instance named turtle):
                >>> turtle.color('red', 'green')
                >>> turtle.color()
                ('red', 'green')
                >>> colormode(255)
                >>> color((40, 80, 120), (160, 200, 240))
                >>> color()
                ('#285078', '#a0c8f0')
        """
        pass

    def down(self): # real signature unknown; restored from __doc__
        """
        Pull the pen down -- drawing when moving.
        
                Aliases: pendown | pd | down
        
                No argument.
        
                Example (for a Turtle instance named turtle):
                >>> turtle.pendown()
        """
        pass

    def fillcolor(self): # real signature unknown; restored from __doc__
        """
        Return or set the fillcolor.
        
                Arguments:
                Four input formats are allowed:
                  - fillcolor()
                    Return the current fillcolor as color specification string,
                    possibly in hex-number format (see example).
                    May be used as input to another color/pencolor/fillcolor call.
                  - fillcolor(colorstring)
                    s is a Tk color specification string, such as "red" or "yellow"
                  - fillcolor((r, g, b))
                    *a tuple* of r, g, and b, which represent, an RGB color,
                    and each of r, g, and b are in the range 0..colormode,
                    where colormode is either 1.0 or 255
                  - fillcolor(r, g, b)
                    r, g, and b represent an RGB color, and each of r, g, and b
                    are in the range 0..colormode
        
                If turtleshape is a polygon, the interior of that polygon is drawn
                with the newly set fillcolor.
        
                Example (for a Turtle instance named turtle):
                >>> turtle.fillcolor('violet')
                >>> col = turtle.pencolor()
                >>> turtle.fillcolor(col)
                >>> turtle.fillcolor(0, .5, 0)
        """
        pass

    def hideturtle(self): # real signature unknown; restored from __doc__
        """
        Makes the turtle invisible.
        
                Aliases: hideturtle | ht
        
                No argument.
        
                It's a good idea to do this while you're in the
                middle of a complicated drawing, because hiding
                the turtle speeds up the drawing observably.
        
                Example (for a Turtle instance named turtle):
                >>> turtle.hideturtle()
        """
        pass

    def ht(self, *args, **kwargs): # real signature unknown
        """
        Makes the turtle invisible.
        
                Aliases: hideturtle | ht
        
                No argument.
        
                It's a good idea to do this while you're in the
                middle of a complicated drawing, because hiding
                the turtle speeds up the drawing observably.
        
                Example (for a Turtle instance named turtle):
                >>> turtle.hideturtle()
        """
        pass

    def isdown(self): # real signature unknown; restored from __doc__
        """
        Return True if pen is down, False if it's up.
        
                No argument.
        
                Example (for a Turtle instance named turtle):
                >>> turtle.penup()
                >>> turtle.isdown()
                False
                >>> turtle.pendown()
                >>> turtle.isdown()
                True
        """
        pass

    def isvisible(self): # real signature unknown; restored from __doc__
        """
        Return True if the Turtle is shown, False if it's hidden.
        
                No argument.
        
                Example (for a Turtle instance named turtle):
                >>> turtle.hideturtle()
                >>> print turtle.isvisible():
                False
        """
        pass

    def pd(self, *args, **kwargs): # real signature unknown
        """
        Pull the pen down -- drawing when moving.
        
                Aliases: pendown | pd | down
        
                No argument.
        
                Example (for a Turtle instance named turtle):
                >>> turtle.pendown()
        """
        pass

    def pen(self): # real signature unknown; restored from __doc__
        """
        Return or set the pen's attributes.
        
                Arguments:
                    pen -- a dictionary with some or all of the below listed keys.
                    **pendict -- one or more keyword-arguments with the below
                                 listed keys as keywords.
        
                Return or set the pen's attributes in a 'pen-dictionary'
                with the following key/value pairs:
                   "shown"      :   True/False
                   "pendown"    :   True/False
                   "pencolor"   :   color-string or color-tuple
                   "fillcolor"  :   color-string or color-tuple
                   "pensize"    :   positive number
                   "speed"      :   number in range 0..10
                   "resizemode" :   "auto" or "user" or "noresize"
                   "stretchfactor": (positive number, positive number)
                   "outline"    :   positive number
                   "tilt"       :   number
        
                This dictionary can be used as argument for a subsequent
                pen()-call to restore the former pen-state. Moreover one
                or more of these attributes can be provided as keyword-arguments.
                This can be used to set several pen attributes in one statement.
        
        
                Examples (for a Turtle instance named turtle):
                >>> turtle.pen(fillcolor="black", pencolor="red", pensize=10)
                >>> turtle.pen()
                {'pensize': 10, 'shown': True, 'resizemode': 'auto', 'outline': 1,
                'pencolor': 'red', 'pendown': True, 'fillcolor': 'black',
                'stretchfactor': (1,1), 'speed': 3}
                >>> penstate=turtle.pen()
                >>> turtle.color("yellow","")
                >>> turtle.penup()
                >>> turtle.pen()
                {'pensize': 10, 'shown': True, 'resizemode': 'auto', 'outline': 1,
                'pencolor': 'yellow', 'pendown': False, 'fillcolor': '',
                'stretchfactor': (1,1), 'speed': 3}
                >>> p.pen(penstate, fillcolor="green")
                >>> p.pen()
                {'pensize': 10, 'shown': True, 'resizemode': 'auto', 'outline': 1,
                'pencolor': 'red', 'pendown': True, 'fillcolor': 'green',
                'stretchfactor': (1,1), 'speed': 3}
        """
        pass

    def pencolor(self): # real signature unknown; restored from __doc__
        """
        Return or set the pencolor.
        
                Arguments:
                Four input formats are allowed:
                  - pencolor()
                    Return the current pencolor as color specification string,
                    possibly in hex-number format (see example).
                    May be used as input to another color/pencolor/fillcolor call.
                  - pencolor(colorstring)
                    s is a Tk color specification string, such as "red" or "yellow"
                  - pencolor((r, g, b))
                    *a tuple* of r, g, and b, which represent, an RGB color,
                    and each of r, g, and b are in the range 0..colormode,
                    where colormode is either 1.0 or 255
                  - pencolor(r, g, b)
                    r, g, and b represent an RGB color, and each of r, g, and b
                    are in the range 0..colormode
        
                If turtleshape is a polygon, the outline of that polygon is drawn
                with the newly set pencolor.
        
                Example (for a Turtle instance named turtle):
                >>> turtle.pencolor('brown')
                >>> tup = (0.2, 0.8, 0.55)
                >>> turtle.pencolor(tup)
                >>> turtle.pencolor()
                '#33cc8c'
        """
        pass

    def pendown(self): # real signature unknown; restored from __doc__
        """
        Pull the pen down -- drawing when moving.
        
                Aliases: pendown | pd | down
        
                No argument.
        
                Example (for a Turtle instance named turtle):
                >>> turtle.pendown()
        """
        pass

    def pensize(self): # real signature unknown; restored from __doc__
        """
        Set or return the line thickness.
        
                Aliases:  pensize | width
        
                Argument:
                width -- positive number
        
                Set the line thickness to width or return it. If resizemode is set
                to "auto" and turtleshape is a polygon, that polygon is drawn with
                the same line thickness. If no argument is given, current pensize
                is returned.
        
                Example (for a Turtle instance named turtle):
                >>> turtle.pensize()
                1
                turtle.pensize(10)   # from here on lines of width 10 are drawn
        """
        pass

    def penup(self): # real signature unknown; restored from __doc__
        """
        Pull the pen up -- no drawing when moving.
        
                Aliases: penup | pu | up
        
                No argument
        
                Example (for a Turtle instance named turtle):
                >>> turtle.penup()
        """
        pass

    def pu(self, *args, **kwargs): # real signature unknown
        """
        Pull the pen up -- no drawing when moving.
        
                Aliases: penup | pu | up
        
                No argument
        
                Example (for a Turtle instance named turtle):
                >>> turtle.penup()
        """
        pass

    def resizemode(self, user): # real signature unknown; restored from __doc__
        """
        Set resizemode to one of the values: "auto", "user", "noresize".
        
                (Optional) Argument:
                rmode -- one of the strings "auto", "user", "noresize"
        
                Different resizemodes have the following effects:
                  - "auto" adapts the appearance of the turtle
                           corresponding to the value of pensize.
                  - "user" adapts the appearance of the turtle according to the
                           values of stretchfactor and outlinewidth (outline),
                           which are set by shapesize()
                  - "noresize" no adaption of the turtle's appearance takes place.
                If no argument is given, return current resizemode.
                resizemode("user") is called by a call of shapesize with arguments.
        
        
                Examples (for a Turtle instance named turtle):
                >>> turtle.resizemode("noresize")
                >>> turtle.resizemode()
                'noresize'
        """
        pass

    def showturtle(self): # real signature unknown; restored from __doc__
        """
        Makes the turtle visible.
        
                Aliases: showturtle | st
        
                No argument.
        
                Example (for a Turtle instance named turtle):
                >>> turtle.hideturtle()
                >>> turtle.showturtle()
        """
        pass

    def speed(self, *args, **kwargs): # real signature unknown; NOTE: unreliably restored from __doc__ 
        """
        Return or set the turtle's speed.
        
                Optional argument:
                speed -- an integer in the range 0..10 or a speedstring (see below)
        
                Set the turtle's speed to an integer value in the range 0 .. 10.
                If no argument is given: return current speed.
        
                If input is a number greater than 10 or smaller than 0.5,
                speed is set to 0.
                Speedstrings  are mapped to speedvalues in the following way:
                    'fastest' :  0
                    'fast'    :  10
                    'normal'  :  6
                    'slow'    :  3
                    'slowest' :  1
                speeds from 1 to 10 enforce increasingly faster animation of
                line drawing and turtle turning.
        
                Attention:
                speed = 0 : *no* animation takes place. forward/back makes turtle jump
                and likewise left/right make the turtle turn instantly.
        
                Example (for a Turtle instance named turtle):
                >>> turtle.speed(3)
        """
        pass

    def st(self, *args, **kwargs): # real signature unknown
        """
        Makes the turtle visible.
        
                Aliases: showturtle | st
        
                No argument.
        
                Example (for a Turtle instance named turtle):
                >>> turtle.hideturtle()
                >>> turtle.showturtle()
        """
        pass

    def up(self): # real signature unknown; restored from __doc__
        """
        Pull the pen up -- no drawing when moving.
        
                Aliases: penup | pu | up
        
                No argument
        
                Example (for a Turtle instance named turtle):
                >>> turtle.penup()
        """
        pass

    def width(self, *args, **kwargs): # real signature unknown
        """
        Set or return the line thickness.
        
                Aliases:  pensize | width
        
                Argument:
                width -- positive number
        
                Set the line thickness to width or return it. If resizemode is set
                to "auto" and turtleshape is a polygon, that polygon is drawn with
                the same line thickness. If no argument is given, current pensize
                is returned.
        
                Example (for a Turtle instance named turtle):
                >>> turtle.pensize()
                1
                turtle.pensize(10)   # from here on lines of width 10 are drawn
        """
        pass

    def _color(self, *args, **kwargs): # real signature unknown
        """ dummy method - to be overwritten by child class """
        pass

    def _colorstr(self, *args, **kwargs): # real signature unknown
        """ dummy method - to be overwritten by child class """
        pass

    def _newLine(self, *args, **kwargs): # real signature unknown
        """ dummy method - to be overwritten by child class """
        pass

    def _reset(self, *args, **kwargs): # real signature unknown
        pass

    def _update(self, *args, **kwargs): # real signature unknown
        """ dummy method - to be overwritten by child class """
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default

    __dict__ = None # (!) real value is ''


class RawTurtle(TPen, TNavigator):
    """
    Animation part of the RawTurtle.
        Puts RawTurtle upon a TurtleScreen and provides tools for
        its animation.
    """
    def begin_fill(self): # real signature unknown; restored from __doc__
        """
        Called just before drawing a shape to be filled.
        
                No argument.
        
                Example (for a Turtle instance named turtle):
                >>> turtle.begin_fill()
                >>> turtle.forward(100)
                >>> turtle.left(90)
                >>> turtle.forward(100)
                >>> turtle.left(90)
                >>> turtle.forward(100)
                >>> turtle.left(90)
                >>> turtle.forward(100)
                >>> turtle.end_fill()
        """
        pass

    def begin_poly(self): # real signature unknown; restored from __doc__
        """
        Start recording the vertices of a polygon.
        
                No argument.
        
                Start recording the vertices of a polygon. Current turtle position
                is first point of polygon.
        
                Example (for a Turtle instance named turtle):
                >>> turtle.begin_poly()
        """
        pass

    def clear(self): # real signature unknown; restored from __doc__
        """
        Delete the turtle's drawings from the screen. Do not move turtle.
        
                No arguments.
        
                Delete the turtle's drawings from the screen. Do not move turtle.
                State and position of the turtle as well as drawings of other
                turtles are not affected.
        
                Examples (for a Turtle instance named turtle):
                >>> turtle.clear()
        """
        pass

    def clearstamp(self, astamp): # real signature unknown; restored from __doc__
        """
        Delete stamp with given stampid
        
                Argument:
                stampid - an integer, must be return value of previous stamp() call.
        
                Example (for a Turtle instance named turtle):
                >>> turtle.color("blue")
                >>> astamp = turtle.stamp()
                >>> turtle.fd(50)
                >>> turtle.clearstamp(astamp)
        """
        pass

    def clearstamps(self, *args, **kwargs): # real signature unknown; NOTE: unreliably restored from __doc__ 
        """
        Delete all or first/last n of turtle's stamps.
        
                Optional argument:
                n -- an integer
        
                If n is None, delete all of pen's stamps,
                else if n > 0 delete first n stamps
                else if n < 0 delete last n stamps.
        
                Example (for a Turtle instance named turtle):
                >>> for i in range(8):
                        turtle.stamp(); turtle.fd(30)
                ...
                >>> turtle.clearstamps(2)
                >>> turtle.clearstamps(-2)
                >>> turtle.clearstamps()
        """
        pass

    def clone(self): # real signature unknown; restored from __doc__
        """
        Create and return a clone of the turtle.
        
                No argument.
        
                Create and return a clone of the turtle with same position, heading
                and turtle properties.
        
                Example (for a Turtle instance named mick):
                mick = Turtle()
                joe = mick.clone()
        """
        pass

    def dot(self): # real signature unknown; restored from __doc__
        """
        Draw a dot with diameter size, using color.
        
                Optional argumentS:
                size -- an integer >= 1 (if given)
                color -- a colorstring or a numeric color tuple
        
                Draw a circular dot with diameter size, using color.
                If size is not given, the maximum of pensize+4 and 2*pensize is used.
        
                Example (for a Turtle instance named turtle):
                >>> turtle.dot()
                >>> turtle.fd(50); turtle.dot(20, "blue"); turtle.fd(50)
        """
        pass

    def end_fill(self): # real signature unknown; restored from __doc__
        """
        Fill the shape drawn after the call begin_fill().
        
                No argument.
        
                Example (for a Turtle instance named turtle):
                >>> turtle.begin_fill()
                >>> turtle.forward(100)
                >>> turtle.left(90)
                >>> turtle.forward(100)
                >>> turtle.left(90)
                >>> turtle.forward(100)
                >>> turtle.left(90)
                >>> turtle.forward(100)
                >>> turtle.end_fill()
        """
        pass

    def end_poly(self): # real signature unknown; restored from __doc__
        """
        Stop recording the vertices of a polygon.
        
                No argument.
        
                Stop recording the vertices of a polygon. Current turtle position is
                last point of polygon. This will be connected with the first point.
        
                Example (for a Turtle instance named turtle):
                >>> turtle.end_poly()
        """
        pass

    def fill(self, True): # real signature unknown; restored from __doc__
        """
        Call fill(True) before drawing a shape to fill, fill(False) when done.
        
                Optional argument:
                flag -- True/False (or 1/0 respectively)
        
                Call fill(True) before drawing the shape you want to fill,
                and  fill(False) when done.
                When used without argument: return fillstate (True if filling,
                False else)
        
                Example (for a Turtle instance named turtle):
                >>> turtle.fill(True)
                >>> turtle.forward(100)
                >>> turtle.left(90)
                >>> turtle.forward(100)
                >>> turtle.left(90)
                >>> turtle.forward(100)
                >>> turtle.left(90)
                >>> turtle.forward(100)
                >>> turtle.fill(False)
        """
        pass

    def getpen(self, *args, **kwargs): # real signature unknown
        """
        Return the Turtleobject itself.
        
                No argument.
        
                Only reasonable use: as a function to return the 'anonymous turtle':
        
                Example:
                >>> pet = getturtle()
                >>> pet.fd(50)
                >>> pet
                <turtle.Turtle object at 0x0187D810>
                >>> turtles()
                [<turtle.Turtle object at 0x0187D810>]
        """
        pass

    def getscreen(self): # real signature unknown; restored from __doc__
        """
        Return the TurtleScreen object, the turtle is drawing  on.
        
                No argument.
        
                Return the TurtleScreen object, the turtle is drawing  on.
                So TurtleScreen-methods can be called for that object.
        
                Example (for a Turtle instance named turtle):
                >>> ts = turtle.getscreen()
                >>> ts
                <turtle.TurtleScreen object at 0x0106B770>
                >>> ts.bgcolor("pink")
        """
        pass

    def getturtle(self): # real signature unknown; restored from __doc__
        """
        Return the Turtleobject itself.
        
                No argument.
        
                Only reasonable use: as a function to return the 'anonymous turtle':
        
                Example:
                >>> pet = getturtle()
                >>> pet.fd(50)
                >>> pet
                <turtle.Turtle object at 0x0187D810>
                >>> turtles()
                [<turtle.Turtle object at 0x0187D810>]
        """
        pass

    def get_poly(self): # real signature unknown; restored from __doc__
        """
        Return the lastly recorded polygon.
        
                No argument.
        
                Example (for a Turtle instance named turtle):
                >>> p = turtle.get_poly()
                >>> turtle.register_shape("myFavouriteShape", p)
        """
        pass

    def onclick(self, turn): # real signature unknown; restored from __doc__
        """
        Bind fun to mouse-click event on this turtle on canvas.
        
                Arguments:
                fun --  a function with two arguments, to which will be assigned
                        the coordinates of the clicked point on the canvas.
                num --  number of the mouse-button defaults to 1 (left mouse button).
                add --  True or False. If True, new binding will be added, otherwise
                        it will replace a former binding.
        
                Example for the anonymous turtle, i. e. the procedural way:
        
                >>> def turn(x, y):
                        left(360)
        
                >>> onclick(turn) # Now clicking into the turtle will turn it.
                >>> onclick(None)  # event-binding will be removed
        """
        pass

    def ondrag(self, turtle_goto): # real signature unknown; restored from __doc__
        """
        Bind fun to mouse-move event on this turtle on canvas.
        
                Arguments:
                fun -- a function with two arguments, to which will be assigned
                       the coordinates of the clicked point on the canvas.
                num -- number of the mouse-button defaults to 1 (left mouse button).
        
                Every sequence of mouse-move-events on a turtle is preceded by a
                mouse-click event on that turtle.
        
                Example (for a Turtle instance named turtle):
                >>> turtle.ondrag(turtle.goto)
        
                ### Subsequently clicking and dragging a Turtle will
                ### move it across the screen thereby producing handdrawings
                ### (if pen is down).
        """
        pass

    def onrelease(self, joe_unglow): # real signature unknown; restored from __doc__
        """
        Bind fun to mouse-button-release event on this turtle on canvas.
        
                Arguments:
                fun -- a function with two arguments, to which will be assigned
                        the coordinates of the clicked point on the canvas.
                num --  number of the mouse-button defaults to 1 (left mouse button).
        
                Example (for a MyTurtle instance named joe):
                >>> class MyTurtle(Turtle):
                        def glow(self,x,y):
                                self.fillcolor("red")
                        def unglow(self,x,y):
                                self.fillcolor("")
        
                >>> joe = MyTurtle()
                >>> joe.onclick(joe.glow)
                >>> joe.onrelease(joe.unglow)
                ### clicking on joe turns fillcolor red,
                ### unclicking turns it to transparent.
        """
        pass

    def reset(self): # real signature unknown; restored from __doc__
        """
        Delete the turtle's drawings and restore its default values.
        
                No argument.
        ,
                Delete the turtle's drawings from the screen, re-center the turtle
                and set variables to the default values.
        
                Example (for a Turtle instance named turtle):
                >>> turtle.position()
                (0.00,-22.00)
                >>> turtle.heading()
                100.0
                >>> turtle.reset()
                >>> turtle.position()
                (0.00,0.00)
                >>> turtle.heading()
                0.0
        """
        pass

    def settiltangle(self, *args, **kwargs): # real signature unknown; NOTE: unreliably restored from __doc__ 
        """
        Rotate the turtleshape to point in the specified direction
        
                Optional argument:
                angle -- number
        
                Rotate the turtleshape to point in the direction specified by angle,
                regardless of its current tilt-angle. DO NOT change the turtle's
                heading (direction of movement).
        
        
                Examples (for a Turtle instance named turtle):
                >>> turtle.shape("circle")
                >>> turtle.shapesize(5,2)
                >>> turtle.settiltangle(45)
                >>> stamp()
                >>> turtle.fd(50)
                >>> turtle.settiltangle(-45)
                >>> stamp()
                >>> turtle.fd(50)
        """
        pass

    def setundobuffer(self, *args, **kwargs): # real signature unknown; NOTE: unreliably restored from __doc__ 
        """
        Set or disable undobuffer.
        
                Argument:
                size -- an integer or None
        
                If size is an integer an empty undobuffer of given size is installed.
                Size gives the maximum number of turtle-actions that can be undone
                by the undo() function.
                If size is None, no undobuffer is present.
        
                Example (for a Turtle instance named turtle):
                >>> turtle.setundobuffer(42)
        """
        pass

    def shape(self): # real signature unknown; restored from __doc__
        """
        Set turtle shape to shape with given name / return current shapename.
        
                Optional argument:
                name -- a string, which is a valid shapename
        
                Set turtle shape to shape with given name or, if name is not given,
                return name of current shape.
                Shape with name must exist in the TurtleScreen's shape dictionary.
                Initially there are the following polygon shapes:
                'arrow', 'turtle', 'circle', 'square', 'triangle', 'classic'.
                To learn about how to deal with shapes see Screen-method register_shape.
        
                Example (for a Turtle instance named turtle):
                >>> turtle.shape()
                'arrow'
                >>> turtle.shape("turtle")
                >>> turtle.shape()
                'turtle'
        """
        pass

    def shapesize(self, *args, **kwargs): # real signature unknown; NOTE: unreliably restored from __doc__ 
        """
        Set/return turtle's stretchfactors/outline. Set resizemode to "user".
        
                Optinonal arguments:
                   stretch_wid : positive number
                   stretch_len : positive number
                   outline  : positive number
        
                Return or set the pen's attributes x/y-stretchfactors and/or outline.
                Set resizemode to "user".
                If and only if resizemode is set to "user", the turtle will be displayed
                stretched according to its stretchfactors:
                stretch_wid is stretchfactor perpendicular to orientation
                stretch_len is stretchfactor in direction of turtles orientation.
                outline determines the width of the shapes's outline.
        
                Examples (for a Turtle instance named turtle):
                >>> turtle.resizemode("user")
                >>> turtle.shapesize(5, 5, 12)
                >>> turtle.shapesize(outline=8)
        """
        pass

    def stamp(self, stamp_id): # real signature unknown; restored from __doc__
        """
        Stamp a copy of the turtleshape onto the canvas and return its id.
        
                No argument.
        
                Stamp a copy of the turtle shape onto the canvas at the current
                turtle position. Return a stamp_id for that stamp, which can be
                used to delete it by calling clearstamp(stamp_id).
        
                Example (for a Turtle instance named turtle):
                >>> turtle.color("blue")
                >>> turtle.stamp()
                13
                >>> turtle.fd(50)
        """
        pass

    def tilt(self, *args, **kwargs): # real signature unknown; NOTE: unreliably restored from __doc__ 
        """
        Rotate the turtleshape by angle.
        
                Argument:
                angle - a number
        
                Rotate the turtleshape by angle from its current tilt-angle,
                but do NOT change the turtle's heading (direction of movement).
        
                Examples (for a Turtle instance named turtle):
                >>> turtle.shape("circle")
                >>> turtle.shapesize(5,2)
                >>> turtle.tilt(30)
                >>> turtle.fd(50)
                >>> turtle.tilt(30)
                >>> turtle.fd(50)
        """
        pass

    def tiltangle(self): # real signature unknown; restored from __doc__
        """
        Return the current tilt-angle.
        
                No argument.
        
                Return the current tilt-angle, i. e. the angle between the
                orientation of the turtleshape and the heading of the turtle
                (its direction of movement).
        
                Examples (for a Turtle instance named turtle):
                >>> turtle.shape("circle")
                >>> turtle.shapesize(5,2)
                >>> turtle.tilt(45)
                >>> turtle.tiltangle()
                >>>
        """
        pass

    def tracer(self, *args, **kwargs): # real signature unknown; NOTE: unreliably restored from __doc__ 
        """
        Turns turtle animation on/off and set delay for update drawings.
        
                Optional arguments:
                n -- nonnegative  integer
                delay -- nonnegative  integer
        
                If n is given, only each n-th regular screen update is really performed.
                (Can be used to accelerate the drawing of complex graphics.)
                Second arguments sets delay value (see RawTurtle.delay())
        
                Example (for a Turtle instance named turtle):
                >>> turtle.tracer(8, 25)
                >>> dist = 2
                >>> for i in range(200):
                        turtle.fd(dist)
                        turtle.rt(90)
                        dist += 2
        """
        pass

    def turtlesize(self, *args, **kwargs): # real signature unknown
        """
        Set/return turtle's stretchfactors/outline. Set resizemode to "user".
        
                Optinonal arguments:
                   stretch_wid : positive number
                   stretch_len : positive number
                   outline  : positive number
        
                Return or set the pen's attributes x/y-stretchfactors and/or outline.
                Set resizemode to "user".
                If and only if resizemode is set to "user", the turtle will be displayed
                stretched according to its stretchfactors:
                stretch_wid is stretchfactor perpendicular to orientation
                stretch_len is stretchfactor in direction of turtles orientation.
                outline determines the width of the shapes's outline.
        
                Examples (for a Turtle instance named turtle):
                >>> turtle.resizemode("user")
                >>> turtle.shapesize(5, 5, 12)
                >>> turtle.shapesize(outline=8)
        """
        pass

    def undo(self, repeatedly): # real signature unknown; restored from __doc__
        """
        undo (repeatedly) the last turtle action.
        
                No argument.
        
                undo (repeatedly) the last turtle action.
                Number of available undo actions is determined by the size of
                the undobuffer.
        
                Example (for a Turtle instance named turtle):
                >>> for i in range(4):
                        turtle.fd(50); turtle.lt(80)
        
                >>> for i in range(8):
                        turtle.undo()
        """
        pass

    def undobufferentries(self): # real signature unknown; restored from __doc__
        """
        Return count of entries in the undobuffer.
        
                No argument.
        
                Example (for a Turtle instance named turtle):
                >>> while undobufferentries():
                        undo()
        """
        pass

    def window_height(self): # real signature unknown; restored from __doc__
        """
        Return the height of the turtle window.
        
                No argument.
        
                Example (for a TurtleScreen instance named screen):
                >>> screen.window_height()
                480
        """
        pass

    def window_width(self): # real signature unknown; restored from __doc__
        """
        Returns the width of the turtle window.
        
                No argument.
        
                Example (for a TurtleScreen instance named screen):
                >>> screen.window_width()
                640
        """
        pass

    def write(self, *args, **kwargs): # real signature unknown; NOTE: unreliably restored from __doc__ 
        """
        Write text at the current turtle position.
        
                Arguments:
                arg -- info, which is to be written to the TurtleScreen
                move (optional) -- True/False
                align (optional) -- one of the strings "left", "center" or right"
                font (optional) -- a triple (fontname, fontsize, fonttype)
        
                Write text - the string representation of arg - at the current
                turtle position according to align ("left", "center" or right")
                and with the given font.
                If move is True, the pen is moved to the bottom-right corner
                of the text. By default, move is False.
        
                Example (for a Turtle instance named turtle):
                >>> turtle.write('Home = ', True, align="center")
                >>> turtle.write((0,0), True)
        """
        pass

    def _cc(self, *args, **kwargs): # real signature unknown
        """ Convert colortriples to hexstrings. """
        pass

    def _clear(self, *args, **kwargs): # real signature unknown
        """ Delete all of pen's drawings """
        pass

    def _clearstamp(self, *args, **kwargs): # real signature unknown
        """ does the work for clearstamp() and clearstamps() """
        pass

    def _color(self, *args, **kwargs): # real signature unknown
        pass

    def _colorstr(self, *args, **kwargs): # real signature unknown
        pass

    def _delay(self, *args, **kwargs): # real signature unknown
        """ Set delay value which determines speed of turtle animation. """
        pass

    def _drawturtle(self, *args, **kwargs): # real signature unknown
        """
        Manages the correct rendering of the turtle with respect to
                its shape, resizemode, stretch and tilt etc.
        """
        pass

    def _goto(self, *args, **kwargs): # real signature unknown
        """
        Move the pen to the point end, thereby drawing a line
                if pen is down. All other methodes for turtle movement depend
                on this one.
        """
        pass

    def _newLine(self, *args, **kwargs): # real signature unknown
        """
        Closes current line item and starts a new one.
                   Remark: if current line became too long, animation
                   performance (via _drawline) slowed down considerably.
        """
        pass

    def _polytrafo(self, *args, **kwargs): # real signature unknown
        """
        Computes transformed polygon shapes from a shape
                according to current position and heading.
        """
        pass

    def _rotate(self, *args, **kwargs): # real signature unknown
        """ Turns pen clockwise by angle. """
        pass

    def _undo(self, *args, **kwargs): # real signature unknown
        """ Does the main part of the work for undo() """
        pass

    def _undogoto(self, *args, **kwargs): # real signature unknown
        """ Reverse a _goto. Used for undo() """
        pass

    def _update(self, *args, **kwargs): # real signature unknown
        """ Perform a Turtle-data update. """
        pass

    def _update_data(self, *args, **kwargs): # real signature unknown
        pass

    def _write(self, *args, **kwargs): # real signature unknown
        """ Performs the writing for write() """
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    screens = []


RawPen = RawTurtle


class Turtle(RawTurtle):
    """
    RawTurtle auto-crating (scrolled) canvas.
    
        When a Turtle object is created or a function derived from some
        Turtle method is called a TurtleScreen object is automatically created.
    """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    _pen = None
    _screen = None


Pen = Turtle


class Shape(object):
    """
    Data structure modeling shapes.
    
        attribute _type is one of "polygon", "image", "compound"
        attribute _data is - depending on _type a poygon-tuple,
        an image or a list constructed using the addcomponent method.
    """
    def addcomponent(self, *args, **kwargs): # real signature unknown; NOTE: unreliably restored from __doc__ 
        """
        Add component to a shape of type compound.
        
                Arguments: poly is a polygon, i. e. a tuple of number pairs.
                fill is the fillcolor of the component,
                outline is the outline color of the component.
        
                call (for a Shapeobject namend s):
                --   s.addcomponent(((0,0), (10,10), (-10,10)), "red", "blue")
        
                Example:
                >>> poly = ((0,0),(10,-5),(0,10),(-10,-5))
                >>> s = Shape("compound")
                >>> s.addcomponent(poly, "red", "blue")
                ### .. add more components and then use register_shape()
        """
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default

    __dict__ = None # (!) real value is ''


class Tbuffer(object):
    """ Ring buffer used as undobuffer for RawTurtle objects. """
    def nr_of_items(self, *args, **kwargs): # real signature unknown
        pass

    def pop(self, *args, **kwargs): # real signature unknown
        pass

    def push(self, *args, **kwargs): # real signature unknown
        pass

    def reset(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    def __repr__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default

    __dict__ = None # (!) real value is ''


class Terminator(Exception):
    """
    Will be raised in TurtleScreen.update, if _RUNNING becomes False.
    
        Thus stops execution of turtle graphics script. Main purpose: use in
        in the Demo-Viewer turtle.Demo.py.
    """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default


class TurtleGraphicsError(Exception):
    """ Some TurtleGraphics Error """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default


class TurtleScreenBase(object):
    """
    Provide the basic graphics functionality.
           Interface between Tkinter and turtle.py.
    
           To port turtle.py to some different graphics toolkit
           a corresponding TurtleScreenBase class has to be implemented.
    """
    def _bgcolor(self, *args, **kwargs): # real signature unknown
        """
        Set canvas' backgroundcolor if color is not None,
                else return backgroundcolor.
        """
        pass

    def _blankimage(): # reliably restored by inspect
        """ return a blank image object """
        pass

    def _createimage(self, *args, **kwargs): # real signature unknown
        """ Create and return image item on canvas. """
        pass

    def _createline(self, *args, **kwargs): # real signature unknown
        """ Create an invisible line item on canvas self.cv) """
        pass

    def _createpoly(self, *args, **kwargs): # real signature unknown
        """ Create an invisible polygon item on canvas self.cv) """
        pass

    def _delay(self, *args, **kwargs): # real signature unknown
        """ Delay subsequent canvas actions for delay ms. """
        pass

    def _delete(self, *args, **kwargs): # real signature unknown
        """
        Delete graphics item from canvas.
                If item is"all" delete all graphics items.
        """
        pass

    def _drawimage(self, *args, **kwargs): # real signature unknown
        """
        Configure image item as to draw image object
                at position (x,y) on canvas)
        """
        pass

    def _drawline(self, *args, **kwargs): # real signature unknown
        """
        Configure lineitem according to provided arguments:
                coordlist is sequence of coordinates
                fill is drawing color
                width is width of drawn line.
                top is a boolean value, which specifies if polyitem
                will be put on top of the canvas' displaylist so it
                will not be covered by other items.
        """
        pass

    def _drawpoly(self, *args, **kwargs): # real signature unknown
        """
        Configure polygonitem polyitem according to provided
                arguments:
                coordlist is sequence of coordinates
                fill is filling color
                outline is outline color
                top is a boolean value, which specifies if polyitem
                will be put on top of the canvas' displaylist so it
                will not be covered by other items.
        """
        pass

    def _image(filename): # reliably restored by inspect
        """
        return an image object containing the
                imagedata from a gif-file named filename.
        """
        pass

    def _iscolorstring(self, *args, **kwargs): # real signature unknown
        """ Check if the string color is a legal Tkinter color string. """
        pass

    def _listen(self, *args, **kwargs): # real signature unknown
        """ Set focus on canvas (in order to collect key-events) """
        pass

    def _onclick(self, *args, **kwargs): # real signature unknown
        """
        Bind fun to mouse-click event on turtle.
                fun must be a function with two arguments, the coordinates
                of the clicked point on the canvas.
                num, the number of the mouse-button defaults to 1
        """
        pass

    def _ondrag(self, *args, **kwargs): # real signature unknown
        """
        Bind fun to mouse-move-event (with pressed mouse button) on turtle.
                fun must be a function with two arguments, the coordinates of the
                actual mouse position on the canvas.
                num, the number of the mouse-button defaults to 1
        
                Every sequence of mouse-move-events on a turtle is preceded by a
                mouse-click event on that turtle.
        """
        pass

    def _onkey(self, *args, **kwargs): # real signature unknown
        """
        Bind fun to key-release event of key.
                Canvas must have focus. See method listen
        """
        pass

    def _onrelease(self, *args, **kwargs): # real signature unknown
        """
        Bind fun to mouse-button-release event on turtle.
                fun must be a function with two arguments, the coordinates
                of the point on the canvas where mouse button is released.
                num, the number of the mouse-button defaults to 1
        
                If a turtle is clicked, first _onclick-event will be performed,
                then _onscreensclick-event.
        """
        pass

    def _onscreenclick(self, *args, **kwargs): # real signature unknown
        """
        Bind fun to mouse-click event on canvas.
                fun must be a function with two arguments, the coordinates
                of the clicked point on the canvas.
                num, the number of the mouse-button defaults to 1
        
                If a turtle is clicked, first _onclick-event will be performed,
                then _onscreensclick-event.
        """
        pass

    def _ontimer(self, *args, **kwargs): # real signature unknown
        """ Install a timer, which calls fun after t milliseconds. """
        pass

    def _pointlist(self, getturtle, *args, **kwargs): # real signature unknown; NOTE: unreliably restored from __doc__ 
        """
        returns list of coordinate-pairs of points of item
                Example (for insiders):
                >>> from turtle import *
                >>> getscreen()._pointlist(getturtle().turtle._item)
                [(0.0, 9.9999999999999982), (0.0, -9.9999999999999982),
                (9.9999999999999982, 0.0)]
                >>>
        """
        pass

    def _rescale(self, *args, **kwargs): # real signature unknown
        pass

    def _resize(self, *args, **kwargs): # real signature unknown
        """
        Resize the canvas the turtles are drawing on. Does
                not alter the drawing window.
        """
        pass

    def _setbgpic(self, *args, **kwargs): # real signature unknown
        """
        Configure image item as to draw image object
                at center of canvas. Set item to the first item
                in the displaylist, so it will be drawn below
                any other item .
        """
        pass

    def _setscrollregion(self, *args, **kwargs): # real signature unknown
        pass

    def _type(self, *args, **kwargs): # real signature unknown
        """
        Return 'line' or 'polygon' or 'image' depending on
                type of item.
        """
        pass

    def _update(self, *args, **kwargs): # real signature unknown
        """ Redraw graphics items on canvas """
        pass

    def _window_size(self, *args, **kwargs): # real signature unknown
        """ Return the width and height of the turtle window. """
        pass

    def _write(self, *args, **kwargs): # real signature unknown
        """
        Write txt at pos in canvas with specified font
                and color.
                Return text item and x-coord of right bottom corner
                of text's bounding box.
        """
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default

    __dict__ = None # (!) real value is ''


class TurtleScreen(TurtleScreenBase):
    """
    Provides screen oriented methods like setbg etc.
    
        Only relies upon the methods of TurtleScreenBase and NOT
        upon components of the underlying graphics toolkit -
        which is Tkinter in this case.
    """
    def addshape(self, *args, **kwargs): # real signature unknown
        """
        Adds a turtle shape to TurtleScreen's shapelist.
        
                Arguments:
                (1) name is the name of a gif-file and shape is None.
                    Installs the corresponding image shape.
                    !! Image-shapes DO NOT rotate when turning the turtle,
                    !! so they do not display the heading of the turtle!
                (2) name is an arbitrary string and shape is a tuple
                    of pairs of coordinates. Installs the corresponding
                    polygon shape
                (3) name is an arbitrary string and shape is a
                    (compound) Shape object. Installs the corresponding
                    compound shape.
                To use a shape, you have to issue the command shape(shapename).
        
                call: register_shape("turtle.gif")
                --or: register_shape("tri", ((0,0), (10,10), (-10,10)))
        
                Example (for a TurtleScreen instance named screen):
                >>> screen.register_shape("triangle", ((5,-3),(0,5),(-5,-3)))
        """
        pass

    def bgcolor(self, orange): # real signature unknown; restored from __doc__
        """
        Set or return backgroundcolor of the TurtleScreen.
        
                Arguments (if given): a color string or three numbers
                in the range 0..colormode or a 3-tuple of such numbers.
        
                Example (for a TurtleScreen instance named screen):
                >>> screen.bgcolor("orange")
                >>> screen.bgcolor()
                'orange'
                >>> screen.bgcolor(0.5,0,0.5)
                >>> screen.bgcolor()
                '#800080'
        """
        pass

    def bgpic(self): # real signature unknown; restored from __doc__
        """
        Set background image or return name of current backgroundimage.
        
                Optional argument:
                picname -- a string, name of a gif-file or "nopic".
        
                If picname is a filename, set the corresponing image as background.
                If picname is "nopic", delete backgroundimage, if present.
                If picname is None, return the filename of the current backgroundimage.
        
                Example (for a TurtleScreen instance named screen):
                >>> screen.bgpic()
                'nopic'
                >>> screen.bgpic("landscape.gif")
                >>> screen.bgpic()
                'landscape.gif'
        """
        pass

    def clear(self): # real signature unknown; restored from __doc__
        """
        Delete all drawings and all turtles from the TurtleScreen.
        
                Reset empty TurtleScreen to its initial state: white background,
                no backgroundimage, no eventbindings and tracing on.
        
                No argument.
        
                Example (for a TurtleScreen instance named screen):
                screen.clear()
        
                Note: this method is not available as function.
        """
        pass

    def clearscreen(self, *args, **kwargs): # real signature unknown
        """
        Delete all drawings and all turtles from the TurtleScreen.
        
                Reset empty TurtleScreen to its initial state: white background,
                no backgroundimage, no eventbindings and tracing on.
        
                No argument.
        
                Example (for a TurtleScreen instance named screen):
                screen.clear()
        
                Note: this method is not available as function.
        """
        pass

    def colormode(self): # real signature unknown; restored from __doc__
        """
        Return the colormode or set it to 1.0 or 255.
        
                Optional argument:
                cmode -- one of the values 1.0 or 255
        
                r, g, b values of colortriples have to be in range 0..cmode.
        
                Example (for a TurtleScreen instance named screen):
                >>> screen.colormode()
                1.0
                >>> screen.colormode(255)
                >>> turtle.pencolor(240,160,80)
        """
        pass

    def delay(self, *args, **kwargs): # real signature unknown; NOTE: unreliably restored from __doc__ 
        """
        Return or set the drawing delay in milliseconds.
        
                Optional argument:
                delay -- positive integer
        
                Example (for a TurtleScreen instance named screen):
                >>> screen.delay(15)
                >>> screen.delay()
                15
        """
        pass

    def getcanvas(self): # real signature unknown; restored from __doc__
        """
        Return the Canvas of this TurtleScreen.
        
                No argument.
        
                Example (for a Screen instance named screen):
                >>> cv = screen.getcanvas()
                >>> cv
                <turtle.ScrolledCanvas instance at 0x010742D8>
        """
        pass

    def getshapes(self): # real signature unknown; restored from __doc__
        """
        Return a list of names of all currently available turtle shapes.
        
                No argument.
        
                Example (for a TurtleScreen instance named screen):
                >>> screen.getshapes()
                ['arrow', 'blank', 'circle', ... , 'turtle']
        """
        pass

    def listen(self): # real signature unknown; restored from __doc__
        """
        Set focus on TurtleScreen (in order to collect key-events)
        
                No arguments.
                Dummy arguments are provided in order
                to be able to pass listen to the onclick method.
        
                Example (for a TurtleScreen instance named screen):
                >>> screen.listen()
        """
        pass

    def mode(self, standard, logo, *args, **kwargs): # real signature unknown; NOTE: unreliably restored from __doc__ 
        """
        Set turtle-mode ('standard', 'logo' or 'world') and perform reset.
        
                Optional argument:
                mode -- on of the strings 'standard', 'logo' or 'world'
        
                Mode 'standard' is compatible with turtle.py.
                Mode 'logo' is compatible with most Logo-Turtle-Graphics.
                Mode 'world' uses userdefined 'worldcoordinates'. *Attention*: in
                this mode angles appear distorted if x/y unit-ratio doesn't equal 1.
                If mode is not given, return the current mode.
        
                     Mode      Initial turtle heading     positive angles
                 ------------|-------------------------|-------------------
                  'standard'    to the right (east)       counterclockwise
                    'logo'        upward    (north)         clockwise
        
                Examples:
                >>> mode('logo')   # resets turtle heading to north
                >>> mode()
                'logo'
        """
        pass

    def onclick(self, turtle_goto): # real signature unknown; restored from __doc__
        """
        Bind fun to mouse-click event on canvas.
        
                Arguments:
                fun -- a function with two arguments, the coordinates of the
                       clicked point on the canvas.
                num -- the number of the mouse-button, defaults to 1
        
                Example (for a TurtleScreen instance named screen
                and a Turtle instance named turtle):
        
                >>> screen.onclick(turtle.goto)
        
                ### Subsequently clicking into the TurtleScreen will
                ### make the turtle move to the clicked point.
                >>> screen.onclick(None)
        
                ### event-binding will be removed
        """
        pass

    def onkey(self, f, Up): # real signature unknown; restored from __doc__
        """
        Bind fun to key-release event of key.
        
                Arguments:
                fun -- a function with no arguments
                key -- a string: key (e.g. "a") or key-symbol (e.g. "space")
        
                In order to be able to register key-events, TurtleScreen
                must have focus. (See method listen.)
        
                Example (for a TurtleScreen instance named screen
                and a Turtle instance named turtle):
        
                >>> def f():
                        fd(50)
                        lt(60)
        
        
                >>> screen.onkey(f, "Up")
                >>> screen.listen()
        
                ### Subsequently the turtle can be moved by
                ### repeatedly pressing the up-arrow key,
                ### consequently drawing a hexagon
        """
        pass

    def onscreenclick(self, *args, **kwargs): # real signature unknown
        """
        Bind fun to mouse-click event on canvas.
        
                Arguments:
                fun -- a function with two arguments, the coordinates of the
                       clicked point on the canvas.
                num -- the number of the mouse-button, defaults to 1
        
                Example (for a TurtleScreen instance named screen
                and a Turtle instance named turtle):
        
                >>> screen.onclick(turtle.goto)
        
                ### Subsequently clicking into the TurtleScreen will
                ### make the turtle move to the clicked point.
                >>> screen.onclick(None)
        
                ### event-binding will be removed
        """
        pass

    def ontimer(self, f, *args, **kwargs): # real signature unknown; NOTE: unreliably restored from __doc__ 
        """
        Install a timer, which calls fun after t milliseconds.
        
                Arguments:
                fun -- a function with no arguments.
                t -- a number >= 0
        
                Example (for a TurtleScreen instance named screen):
        
                >>> running = True
                >>> def f():
                        if running:
                                fd(50)
                                lt(60)
                                screen.ontimer(f, 250)
        
                >>> f()   ### makes the turtle marching around
                >>> running = False
        """
        pass

    def register_shape(self, turtle_gif): # real signature unknown; restored from __doc__
        """
        Adds a turtle shape to TurtleScreen's shapelist.
        
                Arguments:
                (1) name is the name of a gif-file and shape is None.
                    Installs the corresponding image shape.
                    !! Image-shapes DO NOT rotate when turning the turtle,
                    !! so they do not display the heading of the turtle!
                (2) name is an arbitrary string and shape is a tuple
                    of pairs of coordinates. Installs the corresponding
                    polygon shape
                (3) name is an arbitrary string and shape is a
                    (compound) Shape object. Installs the corresponding
                    compound shape.
                To use a shape, you have to issue the command shape(shapename).
        
                call: register_shape("turtle.gif")
                --or: register_shape("tri", ((0,0), (10,10), (-10,10)))
        
                Example (for a TurtleScreen instance named screen):
                >>> screen.register_shape("triangle", ((5,-3),(0,5),(-5,-3)))
        """
        pass

    def reset(self): # real signature unknown; restored from __doc__
        """
        Reset all Turtles on the Screen to their initial state.
        
                No argument.
        
                Example (for a TurtleScreen instance named screen):
                >>> screen.reset()
        """
        pass

    def resetscreen(self, *args, **kwargs): # real signature unknown
        """
        Reset all Turtles on the Screen to their initial state.
        
                No argument.
        
                Example (for a TurtleScreen instance named screen):
                >>> screen.reset()
        """
        pass

    def screensize(self, *args, **kwargs): # real signature unknown; NOTE: unreliably restored from __doc__ 
        """
        Resize the canvas the turtles are drawing on.
        
                Optional arguments:
                canvwidth -- positive integer, new width of canvas in pixels
                canvheight --  positive integer, new height of canvas in pixels
                bg -- colorstring or color-tupel, new backgroundcolor
                If no arguments are given, return current (canvaswidth, canvasheight)
        
                Do not alter the drawing window. To observe hidden parts of
                the canvas use the scrollbars. (Can make visible those parts
                of a drawing, which were outside the canvas before!)
        
                Example (for a Turtle instance named turtle):
                >>> turtle.screensize(2000,1500)
                    ### e. g. to search for an erroneously escaped turtle ;-)
        """
        pass

    def setworldcoordinates(self, *args, **kwargs): # real signature unknown; NOTE: unreliably restored from __doc__ 
        """
        Set up a user defined coordinate-system.
        
                Arguments:
                llx -- a number, x-coordinate of lower left corner of canvas
                lly -- a number, y-coordinate of lower left corner of canvas
                urx -- a number, x-coordinate of upper right corner of canvas
                ury -- a number, y-coordinate of upper right corner of canvas
        
                Set up user coodinat-system and switch to mode 'world' if necessary.
                This performs a screen.reset. If mode 'world' is already active,
                all drawings are redrawn according to the new coordinates.
        
                But ATTENTION: in user-defined coordinatesystems angles may appear
                distorted. (see Screen.mode())
        
                Example (for a TurtleScreen instance named screen):
                >>> screen.setworldcoordinates(-10,-0.5,50,1.5)
                >>> for _ in range(36):
                        left(10)
                        forward(0.5)
        """
        pass

    def tracer(self, *args, **kwargs): # real signature unknown; NOTE: unreliably restored from __doc__ 
        """
        Turns turtle animation on/off and set delay for update drawings.
        
                Optional arguments:
                n -- nonnegative  integer
                delay -- nonnegative  integer
        
                If n is given, only each n-th regular screen update is really performed.
                (Can be used to accelerate the drawing of complex graphics.)
                Second arguments sets delay value (see RawTurtle.delay())
        
                Example (for a TurtleScreen instance named screen):
                >>> screen.tracer(8, 25)
                >>> dist = 2
                >>> for i in range(200):
                        fd(dist)
                        rt(90)
                        dist += 2
        """
        pass

    def turtles(self): # real signature unknown; restored from __doc__
        """
        Return the list of turtles on the screen.
        
                Example (for a TurtleScreen instance named screen):
                >>> screen.turtles()
                [<turtle.Turtle object at 0x00E11FB0>]
        """
        pass

    def update(self, *args, **kwargs): # real signature unknown
        """ Perform a TurtleScreen update. """
        pass

    def window_height(self): # real signature unknown; restored from __doc__
        """
        Return the height of the turtle window.
        
                Example (for a TurtleScreen instance named screen):
                >>> screen.window_height()
                480
        """
        pass

    def window_width(self): # real signature unknown; restored from __doc__
        """
        Return the width of the turtle window.
        
                Example (for a TurtleScreen instance named screen):
                >>> screen.window_width()
                640
        """
        pass

    def _color(self, *args, **kwargs): # real signature unknown
        pass

    def _colorstr(self, *args, **kwargs): # real signature unknown
        """
        Return color string corresponding to args.
        
                Argument may be a string or a tuple of three
                numbers corresponding to actual colormode,
                i.e. in the range 0<=n<=colormode.
        
                If the argument doesn't represent a color,
                an error is raised.
        """
        pass

    def _incrementudc(self, *args, **kwargs): # real signature unknown
        """ Increment upadate counter. """
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    _RUNNING = True


class Vec2D(tuple):
    """
    A 2 dimensional vector class, used as a helper class
        for implementing turtle graphics.
        May be useful for turtle graphics programs also.
        Derived from tuple, so a vector is a tuple!
    
        Provides (for a, b vectors, k number):
           a+b vector addition
           a-b vector subtraction
           a*b inner product
           k*a and a*k multiplication with scalar
           |a| absolute value of a
           a.rotate(angle) rotation
    """
    def rotate(self, *args, **kwargs): # real signature unknown
        """ rotate self counterclockwise by angle """
        pass

    def __abs__(self, *args, **kwargs): # real signature unknown
        pass

    def __add__(self, *args, **kwargs): # real signature unknown
        pass

    def __getnewargs__(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    def __mul__(self, *args, **kwargs): # real signature unknown
        pass

    def __neg__(self, *args, **kwargs): # real signature unknown
        pass

    @staticmethod # known case of __new__
    def __new__(cls, x, y): # reliably restored by inspect
        # no doc
        pass

    def __repr__(self, *args, **kwargs): # real signature unknown
        pass

    def __rmul__(self, *args, **kwargs): # real signature unknown
        pass

    def __sub__(self, *args, **kwargs): # real signature unknown
        pass

    __dict__ = None # (!) real value is ''


class _Screen(TurtleScreen):
    # no doc
    def bye(self): # real signature unknown; restored from __doc__
        """
        Shut the turtlegraphics window.
        
                Example (for a TurtleScreen instance named screen):
                >>> screen.bye()
        """
        pass

    def exitonclick(self): # real signature unknown; restored from __doc__
        """
        Go into mainloop until the mouse is clicked.
        
                No arguments.
        
                Bind bye() method to mouseclick on TurtleScreen.
                If "using_IDLE" - value in configuration dictionary is False
                (default value), enter mainloop.
                If IDLE with -n switch (no subprocess) is used, this value should be
                set to True in turtle.cfg. In this case IDLE's mainloop
                is active also for the client script.
        
                This is a method of the Screen-class and not available for
                TurtleScreen instances.
        
                Example (for a Screen instance named screen):
                >>> screen.exitonclick()
        """
        pass

    def setup(self, width=200, height=200, startx=0, starty=0): # real signature unknown; restored from __doc__
        """
        Set the size and position of the main window.
        
                Arguments:
                width: as integer a size in pixels, as float a fraction of the screen.
                  Default is 50% of screen.
                height: as integer the height in pixels, as float a fraction of the
                  screen. Default is 75% of screen.
                startx: if positive, starting position in pixels from the left
                  edge of the screen, if negative from the right edge
                  Default, startx=None is to center window horizontally.
                starty: if positive, starting position in pixels from the top
                  edge of the screen, if negative from the bottom edge
                  Default, starty=None is to center window vertically.
        
                Examples (for a Screen instance named screen):
                >>> screen.setup (width=200, height=200, startx=0, starty=0)
        
                sets window to 200x200 pixels, in upper left of screen
        
                >>> screen.setup(width=.75, height=0.5, startx=None, starty=None)
        
                sets window to 75% of screen by 50% of screen and centers
        """
        pass

    def title(self, *args, **kwargs): # real signature unknown; NOTE: unreliably restored from __doc__ 
        """
        Set title of turtle-window
        
                Argument:
                titlestring -- a string, to appear in the titlebar of the
                               turtle graphics window.
        
                This is a method of Screen-class. Not available for TurtleScreen-
                objects.
        
                Example (for a Screen instance named screen):
                >>> screen.title("Welcome to the turtle-zoo!")
        """
        pass

    def _destroy(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    _canvas = None
    _root = None
    _title = 'Python Turtle Graphics'


class _TurtleImage(object):
    """ Helper class: Datatype to store Turtle attributes """
    def _setshape(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default

    __dict__ = None # (!) real value is ''


# variables with complex values

Canvas = TK.Canvas

ScrolledCanvas = None # (!) real value is ''

_alias_list = [
    'addshape',
    'backward',
    'bk',
    'fd',
    'ht',
    'lt',
    'pd',
    'pos',
    'pu',
    'rt',
    'seth',
    'setpos',
    'setposition',
    'st',
    'turtlesize',
    'up',
    'width',
]

_CFG = {
    'canvheight': 300,
    'canvwidth': 400,
    'colormode': 1.0,
    'delay': 10,
    'examplescreen': 'screen',
    'exampleturtle': 'turtle',
    'fillcolor': 'black',
    'height': 0.75,
    'language': 'english',
    'leftright': None,
    'mode': 'standard',
    'pencolor': 'black',
    'resizemode': 'noresize',
    'shape': 'classic',
    'title': 'Python Turtle Graphics',
    'topbottom': None,
    'undobuffersize': 1000,
    'using_IDLE': False,
    'visible': True,
    'width': 0.5,
}

_math_functions = [
    'acos',
    'asin',
    'atan',
    'atan2',
    'ceil',
    'cos',
    'cosh',
    'e',
    'exp',
    'fabs',
    'floor',
    'fmod',
    'frexp',
    'hypot',
    'ldexp',
    'log',
    'log10',
    'modf',
    'pi',
    'pow',
    'sin',
    'sinh',
    'sqrt',
    'tan',
    'tanh',
]

_Root = None # (!) real value is ''

_tg_classes = [
    'ScrolledCanvas',
    'TurtleScreen',
    'Screen',
    'RawTurtle',
    'Turtle',
    'RawPen',
    'Pen',
    'Shape',
    'Vec2D',
]

_tg_screen_functions = [
    'addshape',
    'bgcolor',
    'bgpic',
    'bye',
    'clearscreen',
    'colormode',
    'delay',
    'exitonclick',
    'getcanvas',
    'getshapes',
    'listen',
    'mode',
    'onkey',
    'onscreenclick',
    'ontimer',
    'register_shape',
    'resetscreen',
    'screensize',
    'setup',
    'setworldcoordinates',
    'title',
    'tracer',
    'turtles',
    'update',
    'window_height',
    'window_width',
]

_tg_turtle_functions = [
    'back',
    'backward',
    'begin_fill',
    'begin_poly',
    'bk',
    'circle',
    'clear',
    'clearstamp',
    'clearstamps',
    'clone',
    'color',
    'degrees',
    'distance',
    'dot',
    'down',
    'end_fill',
    'end_poly',
    'fd',
    'fill',
    'fillcolor',
    'forward',
    'get_poly',
    'getpen',
    'getscreen',
    'getturtle',
    'goto',
    'heading',
    'hideturtle',
    'home',
    'ht',
    'isdown',
    'isvisible',
    'left',
    'lt',
    'onclick',
    'ondrag',
    'onrelease',
    'pd',
    'pen',
    'pencolor',
    'pendown',
    'pensize',
    'penup',
    'pos',
    'position',
    'pu',
    'radians',
    'right',
    'reset',
    'resizemode',
    'rt',
    'seth',
    'setheading',
    'setpos',
    'setposition',
    'settiltangle',
    'setundobuffer',
    'setx',
    'sety',
    'shape',
    'shapesize',
    'showturtle',
    'speed',
    'st',
    'stamp',
    'tilt',
    'tiltangle',
    'towards',
    'tracer',
    'turtlesize',
    'undo',
    'undobufferentries',
    'up',
    'width',
    'window_height',
    'window_width',
    'write',
    'xcor',
    'ycor',
]

_tg_utilities = [
    'write_docstringdict',
    'done',
    'mainloop',
]

__all__ = [
    'ScrolledCanvas',
    'TurtleScreen',
    'Screen',
    'RawTurtle',
    'Turtle',
    'RawPen',
    'Pen',
    'Shape',
    'Vec2D',
    'addshape',
    'bgcolor',
    'bgpic',
    'bye',
    'clearscreen',
    'colormode',
    'delay',
    'exitonclick',
    'getcanvas',
    'getshapes',
    'listen',
    'mode',
    'onkey',
    'onscreenclick',
    'ontimer',
    'register_shape',
    'resetscreen',
    'screensize',
    'setup',
    'setworldcoordinates',
    'title',
    'tracer',
    'turtles',
    'update',
    'window_height',
    'window_width',
    'back',
    'backward',
    'begin_fill',
    'begin_poly',
    'bk',
    'circle',
    'clear',
    'clearstamp',
    'clearstamps',
    'clone',
    'color',
    'degrees',
    'distance',
    'dot',
    'down',
    'end_fill',
    'end_poly',
    'fd',
    'fill',
    'fillcolor',
    'forward',
    'get_poly',
    'getpen',
    'getscreen',
    'getturtle',
    'goto',
    'heading',
    'hideturtle',
    'home',
    'ht',
    'isdown',
    'isvisible',
    'left',
    'lt',
    'onclick',
    'ondrag',
    'onrelease',
    'pd',
    'pen',
    'pencolor',
    'pendown',
    'pensize',
    'penup',
    'pos',
    'position',
    'pu',
    'radians',
    'right',
    'reset',
    'resizemode',
    'rt',
    'seth',
    'setheading',
    'setpos',
    'setposition',
    'settiltangle',
    'setundobuffer',
    'setx',
    'sety',
    'shape',
    'shapesize',
    'showturtle',
    'speed',
    'st',
    'stamp',
    'tilt',
    'tiltangle',
    'towards',
    'tracer',
    'turtlesize',
    'undo',
    'undobufferentries',
    'up',
    'width',
    'window_height',
    'window_width',
    'write',
    'xcor',
    'ycor',
    'write_docstringdict',
    'done',
    'mainloop',
    'acos',
    'asin',
    'atan',
    'atan2',
    'ceil',
    'cos',
    'cosh',
    'e',
    'exp',
    'fabs',
    'floor',
    'fmod',
    'frexp',
    'hypot',
    'ldexp',
    'log',
    'log10',
    'modf',
    'pi',
    'pow',
    'sin',
    'sinh',
    'sqrt',
    'tan',
    'tanh',
]

