# encoding: utf-8
# module xml.sax.expatreader
# from /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/xml/sax/expatreader.pyo by generator 1.99
"""
SAX driver for the pyexpat C module.  This driver works with
pyexpat.__version__ == '2.22'.
"""

# imports
import xml.parsers.expat as expat # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/xml/parsers/expat.pyc
import xml.sax.handler as handler # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/xml/sax/handler.pyc
import xml.sax.saxutils as saxutils # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/xml/sax/saxutils.pyc
import xml.sax.xmlreader as xmlreader # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/xml/sax/xmlreader.pyc
from _weakref import _mkproxy

import xml.sax._exceptions as __xml_sax__exceptions


# Variables with simple values

feature_external_ges = 'http://xml.org/sax/features/external-general-entities'
feature_external_pes = 'http://xml.org/sax/features/external-parameter-entities'

feature_namespaces = 'http://xml.org/sax/features/namespaces'

feature_namespace_prefixes = 'http://xml.org/sax/features/namespace-prefixes'

feature_string_interning = 'http://xml.org/sax/features/string-interning'

feature_validation = 'http://xml.org/sax/features/validation'

property_interning_dict = 'http://www.python.org/sax/properties/interning-dict'

property_xml_string = 'http://xml.org/sax/properties/xml-string'

version = '0.20'

# functions

def create_parser(*args, **kwargs): # reliably restored by inspect
    # no doc
    pass


# classes

class SAXException(Exception):
    """
    Encapsulate an XML error or warning. This class can contain
        basic error or warning information from either the XML parser or
        the application: you can subclass it to provide additional
        functionality, or to add localization. Note that although you will
        receive a SAXException as the argument to the handlers in the
        ErrorHandler interface, you are not actually required to throw
        the exception; instead, you can simply read the information in
        it.
    """
    def getException(self, *args, **kwargs): # real signature unknown
        """ Return the embedded exception, or None if there was none. """
        pass

    def getMessage(self, *args, **kwargs): # real signature unknown
        """ Return a message for this exception. """
        pass

    def __getitem__(self, *args, **kwargs): # real signature unknown
        """
        Avoids weird error messages if someone does exception[ix] by
                mistake, since Exception has __getitem__ defined.
        """
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        """
        Creates an exception. The message is required, but the exception
                is optional.
        """
        pass

    def __str__(self, *args, **kwargs): # real signature unknown
        """ Create a string representation of the exception. """
        pass

    __weakref__ = property(lambda self: object()) # default


class SAXNotRecognizedException(__xml_sax__exceptions.SAXException):
    """
    Exception class for an unrecognized identifier.
    
        An XMLReader will raise this exception when it is confronted with an
        unrecognized feature or property. SAX applications and extensions may
        use this class for similar purposes.
    """
    def __init__(self, *args, **kwargs): # real signature unknown
        """
        Creates an exception. The message is required, but the exception
                is optional.
        """
        pass


class SAXNotSupportedException(__xml_sax__exceptions.SAXException):
    """
    Exception class for an unsupported operation.
    
        An XMLReader will raise this exception when a service it cannot
        perform is requested (specifically setting a state or value). SAX
        applications and extensions may use this class for similar
        purposes.
    """
    def __init__(self, *args, **kwargs): # real signature unknown
        """
        Creates an exception. The message is required, but the exception
                is optional.
        """
        pass


class SAXParseException(__xml_sax__exceptions.SAXException):
    """
    Encapsulate an XML parse error or warning.
    
        This exception will include information for locating the error in
        the original XML document. Note that although the application will
        receive a SAXParseException as the argument to the handlers in the
        ErrorHandler interface, the application is not actually required
        to throw the exception; instead, it can simply read the
        information in it and take a different action.
    
        Since this exception is a subclass of SAXException, it inherits
        the ability to wrap another exception.
    """
    def getColumnNumber(self, *args, **kwargs): # real signature unknown
        """
        The column number of the end of the text where the exception
                occurred.
        """
        pass

    def getLineNumber(self, *args, **kwargs): # real signature unknown
        """ The line number of the end of the text where the exception occurred. """
        pass

    def getPublicId(self, *args, **kwargs): # real signature unknown
        """ Get the public identifier of the entity where the exception occurred. """
        pass

    def getSystemId(self, *args, **kwargs): # real signature unknown
        """ Get the system identifier of the entity where the exception occurred. """
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        """ Creates the exception. The exception parameter is allowed to be None. """
        pass

    def __str__(self, *args, **kwargs): # real signature unknown
        """ Create a string representation of the exception. """
        pass


class SAXReaderNotAvailable(__xml_sax__exceptions.SAXNotSupportedException):
    """
    Exception class for a missing driver.
    
        An XMLReader module (driver) should raise this exception when it
        is first imported, e.g. when a support module cannot be imported.
        It also may be raised during parsing, e.g. if executing an external
        program is not permitted.
    """
    def __init__(self, *args, **kwargs): # real signature unknown
        """
        Creates an exception. The message is required, but the exception
                is optional.
        """
        pass


# variables with complex values

AttributesImpl = xmlreader.AttributesImpl

AttributesNSImpl = xmlreader.AttributesNSImpl

ExpatLocator = None # (!) real value is ''

ExpatParser = None # (!) real value is ''

