# encoding: utf-8
# module OpenSSL.crypto
# from /System/Library/Frameworks/Python.framework/Versions/2.6/Extras/lib/python/OpenSSL/crypto.so by generator 1.99
"""
Main file of crypto sub module.
See the file RATIONALE for a short explanation of why this module was written.
"""
# no imports

# Variables with simple values

FILETYPE_ASN1 = 2
FILETYPE_PEM = 1

TYPE_DSA = 116
TYPE_RSA = 6

# functions

def dump_certificate(*args, **kwargs): # real signature unknown
    """
    Dump a certificate to a buffer
    
    Arguments: spam - Always NULL
               args - The Python argument tuple, should be:
                 type - The file type (one of FILETYPE_PEM, FILETYPE_ASN1)
                 cert - The certificate to dump
    Returns:   The buffer with the dumped certificate in
    """
    pass


def dump_certificate_request(*args, **kwargs): # real signature unknown
    """
    Dump a certificate request to a buffer
    
    Arguments: spam - Always NULL
               args - The Python argument tuple, should be:
                 type - The file type (one of FILETYPE_PEM, FILETYPE_ASN1)
                 req  - The certificate request to dump
    Returns:   The buffer with the dumped certificate request in
    """
    pass


def dump_privatekey(*args, **kwargs): # real signature unknown
    """
    Dump a private key to a buffer
    
    Arguments: spam - Always NULL
               args - The Python argument tuple, should be:
                 type       - The file type (one of FILETYPE_PEM, FILETYPE_ASN1)
                 pkey       - The PKey to dump
                 cipher     - (optional) if encrypted PEM format, the cipher to
                              use
                 passphrase - (optional) if encrypted PEM format, this can be either
                              the passphrase to use, or a callback for providing the
                              passphrase.
    Returns:   The buffer with the dumped key in
    """
    pass


def load_certificate(*args, **kwargs): # real signature unknown
    """
    Load a certificate from a buffer
    
    Arguments: spam - Always NULL
               args - The Python argument tuple, should be:
                 type   - The file type (one of FILETYPE_PEM, FILETYPE_ASN1)
                 buffer - The buffer the certificate is stored in
    Returns:   The X509 object
    """
    pass


def load_certificate_request(*args, **kwargs): # real signature unknown
    """
    Load a certificate request from a buffer
    
    Arguments: spam - Always NULL
               args - The Python argument tuple, should be:
                 type   - The file type (one of FILETYPE_PEM, FILETYPE_ASN1)
                 buffer - The buffer the certificate request is stored in
    Returns:   The X509Req object
    """
    pass


def load_pkcs12(*args, **kwargs): # real signature unknown
    """
    Load a PKCS12 object from a buffer
    
    Arguments: spam - Always NULL
               args - The Python argument tuple, should be:
                 buffer - The buffer the certificate is stored in
                 passphrase (Optional) - The password to decrypt the PKCS12 lump
    Returns:   The PKCS12 object
    """
    pass


def load_pkcs7_data(*args, **kwargs): # real signature unknown
    """
    Load pkcs7 data from a buffer
    
    Arguments: spam - Always NULL
               args - The argument tuple, should be:
                 type - The file type (one of FILETYPE_PEM or FILETYPE_ASN1)
                 buffer - The buffer with the pkcs7 data.
    Returns: The PKCS7 object
    """
    pass


def load_privatekey(*args, **kwargs): # real signature unknown
    """
    Load a private key from a buffer
    
    Arguments: spam - Always NULL
               args - The Python argument tuple, should be:
                 type       - The file type (one of FILETYPE_PEM, FILETYPE_ASN1)
                 buffer     - The buffer the key is stored in
                 passphrase - (optional) if encrypted PEM format, this can be
                              either the passphrase to use, or a callback for
                              providing the passphrase.
    Returns:   The PKey object
    """
    pass


def NetscapeSPKI(*args, **kwargs): # real signature unknown
    """
    The factory function inserted in the module dictionary to create NetscapeSPKI
    objects
    
    Arguments: spam - Always NULL
               args - The Python argument tuple, should be empty or, optionally
                 enc - Base64 encoded NetscapeSPKI object.
    Returns:   The NetscapeSPKI object
    """
    pass


def PKey(*args, **kwargs): # real signature unknown
    """
    The factory function inserted in the module dictionary to create PKey
    objects
    
    Arguments: spam - Always NULL
               args - The Python argument tuple, should be empty
    Returns:   The PKey object
    """
    pass


def X509(*args, **kwargs): # real signature unknown
    """
    The factory function inserted in the module dictionary to create X509
    objects
    
    Arguments: spam - Always NULL
               args - The Python argument tuple, should be empty
    Returns:   The X509 object
    """
    pass


def X509Extension(*args, **kwargs): # real signature unknown
    """
    The factory function inserted in the module dictionary to create
    X509Extension objects.
    
    Arguments: spam - Always NULL
               args - The Python argument tuple, should be
                 typename - ???
                 critical - ???
                 value    - ???
    Returns:   The X509Extension object
    """
    pass


def X509Name(*args, **kwargs): # real signature unknown
    """
    The factory function inserted in the module dictionary as a copy
    constructor for X509Name objects.
    
    Arguments: spam - Always NULL
               args - The Python argument tuple, should be:
                 name - An X509Name object to copy
    Returns:   The X509Name object
    """
    pass


def X509Req(*args, **kwargs): # real signature unknown
    """
    The factory function inserted in the module dictionary to create X509Req
    objects
    
    Arguments: spam - Always NULL
               args - The Python argument tuple, should be empty
    Returns:   The X509Req object
    """
    pass


def X509_verify_cert_error_string(*args, **kwargs): # real signature unknown
    """
    Get X509 verify certificate error string.
    
    Arguments: errnum - Error number
    Returns:   Error string as a Python string
    """
    pass


# classes

class Error(Exception):
    # no doc
    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default


class NetscapeSPKIType(object):
    # no doc
    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class PKCS12Type(object):
    # no doc
    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class PKCS7Type(object):
    # no doc
    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class PKeyType(object):
    # no doc
    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class X509ExtensionType(object):
    # no doc
    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    def __str__(self): # real signature unknown; restored from __doc__
        """ x.__str__() <==> str(x) """
        pass


class X509NameType(object):
    # no doc
    def __cmp__(self, y): # real signature unknown; restored from __doc__
        """ x.__cmp__(y) <==> cmp(x,y) """
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    def __repr__(self): # real signature unknown; restored from __doc__
        """ x.__repr__() <==> repr(x) """
        pass


class X509ReqType(object):
    # no doc
    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class X509StoreType(object):
    # no doc
    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class X509Type(object):
    # no doc
    def __init__(self, *args, **kwargs): # real signature unknown
        pass


# variables with complex values

_C_API = None # (!) real value is ''

