# encoding: utf-8
# module OpenSSL.rand
# from /System/Library/Frameworks/Python.framework/Versions/2.6/Extras/lib/python/OpenSSL/rand.so by generator 1.99
"""
PRNG management routines, thin wrappers.
See the file RATIONALE for a short explanation of why this module was written.
"""
# no imports

# functions

def add(*args, **kwargs): # real signature unknown
    """
    Add data with a given entropy to the PRNG
    
    Arguments: spam - Always NULL
               args - The Python argument tuple, should be:
                 buffer  - Buffer with random data
                 entropy - The entropy (in bytes) measurement of the buffer
    Returns:   None
    """
    pass


def cleanup(*args, **kwargs): # real signature unknown
    """
    Erase the memory used by the PRNG.
    
    Arguments: spam - Always NULL
               args - The Python argument tuple, should be empty
    Returns:   None
    """
    pass


def egd(*args, **kwargs): # real signature unknown
    """
    Query an entropy gathering daemon (EGD) for random data and add it to the
    PRNG. I haven't found any problems when the socket is missing, the function
    just returns 0.
    
    Arguments: spam - Always NULL
               args - The Python argument tuple, should be:
                 path  - The path to the EGD socket
                 bytes - (optional) The number of bytes to read, default is 255
    Returns:   The number of bytes read (NB: a value of 0 isn't necessarily an
               error, check rand.status())
    """
    pass


def load_file(*args, **kwargs): # real signature unknown
    """
    Seed the PRNG with data from a file
    
    Arguments: spam - Always NULL
               args - The Python argument tuple, should be:
                 filename - The file to read data from
                 maxbytes - (optional) The number of bytes to read, default is
                            to read the entire file
    Returns:   The number of bytes read
    """
    pass


def seed(*args, **kwargs): # real signature unknown
    """
    Alias for rand_add, with entropy equal to length
    
    Arguments: spam - Always NULL
               args - The Python argument tuple, should be:
                 buffer - Buffer with random data
    Returns:   None
    """
    pass


def status(*args, **kwargs): # real signature unknown
    """
    Retrieve the status of the PRNG
    
    Arguments: spam - Always NULL
               args - The Python argument tuple, should be empty
    Returns:   True if the PRNG is seeded enough, false otherwise
    """
    pass


def write_file(*args, **kwargs): # real signature unknown
    """
    Save PRNG state to a file
    
    Arguments: spam - Always NULL
               args - The Python argument tuple, should be:
                 filename - The file to write data to
    Returns:   The number of bytes written
    """
    pass


# no classes
