# encoding: utf-8
# module SimpleXMLRPCServer
# from /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/SimpleXMLRPCServer.pyo by generator 1.99
"""
Simple XML-RPC Server.

This module can be used to create simple XML-RPC servers
by creating a server and either installing functions, a
class instance, or by extending the SimpleXMLRPCServer
class.

It can also be used to handle XML-RPC requests in a CGI
environment using CGIXMLRPCRequestHandler.

A list of possible usage patterns follows:

1. Install functions:

server = SimpleXMLRPCServer(("localhost", 8000))
server.register_function(pow)
server.register_function(lambda x,y: x+y, 'add')
server.serve_forever()

2. Install an instance:

class MyFuncs:
    def __init__(self):
        # make all of the string functions available through
        # string.func_name
        import string
        self.string = string
    def _listMethods(self):
        # implement this method so that system.listMethods
        # knows to advertise the strings methods
        return list_public_methods(self) +                 ['string.' + method for method in list_public_methods(self.string)]
    def pow(self, x, y): return pow(x, y)
    def add(self, x, y) : return x + y

server = SimpleXMLRPCServer(("localhost", 8000))
server.register_introspection_functions()
server.register_instance(MyFuncs())
server.serve_forever()

3. Install an instance with custom dispatch method:

class Math:
    def _listMethods(self):
        # this method must be present for system.listMethods
        # to work
        return ['add', 'pow']
    def _methodHelp(self, method):
        # this method must be present for system.methodHelp
        # to work
        if method == 'add':
            return "add(2,3) => 5"
        elif method == 'pow':
            return "pow(x, y[, z]) => number"
        else:
            # By convention, return empty
            # string if no help is available
            return ""
    def _dispatch(self, method, params):
        if method == 'pow':
            return pow(*params)
        elif method == 'add':
            return params[0] + params[1]
        else:
            raise 'bad method'

server = SimpleXMLRPCServer(("localhost", 8000))
server.register_introspection_functions()
server.register_instance(Math())
server.serve_forever()

4. Subclass SimpleXMLRPCServer:

class MathServer(SimpleXMLRPCServer):
    def _dispatch(self, method, params):
        try:
            # We are forcing the 'export_' prefix on methods that are
            # callable through XML-RPC to prevent potential security
            # problems
            func = getattr(self, 'export_' + method)
        except AttributeError:
            raise Exception('method "%s" is not supported' % method)
        else:
            return func(*params)

    def export_add(self, x, y):
        return x + y

server = MathServer(("localhost", 8000))
server.serve_forever()

5. CGI script:

server = CGIXMLRPCRequestHandler()
server.register_function(pow)
server.handle_request()
"""

# imports
import fcntl as fcntl # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/lib-dynload/fcntl.so
import SocketServer as SocketServer # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/SocketServer.pyc
import traceback as traceback # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/traceback.pyc
import xmlrpclib as xmlrpclib # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/xmlrpclib.pyc
import sys as sys # <module 'sys' (built-in)>
import BaseHTTPServer as BaseHTTPServer # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/BaseHTTPServer.pyc
import os as os # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/os.pyc
import xmlrpclib as __xmlrpclib


# functions

def list_public_methods(obj): # reliably restored by inspect
    """
    Returns a list of attribute strings, found in the specified
        object, which represent callable attributes
    """
    pass


def remove_duplicates(lst): # reliably restored by inspect
    """
    remove_duplicates([2,2,2,1,3,3]) => [3,1,2]
    
        Returns a copy of a list without duplicates. Every list
        item must be hashable and the order of the items in the
        resulting list is not defined.
    """
    pass


def resolve_dotted_attribute(obj, attr, allow_dotted_names=True): # reliably restored by inspect
    """
    resolve_dotted_attribute(a, 'b.c.d') => a.b.c.d
    
        Resolves a dotted attribute name to an object.  Raises
        an AttributeError if any attribute in the chain starts with a '_'.
    
        If the optional allow_dotted_names argument is false, dots are not
        supported and this function operates similar to getattr(obj, attr).
    """
    pass


# classes

class Fault(__xmlrpclib.Error):
    """ Indicates an XML-RPC fault package. """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    def __repr__(self, *args, **kwargs): # real signature unknown
        pass


# variables with complex values

CGIXMLRPCRequestHandler = None # (!) real value is ''

SimpleXMLRPCDispatcher = None # (!) real value is ''

SimpleXMLRPCRequestHandler = None # (!) real value is ''

SimpleXMLRPCServer = None # (!) real value is ''

