# encoding: utf-8
# module _abcoll
# from /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/_abcoll.pyo by generator 1.99
"""
Abstract Base Classes (ABCs) for collections, according to PEP 3119.

DON'T USE THIS MODULE DIRECTLY!  The classes here should be imported
via collections; they are defined here only to alleviate certain
bootstrapping issues.  Unit tests are in test_collections.
"""

# imports
import sys as sys # <module 'sys' (built-in)>

# functions

def abstractmethod(funcobj): # reliably restored by inspect
    """
    A decorator indicating abstract methods.
    
        Requires that the metaclass is ABCMeta or derived from it.  A
        class that has a metaclass derived from ABCMeta cannot be
        instantiated unless all of its abstract methods are overridden.
        The abstract methods can be called using any of the the normal
        'super' call mechanisms.
    
        Usage:
    
            class C(metaclass=ABCMeta):
                @abstractmethod
                def my_abstract_method(self, ...):
                    ...
    """
    pass


# classes

class ABCMeta(type):
    """
    Metaclass for defining Abstract Base Classes (ABCs).
    
        Use this metaclass to create an ABC.  An ABC can be subclassed
        directly, and then acts as a mix-in class.  You can also register
        unrelated concrete classes (even built-in classes) and unrelated
        ABCs as 'virtual subclasses' -- these and their descendants will
        be considered subclasses of the registering ABC by the built-in
        issubclass() function, but the registering ABC won't show up in
        their MRO (Method Resolution Order) nor will method
        implementations defined by the registering ABC be callable (not
        even via super()).
    """
    def register(self, *args, **kwargs): # real signature unknown
        """ Register a virtual subclass of an ABC. """
        pass

    def _dump_registry(self, *args, **kwargs): # real signature unknown
        """ Debug helper to print the ABC registry. """
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    def __instancecheck__(self, *args, **kwargs): # real signature unknown
        pass

    @staticmethod # known case of __new__
    def __new__(mcls, name, bases, namespace): # reliably restored by inspect
        # no doc
        pass

    def __subclasscheck__(self, *args, **kwargs): # real signature unknown
        pass

    _abc_invalidation_counter = 9


class Callable(object):
    # no doc
    def __call__(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    def __metaclass__(self, *args, **kwargs): # real signature unknown
        """
        Metaclass for defining Abstract Base Classes (ABCs).
        
            Use this metaclass to create an ABC.  An ABC can be subclassed
            directly, and then acts as a mix-in class.  You can also register
            unrelated concrete classes (even built-in classes) and unrelated
            ABCs as 'virtual subclasses' -- these and their descendants will
            be considered subclasses of the registering ABC by the built-in
            issubclass() function, but the registering ABC won't show up in
            their MRO (Method Resolution Order) nor will method
            implementations defined by the registering ABC be callable (not
            even via super()).
        """
        pass

    @classmethod
    def __subclasshook__(cls, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default

    _abc_cache = None # (!) real value is ''
    _abc_negative_cache = None # (!) real value is ''
    _abc_negative_cache_version = 1
    _abc_registry = None # (!) real value is ''
    __abstractmethods__ = None # (!) real value is ''
    __dict__ = None # (!) real value is ''


class Container(object):
    # no doc
    def __contains__(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    def __metaclass__(self, *args, **kwargs): # real signature unknown
        """
        Metaclass for defining Abstract Base Classes (ABCs).
        
            Use this metaclass to create an ABC.  An ABC can be subclassed
            directly, and then acts as a mix-in class.  You can also register
            unrelated concrete classes (even built-in classes) and unrelated
            ABCs as 'virtual subclasses' -- these and their descendants will
            be considered subclasses of the registering ABC by the built-in
            issubclass() function, but the registering ABC won't show up in
            their MRO (Method Resolution Order) nor will method
            implementations defined by the registering ABC be callable (not
            even via super()).
        """
        pass

    @classmethod
    def __subclasshook__(cls, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default

    _abc_cache = None # (!) real value is ''
    _abc_negative_cache = None # (!) real value is ''
    _abc_negative_cache_version = 1
    _abc_registry = None # (!) real value is ''
    __abstractmethods__ = None # (!) real value is ''
    __dict__ = None # (!) real value is ''


class Hashable(object):
    # no doc
    def __hash__(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    def __metaclass__(self, *args, **kwargs): # real signature unknown
        """
        Metaclass for defining Abstract Base Classes (ABCs).
        
            Use this metaclass to create an ABC.  An ABC can be subclassed
            directly, and then acts as a mix-in class.  You can also register
            unrelated concrete classes (even built-in classes) and unrelated
            ABCs as 'virtual subclasses' -- these and their descendants will
            be considered subclasses of the registering ABC by the built-in
            issubclass() function, but the registering ABC won't show up in
            their MRO (Method Resolution Order) nor will method
            implementations defined by the registering ABC be callable (not
            even via super()).
        """
        pass

    @classmethod
    def __subclasshook__(cls, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default

    _abc_cache = None # (!) real value is ''
    _abc_negative_cache = None # (!) real value is ''
    _abc_negative_cache_version = 0
    _abc_registry = None # (!) real value is ''
    __abstractmethods__ = None # (!) real value is ''
    __dict__ = None # (!) real value is ''


class Iterable(object):
    # no doc
    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    def __iter__(self, *args, **kwargs): # real signature unknown
        pass

    def __metaclass__(self, *args, **kwargs): # real signature unknown
        """
        Metaclass for defining Abstract Base Classes (ABCs).
        
            Use this metaclass to create an ABC.  An ABC can be subclassed
            directly, and then acts as a mix-in class.  You can also register
            unrelated concrete classes (even built-in classes) and unrelated
            ABCs as 'virtual subclasses' -- these and their descendants will
            be considered subclasses of the registering ABC by the built-in
            issubclass() function, but the registering ABC won't show up in
            their MRO (Method Resolution Order) nor will method
            implementations defined by the registering ABC be callable (not
            even via super()).
        """
        pass

    @classmethod
    def __subclasshook__(cls, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default

    _abc_cache = None # (!) real value is ''
    _abc_negative_cache = None # (!) real value is ''
    _abc_negative_cache_version = 0
    _abc_registry = None # (!) real value is ''
    __abstractmethods__ = None # (!) real value is ''
    __dict__ = None # (!) real value is ''


class Sized(object):
    # no doc
    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    def __len__(self, *args, **kwargs): # real signature unknown
        pass

    def __metaclass__(self, *args, **kwargs): # real signature unknown
        """
        Metaclass for defining Abstract Base Classes (ABCs).
        
            Use this metaclass to create an ABC.  An ABC can be subclassed
            directly, and then acts as a mix-in class.  You can also register
            unrelated concrete classes (even built-in classes) and unrelated
            ABCs as 'virtual subclasses' -- these and their descendants will
            be considered subclasses of the registering ABC by the built-in
            issubclass() function, but the registering ABC won't show up in
            their MRO (Method Resolution Order) nor will method
            implementations defined by the registering ABC be callable (not
            even via super()).
        """
        pass

    @classmethod
    def __subclasshook__(cls, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default

    _abc_cache = None # (!) real value is ''
    _abc_negative_cache = None # (!) real value is ''
    _abc_negative_cache_version = 1
    _abc_registry = None # (!) real value is ''
    __abstractmethods__ = None # (!) real value is ''
    __dict__ = None # (!) real value is ''


class MappingView(Sized):
    # no doc
    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    def __len__(self, *args, **kwargs): # real signature unknown
        pass

    _abc_cache = None # (!) real value is ''
    _abc_negative_cache = None # (!) real value is ''
    _abc_negative_cache_version = 3
    _abc_registry = None # (!) real value is ''
    __abstractmethods__ = None # (!) real value is ''


class Set(Sized, Iterable, Container):
    """
    A set is a finite, iterable container.
    
        This class provides concrete generic implementations of all
        methods except for __contains__, __iter__ and __len__.
    
        To override the comparisons (presumably for speed, as the
        semantics are fixed), all you have to do is redefine __le__ and
        then the other operations will automatically follow suit.
    """
    def isdisjoint(self, *args, **kwargs): # real signature unknown
        pass

    @classmethod
    def _from_iterable(cls, *args, **kwargs): # real signature unknown
        """
        Construct an instance of the class from any iterable input.
        
                Must override this method if the class constructor signature
                does not accept an iterable for an input.
        """
        pass

    def _hash(self, *args, **kwargs): # real signature unknown
        """
        Compute the hash value of a set.
        
                Note that we don't define __hash__: not all sets are hashable.
                But if you define a hashable set type, its __hash__ should
                call this function.
        
                This must be compatible __eq__.
        
                All sets ought to compare equal if they contain the same
                elements, regardless of how they are implemented, and
                regardless of the order of the elements; so there's not much
                freedom for __eq__ or __hash__.  We match the algorithm used
                by the built-in frozenset type.
        """
        pass

    def __and__(self, *args, **kwargs): # real signature unknown
        pass

    def __eq__(self, *args, **kwargs): # real signature unknown
        pass

    def __ge__(self, *args, **kwargs): # real signature unknown
        pass

    def __gt__(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    def __le__(self, *args, **kwargs): # real signature unknown
        pass

    def __lt__(self, *args, **kwargs): # real signature unknown
        pass

    def __ne__(self, *args, **kwargs): # real signature unknown
        pass

    def __or__(self, *args, **kwargs): # real signature unknown
        pass

    def __sub__(self, *args, **kwargs): # real signature unknown
        pass

    def __xor__(self, *args, **kwargs): # real signature unknown
        pass

    _abc_cache = None # (!) real value is ''
    _abc_negative_cache = None # (!) real value is ''
    _abc_negative_cache_version = 1
    _abc_registry = None # (!) real value is ''
    __abstractmethods__ = None # (!) real value is ''
    __hash__ = None


class ItemsView(MappingView, Set):
    # no doc
    def __contains__(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    def __iter__(self, *args, **kwargs): # real signature unknown
        pass

    _abc_cache = None # (!) real value is ''
    _abc_negative_cache = None # (!) real value is ''
    _abc_negative_cache_version = 3
    _abc_registry = None # (!) real value is ''
    __abstractmethods__ = None # (!) real value is ''


class Iterator(Iterable):
    # no doc
    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    def __iter__(self, *args, **kwargs): # real signature unknown
        pass

    def __next__(self, *args, **kwargs): # real signature unknown
        pass

    @classmethod
    def __subclasshook__(cls, *args, **kwargs): # real signature unknown
        pass

    _abc_cache = None # (!) real value is ''
    _abc_negative_cache = None # (!) real value is ''
    _abc_negative_cache_version = 1
    _abc_registry = None # (!) real value is ''
    __abstractmethods__ = None # (!) real value is ''


class KeysView(MappingView, Set):
    # no doc
    def __contains__(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    def __iter__(self, *args, **kwargs): # real signature unknown
        pass

    _abc_cache = None # (!) real value is ''
    _abc_negative_cache = None # (!) real value is ''
    _abc_negative_cache_version = 3
    _abc_registry = None # (!) real value is ''
    __abstractmethods__ = None # (!) real value is ''


class Mapping(Sized, Iterable, Container):
    # no doc
    def get(self, *args, **kwargs): # real signature unknown
        pass

    def items(self, *args, **kwargs): # real signature unknown
        pass

    def iteritems(self, *args, **kwargs): # real signature unknown
        pass

    def iterkeys(self, *args, **kwargs): # real signature unknown
        pass

    def itervalues(self, *args, **kwargs): # real signature unknown
        pass

    def keys(self, *args, **kwargs): # real signature unknown
        pass

    def values(self, *args, **kwargs): # real signature unknown
        pass

    def __contains__(self, *args, **kwargs): # real signature unknown
        pass

    def __eq__(self, *args, **kwargs): # real signature unknown
        pass

    def __getitem__(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    def __ne__(self, *args, **kwargs): # real signature unknown
        pass

    _abc_cache = None # (!) real value is ''
    _abc_negative_cache = None # (!) real value is ''
    _abc_negative_cache_version = 3
    _abc_registry = None # (!) real value is ''
    __abstractmethods__ = None # (!) real value is ''
    __hash__ = None


class MutableMapping(Mapping):
    # no doc
    def clear(self, *args, **kwargs): # real signature unknown
        pass

    def pop(self, *args, **kwargs): # real signature unknown
        pass

    def popitem(self, *args, **kwargs): # real signature unknown
        pass

    def setdefault(self, *args, **kwargs): # real signature unknown
        pass

    def update(self, *args, **kwargs): # real signature unknown
        pass

    def __delitem__(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    def __setitem__(self, *args, **kwargs): # real signature unknown
        pass

    _abc_cache = None # (!) real value is ''
    _abc_negative_cache = None # (!) real value is ''
    _abc_negative_cache_version = 8
    _abc_registry = None # (!) real value is ''
    _MutableMapping__marker = None # (!) real value is ''
    __abstractmethods__ = None # (!) real value is ''


class Sequence(Sized, Iterable, Container):
    """
    All the operations on a read-only sequence.
    
        Concrete subclasses must override __new__ or __init__,
        __getitem__, and __len__.
    """
    def count(self, *args, **kwargs): # real signature unknown
        pass

    def index(self, *args, **kwargs): # real signature unknown
        pass

    def __contains__(self, *args, **kwargs): # real signature unknown
        pass

    def __getitem__(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    def __iter__(self, *args, **kwargs): # real signature unknown
        pass

    def __reversed__(self, *args, **kwargs): # real signature unknown
        pass

    _abc_cache = None # (!) real value is ''
    _abc_negative_cache = None # (!) real value is ''
    _abc_negative_cache_version = 6
    _abc_registry = None # (!) real value is ''
    __abstractmethods__ = None # (!) real value is ''


class MutableSequence(Sequence):
    # no doc
    def append(self, *args, **kwargs): # real signature unknown
        pass

    def extend(self, *args, **kwargs): # real signature unknown
        pass

    def insert(self, *args, **kwargs): # real signature unknown
        pass

    def pop(self, *args, **kwargs): # real signature unknown
        pass

    def remove(self, *args, **kwargs): # real signature unknown
        pass

    def reverse(self, *args, **kwargs): # real signature unknown
        pass

    def __delitem__(self, *args, **kwargs): # real signature unknown
        pass

    def __iadd__(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    def __setitem__(self, *args, **kwargs): # real signature unknown
        pass

    _abc_cache = None # (!) real value is ''
    _abc_negative_cache = None # (!) real value is ''
    _abc_negative_cache_version = 7
    _abc_registry = None # (!) real value is ''
    __abstractmethods__ = None # (!) real value is ''


class MutableSet(Set):
    # no doc
    def add(self, *args, **kwargs): # real signature unknown
        """ Return True if it was added, False if already there. """
        pass

    def clear(self, *args, **kwargs): # real signature unknown
        """ This is slow (creates N new iterators!) but effective. """
        pass

    def discard(self, *args, **kwargs): # real signature unknown
        """ Return True if it was deleted, False if not there. """
        pass

    def pop(self, *args, **kwargs): # real signature unknown
        """ Return the popped value.  Raise KeyError if empty. """
        pass

    def remove(self, *args, **kwargs): # real signature unknown
        """ Remove an element. If not a member, raise a KeyError. """
        pass

    def __iand__(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    def __ior__(self, *args, **kwargs): # real signature unknown
        pass

    def __isub__(self, *args, **kwargs): # real signature unknown
        pass

    def __ixor__(self, *args, **kwargs): # real signature unknown
        pass

    _abc_cache = None # (!) real value is ''
    _abc_negative_cache = None # (!) real value is ''
    _abc_negative_cache_version = 2
    _abc_registry = None # (!) real value is ''
    __abstractmethods__ = None # (!) real value is ''


class ValuesView(MappingView):
    # no doc
    def __contains__(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    def __iter__(self, *args, **kwargs): # real signature unknown
        pass

    _abc_cache = None # (!) real value is ''
    _abc_negative_cache = None # (!) real value is ''
    _abc_negative_cache_version = 3
    _abc_registry = None # (!) real value is ''
    __abstractmethods__ = None # (!) real value is ''


# variables with complex values

__all__ = [
    'Hashable',
    'Iterable',
    'Iterator',
    'Sized',
    'Container',
    'Callable',
    'Set',
    'MutableSet',
    'Mapping',
    'MutableMapping',
    'MappingView',
    'KeysView',
    'ItemsView',
    'ValuesView',
    'Sequence',
    'MutableSequence',
]

