# encoding: utf-8
# module abc
# from /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/abc.pyo by generator 1.99
""" Abstract Base Classes (ABCs) according to PEP 3119. """
# no imports

# functions

def abstractmethod(funcobj): # reliably restored by inspect
    """
    A decorator indicating abstract methods.
    
        Requires that the metaclass is ABCMeta or derived from it.  A
        class that has a metaclass derived from ABCMeta cannot be
        instantiated unless all of its abstract methods are overridden.
        The abstract methods can be called using any of the the normal
        'super' call mechanisms.
    
        Usage:
    
            class C(metaclass=ABCMeta):
                @abstractmethod
                def my_abstract_method(self, ...):
                    ...
    """
    pass


# classes

class ABCMeta(type):
    """
    Metaclass for defining Abstract Base Classes (ABCs).
    
        Use this metaclass to create an ABC.  An ABC can be subclassed
        directly, and then acts as a mix-in class.  You can also register
        unrelated concrete classes (even built-in classes) and unrelated
        ABCs as 'virtual subclasses' -- these and their descendants will
        be considered subclasses of the registering ABC by the built-in
        issubclass() function, but the registering ABC won't show up in
        their MRO (Method Resolution Order) nor will method
        implementations defined by the registering ABC be callable (not
        even via super()).
    """
    def register(self, *args, **kwargs): # real signature unknown
        """ Register a virtual subclass of an ABC. """
        pass

    def _dump_registry(self, *args, **kwargs): # real signature unknown
        """ Debug helper to print the ABC registry. """
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    def __instancecheck__(self, *args, **kwargs): # real signature unknown
        pass

    @staticmethod # known case of __new__
    def __new__(mcls, name, bases, namespace): # reliably restored by inspect
        # no doc
        pass

    def __subclasscheck__(self, *args, **kwargs): # real signature unknown
        pass

    _abc_invalidation_counter = 9


class abstractproperty(property):
    """
    A decorator indicating abstract properties.
    
        Requires that the metaclass is ABCMeta or derived from it.  A
        class that has a metaclass derived from ABCMeta cannot be
        instantiated unless all of its abstract properties are overridden.
        The abstract properties can be called using any of the the normal
        'super' call mechanisms.
    
        Usage:
    
            class C(metaclass=ABCMeta):
                @abstractproperty
                def my_abstract_property(self):
                    ...
    
        This defines a read-only property; you can also define a read-write
        abstract property using the 'long' form of property declaration:
    
            class C(metaclass=ABCMeta):
                def getx(self): ...
                def setx(self, value): ...
                x = abstractproperty(getx, setx)
    """
    def __init__(self, getx, setx): # real signature unknown; restored from __doc__
        pass

    __weakref__ = property(lambda self: object()) # default

    __dict__ = None # (!) real value is ''
    __isabstractmethod__ = True


