# encoding: utf-8
# module ast
# from /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/ast.pyo by generator 1.99
"""
ast
    ~~~

    The `ast` module helps Python applications to process trees of the Python
    abstract syntax grammar.  The abstract syntax itself might change with
    each Python release; this module helps to find out programmatically what
    the current grammar looks like and allows modifications of it.

    An abstract syntax tree can be generated by passing `ast.PyCF_ONLY_AST` as
    a flag to the `compile()` builtin function or by using the `parse()`
    function from this module.  The result will be a tree of objects whose
    classes all inherit from `ast.AST`.

    A modified abstract syntax tree can be compiled into a Python code object
    using the built-in `compile()` function.

    Additionally various helper functions are provided that make working with
    the trees simpler.  The main intention of the helper functions and this
    module in general is to provide an easy to use interface for libraries
    that work tightly with the python syntax (template engines for example).


    :copyright: Copyright 2008 by Armin Ronacher.
    :license: Python License.
"""

# imports
from _ast import (AST, Add, And, Assert, Assign, Attribute, AugAssign, 
    AugLoad, AugStore, BinOp, BitAnd, BitOr, BitXor, BoolOp, Break, Call, 
    ClassDef, Compare, Continue, Del, Delete, Dict, Div, Ellipsis, Eq, 
    ExceptHandler, Exec, Expr, Expression, ExtSlice, FloorDiv, For, 
    FunctionDef, GeneratorExp, Global, Gt, GtE, If, IfExp, Import, ImportFrom, 
    In, Index, Interactive, Invert, Is, IsNot, LShift, Lambda, List, ListComp, 
    Load, Lt, LtE, Mod, Module, Mult, Name, Not, NotEq, NotIn, Num, Or, Param, 
    Pass, Pow, Print, RShift, Raise, Repr, Return, Slice, Store, Str, Sub, 
    Subscript, Suite, TryExcept, TryFinally, Tuple, UAdd, USub, UnaryOp, 
    While, With, Yield, alias, arguments, boolop, cmpop, comprehension, 
    excepthandler, expr, expr_context, keyword, mod, operator, slice, stmt, 
    unaryop)


# Variables with simple values

PyCF_ONLY_AST = 1024

__version__ = '62047'

# functions

def copy_location(new_node, old_node): # reliably restored by inspect
    """
    Copy source location (`lineno` and `col_offset` attributes) from
        *old_node* to *new_node* if possible, and return *new_node*.
    """
    pass


def dump(node, annotate_fields=True, include_attributes=False): # reliably restored by inspect
    """
    Return a formatted dump of the tree in *node*.  This is mainly useful for
        debugging purposes.  The returned string will show the names and the values
        for fields.  This makes the code impossible to evaluate, so if evaluation is
        wanted *annotate_fields* must be set to False.  Attributes such as line
        numbers and column offsets are not dumped by default.  If this is wanted,
        *include_attributes* can be set to True.
    """
    pass


def fix_missing_locations(node): # reliably restored by inspect
    """
    When you compile a node tree with compile(), the compiler expects lineno and
        col_offset attributes for every node that supports them.  This is rather
        tedious to fill in for generated nodes, so this helper adds these attributes
        recursively where not already set, by setting them to the values of the
        parent node.  It works recursively starting at *node*.
    """
    pass


def get_docstring(node, clean=True): # reliably restored by inspect
    """
    Return the docstring for the given node or None if no docstring can
        be found.  If the node provided does not have docstrings a TypeError
        will be raised.
    """
    pass


def increment_lineno(node, n=1): # reliably restored by inspect
    """
    Increment the line number of each node in the tree starting at *node* by *n*.
        This is useful to "move code" to a different location in a file.
    """
    pass


def iter_child_nodes(node): # reliably restored by inspect
    """
    Yield all direct child nodes of *node*, that is, all fields that are nodes
        and all items of fields that are lists of nodes.
    """
    pass


def iter_fields(node): # reliably restored by inspect
    """
    Yield a tuple of ``(fieldname, value)`` for each field in ``node._fields``
        that is present on *node*.
    """
    pass


def literal_eval(node_or_string): # reliably restored by inspect
    """
    Safely evaluate an expression node or a string containing a Python
        expression.  The string or node provided may only consist of the following
        Python literal structures: strings, numbers, tuples, lists, dicts, booleans,
        and None.
    """
    pass


def parse(expr, filename=None, mode=None): # reliably restored by inspect
    """
    Parse an expression into an AST node.
        Equivalent to compile(expr, filename, mode, PyCF_ONLY_AST).
    """
    pass


def walk(node): # reliably restored by inspect
    """
    Recursively yield all child nodes of *node*, in no specified order.  This is
        useful if you only want to modify nodes in place and don't care about the
        context.
    """
    pass


# classes

class NodeVisitor(object):
    """
    A node visitor base class that walks the abstract syntax tree and calls a
        visitor function for every node found.  This function may return a value
        which is forwarded by the `visit` method.
    
        This class is meant to be subclassed, with the subclass adding visitor
        methods.
    
        Per default the visitor functions for the nodes are ``'visit_'`` +
        class name of the node.  So a `TryFinally` node visit function would
        be `visit_TryFinally`.  This behavior can be changed by overriding
        the `visit` method.  If no visitor function exists for a node
        (return value `None`) the `generic_visit` visitor is used instead.
    
        Don't use the `NodeVisitor` if you want to apply changes to nodes during
        traversing.  For this a special visitor exists (`NodeTransformer`) that
        allows modifications.
    """
    def generic_visit(self, *args, **kwargs): # real signature unknown
        """ Called if no explicit visitor function exists for a node. """
        pass

    def visit(self, *args, **kwargs): # real signature unknown
        """ Visit a node. """
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default

    __dict__ = None # (!) real value is ''


class NodeTransformer(NodeVisitor):
    """
    A :class:`NodeVisitor` subclass that walks the abstract syntax tree and
        allows modification of nodes.
    
        The `NodeTransformer` will walk the AST and use the return value of the
        visitor methods to replace or remove the old node.  If the return value of
        the visitor method is ``None``, the node will be removed from its location,
        otherwise it is replaced with the return value.  The return value may be the
        original node in which case no replacement takes place.
    
        Here is an example transformer that rewrites all occurrences of name lookups
        (``foo``) to ``data['foo']``::
    
           class RewriteName(NodeTransformer):
    
               def visit_Name(self, node):
                   return copy_location(Subscript(
                       value=Name(id='data', ctx=Load()),
                       slice=Index(value=Str(s=node.id)),
                       ctx=node.ctx
                   ), node)
    
        Keep in mind that if the node you're operating on has child nodes you must
        either transform the child nodes yourself or call the :meth:`generic_visit`
        method for the node first.
    
        For nodes that were part of a collection of statements (that applies to all
        statement nodes), the visitor may also return a list of nodes rather than
        just a single node.
    
        Usually you use the transformer like this::
    
           node = YourTransformer().visit(node)
    """
    def generic_visit(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass


