# encoding: utf-8
# module base64
# from /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/base64.pyo by generator 1.99
""" RFC 3548: Base16, Base32, Base64 Data Encodings """

# imports
import struct as struct # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/struct.pyc
import binascii as binascii # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/lib-dynload/binascii.so
import re as re # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/re.pyc

# Variables with simple values

EMPTYSTRING = ''
k = 31

MAXBINSIZE = 57
MAXLINESIZE = 76
v = '7'

_x = 255

# functions

def b16decode(s, casefold=False): # reliably restored by inspect
    """
    Decode a Base16 encoded string.
    
        s is the string to decode.  Optional casefold is a flag specifying whether
        a lowercase alphabet is acceptable as input.  For security purposes, the
        default is False.
    
        The decoded string is returned.  A TypeError is raised if s were
        incorrectly padded or if there are non-alphabet characters present in the
        string.
    """
    pass


def b16encode(s): # reliably restored by inspect
    """
    Encode a string using Base16.
    
        s is the string to encode.  The encoded string is returned.
    """
    pass


def b32decode(s, casefold=False, map01=None): # reliably restored by inspect
    """
    Decode a Base32 encoded string.
    
        s is the string to decode.  Optional casefold is a flag specifying whether
        a lowercase alphabet is acceptable as input.  For security purposes, the
        default is False.
    
        RFC 3548 allows for optional mapping of the digit 0 (zero) to the letter O
        (oh), and for optional mapping of the digit 1 (one) to either the letter I
        (eye) or letter L (el).  The optional argument map01 when not None,
        specifies which letter the digit 1 should be mapped to (when map01 is not
        None, the digit 0 is always mapped to the letter O).  For security
        purposes the default is None, so that 0 and 1 are not allowed in the
        input.
    
        The decoded string is returned.  A TypeError is raised if s were
        incorrectly padded or if there are non-alphabet characters present in the
        string.
    """
    pass


def b32encode(s): # reliably restored by inspect
    """
    Encode a string using Base32.
    
        s is the string to encode.  The encoded string is returned.
    """
    pass


def b64decode(s, altchars=None): # reliably restored by inspect
    """
    Decode a Base64 encoded string.
    
        s is the string to decode.  Optional altchars must be a string of at least
        length 2 (additional characters are ignored) which specifies the
        alternative alphabet used instead of the '+' and '/' characters.
    
        The decoded string is returned.  A TypeError is raised if s were
        incorrectly padded or if there are non-alphabet characters present in the
        string.
    """
    pass


def b64encode(s, altchars=None): # reliably restored by inspect
    """
    Encode a string using Base64.
    
        s is the string to encode.  Optional altchars must be a string of at least
        length 2 (additional characters are ignored) which specifies an
        alternative alphabet for the '+' and '/' characters.  This allows an
        application to e.g. generate url or filesystem safe Base64 strings.
    
        The encoded string is returned.
    """
    pass


def decode(input, output): # reliably restored by inspect
    """ Decode a file. """
    pass


def decodestring(s): # reliably restored by inspect
    """ Decode a string. """
    pass


def encode(input, output): # reliably restored by inspect
    """ Encode a file. """
    pass


def encodestring(s): # reliably restored by inspect
    """ Encode a string into multiple lines of base-64 data. """
    pass


def standard_b64decode(s): # reliably restored by inspect
    """
    Decode a string encoded with the standard Base64 alphabet.
    
        s is the string to decode.  The decoded string is returned.  A TypeError
        is raised if the string is incorrectly padded or if there are non-alphabet
        characters present in the string.
    """
    pass


def standard_b64encode(s): # reliably restored by inspect
    """
    Encode a string using the standard Base64 alphabet.
    
        s is the string to encode.  The encoded string is returned.
    """
    pass


def test(): # reliably restored by inspect
    """ Small test program """
    pass


def test1(): # reliably restored by inspect
    # no doc
    pass


def urlsafe_b64decode(s): # reliably restored by inspect
    """
    Decode a string encoded with the standard Base64 alphabet.
    
        s is the string to decode.  The decoded string is returned.  A TypeError
        is raised if the string is incorrectly padded or if there are non-alphabet
        characters present in the string.
    
        The alphabet uses '-' instead of '+' and '_' instead of '/'.
    """
    pass


def urlsafe_b64encode(s): # reliably restored by inspect
    """
    Encode a string using a url-safe Base64 alphabet.
    
        s is the string to encode.  The encoded string is returned.  The alphabet
        uses '-' instead of '+' and '_' instead of '/'.
    """
    pass


def _translate(s, altchars): # reliably restored by inspect
    # no doc
    pass


# no classes
# variables with complex values

_b32alphabet = {
    0: 'A',
    1: 'B',
    2: 'C',
    3: 'D',
    4: 'E',
    5: 'F',
    6: 'G',
    7: 'H',
    8: 'I',
    9: 'J',
    10: 'K',
    11: 'L',
    12: 'M',
    13: 'N',
    14: 'O',
    15: 'P',
    16: 'Q',
    17: 'R',
    18: 'S',
    19: 'T',
    20: 'U',
    21: 'V',
    22: 'W',
    23: 'X',
    24: 'Y',
    25: 'Z',
    26: '2',
    27: '3',
    28: '4',
    29: '5',
    30: '6',
    31: '7',
}

_b32rev = {
    '2': 26L,
    '3': 27L,
    '4': 28L,
    '5': 29L,
    '6': 30L,
    '7': 31L,
    'A': 0L,
    'B': 1L,
    'C': 2L,
    'D': 3L,
    'E': 4L,
    'F': 5L,
    'G': 6L,
    'H': 7L,
    'I': 8L,
    'J': 9L,
    'K': 10L,
    'L': 11L,
    'M': 12L,
    'N': 13L,
    'O': 14L,
    'P': 15L,
    'Q': 16L,
    'R': 17L,
    'S': 18L,
    'T': 19L,
    'U': 20L,
    'V': 21L,
    'W': 22L,
    'X': 23L,
    'Y': 24L,
    'Z': 25L,
}

_b32tab = [
    'A',
    'B',
    'C',
    'D',
    'E',
    'F',
    'G',
    'H',
    'I',
    'J',
    'K',
    'L',
    'M',
    'N',
    'O',
    'P',
    'Q',
    'R',
    'S',
    'T',
    'U',
    'V',
    'W',
    'X',
    'Y',
    'Z',
    '2',
    '3',
    '4',
    '5',
    '6',
    '7',
]

_translation = [
    '\x00',
    '\x01',
    '\x02',
    '\x03',
    '\x04',
    '\x05',
    '\x06',
    '\x07',
    '\x08',
    '\t',
    '\n',
    '\x0b',
    '\x0c',
    '\r',
    '\x0e',
    '\x0f',
    '\x10',
    '\x11',
    '\x12',
    '\x13',
    '\x14',
    '\x15',
    '\x16',
    '\x17',
    '\x18',
    '\x19',
    '\x1a',
    '\x1b',
    '\x1c',
    '\x1d',
    '\x1e',
    '\x1f',
    ' ',
    '!',
    '"',
    '#',
    '$',
    '%',
    '&',
    "'",
    '(',
    ')',
    '*',
    '+',
    ',',
    '-',
    '.',
    '/',
    '0',
    '1',
    '2',
    '3',
    '4',
    '5',
    '6',
    '7',
    '8',
    '9',
    ':',
    ';',
    '<',
    '=',
    '>',
    '?',
    '@',
    'A',
    'B',
    'C',
    'D',
    'E',
    'F',
    'G',
    'H',
    'I',
    'J',
    'K',
    'L',
    'M',
    'N',
    'O',
    'P',
    'Q',
    'R',
    'S',
    'T',
    'U',
    'V',
    'W',
    'X',
    'Y',
    'Z',
    '[',
    '\\',
    ']',
    '^',
    '_',
    '`',
    'a',
    'b',
    'c',
    'd',
    'e',
    'f',
    'g',
    'h',
    'i',
    'j',
    'k',
    'l',
    'm',
    'n',
    'o',
    'p',
    'q',
    'r',
    's',
    't',
    'u',
    'v',
    'w',
    'x',
    'y',
    'z',
    '{',
    '|',
    '}',
    '~',
    '\x7f',
    '\x80',
    '\x81',
    '\x82',
    '\x83',
    '\x84',
    '\x85',
    '\x86',
    '\x87',
    '\x88',
    '\x89',
    '\x8a',
    '\x8b',
    '\x8c',
    '\x8d',
    '\x8e',
    '\x8f',
    '\x90',
    '\x91',
    '\x92',
    '\x93',
    '\x94',
    '\x95',
    '\x96',
    '\x97',
    '\x98',
    '\x99',
    '\x9a',
    '\x9b',
    '\x9c',
    '\x9d',
    '\x9e',
    '\x9f',
    '\xa0',
    '\xa1',
    '\xa2',
    '\xa3',
    '\xa4',
    '\xa5',
    '\xa6',
    '\xa7',
    '\xa8',
    '\xa9',
    '\xaa',
    '\xab',
    '\xac',
    '\xad',
    '\xae',
    '\xaf',
    '\xb0',
    '\xb1',
    '\xb2',
    '\xb3',
    '\xb4',
    '\xb5',
    '\xb6',
    '\xb7',
    '\xb8',
    '\xb9',
    '\xba',
    '\xbb',
    '\xbc',
    '\xbd',
    '\xbe',
    '\xbf',
    '\xc0',
    '\xc1',
    '\xc2',
    '\xc3',
    '\xc4',
    '\xc5',
    '\xc6',
    '\xc7',
    '\xc8',
    '\xc9',
    '\xca',
    '\xcb',
    '\xcc',
    '\xcd',
    '\xce',
    '\xcf',
    '\xd0',
    '\xd1',
    '\xd2',
    '\xd3',
    '\xd4',
    '\xd5',
    '\xd6',
    '\xd7',
    '\xd8',
    '\xd9',
    '\xda',
    '\xdb',
    '\xdc',
    '\xdd',
    '\xde',
    '\xdf',
    '\xe0',
    '\xe1',
    '\xe2',
    '\xe3',
    '\xe4',
    '\xe5',
    '\xe6',
    '\xe7',
    '\xe8',
    '\xe9',
    '\xea',
    '\xeb',
    '\xec',
    '\xed',
    '\xee',
    '\xef',
    '\xf0',
    '\xf1',
    '\xf2',
    '\xf3',
    '\xf4',
    '\xf5',
    '\xf6',
    '\xf7',
    '\xf8',
    '\xf9',
    '\xfa',
    '\xfb',
    '\xfc',
    '\xfd',
    '\xfe',
    '\xff',
]

__all__ = [
    'encode',
    'decode',
    'encodestring',
    'decodestring',
    'b64encode',
    'b64decode',
    'b32encode',
    'b32decode',
    'b16encode',
    'b16decode',
    'standard_b64encode',
    'standard_b64decode',
    'urlsafe_b64encode',
    'urlsafe_b64decode',
]

